/*
 * Decompiled with CFR 0.152.
 */
package net.milkbowl.vault.permission.plugins;

import de.bananaco.bpermissions.api.ApiLayer;
import de.bananaco.bpermissions.api.WorldManager;
import de.bananaco.bpermissions.api.util.Calculable;
import de.bananaco.bpermissions.api.util.CalculableType;
import java.util.HashSet;
import java.util.Set;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.plugin.Plugin;

public class Permission_bPermissions2
extends Permission {
    private final String name = "bPermissions2";
    private boolean hooked = false;

    public Permission_bPermissions2(Plugin plugin) {
        Plugin p;
        this.plugin = plugin;
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new PermissionServerListener(), plugin);
        if (!this.hooked && (p = plugin.getServer().getPluginManager().getPlugin("bPermissions")) != null) {
            this.hooked = true;
            log.info(String.format("[%s][Permission] %s hooked.", plugin.getDescription().getName(), "bPermissions2"));
        }
    }

    @Override
    public String getName() {
        return "bPermissions2";
    }

    @Override
    public boolean isEnabled() {
        return this.hooked;
    }

    @Override
    public boolean has(Player player, String permission) {
        return this.playerHas(player.getWorld().getName(), player.getName(), permission);
    }

    @Override
    public boolean has(String world, String player, String permission) {
        return this.playerHas(world, player, permission);
    }

    @Override
    public boolean has(CommandSender sender, String permission) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            return this.has(player, permission);
        }
        return sender.hasPermission(permission);
    }

    @Override
    public boolean has(World world, String player, String permission) {
        return this.playerHas(world.getName(), player, permission);
    }

    @Override
    public boolean playerHas(String world, String player, String permission) {
        return ApiLayer.hasPermission((String)world, (CalculableType)CalculableType.USER, (String)player, (String)permission);
    }

    @Override
    public boolean playerAdd(String world, String player, String permission) {
        ApiLayer.addPermission((String)world, (CalculableType)CalculableType.USER, (String)player, (de.bananaco.bpermissions.api.util.Permission)de.bananaco.bpermissions.api.util.Permission.loadFromString((String)permission));
        return true;
    }

    @Override
    public boolean playerRemove(String world, String player, String permission) {
        ApiLayer.removePermission((String)world, (CalculableType)CalculableType.USER, (String)player, (String)permission);
        return true;
    }

    @Override
    public boolean groupHas(String world, String group, String permission) {
        return ApiLayer.hasPermission((String)world, (CalculableType)CalculableType.GROUP, (String)group, (String)permission);
    }

    @Override
    public boolean groupAdd(String world, String group, String permission) {
        ApiLayer.addPermission((String)world, (CalculableType)CalculableType.GROUP, (String)group, (de.bananaco.bpermissions.api.util.Permission)de.bananaco.bpermissions.api.util.Permission.loadFromString((String)permission));
        return true;
    }

    @Override
    public boolean groupRemove(String world, String group, String permission) {
        ApiLayer.removePermission((String)world, (CalculableType)CalculableType.GROUP, (String)group, (String)permission);
        return true;
    }

    @Override
    public boolean playerInGroup(String world, String player, String group) {
        return ApiLayer.hasGroup((String)world, (CalculableType)CalculableType.USER, (String)player, (String)group);
    }

    @Override
    public boolean playerAddGroup(String world, String player, String group) {
        ApiLayer.addGroup((String)world, (CalculableType)CalculableType.USER, (String)player, (String)group);
        return true;
    }

    @Override
    public boolean playerRemoveGroup(String world, String player, String group) {
        ApiLayer.removeGroup((String)world, (CalculableType)CalculableType.USER, (String)player, (String)group);
        return true;
    }

    @Override
    public String[] getPlayerGroups(String world, String player) {
        return ApiLayer.getGroups((String)world, (CalculableType)CalculableType.USER, (String)player);
    }

    @Override
    public String getPrimaryGroup(String world, String player) {
        String[] groups = this.getPlayerGroups(world, player);
        return groups != null && groups.length > 0 ? groups[0] : null;
    }

    @Override
    public String[] getGroups() {
        String[] groups = null;
        HashSet<String> gSet = new HashSet<String>();
        for (de.bananaco.bpermissions.api.World world : WorldManager.getInstance().getAllWorlds()) {
            Set gr = world.getAll(CalculableType.GROUP);
            for (Calculable c : gr) {
                gSet.add(c.getNameLowerCase());
            }
        }
        groups = gSet.toArray(new String[gSet.size()]);
        return groups;
    }

    @Override
    public boolean hasSuperPermsCompat() {
        return true;
    }

    public class PermissionServerListener
    implements Listener {
        @EventHandler(priority=EventPriority.MONITOR)
        public void onPluginEnable(PluginEnableEvent event) {
            Plugin p;
            if (!Permission_bPermissions2.this.hooked && (p = event.getPlugin()).getDescription().getName().equals("bPermissions") && p.isEnabled()) {
                Permission_bPermissions2.this.hooked = true;
                log.info(String.format("[%s][Permission] %s hooked.", Permission_bPermissions2.this.plugin.getDescription().getName(), "bPermissions2"));
            }
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onPluginDisable(PluginDisableEvent event) {
            if (Permission_bPermissions2.this.hooked && event.getPlugin().getDescription().getName().equals("bPermissions")) {
                Permission_bPermissions2.this.hooked = false;
                log.info(String.format("[%s][Permission] %s un-hooked.", Permission_bPermissions2.this.plugin.getDescription().getName(), "bPermissions2"));
            }
        }
    }
}

