/*
 * Decompiled with CFR 0.152.
 */
package ca.xshade.questionmanager;

import ca.xshade.questionmanager.InvalidOptionException;
import ca.xshade.questionmanager.Option;
import java.util.List;

public abstract class AbstractQuestion {
    protected int id;
    protected String question;
    protected List<Option> options;
    protected boolean persistance = false;

    public Option getOption(String command) throws InvalidOptionException {
        for (Option option : this.options) {
            if (!option.command.toLowerCase().equals(command.toLowerCase())) continue;
            return option;
        }
        throw new InvalidOptionException();
    }

    public String getQuestion() {
        return this.question;
    }

    public boolean hasCommand(String command) {
        for (Option option : this.options) {
            if (!option.isCommand(command)) continue;
            return true;
        }
        return false;
    }

    public List<Option> getOptions() {
        return this.options;
    }
}

