/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit;

import com.sk89q.jnbt.ByteArrayTag;
import com.sk89q.jnbt.ByteTag;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.DoubleTag;
import com.sk89q.jnbt.EndTag;
import com.sk89q.jnbt.FloatTag;
import com.sk89q.jnbt.IntArrayTag;
import com.sk89q.jnbt.IntTag;
import com.sk89q.jnbt.ListTag;
import com.sk89q.jnbt.LongTag;
import com.sk89q.jnbt.NBTConstants;
import com.sk89q.jnbt.ShortTag;
import com.sk89q.jnbt.StringTag;
import com.sk89q.jnbt.Tag;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.blocks.TileEntityBlock;
import com.sk89q.worldedit.bukkit.BukkitWorld;
import com.sk89q.worldedit.data.DataException;
import com.sk89q.worldedit.foundation.Block;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import net.minecraft.server.NBTBase;
import net.minecraft.server.NBTTagByte;
import net.minecraft.server.NBTTagByteArray;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.NBTTagDouble;
import net.minecraft.server.NBTTagEnd;
import net.minecraft.server.NBTTagFloat;
import net.minecraft.server.NBTTagInt;
import net.minecraft.server.NBTTagIntArray;
import net.minecraft.server.NBTTagList;
import net.minecraft.server.NBTTagLong;
import net.minecraft.server.NBTTagShort;
import net.minecraft.server.NBTTagString;
import net.minecraft.server.TileEntity;
import org.bukkit.World;
import org.bukkit.craftbukkit.CraftWorld;

class NmsBlock
extends BaseBlock
implements TileEntityBlock {
    private static final Logger logger = Logger.getLogger(NmsBlock.class.getCanonicalName());
    private static Field compoundMapField;
    private NBTTagCompound nbtData = null;

    public NmsBlock(int type, int data, TileEntityBlock tileEntityBlock) {
        super(type, data);
        this.nbtData = (NBTTagCompound)NmsBlock.fromNative(tileEntityBlock.getNbtData());
    }

    public NmsBlock(int type, int data, NBTTagCompound nbtData) {
        super(type, data);
        this.nbtData = nbtData;
    }

    private NBTTagCompound getNmsData(Vector pt) {
        if (this.nbtData == null) {
            return null;
        }
        this.nbtData.set("x", (NBTBase)new NBTTagInt("x", pt.getBlockX()));
        this.nbtData.set("y", (NBTBase)new NBTTagInt("y", pt.getBlockY()));
        this.nbtData.set("z", (NBTBase)new NBTTagInt("z", pt.getBlockZ()));
        return this.nbtData;
    }

    @Override
    public boolean hasNbtData() {
        return this.nbtData != null;
    }

    @Override
    public String getNbtId() {
        if (this.nbtData == null) {
            return "";
        }
        return this.nbtData.getString("id");
    }

    @Override
    public CompoundTag getNbtData() {
        if (this.nbtData == null) {
            return new CompoundTag(this.getNbtId(), new HashMap<String, Tag>());
        }
        return (CompoundTag)NmsBlock.toNative((NBTBase)this.nbtData);
    }

    @Override
    public void setNbtData(CompoundTag tag) throws DataException {
        if (tag == null) {
            this.nbtData = null;
        }
        this.nbtData = (NBTTagCompound)NmsBlock.fromNative(tag);
    }

    public static NmsBlock get(World world, Vector position, int type, int data) {
        TileEntity te = ((CraftWorld)world).getHandle().getTileEntity(position.getBlockX(), position.getBlockY(), position.getBlockZ());
        if (te != null) {
            NBTTagCompound tag = new NBTTagCompound();
            te.b(tag);
            return new NmsBlock(type, data, tag);
        }
        return null;
    }

    public static boolean set(World world, Vector position, BaseBlock block) {
        TileEntity te;
        NmsBlock nmsProxyBlock;
        NBTTagCompound data = null;
        if (block instanceof NmsBlock) {
            nmsProxyBlock = (NmsBlock)block;
            data = nmsProxyBlock.getNmsData(position);
        } else if (block instanceof TileEntityBlock) {
            nmsProxyBlock = new NmsBlock(block.getType(), block.getData(), block);
            data = nmsProxyBlock.getNmsData(position);
        }
        if (data != null && (te = ((CraftWorld)world).getHandle().getTileEntity(position.getBlockX(), position.getBlockY(), position.getBlockZ())) != null) {
            te.a(data);
            return true;
        }
        return false;
    }

    public static boolean setSafely(BukkitWorld world, Vector position, Block block, boolean notifyAdjacent) {
        int x = position.getBlockX();
        int y = position.getBlockY();
        int z = position.getBlockZ();
        CraftWorld craftWorld = (CraftWorld)world.getWorld();
        boolean successful = craftWorld.getHandle().setRawTypeIdAndData(x, y, z, block.getId(), block.getData());
        if (successful) {
            if (block instanceof BaseBlock) {
                world.copyToWorld(position, (BaseBlock)block);
            }
            if (notifyAdjacent) {
                craftWorld.getHandle().update(x, y, z, block.getId());
            } else {
                craftWorld.getHandle().notify(x, y, z);
            }
        }
        return successful;
    }

    private static Tag toNative(NBTBase foreign) {
        if (foreign == null) {
            return null;
        }
        if (foreign instanceof NBTTagCompound) {
            HashMap<String, Tag> values = new HashMap<String, Tag>();
            Collection foreignValues = null;
            if (compoundMapField == null) {
                try {
                    foreignValues = ((NBTTagCompound)foreign).c();
                }
                catch (Throwable t) {
                    try {
                        logger.warning("WorldEdit: Couldn't get NBTTagCompound.c(), so we're going to try to get at the 'map' field directly from now on");
                        if (compoundMapField == null) {
                            compoundMapField = NBTTagCompound.class.getDeclaredField("map");
                            compoundMapField.setAccessible(true);
                        }
                    }
                    catch (Throwable e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            if (compoundMapField != null) {
                try {
                    foreignValues = ((HashMap)compoundMapField.get(foreign)).values();
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
            for (Object obj : foreignValues) {
                NBTBase base = (NBTBase)obj;
                values.put(base.getName(), NmsBlock.toNative(base));
            }
            return new CompoundTag(foreign.getName(), values);
        }
        if (foreign instanceof NBTTagByte) {
            return new ByteTag(foreign.getName(), ((NBTTagByte)foreign).data);
        }
        if (foreign instanceof NBTTagByteArray) {
            return new ByteArrayTag(foreign.getName(), ((NBTTagByteArray)foreign).data);
        }
        if (foreign instanceof NBTTagDouble) {
            return new DoubleTag(foreign.getName(), ((NBTTagDouble)foreign).data);
        }
        if (foreign instanceof NBTTagFloat) {
            return new FloatTag(foreign.getName(), ((NBTTagFloat)foreign).data);
        }
        if (foreign instanceof NBTTagInt) {
            return new IntTag(foreign.getName(), ((NBTTagInt)foreign).data);
        }
        if (foreign instanceof NBTTagIntArray) {
            return new IntArrayTag(foreign.getName(), ((NBTTagIntArray)foreign).data);
        }
        if (foreign instanceof NBTTagList) {
            ArrayList<Tag> values = new ArrayList<Tag>();
            NBTTagList foreignList = (NBTTagList)foreign;
            int type = 1;
            for (int i = 0; i < foreignList.size(); ++i) {
                NBTBase foreignTag = foreignList.get(i);
                values.add(NmsBlock.toNative(foreignTag));
                type = foreignTag.getTypeId();
            }
            Class<? extends Tag> cls = NBTConstants.getClassFromType(type);
            return new ListTag(foreign.getName(), cls, values);
        }
        if (foreign instanceof NBTTagLong) {
            return new LongTag(foreign.getName(), ((NBTTagLong)foreign).data);
        }
        if (foreign instanceof NBTTagShort) {
            return new ShortTag(foreign.getName(), ((NBTTagShort)foreign).data);
        }
        if (foreign instanceof NBTTagString) {
            return new StringTag(foreign.getName(), ((NBTTagString)foreign).data);
        }
        if (foreign instanceof NBTTagEnd) {
            return new EndTag();
        }
        throw new IllegalArgumentException("Don't know how to make native " + foreign.getClass().getCanonicalName());
    }

    private static NBTBase fromNative(Tag foreign) {
        if (foreign == null) {
            return null;
        }
        if (foreign instanceof CompoundTag) {
            NBTTagCompound tag = new NBTTagCompound(foreign.getName());
            for (Map.Entry entry : ((CompoundTag)foreign).getValue().entrySet()) {
                tag.set((String)entry.getKey(), NmsBlock.fromNative((Tag)entry.getValue()));
            }
            return tag;
        }
        if (foreign instanceof ByteTag) {
            return new NBTTagByte(foreign.getName(), ((ByteTag)foreign).getValue().byteValue());
        }
        if (foreign instanceof ByteArrayTag) {
            return new NBTTagByteArray(foreign.getName(), ((ByteArrayTag)foreign).getValue());
        }
        if (foreign instanceof DoubleTag) {
            return new NBTTagDouble(foreign.getName(), ((DoubleTag)foreign).getValue().doubleValue());
        }
        if (foreign instanceof FloatTag) {
            return new NBTTagFloat(foreign.getName(), ((FloatTag)foreign).getValue().floatValue());
        }
        if (foreign instanceof IntTag) {
            return new NBTTagInt(foreign.getName(), ((IntTag)foreign).getValue().intValue());
        }
        if (foreign instanceof IntArrayTag) {
            return new NBTTagIntArray(foreign.getName(), ((IntArrayTag)foreign).getValue());
        }
        if (foreign instanceof ListTag) {
            NBTTagList tag = new NBTTagList(foreign.getName());
            ListTag foreignList = (ListTag)foreign;
            Iterator i$ = foreignList.getValue().iterator();
            while (i$.hasNext()) {
                Tag t = (Tag)i$.next();
                tag.add(NmsBlock.fromNative(t));
            }
            return tag;
        }
        if (foreign instanceof LongTag) {
            return new NBTTagLong(foreign.getName(), ((LongTag)foreign).getValue().longValue());
        }
        if (foreign instanceof ShortTag) {
            return new NBTTagShort(foreign.getName(), ((ShortTag)foreign).getValue().shortValue());
        }
        if (foreign instanceof StringTag) {
            return new NBTTagString(foreign.getName(), ((StringTag)foreign).getValue());
        }
        if (foreign instanceof EndTag) {
            return new NBTTagEnd();
        }
        throw new IllegalArgumentException("Don't know how to make NMS " + foreign.getClass().getCanonicalName());
    }
}

