/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.spout;

import com.sk89q.worldedit.LocalEntity;
import com.sk89q.worldedit.Location;
import com.sk89q.worldedit.spout.SpoutUtil;
import com.sk89q.worldedit.spout.SpoutWorld;
import org.spout.api.entity.Controller;
import org.spout.api.entity.Entity;
import org.spout.api.entity.controller.type.ControllerType;
import org.spout.api.geo.World;
import org.spout.api.geo.discrete.Point;

public class SpoutEntity
extends LocalEntity {
    private final ControllerType type;
    private final int entityId;

    public SpoutEntity(Location position, int id, Controller controller) {
        super(position);
        this.type = controller.getType();
        this.entityId = id;
    }

    public int getEntityId() {
        return this.entityId;
    }

    @Override
    public boolean spawn(Location loc) {
        World world = ((SpoutWorld)loc.getWorld()).getWorld();
        Point pos = SpoutUtil.toPoint(world, loc.getPosition());
        Controller controller = this.type.createController();
        if (controller == null) {
            return false;
        }
        Entity e = world.createAndSpawnEntity(pos, controller);
        if (e != null) {
            e.setPitch(loc.getPitch());
            e.setYaw(loc.getYaw());
            return true;
        }
        return false;
    }
}

