/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.spout;

import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandPermissions;
import com.sk89q.minecraft.util.commands.CommandsManager;
import com.sk89q.worldedit.LocalPlayer;
import com.sk89q.worldedit.LocalWorld;
import com.sk89q.worldedit.ServerInterface;
import com.sk89q.worldedit.spout.SpoutBiomeTypes;
import com.sk89q.worldedit.spout.SpoutRawCommandExecutor;
import com.sk89q.worldedit.spout.SpoutUtil;
import com.sk89q.worldedit.spout.WorldEditPlugin;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.spout.api.Engine;
import org.spout.api.command.RawCommandExecutor;
import org.spout.api.geo.World;
import org.spout.api.material.Material;
import org.spout.api.material.MaterialRegistry;
import org.spout.api.scheduler.TaskPriority;
import org.spout.api.util.Named;
import org.spout.vanilla.material.VanillaMaterial;

public class SpoutServerInterface
extends ServerInterface {
    public Engine game;
    public WorldEditPlugin plugin;
    private final SpoutRawCommandExecutor executor;
    private SpoutBiomeTypes biomes;

    public SpoutServerInterface(WorldEditPlugin plugin, Engine game) {
        this.plugin = plugin;
        this.game = game;
        this.biomes = new SpoutBiomeTypes();
        this.executor = new SpoutRawCommandExecutor(plugin);
    }

    @Override
    public int resolveItem(String name) {
        Material mat = MaterialRegistry.get((String)name);
        return mat == null || !(mat instanceof VanillaMaterial) ? 0 : ((VanillaMaterial)mat).getMinecraftId();
    }

    @Override
    public boolean isValidMobType(String type) {
        return false;
    }

    @Override
    public void reload() {
        this.plugin.loadConfiguration();
    }

    @Override
    public SpoutBiomeTypes getBiomes() {
        return this.biomes;
    }

    @Override
    public int schedule(long delay, long period, Runnable task) {
        return this.game.getScheduler().scheduleSyncRepeatingTask((Object)this.plugin, task, delay * 50L, period * 50L, TaskPriority.NORMAL);
    }

    @Override
    public List<LocalWorld> getWorlds() {
        Collection worlds = this.game.getWorlds();
        ArrayList<LocalWorld> ret = new ArrayList<LocalWorld>(worlds.size());
        for (World world : worlds) {
            ret.add(SpoutUtil.getLocalWorld(world));
        }
        return ret;
    }

    @Override
    public void onCommandRegistration(List<Command> commands, CommandsManager<LocalPlayer> manager) {
        for (Command command : commands) {
            org.spout.api.command.Command spoutCommand = this.game.getRootCommand().addSubCommand((Named)this.plugin, command.aliases()[0]).addAlias(command.aliases()).setRawExecutor((RawCommandExecutor)this.executor).setHelp("/" + command.aliases()[0] + " " + command.usage() + " - " + command.desc());
            Method cmdMethod = manager.getMethods().get(null).get(command.aliases()[0]);
            if (cmdMethod != null && cmdMethod.isAnnotationPresent(CommandPermissions.class)) {
                spoutCommand.setPermissions(false, cmdMethod.getAnnotation(CommandPermissions.class).value());
            }
            spoutCommand.closeSubCommand();
        }
    }
}

