/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.Breeze.Utils;

import com.Acrobot.Breeze.Utils.MaterialUtil;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class InventoryUtil {
    public static int getAmount(ItemStack item, Inventory inventory) {
        if (!inventory.contains(item.getType())) {
            return 0;
        }
        HashMap items = inventory.all(item.getType());
        int itemAmount = 0;
        for (ItemStack iStack : items.values()) {
            if (!MaterialUtil.equals(iStack, item)) continue;
            itemAmount += iStack.getAmount();
        }
        return itemAmount;
    }

    public static boolean fits(ItemStack item, Inventory inventory) {
        int left = item.getAmount();
        for (ItemStack iStack : inventory.getContents()) {
            if (left <= 0) {
                return true;
            }
            if (MaterialUtil.isEmpty(iStack)) {
                left -= inventory.getMaxStackSize();
                continue;
            }
            if (!MaterialUtil.equals(iStack, item)) continue;
            left -= iStack.getMaxStackSize() - iStack.getAmount();
        }
        return left <= 0;
    }

    public static int add(ItemStack item, Inventory inventory) {
        HashMap leftovers = inventory.addItem(new ItemStack[]{item});
        return InventoryUtil.countItems(leftovers);
    }

    public static int remove(ItemStack item, Inventory inventory) {
        HashMap leftovers = inventory.removeItem(new ItemStack[]{item});
        return InventoryUtil.countItems(leftovers);
    }

    private static int countItems(Map<Integer, ?> items) {
        int totalLeft = 0;
        for (int left : items.keySet()) {
            totalLeft += left;
        }
        return totalLeft;
    }
}

