/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.Breeze.Utils;

import com.Acrobot.Breeze.Utils.NumberUtil;
import com.Acrobot.Breeze.Utils.StringUtil;
import info.somethingodd.bukkit.OddItem.OddItem;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.CoalType;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.TreeSpecies;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.Coal;
import org.bukkit.material.Colorable;
import org.bukkit.material.MaterialData;
import org.bukkit.material.SpawnEgg;
import org.bukkit.material.TexturedMaterial;
import org.bukkit.material.Tree;

public class MaterialUtil {
    private static final Pattern DURABILITY = Pattern.compile(":(\\d)*");
    private static final Pattern ENCHANTMENT = Pattern.compile("-([0-9a-zA-Z])*");

    public static boolean isEmpty(ItemStack item) {
        return item == null || item.getType() == Material.AIR;
    }

    public static boolean equals(ItemStack one, ItemStack two) {
        if (one.getType() != two.getType()) {
            return false;
        }
        if (one.getDurability() != two.getDurability()) {
            return false;
        }
        return ((Object)one.getEnchantments()).equals(two.getEnchantments());
    }

    public static Material getMaterial(String name) {
        Material material = Material.matchMaterial((String)name);
        if (material != null) {
            return material;
        }
        name = name.toUpperCase().replace(" ", "_");
        int length = Short.MAX_VALUE;
        for (Material currentMaterial : Material.values()) {
            String matName = currentMaterial.name();
            if (!matName.startsWith(name) || matName.length() >= length) continue;
            length = (short)matName.length();
            material = currentMaterial;
        }
        return material;
    }

    public static String getName(ItemStack itemStack) {
        return MaterialUtil.getName(itemStack, true);
    }

    public static String getName(ItemStack itemStack, boolean showDataValue) {
        String dataName = DataValue.name(itemStack);
        if (dataName != null && showDataValue) {
            return StringUtil.capitalizeFirstLetter(dataName + '_' + itemStack.getType(), '_');
        }
        return StringUtil.capitalizeFirstLetter(itemStack.getType().toString(), '_');
    }

    public static String getSignName(ItemStack itemStack) {
        StringBuilder name = new StringBuilder(15);
        name.append(itemStack.getType().name());
        if (itemStack.getDurability() != 0) {
            name.append(':').append(itemStack.getDurability());
        }
        if (!itemStack.getEnchantments().isEmpty()) {
            name.append('-').append(Enchantment.encodeEnchantment(itemStack));
        }
        return name.toString();
    }

    public static ItemStack getItem(String itemName) {
        String[] spaces;
        ItemStack itemStack = Odd.getFromString(itemName);
        if (itemStack != null) {
            return itemStack;
        }
        String[] split = itemName.trim().split(":|-");
        if (split.length == 0) {
            return null;
        }
        Material material = MaterialUtil.getMaterial(split[0]);
        boolean onlyPartiallyChecked = false;
        if (material == null) {
            int index = split[0].indexOf(32);
            if (index == -1) {
                return null;
            }
            material = MaterialUtil.getMaterial(split[0].substring(index + 1));
            if (material == null) {
                return null;
            }
            onlyPartiallyChecked = true;
        }
        itemStack = new ItemStack(material, 1);
        short durability = MaterialUtil.getDurability(itemName);
        if (durability == 0 && onlyPartiallyChecked && (spaces = itemName.split(" ")).length != 0) {
            durability = DataValue.get(spaces[0], material);
        }
        itemStack.setDurability(durability);
        Map<org.bukkit.enchantments.Enchantment, Integer> enchantments = MaterialUtil.getEnchantments(itemName);
        if (!enchantments.isEmpty()) {
            itemStack.addEnchantments(enchantments);
        }
        return itemStack;
    }

    public static short getDurability(String itemName) {
        Matcher m = DURABILITY.matcher(itemName);
        if (!m.find()) {
            return 0;
        }
        String data = m.group();
        if (data == null || data.isEmpty()) {
            return 0;
        }
        return NumberUtil.isInteger(data = data.substring(1)) ? Short.valueOf(data) : (short)0;
    }

    public static Map<org.bukkit.enchantments.Enchantment, Integer> getEnchantments(String itemName) {
        Matcher m = ENCHANTMENT.matcher(itemName);
        if (!m.find()) {
            return new HashMap<org.bukkit.enchantments.Enchantment, Integer>();
        }
        String group = m.group().substring(1);
        return Enchantment.getEnchantments(group);
    }

    public static class Odd {
        private static boolean isInitialized = false;

        public static ItemStack getFromString(String itemName) {
            if (!isInitialized) {
                return null;
            }
            String name = itemName.replace(':', ';');
            try {
                return OddItem.getItemStack((String)name);
            }
            catch (Exception ex) {
                return null;
            }
        }

        public static void initialize() {
            isInitialized = true;
        }
    }

    public static class DataValue {
        public static byte get(String type, Material material) {
            if (material == null || material.getData() == null) {
                return 0;
            }
            type = type.toUpperCase().replace(" ", "_");
            MaterialData materialData = material.getNewData((byte)0);
            if (materialData instanceof TexturedMaterial) {
                TexturedMaterial texturedMaterial = (TexturedMaterial)materialData;
                for (Material mat : texturedMaterial.getTextures()) {
                    if (!mat.name().startsWith(type) || mat.equals((Object)material)) continue;
                    return (byte)texturedMaterial.getTextures().indexOf(mat);
                }
            } else {
                if (materialData instanceof Colorable) {
                    DyeColor color;
                    try {
                        color = DyeColor.valueOf((String)type);
                    }
                    catch (IllegalArgumentException exception) {
                        return 0;
                    }
                    if (material == Material.INK_SACK) {
                        color = DyeColor.getByData((byte)((byte)(15 - color.getData())));
                    }
                    return color.getData();
                }
                if (materialData instanceof Tree) {
                    try {
                        return TreeSpecies.valueOf((String)type).getData();
                    }
                    catch (IllegalArgumentException ex) {
                        return 0;
                    }
                }
                if (materialData instanceof SpawnEgg) {
                    try {
                        EntityType entityType = EntityType.valueOf((String)type);
                        return (byte)entityType.getTypeId();
                    }
                    catch (IllegalArgumentException ex) {
                        return 0;
                    }
                }
                if (materialData instanceof Coal) {
                    try {
                        return CoalType.valueOf((String)type).getData();
                    }
                    catch (IllegalArgumentException ex) {
                        return 0;
                    }
                }
            }
            return 0;
        }

        public static String name(ItemStack itemStack) {
            MaterialData data = itemStack.getData();
            if (data == null) {
                return null;
            }
            if (data instanceof TexturedMaterial) {
                return ((TexturedMaterial)data).getMaterial().name();
            }
            if (data instanceof Colorable) {
                return ((Colorable)data).getColor().name();
            }
            if (data instanceof Tree) {
                TreeSpecies specie = ((Tree)data).getSpecies();
                return specie != null && specie != TreeSpecies.GENERIC ? specie.name() : null;
            }
            if (data instanceof SpawnEgg) {
                EntityType type = ((SpawnEgg)data).getSpawnedType();
                return type != null ? type.name() : null;
            }
            if (data instanceof Coal) {
                CoalType coal = ((Coal)data).getType();
                return coal != null && coal != CoalType.COAL ? coal.name() : null;
            }
            return null;
        }
    }

    public static class Enchantment {
        public static Map<org.bukkit.enchantments.Enchantment, Integer> getEnchantments(String base32) {
            if (base32 == null) {
                return new HashMap<org.bukkit.enchantments.Enchantment, Integer>();
            }
            HashMap<org.bukkit.enchantments.Enchantment, Integer> map = new HashMap<org.bukkit.enchantments.Enchantment, Integer>();
            StringBuilder number = new StringBuilder(Long.toString(Long.parseLong(base32, 32)));
            while (number.length() % 3 != 0) {
                number.insert(0, '0');
            }
            for (int i = 0; i < number.length() / 3; ++i) {
                int level;
                String item = number.substring(i * 3, i * 3 + 3);
                org.bukkit.enchantments.Enchantment enchantment = org.bukkit.enchantments.Enchantment.getById((int)Integer.parseInt(item.substring(0, 2)));
                if (enchantment == null || (level = Integer.parseInt(item.substring(2))) > enchantment.getMaxLevel() || level < enchantment.getStartLevel()) continue;
                map.put(enchantment, level);
            }
            return map;
        }

        public static String encodeEnchantment(Map<org.bukkit.enchantments.Enchantment, Integer> enchantments) {
            long number = 0L;
            for (Map.Entry<org.bukkit.enchantments.Enchantment, Integer> entry : enchantments.entrySet()) {
                number = number * 1000L + (long)(entry.getKey().getId() * 10) + (long)entry.getValue().intValue();
            }
            return number != 0L ? Long.toString(number, 32) : null;
        }

        public static String encodeEnchantment(ItemStack item) {
            return Enchantment.encodeEnchantment(item.getEnchantments());
        }
    }
}

