/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop;

import com.Acrobot.ChestShop.Commands.ItemInfo;
import com.Acrobot.ChestShop.Commands.Version;
import com.Acrobot.ChestShop.Config.Config;
import com.Acrobot.ChestShop.Config.Property;
import com.Acrobot.ChestShop.DB.Generator;
import com.Acrobot.ChestShop.DB.Queue;
import com.Acrobot.ChestShop.DB.Transaction;
import com.Acrobot.ChestShop.Dependencies;
import com.Acrobot.ChestShop.Listeners.Block.BlockBreak;
import com.Acrobot.ChestShop.Listeners.Block.BlockPlace;
import com.Acrobot.ChestShop.Listeners.Block.EntityExplode;
import com.Acrobot.ChestShop.Listeners.Block.SignChange;
import com.Acrobot.ChestShop.Listeners.ItemInfoListener;
import com.Acrobot.ChestShop.Listeners.Player.PlayerConnect;
import com.Acrobot.ChestShop.Listeners.Player.PlayerInteract;
import com.Acrobot.ChestShop.Listeners.Player.ShortNameSaver;
import com.Acrobot.ChestShop.Listeners.Transaction.EmptyShopDeleter;
import com.Acrobot.ChestShop.Listeners.Transaction.TransactionLogger;
import com.Acrobot.ChestShop.Listeners.Transaction.TransactionMessageSender;
import com.Acrobot.ChestShop.Logging.FileFormatter;
import com.Acrobot.ChestShop.Metrics;
import com.avaje.ebean.EbeanServer;
import com.lennardf1989.bukkitex.Database;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.FileHandler;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class ChestShop
extends JavaPlugin {
    public static File dataFolder = new File("plugins/ChestShop");
    private static EbeanServer DB;
    private static PluginDescriptionFile description;
    private static Server server;
    private static Logger logger;
    private static PluginManager pluginManager;
    private static ChestShop plugin;
    private FileHandler handler;
    private static Database database;

    public void onEnable() {
        plugin = this;
        logger = this.getLogger();
        pluginManager = this.getServer().getPluginManager();
        dataFolder = this.getDataFolder();
        description = this.getDescription();
        server = this.getServer();
        Config.setup();
        Dependencies.load();
        this.registerEvents();
        if (Config.getBoolean(Property.LOG_TO_DATABASE) || Config.getBoolean(Property.GENERATE_STATISTICS_PAGE)) {
            this.setupDB();
        }
        if (Config.getBoolean(Property.GENERATE_STATISTICS_PAGE)) {
            File htmlFolder = new File(Config.getString(Property.STATISTICS_PAGE_PATH));
            this.scheduleTask(new Generator(htmlFolder), 300L, (long)Config.getDouble(Property.STATISTICS_PAGE_GENERATION_INTERVAL) * 20L);
        }
        if (Config.getBoolean(Property.LOG_TO_FILE)) {
            File log = ChestShop.loadFile(new File(ChestShop.getFolder(), "ChestShop.log"));
            FileHandler handler = ChestShop.loadHandler(log.getAbsolutePath());
            handler.setFormatter(new FileFormatter());
            this.handler = handler;
            logger.addHandler(handler);
        }
        if (!Config.getBoolean(Property.LOG_TO_CONSOLE)) {
            logger.setUseParentHandlers(false);
        }
        this.getCommand("iteminfo").setExecutor((CommandExecutor)new ItemInfo());
        this.getCommand("csVersion").setExecutor((CommandExecutor)new Version());
        this.startStatistics();
    }

    private static File loadFile(File file) {
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return file;
    }

    private static FileHandler loadHandler(String path) {
        FileHandler handler = null;
        try {
            handler = new FileHandler(path, true);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return handler;
    }

    public void onDisable() {
        this.getServer().getScheduler().cancelTasks((Plugin)this);
        if (this.handler != null) {
            this.handler.close();
            this.getLogger().removeHandler(this.handler);
        }
    }

    private void registerEvents() {
        this.registerEvent(new com.Acrobot.ChestShop.Plugins.ChestShop());
        this.registerEvent(new BlockBreak());
        this.registerEvent(new BlockPlace());
        this.registerEvent(new SignChange());
        this.registerEvent(new EntityExplode());
        this.registerEvent(new PlayerConnect());
        this.registerEvent(new ItemInfoListener());
        this.registerEvent(new EmptyShopDeleter());
        this.registerEvent(new TransactionLogger());
        this.registerEvent(new TransactionMessageSender());
        this.registerEvent(new ShortNameSaver());
        this.registerEvent(new PlayerInteract(Config.getInteger(Property.SHOP_INTERACTION_INTERVAL)));
    }

    public void registerEvent(Listener listener) {
        this.getServer().getPluginManager().registerEvents(listener, (Plugin)this);
    }

    private void scheduleTask(Runnable runnable, long startTime, long repetetionTime) {
        server.getScheduler().scheduleAsyncRepeatingTask((Plugin)this, runnable, startTime, repetetionTime);
    }

    private void startStatistics() {
        try {
            new Metrics((Plugin)this).start();
        }
        catch (IOException ex) {
            ChestShop.getBukkitLogger().severe("There was an error while submitting statistics.");
        }
    }

    private static YamlConfiguration getBukkitConfig() {
        return YamlConfiguration.loadConfiguration((File)new File("bukkit.yml"));
    }

    private void setupDB() {
        database = new Database(this){

            @Override
            protected List<Class<?>> getDatabaseClasses() {
                ArrayList list = new ArrayList();
                list.add(Transaction.class);
                return list;
            }
        };
        YamlConfiguration config = ChestShop.getBukkitConfig();
        database.initializeDatabase(config.getString("database.driver"), config.getString("database.url"), config.getString("database.username"), config.getString("database.password"), config.getString("database.isolation"));
        DB = database.getDatabase();
        this.getServer().getScheduler().scheduleAsyncRepeatingTask((Plugin)this, (Runnable)new Queue(), 200L, 200L);
    }

    public EbeanServer getDatabase() {
        return database.getDatabase();
    }

    public static File getFolder() {
        return dataFolder;
    }

    public static Logger getBukkitLogger() {
        return logger;
    }

    public static Server getBukkitServer() {
        return server;
    }

    public static String getVersion() {
        return description.getVersion();
    }

    public static String getPluginName() {
        return description.getName();
    }

    public static EbeanServer getDB() {
        return DB;
    }

    public static List getDependencies() {
        return description.getSoftDepend();
    }

    public static void registerListener(Listener listener) {
        plugin.registerEvent(listener);
    }

    public static void callEvent(Event event) {
        pluginManager.callEvent(event);
    }

    public static void scheduleRepeating(Runnable runnable, int delay) {
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)plugin, runnable, 0L, (long)delay);
    }
}

