/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Config;

import com.Acrobot.ChestShop.Config.Value;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;

public class BreezeConfiguration
extends YamlConfiguration {
    protected final File file;
    protected final Map<String, Value> defaultValues = new LinkedHashMap<String, Value>();

    protected BreezeConfiguration(File file) {
        this.file = file;
    }

    public void addDefaultValues(Map<String, ? extends Value> map) {
        this.defaultValues.putAll(map);
    }

    public static BreezeConfiguration loadConfiguration(File file) {
        if (file == null) {
            throw new IllegalArgumentException("File cannot be null");
        }
        BreezeConfiguration config = new BreezeConfiguration(file);
        config.load();
        return config;
    }

    public static BreezeConfiguration loadConfiguration(File file, Map<String, Value> defaults) {
        if (file == null) {
            throw new IllegalArgumentException("File cannot be null");
        }
        BreezeConfiguration config = new BreezeConfiguration(file);
        config.addDefaultValues(defaults);
        config.load();
        return config;
    }

    public void load() {
        try {
            if (!this.file.getParentFile().exists()) {
                this.file.getParentFile().mkdir();
            }
            if (!this.file.exists()) {
                this.file.createNewFile();
            }
            super.load(this.file);
        }
        catch (InvalidConfigurationException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.createDefaultValues()) {
            this.load();
        }
    }

    public void reload() {
        this.save();
        this.load();
    }

    private boolean createDefaultValues() {
        boolean changed = false;
        if (!this.file.exists()) {
            try {
                this.file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(this.file, true));
            for (Map.Entry<String, Value> entry : this.defaultValues.entrySet()) {
                if (this.contains(entry.getKey())) continue;
                changed = true;
                bw.write('\n' + entry.getKey() + ": " + entry.getValue().retrieveValue());
            }
            bw.close();
            if (changed) {
                this.load();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return changed;
    }

    public void save() {
        try {
            super.save(this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

