/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Config;

import com.Acrobot.ChestShop.ChestShop;
import com.Acrobot.ChestShop.Config.BreezeConfiguration;
import com.Acrobot.ChestShop.Config.Language;
import com.Acrobot.ChestShop.Config.Property;
import com.Acrobot.ChestShop.Utils.uName;
import com.nijikokun.register.payment.forChestShop.Methods;
import java.io.File;
import org.bukkit.ChatColor;

public class Config {
    private static BreezeConfiguration normalConfig;
    private static BreezeConfiguration languageConfig;

    public static void setup() {
        File configFolder = ChestShop.getFolder();
        normalConfig = BreezeConfiguration.loadConfiguration(new File(configFolder, "config.yml"), Property.getValues());
        languageConfig = BreezeConfiguration.loadConfiguration(new File(configFolder, "local.yml"), Language.getValues());
        uName.config = BreezeConfiguration.loadConfiguration(new File(configFolder, "longName.storage"));
        Methods.setPreferred(Config.getString(Property.PREFERRED_ECONOMY_PLUGIN));
    }

    public static boolean getBoolean(Property value) {
        return (Boolean)Config.getValue(value.name());
    }

    public static float getFloat(Property value) {
        return Config.getFloat(value.name());
    }

    public static float getFloat(String value) {
        return new Float(Config.getValue(value).toString()).floatValue();
    }

    public static String getString(Property value) {
        return (String)Config.getValue(value.name());
    }

    public static int getInteger(Property value) {
        return Integer.parseInt(Config.getValue(value.name()).toString());
    }

    public static double getDouble(Property value) {
        return Config.getDouble(value.name());
    }

    public static double getDouble(String value) {
        return new Double(Config.getValue(value).toString());
    }

    private static String getColored(String msg) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)msg);
    }

    public static String getLocal(Language lang) {
        return Config.getColored(languageConfig.getString(Language.prefix.name()) + languageConfig.getString(lang.name()));
    }

    public static boolean exists(String value) {
        return Config.getValue(value) != null;
    }

    private static Object getValue(String node) {
        return normalConfig.get(node);
    }
}

