/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Config;

import com.Acrobot.ChestShop.Config.Config;
import org.bukkit.Material;

public class MaxPrice {
    public static boolean canCreate(double buyPrice, double sellPrice, Material mat) {
        return MaxPrice.buyPriceWithinRange(buyPrice, mat) && MaxPrice.sellPriceWithinRange(sellPrice, mat);
    }

    private static boolean buyPriceWithinRange(double buyPrice, Material material) {
        double bPrice = MaxPrice.maxBuyPrice(material);
        double maxPrice = MaxPrice.maxBuyPrice();
        return buyPrice <= bPrice && buyPrice <= maxPrice;
    }

    private static boolean sellPriceWithinRange(double sellPrice, Material material) {
        double sPrice = MaxPrice.maxSellPrice(material);
        double maxPrice = MaxPrice.maxSellPrice();
        return sellPrice <= sPrice && sellPrice <= maxPrice;
    }

    public static double maxBuyPrice() {
        return MaxPrice.getPrice(Price.buy);
    }

    public static double maxSellPrice() {
        return MaxPrice.getPrice(Price.sell);
    }

    public static double maxBuyPrice(Material material) {
        return MaxPrice.getPrice(Price.buy, material.getId());
    }

    public static double maxSellPrice(Material material) {
        return MaxPrice.getPrice(Price.sell, material.getId());
    }

    public static double getPrice(Price price) {
        return MaxPrice.getPrice(price, -1);
    }

    public static double getPrice(Price price, int itemID) {
        String node = "max-" + (Object)((Object)price) + "-price" + (itemID > 0 ? "-" + itemID : "");
        return Config.exists(node) ? Config.getDouble(node) : Double.MAX_VALUE;
    }

    private static enum Price {
        buy,
        sell;

    }
}

