/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Containers;

import com.Acrobot.Breeze.Utils.InventoryUtil;
import com.Acrobot.ChestShop.Containers.Container;
import com.Acrobot.ChestShop.Utils.uBlock;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Chest;
import org.bukkit.block.Sign;
import org.bukkit.inventory.ItemStack;

public class ShopChest
implements Container {
    private final Chest chest;
    private static final BlockFace[] NEIGHBOR_FACES = new BlockFace[]{BlockFace.EAST, BlockFace.NORTH, BlockFace.WEST, BlockFace.SOUTH};

    public ShopChest(Chest chest) {
        this.chest = chest;
    }

    @Override
    public boolean isEmpty() {
        for (ItemStack item : this.chest.getInventory()) {
            if (item == null) continue;
            return false;
        }
        return true;
    }

    @Override
    public void addItem(ItemStack item) {
        InventoryUtil.add(item, this.chest.getInventory());
    }

    @Override
    public void removeItem(ItemStack item) {
        InventoryUtil.remove(item, this.chest.getInventory());
    }

    @Override
    public int amount(ItemStack item) {
        return InventoryUtil.getAmount(item, this.chest.getInventory());
    }

    @Override
    public boolean hasEnough(ItemStack item) {
        return this.amount(item) >= item.getAmount();
    }

    @Override
    public boolean fits(ItemStack item) {
        return InventoryUtil.fits(item, this.chest.getInventory());
    }

    public Sign findShopSign() {
        Sign sign = uBlock.findAnyNearbyShopSign(this.chest.getBlock());
        if (sign == null && this.getNeighbor() != null) {
            sign = uBlock.findAnyNearbyShopSign(this.getNeighbor().getBlock());
        }
        return sign;
    }

    private Chest getNeighbor() {
        Block chestBlock = this.chest.getBlock();
        for (BlockFace chestFace : NEIGHBOR_FACES) {
            Block relative = chestBlock.getRelative(chestFace);
            if (!(relative.getState() instanceof Chest)) continue;
            return (Chest)relative.getState();
        }
        return null;
    }
}

