/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.DB;

import com.Acrobot.ChestShop.ChestShop;
import com.Acrobot.ChestShop.Config.Config;
import com.Acrobot.ChestShop.Config.Property;
import com.Acrobot.ChestShop.DB.Transaction;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.persistence.OptimisticLockException;

public class Queue
implements Runnable {
    private static final ConcurrentLinkedQueue<Transaction> queue = new ConcurrentLinkedQueue();

    public static void addToQueue(Transaction t) {
        queue.add(t);
    }

    @Override
    public synchronized void run() {
        if (Config.getInteger(Property.RECORD_TIME_TO_LIVE) != -1) {
            Queue.deleteOld();
        }
        ChestShop.getDB().save(queue);
        queue.clear();
    }

    public static synchronized boolean deleteOld() {
        try {
            ChestShop.getDB().delete((Collection)Queue.getOld());
            return true;
        }
        catch (OptimisticLockException ex) {
            return false;
        }
    }

    public static List getOld() throws OptimisticLockException {
        return ChestShop.getDB().find(Transaction.class).where().lt("sec", (Object)(System.currentTimeMillis() / 1000L - (long)Config.getInteger(Property.RECORD_TIME_TO_LIVE))).findList();
    }
}

