/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop;

import com.Acrobot.Breeze.Utils.MaterialUtil;
import com.Acrobot.ChestShop.ChestShop;
import com.Acrobot.ChestShop.Config.Config;
import com.Acrobot.ChestShop.Config.Property;
import com.Acrobot.ChestShop.Economy.Economy;
import com.Acrobot.ChestShop.Economy.NoProvider;
import com.Acrobot.ChestShop.Economy.Register;
import com.Acrobot.ChestShop.Economy.Vault;
import com.Acrobot.ChestShop.Plugins.Deadbolt;
import com.Acrobot.ChestShop.Plugins.Heroes;
import com.Acrobot.ChestShop.Plugins.LightweightChestProtection;
import com.Acrobot.ChestShop.Plugins.Lockette;
import com.Acrobot.ChestShop.Plugins.SimpleChestLock;
import com.Acrobot.ChestShop.Plugins.Towny;
import com.Acrobot.ChestShop.Plugins.WorldGuardBuilding;
import com.Acrobot.ChestShop.Plugins.WorldGuardProtection;
import com.nijikokun.register.payment.forChestShop.Method;
import com.nijikokun.register.payment.forChestShop.Methods;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginManager;

public class Dependencies {
    public static void load() {
        PluginManager pluginManager = Bukkit.getPluginManager();
        for (String dependency : ChestShop.getDependencies()) {
            Plugin plugin = pluginManager.getPlugin(dependency);
            if (plugin == null) continue;
            Dependencies.initializePlugin(dependency, plugin);
        }
        if (!Economy.isLoaded()) {
            Dependencies.loadRegister();
        }
    }

    private static void loadRegister() {
        Method method = Methods.load();
        if (method == null) {
            Economy.setPlugin(new NoProvider());
            return;
        }
        Economy.setPlugin(new Register(method));
        ChestShop.getBukkitLogger().info(method.getName() + " version " + method.getVersion() + " loaded.");
    }

    private static void initializePlugin(String name, Plugin plugin) {
        Dependency dependency;
        try {
            dependency = Dependency.valueOf(name);
        }
        catch (IllegalArgumentException exception) {
            return;
        }
        Object listener = null;
        switch (dependency) {
            case LWC: {
                listener = new LightweightChestProtection();
                break;
            }
            case Lockette: {
                listener = new Lockette();
                break;
            }
            case Deadbolt: {
                listener = new Deadbolt();
                break;
            }
            case SimpleChestLock: {
                listener = SimpleChestLock.getSimpleChestLock(plugin);
                break;
            }
            case Towny: {
                Towny towny = Towny.getTowny();
                if (towny == null) {
                    return;
                }
                listener = towny;
                break;
            }
            case WorldGuard: {
                boolean inUse;
                WorldGuardPlugin worldGuard = (WorldGuardPlugin)plugin;
                boolean bl = inUse = Config.getBoolean(Property.WORLDGUARD_USE_PROTECTION) || Config.getBoolean(Property.WORLDGUARD_INTEGRATION);
                if (!inUse) {
                    return;
                }
                if (Config.getBoolean(Property.WORLDGUARD_USE_PROTECTION)) {
                    ChestShop.registerListener(new WorldGuardProtection(worldGuard));
                }
                if (!Config.getBoolean(Property.WORLDGUARD_INTEGRATION)) break;
                listener = new WorldGuardBuilding(worldGuard);
                break;
            }
            case Vault: {
                Vault vault = Vault.getVault();
                if (vault == null) {
                    return;
                }
                Economy.setPlugin(vault);
                ChestShop.getBukkitLogger().info("Vault loaded - using " + Vault.getPluginName());
                return;
            }
            case Heroes: {
                Heroes heroes = Heroes.getHeroes(plugin);
                if (heroes == null) {
                    return;
                }
                listener = heroes;
                break;
            }
            case OddItem: {
                MaterialUtil.Odd.initialize();
            }
        }
        if (listener != null) {
            ChestShop.registerListener(listener);
        }
        PluginDescriptionFile description = plugin.getDescription();
        ChestShop.getBukkitLogger().info(description.getName() + " version " + description.getVersion() + " loaded.");
    }

    private static enum Dependency {
        LWC,
        Lockette,
        Deadbolt,
        SimpleChestLock,
        OddItem,
        Towny,
        WorldGuard,
        Vault,
        Heroes;

    }
}

