/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Economy;

import com.Acrobot.Breeze.Utils.NumberUtil;
import com.Acrobot.ChestShop.Config.Config;
import com.Acrobot.ChestShop.Config.Property;
import com.Acrobot.ChestShop.Economy.EcoPlugin;
import com.Acrobot.ChestShop.Utils.uName;

public class Economy {
    private static EcoPlugin economy;

    public static boolean hasAccount(String p) {
        return !p.isEmpty() && economy.hasAccount(uName.getName(p));
    }

    public static void add(String name, double amount) {
        Property taxAmount;
        if (!Economy.hasAccount(name)) {
            return;
        }
        String serverAccount = Config.getString(Property.SERVER_ECONOMY_ACCOUNT);
        Property property = taxAmount = name.equals(serverAccount) ? Property.SERVER_TAX_AMOUNT : Property.TAX_AMOUNT;
        if (Config.getFloat(taxAmount) != 0.0f) {
            double tax = Economy.getTax(taxAmount, amount);
            if (!serverAccount.isEmpty()) {
                economy.add(serverAccount, tax);
            }
            amount -= tax;
        }
        economy.add(uName.getName(name), NumberUtil.roundUp(amount));
    }

    public static double getTax(Property tax, double price) {
        return (double)(Config.getFloat(tax) / 100.0f) * price;
    }

    public static void subtract(String name, double amount) {
        if (!Economy.hasAccount(name)) {
            return;
        }
        economy.subtract(uName.getName(name), NumberUtil.roundUp(amount));
    }

    public static boolean hasEnough(String name, double amount) {
        if (!Economy.hasAccount(name)) {
            return true;
        }
        return economy.hasEnough(uName.getName(name), NumberUtil.roundUp(amount));
    }

    public static double balance(String name) {
        return economy.balance(uName.getName(name));
    }

    public static String formatBalance(double amount) {
        return economy.format(NumberUtil.roundUp(amount));
    }

    public static void setPlugin(EcoPlugin plugin) {
        economy = plugin;
    }

    public static EcoPlugin getPlugin() {
        return economy;
    }

    public static boolean isLoaded() {
        return economy != null;
    }
}

