/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Listeners.Block;

import com.Acrobot.Breeze.Utils.BlockUtil;
import com.Acrobot.ChestShop.Config.Config;
import com.Acrobot.ChestShop.Config.Language;
import com.Acrobot.ChestShop.Config.Property;
import com.Acrobot.ChestShop.Economy.Economy;
import com.Acrobot.ChestShop.Permission;
import com.Acrobot.ChestShop.Utils.uBlock;
import com.Acrobot.ChestShop.Utils.uName;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.material.Directional;
import org.bukkit.material.PistonBaseMaterial;

public class BlockBreak
implements Listener {
    public static boolean cancellingBlockBreak(Block block, Player player) {
        Sign sign;
        if (block == null) {
            return false;
        }
        if (BlockUtil.isSign(block)) {
            block.getState().update();
        }
        if (!BlockBreak.isCorrectSign(sign = uBlock.findValidShopSign(block, player != null ? uName.stripName(player.getName()) : null), block)) {
            return false;
        }
        if (BlockBreak.playerIsNotOwner(player, sign)) {
            return !BlockBreak.isAdmin(player);
        }
        if (BlockBreak.weShouldReturnMoney() && !Permission.has(player, Permission.NOFEE)) {
            float refundPrice = Config.getFloat(Property.SHOP_REFUND_PRICE);
            Economy.add(uName.getName(sign.getLine(0)), refundPrice);
            player.sendMessage(Config.getLocal(Language.SHOP_REFUNDED).replace("%amount", Economy.formatBalance(refundPrice)));
        }
        return false;
    }

    private static boolean isAdmin(Player p) {
        return p != null && (Permission.has(p, Permission.ADMIN) || Permission.has(p, Permission.MOD));
    }

    private static boolean weShouldReturnMoney() {
        return Config.getFloat(Property.SHOP_REFUND_PRICE) != 0.0f;
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public static void onBlockBreak(BlockBreakEvent event) {
        if (BlockBreak.cancellingBlockBreak(event.getBlock(), event.getPlayer())) {
            event.setCancelled(true);
        }
    }

    private static boolean isCorrectSign(Sign sign, Block block) {
        return sign != null && (sign.getBlock().equals(block) || uBlock.getAttachedFace(sign).equals(block));
    }

    private static boolean playerIsNotOwner(Player player, Sign sign) {
        return player == null || !uName.stripName(player.getName()).equals(sign.getLine(0)) && !Permission.otherName(player, sign.getLine(0));
    }

    @EventHandler(ignoreCancelled=true)
    public static void onBlockPistonExtend(BlockPistonExtendEvent event) {
        for (Block b : BlockBreak.getExtendBlocks(event)) {
            if (!BlockBreak.cancellingBlockBreak(b, null)) continue;
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(ignoreCancelled=true)
    public static void onBlockPistonRetract(BlockPistonRetractEvent event) {
        if (BlockBreak.cancellingBlockBreak(BlockBreak.getRetractBlock(event), null)) {
            event.setCancelled(true);
        }
    }

    private static Block getRetractBlock(BlockPistonRetractEvent event) {
        Block block = BlockBreak.getRetractLocationBlock(event);
        return block != null && !BlockUtil.isSign(block) ? block : null;
    }

    private static BlockFace getPistonDirection(Block block) {
        return block.getState().getData() instanceof PistonBaseMaterial ? ((Directional)block.getState().getData()).getFacing() : null;
    }

    private static Block getRetractLocationBlock(BlockPistonRetractEvent event) {
        BlockFace pistonDirection = BlockBreak.getPistonDirection(event.getBlock());
        return pistonDirection != null ? event.getBlock().getRelative(pistonDirection, 2).getLocation().getBlock() : null;
    }

    private static List<Block> getExtendBlocks(BlockPistonExtendEvent event) {
        Block block;
        Material blockType;
        BlockFace pistonDirection = BlockBreak.getPistonDirection(event.getBlock());
        if (pistonDirection == null) {
            return new ArrayList<Block>();
        }
        Block piston = event.getBlock();
        ArrayList<Block> pushedBlocks = new ArrayList<Block>();
        for (int currentBlock = 1; currentBlock < event.getLength() + 1 && (blockType = (block = piston.getRelative(pistonDirection, currentBlock)).getType()) != Material.AIR; ++currentBlock) {
            pushedBlocks.add(block);
        }
        return pushedBlocks;
    }
}

