/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Listeners.Block;

import com.Acrobot.Breeze.Utils.MaterialUtil;
import com.Acrobot.Breeze.Utils.PriceUtil;
import com.Acrobot.Breeze.Utils.StringUtil;
import com.Acrobot.ChestShop.ChestShop;
import com.Acrobot.ChestShop.Config.Config;
import com.Acrobot.ChestShop.Config.Language;
import com.Acrobot.ChestShop.Config.MaxPrice;
import com.Acrobot.ChestShop.Config.Property;
import com.Acrobot.ChestShop.Economy.Economy;
import com.Acrobot.ChestShop.Events.Protection.BuildPermissionEvent;
import com.Acrobot.ChestShop.Events.ShopCreatedEvent;
import com.Acrobot.ChestShop.Permission;
import com.Acrobot.ChestShop.Security;
import com.Acrobot.ChestShop.Signs.ChestShopSign;
import com.Acrobot.ChestShop.Utils.uBlock;
import com.Acrobot.ChestShop.Utils.uName;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Chest;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.inventory.ItemStack;

public class SignChange
implements Listener {
    @EventHandler(ignoreCancelled=true)
    public static void onSignChange(SignChangeEvent event) {
        String formattedPrice;
        Block signBlock = event.getBlock();
        String[] line = event.getLines();
        ItemStack stock = MaterialUtil.getItem(line[3]);
        if (!ChestShopSign.isValidPreparedSign(line)) {
            return;
        }
        if (stock == null) {
            SignChange.sendMessageAndExit(Language.INCORRECT_ITEM_ID, event);
            return;
        }
        Player player = event.getPlayer();
        boolean isAdmin = Permission.has(player, Permission.ADMIN);
        if (!SignChange.playerCanUseName(player, line[0])) {
            event.setLine(0, uName.stripName(player.getName()));
        }
        if ((formattedPrice = SignChange.formatPriceLine(line[2])) == null) {
            SignChange.sendMessageAndExit(Language.YOU_CANNOT_CREATE_SHOP, event);
            return;
        }
        event.setLine(2, formattedPrice);
        event.setLine(3, SignChange.formatItemLine(line[3], stock));
        Chest connectedChest = uBlock.findConnectedChest(signBlock);
        if (!ChestShopSign.isAdminShop(line[0])) {
            if (connectedChest == null) {
                SignChange.sendMessageAndExit(Language.NO_CHEST_DETECTED, event);
                return;
            }
            if (!isAdmin && !Security.canPlaceSign(player, (Sign)signBlock.getState())) {
                SignChange.sendMessageAndExit(Language.CANNOT_CREATE_SHOP_HERE, event);
                return;
            }
            BuildPermissionEvent bEvent = new BuildPermissionEvent(player, connectedChest.getLocation(), signBlock.getLocation());
            ChestShop.callEvent(bEvent);
            if (!bEvent.isAllowed()) {
                SignChange.sendMessageAndExit(Language.CANNOT_CREATE_SHOP_HERE, event);
                return;
            }
            if (!Security.canAccess(player, connectedChest.getBlock())) {
                SignChange.sendMessageAndExit(Language.CANNOT_ACCESS_THE_CHEST, event);
                return;
            }
        }
        double buyPrice = PriceUtil.getBuyPrice(formattedPrice);
        double sellPrice = PriceUtil.getSellPrice(formattedPrice);
        if (!(isAdmin || SignChange.canCreateShop(player, stock.getType(), buyPrice, sellPrice) && MaxPrice.canCreate(buyPrice, sellPrice, stock.getType()))) {
            SignChange.sendMessageAndExit(Language.YOU_CANNOT_CREATE_SHOP, event);
            return;
        }
        float shopCreationPrice = Config.getFloat(Property.SHOP_CREATION_PRICE);
        if (shopCreationPrice != 0.0f && !ChestShopSign.isAdminShop(line[0]) && !Permission.has(player, Permission.NOFEE)) {
            if (!Economy.hasEnough(player.getName(), shopCreationPrice)) {
                SignChange.sendMessageAndExit(Language.NOT_ENOUGH_MONEY, event);
                return;
            }
            Economy.subtract(player.getName(), shopCreationPrice);
            player.sendMessage(Config.getLocal(Language.SHOP_CREATED) + " - " + Economy.formatBalance(shopCreationPrice));
        } else {
            player.sendMessage(Config.getLocal(Language.SHOP_CREATED));
        }
        ShopCreatedEvent sEvent = new ShopCreatedEvent(player, (Sign)signBlock.getState(), connectedChest, event.getLines());
        ChestShop.callEvent(sEvent);
    }

    private static boolean canCreateShop(Player player, Material mat, double buyPrice, double sellPrice) {
        if (Config.getBoolean(Property.BLOCK_SHOPS_WITH_SELL_PRICE_HIGHER_THAN_BUY_PRICE) && buyPrice != -1.0 && sellPrice != -1.0 && sellPrice > buyPrice) {
            return false;
        }
        return SignChange.canCreateShop(player, mat, buyPrice != -1.0, sellPrice != -1.0) && MaxPrice.canCreate(buyPrice, sellPrice, mat);
    }

    private static boolean canCreateShop(Player player, Material material, boolean buy, boolean sell) {
        if (Permission.has(player, (Object)((Object)Permission.SHOP_CREATION_ID) + Integer.toString(material.getId()))) {
            return true;
        }
        if (buy && !Permission.has(player, Permission.SHOP_CREATION_BUY)) {
            return false;
        }
        return !sell || Permission.has(player, Permission.SHOP_CREATION_SELL);
    }

    private static String formatPriceLine(String thirdLine) {
        String line = thirdLine;
        String[] split = line.split(":");
        if (PriceUtil.textIsPrice(split[0])) {
            line = "B " + line;
        }
        if (split.length == 2 && PriceUtil.textIsPrice(split[1])) {
            line = line + " S";
        }
        if (line.length() > 15) {
            line = line.replace(" ", "");
        }
        return line.length() > 15 ? null : line;
    }

    private static String formatItemLine(String line, ItemStack itemStack) {
        String[] split = line.split(":|-", 2);
        StringBuilder formatted = new StringBuilder(15);
        String itemName = MaterialUtil.getName(itemStack, false);
        short dataLength = (short)(line.length() - split[0].length());
        if (itemName.length() > 15 - dataLength) {
            itemName = itemName.substring(0, 15 - dataLength);
        }
        if (MaterialUtil.getItem(itemName).getType() != itemStack.getType()) {
            itemName = String.valueOf(itemStack.getTypeId());
        }
        formatted.append(itemName);
        if (split.length == 2) {
            int dataValuePos = line.indexOf(split[1], split[0].length());
            formatted.append(line.charAt(dataValuePos - 1)).append(split[1]);
        }
        return StringUtil.capitalizeFirstLetter(formatted.toString());
    }

    private static boolean playerCanUseName(Player player, String name) {
        return !name.isEmpty() && (uName.canUseName(player, name) || Permission.has(player, Permission.ADMIN));
    }

    private static void sendMessageAndExit(Language message, SignChangeEvent event) {
        event.getPlayer().sendMessage(Config.getLocal(message));
        SignChange.dropSign(event);
    }

    private static void dropSign(SignChangeEvent event) {
        event.setCancelled(true);
        event.getBlock().breakNaturally();
    }
}

