/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Listeners;

import com.Acrobot.Breeze.Utils.NumberUtil;
import com.Acrobot.Breeze.Utils.StringUtil;
import com.Acrobot.ChestShop.Events.ItemInfoEvent;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.Potion;
import org.bukkit.potion.PotionEffect;

public class ItemInfoListener
implements Listener {
    @EventHandler
    public static void addEnchantment(ItemInfoEvent event) {
        ItemStack item = event.getItem();
        CommandSender sender = event.getSender();
        Map enchantments = item.getEnchantments();
        for (Map.Entry enchantment : enchantments.entrySet()) {
            sender.sendMessage(ChatColor.DARK_GRAY + StringUtil.capitalizeFirstLetter(((Enchantment)enchantment.getKey()).getName(), '_') + ' ' + NumberUtil.toRoman((Integer)enchantment.getValue()));
        }
    }

    @EventHandler
    public static void addPotionInfo(ItemInfoEvent event) {
        ItemStack item = event.getItem();
        if (item.getType() != Material.POTION || item.getDurability() == 0) {
            return;
        }
        Potion potion = Potion.fromItemStack((ItemStack)item);
        StringBuilder message = new StringBuilder(50);
        message.append(ChatColor.GRAY);
        if (potion.getType() == null) {
            return;
        }
        if (potion.isSplash()) {
            message.append("Splash ");
        }
        message.append("Potion of ");
        message.append(StringUtil.capitalizeFirstLetter(potion.getType().name(), '_'));
        message.append(NumberUtil.toRoman(potion.getLevel()));
        CommandSender sender = event.getSender();
        sender.sendMessage(message.toString());
        for (PotionEffect effect : potion.getEffects()) {
            sender.sendMessage(ChatColor.DARK_GRAY + StringUtil.capitalizeFirstLetter(effect.getType().getName(), '_') + ' ' + NumberUtil.toTime(effect.getDuration() / 20));
        }
    }
}

