/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Plugins;

import com.Acrobot.Breeze.Utils.BlockUtil;
import com.Acrobot.ChestShop.Containers.ShopChest;
import com.Acrobot.ChestShop.Events.Protection.ProtectionCheckEvent;
import com.Acrobot.ChestShop.Signs.ChestShopSign;
import com.Acrobot.ChestShop.Utils.uName;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Chest;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class ChestShop
implements Listener {
    @EventHandler
    public static void onProtectionCheck(ProtectionCheckEvent event) {
        if (event.getResult() == Event.Result.DENY) {
            return;
        }
        Block block = event.getBlock();
        Player player = event.getPlayer();
        if (!ChestShop.canAccess(player, block)) {
            event.setResult(Event.Result.DENY);
        }
    }

    public static boolean canAccess(Player player, Block block) {
        ShopChest chest;
        Sign sign;
        if (!ChestShop.canBeProtected(block)) {
            return true;
        }
        if (ChestShop.isSign(block)) {
            Sign sign2 = (Sign)block.getState();
            if (!ChestShopSign.isValid(sign2)) {
                return true;
            }
            if (!ChestShop.isShopMember(player, sign2)) {
                return false;
            }
        }
        return !ChestShop.isChest(block) || (sign = (chest = new ShopChest((Chest)block.getState())).findShopSign()) == null || ChestShop.isShopMember(player, sign);
    }

    private static boolean isChest(Block block) {
        return block.getType() == Material.CHEST;
    }

    private static boolean isSign(Block block) {
        return BlockUtil.isSign(block);
    }

    private static boolean canBeProtected(Block block) {
        return ChestShop.isSign(block) || ChestShop.isChest(block);
    }

    private static boolean isShopMember(Player player, Sign sign) {
        return uName.canUseName(player, sign.getLine(0));
    }
}

