/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Plugins;

import com.Acrobot.ChestShop.Config.Config;
import com.Acrobot.ChestShop.Config.Language;
import com.Acrobot.ChestShop.Config.Property;
import com.Acrobot.ChestShop.Events.Protection.ProtectBlockEvent;
import com.Acrobot.ChestShop.Events.Protection.ProtectionCheckEvent;
import com.Acrobot.ChestShop.Events.ShopCreatedEvent;
import com.Acrobot.ChestShop.Security;
import com.griefcraft.lwc.LWC;
import com.griefcraft.model.Protection;
import com.griefcraft.modules.limits.LimitsV2;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.block.Chest;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class LightweightChestProtection
implements Listener {
    private LWC lwc = LWC.getInstance();
    private LimitsV2 limitsModule = new LimitsV2();

    @EventHandler
    public static void onShopCreation(ShopCreatedEvent event) {
        Player player = event.getPlayer();
        Sign sign = event.getSign();
        Chest connectedChest = event.getChest();
        if (Config.getBoolean(Property.PROTECT_SIGN_WITH_LWC) && !Security.protect(player.getName(), sign.getBlock())) {
            player.sendMessage(Config.getLocal(Language.NOT_ENOUGH_PROTECTIONS));
        }
        if (Config.getBoolean(Property.PROTECT_CHEST_WITH_LWC) && connectedChest != null && Security.protect(player.getName(), connectedChest.getBlock())) {
            player.sendMessage(Config.getLocal(Language.PROTECTED_SHOP));
        }
    }

    @EventHandler
    public void onProtectionCheck(ProtectionCheckEvent event) {
        if (event.getResult() == Event.Result.DENY) {
            return;
        }
        Block block = event.getBlock();
        Player player = event.getPlayer();
        Protection protection = this.lwc.findProtection(block);
        if (protection == null) {
            return;
        }
        if (!this.lwc.canAccessProtection(player, protection)) {
            event.setResult(Event.Result.DENY);
        }
    }

    @EventHandler
    public void onBlockProtect(ProtectBlockEvent event) {
        if (event.isProtected()) {
            return;
        }
        Block block = event.getBlock();
        Player player = Bukkit.getPlayer((String)event.getName());
        if (player == null || this.limitsModule.hasReachedLimit(player, block.getType())) {
            return;
        }
        int x = block.getX();
        int y = block.getY();
        int z = block.getZ();
        String worldName = block.getWorld().getName();
        Protection protection = this.lwc.getPhysicalDatabase().registerProtection(block.getTypeId(), Protection.Type.PRIVATE, worldName, event.getName(), "", x, y, z);
        if (protection != null) {
            event.setProtected(true);
        }
    }
}

