/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Plugins;

import com.Acrobot.ChestShop.Config.Config;
import com.Acrobot.ChestShop.Config.Property;
import com.Acrobot.ChestShop.Events.Protection.BuildPermissionEvent;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.TownBlockOwner;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class Towny
implements Listener {
    @EventHandler
    public static void canBuild(BuildPermissionEvent event) {
        Location sign;
        Location chest = event.getChest();
        if (Towny.isInWilderness(chest, sign = event.getSign()) || !Towny.isInsideShopPlot(chest, sign)) {
            event.disallow();
            return;
        }
        boolean allow = Config.getBoolean(Property.TOWNY_SHOPS_FOR_OWNERS_ONLY) ? Towny.isPlotOwner(event.getPlayer(), chest, sign) : Towny.isResident(event.getPlayer(), chest, sign);
        event.allow(allow);
    }

    private static boolean isResident(Player player, Location location) throws NotRegisteredException {
        return TownyUniverse.getTownBlock((Location)location).getTown().hasResident(player.getName());
    }

    private static boolean isResident(Player player, Location ... locations) {
        try {
            for (Location location : locations) {
                if (Towny.isResident(player, location)) continue;
                return false;
            }
        }
        catch (NotRegisteredException exception) {
            return false;
        }
        return true;
    }

    private static boolean isPlotOwner(Player player, Location location) throws NotRegisteredException {
        Resident owner = TownyUniverse.getDataSource().getResident(player.getName());
        return TownyUniverse.getTownBlock((Location)location).isOwner((TownBlockOwner)owner);
    }

    private static boolean isPlotOwner(Player player, Location ... locations) {
        try {
            for (Location location : locations) {
                if (Towny.isPlotOwner(player, location)) continue;
                return false;
            }
        }
        catch (NotRegisteredException exception) {
            return false;
        }
        return true;
    }

    private static boolean isInsideShopPlot(Location location) {
        return TownyUniverse.getTownBlock((Location)location).getType() == TownBlockType.COMMERCIAL;
    }

    private static boolean isInsideShopPlot(Location ... locations) {
        for (Location location : locations) {
            if (Towny.isInsideShopPlot(location)) continue;
            return false;
        }
        return true;
    }

    private static boolean isInWilderness(Location location) {
        return TownyUniverse.isWilderness((Block)location.getBlock());
    }

    private static boolean isInWilderness(Location ... locations) {
        for (Location location : locations) {
            if (Towny.isInWilderness(location)) continue;
            return false;
        }
        return true;
    }

    public static Towny getTowny() {
        if (!Config.getBoolean(Property.TOWNY_INTEGRATION)) {
            return null;
        }
        return new Towny();
    }
}

