/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Shop;

import com.Acrobot.Breeze.Utils.InventoryUtil;
import com.Acrobot.Breeze.Utils.MaterialUtil;
import com.Acrobot.Breeze.Utils.PriceUtil;
import com.Acrobot.Breeze.Utils.StringUtil;
import com.Acrobot.ChestShop.ChestShop;
import com.Acrobot.ChestShop.Config.Config;
import com.Acrobot.ChestShop.Config.Language;
import com.Acrobot.ChestShop.Config.Property;
import com.Acrobot.ChestShop.Containers.AdminChest;
import com.Acrobot.ChestShop.Containers.Container;
import com.Acrobot.ChestShop.Containers.ShopChest;
import com.Acrobot.ChestShop.Economy.Economy;
import com.Acrobot.ChestShop.Events.TransactionEvent;
import com.Acrobot.ChestShop.Permission;
import com.Acrobot.ChestShop.Signs.ChestShopSign;
import com.Acrobot.ChestShop.Utils.uBlock;
import org.bukkit.Material;
import org.bukkit.block.Chest;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class Shop {
    private final Container container;
    private final String owner;
    private ItemStack stock;
    private final Sign sign;

    public Shop(Container container, ItemStack stock, Sign sign) {
        this.container = container;
        this.sign = sign;
        this.owner = sign.getLine(0);
        this.stock = stock;
    }

    public void buyFromPlayer(Player player) {
        Language message = this.sell(player);
        Shop.sendMessage(player, message);
    }

    public void sellToPlayer(Player player) {
        Language message = this.buy(player);
        Shop.sendMessage(player, message);
    }

    private Language buy(Player player) {
        int possiblePartialItemCount;
        double price = PriceUtil.getBuyPrice(this.sign.getLine(2));
        if (price == -1.0) {
            return Language.NO_BUYING_HERE;
        }
        if (this.container == null) {
            return Language.NO_CHEST_DETECTED;
        }
        if (!Shop.hasPermission(player, this.stock.getType(), true)) {
            return Language.NO_PERMISSION;
        }
        String playerName = player.getName();
        String itemName = StringUtil.capitalizeFirstLetter(this.stock.getType().name());
        double balance = Economy.balance(playerName);
        if (!Economy.hasEnough(playerName, price)) {
            possiblePartialItemCount = this.calculateItemAmount(balance, price);
            if (!Shop.partialTransactionAllowed(possiblePartialItemCount)) {
                return Language.NOT_ENOUGH_MONEY;
            }
            price = price / (double)this.stock.getAmount() * (double)possiblePartialItemCount;
            this.stock.setAmount(possiblePartialItemCount);
        }
        if (!this.stockFitsPlayer(player)) {
            return Language.NOT_ENOUGH_SPACE_IN_INVENTORY;
        }
        if (!this.shopHasEnoughItems()) {
            possiblePartialItemCount = this.getStockAmount(this.stock);
            if (!Shop.partialTransactionAllowed(possiblePartialItemCount)) {
                if (Config.getBoolean(Property.SHOW_MESSAGE_OUT_OF_STOCK)) {
                    this.sendMessageToOwner(Config.getLocal(Language.NOT_ENOUGH_STOCK_IN_YOUR_SHOP).replace("%material", itemName));
                }
                return Language.NOT_ENOUGH_STOCK;
            }
            price = price / (double)this.stock.getAmount() * (double)possiblePartialItemCount;
            this.stock.setAmount(possiblePartialItemCount);
        }
        Economy.add(this.getOwnerAccount(), price);
        Economy.subtract(playerName, price);
        this.container.removeItem(this.stock.clone());
        InventoryUtil.add(this.stock.clone(), (Inventory)player.getInventory());
        player.updateInventory();
        TransactionEvent event = new TransactionEvent(TransactionEvent.Type.BUY, this.container, this.sign, player, this.owner, this.stock, price);
        ChestShop.callEvent(event);
        return null;
    }

    private Language sell(Player player) {
        int possiblePartialItemCount;
        double price = PriceUtil.getSellPrice(this.sign.getLine(2));
        if (this.container == null) {
            return Language.NO_CHEST_DETECTED;
        }
        if (price == -1.0) {
            return Language.NO_SELLING_HERE;
        }
        if (!Shop.hasPermission(player, this.stock.getType(), false)) {
            return Language.NO_PERMISSION;
        }
        String ownerAccount = this.getOwnerAccount();
        if (!Economy.hasEnough(ownerAccount, price)) {
            possiblePartialItemCount = this.calculateItemAmount(Economy.balance(ownerAccount), price);
            if (!Shop.partialTransactionAllowed(possiblePartialItemCount)) {
                return Language.NOT_ENOUGH_MONEY_SHOP;
            }
            price = price / (double)this.stock.getAmount() * (double)possiblePartialItemCount;
            this.stock.setAmount(possiblePartialItemCount);
        }
        if (!this.playerHasEnoughItems(player)) {
            possiblePartialItemCount = InventoryUtil.getAmount(this.stock, (Inventory)player.getInventory());
            if (!Shop.partialTransactionAllowed(possiblePartialItemCount)) {
                return Language.NOT_ENOUGH_ITEMS_TO_SELL;
            }
            price = price / (double)this.stock.getAmount() * (double)possiblePartialItemCount;
            this.stock.setAmount(possiblePartialItemCount);
        }
        if (!this.stockFitsChest()) {
            return Language.NOT_ENOUGH_SPACE_IN_CHEST;
        }
        Economy.subtract(ownerAccount, price);
        Economy.add(player.getName(), price);
        this.container.addItem(this.stock.clone());
        InventoryUtil.remove(this.stock.clone(), (Inventory)player.getInventory());
        player.updateInventory();
        TransactionEvent event = new TransactionEvent(TransactionEvent.Type.SELL, this.container, this.sign, player, this.owner, this.stock, price);
        ChestShop.callEvent(event);
        return null;
    }

    private String getOwnerAccount() {
        return this.isAdminShop() ? Config.getString(Property.SERVER_ECONOMY_ACCOUNT) : this.owner;
    }

    private boolean isAdminShop() {
        return ChestShopSign.isAdminShop(this.owner);
    }

    private boolean stockFitsPlayer(Player player) {
        return InventoryUtil.fits(this.stock, (Inventory)player.getInventory());
    }

    private boolean stockFitsChest() {
        return this.container.fits(this.stock);
    }

    private int getStockAmount(ItemStack item) {
        return this.container.amount(item);
    }

    private boolean shopHasEnoughItems() {
        return this.container.hasEnough(this.stock);
    }

    private boolean playerHasEnoughItems(Player player) {
        return InventoryUtil.getAmount(this.stock, (Inventory)player.getInventory()) >= this.stock.getAmount();
    }

    private int calculateItemAmount(double money, double basePrice) {
        return (int)Math.floor(money / (basePrice / (double)this.stock.getAmount()));
    }

    private static void sendMessage(Player player, Language message) {
        if (message != null) {
            player.sendMessage(Config.getLocal(message));
        }
    }

    private void sendMessageToOwner(String msg) {
        Player player = ChestShop.getBukkitServer().getPlayer(this.owner);
        if (player != null) {
            player.sendMessage(msg);
        }
    }

    public static Shop getShopFromSign(Sign sign) {
        Chest chestMc = uBlock.findConnectedChest(sign);
        ItemStack item = MaterialUtil.getItem(sign.getLine(3));
        if (item == null) {
            return null;
        }
        int itemAmount = Integer.parseInt(sign.getLine(1));
        item.setAmount(itemAmount);
        if (ChestShopSign.isAdminShop(sign)) {
            return new Shop(new AdminChest(), item, sign);
        }
        return new Shop(chestMc != null ? new ShopChest(chestMc) : null, item, sign);
    }

    private static boolean partialTransactionAllowed(int itemCount) {
        return Config.getBoolean(Property.ALLOW_PARTIAL_TRANSACTIONS) && itemCount > 0;
    }

    private static boolean hasPermission(Player player, Material material, boolean buying) {
        if (buying) {
            return Permission.has(player, Permission.BUY) || Permission.has(player, (Object)((Object)Permission.BUY_ID) + Integer.toString(material.getId()));
        }
        return Permission.has(player, Permission.SELL) || Permission.has(player, (Object)((Object)Permission.SELL_ID) + Integer.toString(material.getId()));
    }
}

