/*
 * Decompiled with CFR 0.152.
 */
package com.iCo6.IO.mini;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

public class Arguments {
    private String key;
    private LinkedHashMap<String, String> values;
    private boolean caseSensitive;

    public Arguments(Object key) {
        this.key = this.parseKey(key);
        this.values = new LinkedHashMap();
        this.caseSensitive = false;
    }

    public Arguments(Object key, boolean caseSensitive) {
        this.key = this.parseKey(key);
        this.values = new LinkedHashMap();
        this.caseSensitive = caseSensitive;
    }

    public String getKey() {
        return this.parseKey(this.key);
    }

    private String encode(String data) {
        return data.trim().replace(" ", "}+{");
    }

    private String decode(String data) {
        return data.replace("}+{", " ").trim();
    }

    public boolean hasKey(Object key) {
        return this.values.containsKey(this.parseKey(key));
    }

    public void setValue(String key, Object value) {
        this.values.put(this.encode(this.parseKey(key)), this.encode(String.valueOf(value)));
    }

    public String getValue(String key) {
        return this.decode(this.values.get(this.parseKey(key)));
    }

    public Integer getInteger(String key) throws NumberFormatException {
        return Integer.valueOf(this.getValue(key));
    }

    public Double getDouble(String key) throws NumberFormatException {
        return Double.valueOf(this.getValue(key));
    }

    public Long getLong(String key) throws NumberFormatException {
        return Long.valueOf(this.getValue(key));
    }

    public Float getFloat(String key) throws NumberFormatException {
        return Float.valueOf(this.getValue(key));
    }

    public Short getShort(String key) throws NumberFormatException {
        return Short.valueOf(this.getValue(key));
    }

    public Boolean getBoolean(String key) {
        return Boolean.valueOf(this.getValue(key));
    }

    public String[] getArray(String key) {
        String value = this.getValue(key);
        if (value == null || !value.contains(",")) {
            return null;
        }
        if (value.split(",") == null) {
            return null;
        }
        return this.trim(value.split(","));
    }

    private String[] trim(String[] values) {
        int length = values.length;
        for (int i = 0; i < length; ++i) {
            if (values[i] == null) continue;
            values[i] = values[i].trim();
        }
        return values;
    }

    private String parseKey(Object key) {
        if (this.caseSensitive) {
            return String.valueOf(key);
        }
        return String.valueOf(key).toLowerCase();
    }

    private List trim(List values) {
        ArrayList<String> trimmed = new ArrayList<String>();
        int length = values.size();
        for (int i = 0; i < length; ++i) {
            String v = (String)values.get(i);
            if (v != null) {
                v = v.trim();
            }
            trimmed.add(v);
        }
        return trimmed;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.key).append(" ");
        for (String k : this.values.keySet()) {
            sb.append(k).append(":").append(this.values.get(k)).append(" ");
        }
        return sb.toString().trim();
    }

    public Arguments copy() {
        Arguments copy = new Arguments(this.key);
        for (String k : this.values.keySet()) {
            copy.values.put(k, this.values.get(k));
        }
        return copy;
    }
}

