/*
 * Decompiled with CFR 0.152.
 */
package com.iCo6.IO.mini;

import com.iCo6.IO.mini.Arguments;
import com.iCo6.IO.mini.file.Manager;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mini {
    private String folder;
    private String database;
    private String source;
    private boolean changed = false;
    private boolean caseSensitive = false;
    private Manager Database;
    private LinkedHashMap<String, Arguments> Indexes;
    private LinkedHashMap<String, Arguments> pushedIndexes;

    public Mini(String folder, String database) {
        this.database = database;
        this.folder = folder;
        this.Database = new Manager(this.folder, this.database, true);
        this.read();
    }

    public Mini(String folder, String database, boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
        this.database = database;
        this.folder = folder;
        this.Database = new Manager(this.folder, this.database, true);
        this.read();
    }

    public Mini(File data) {
        this.database = data.getName();
        this.folder = data.getPath();
        this.Database = new Manager(this.folder, this.database, true);
        this.read();
    }

    public Mini(File data, boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
        this.database = data.getName();
        this.folder = data.getPath();
        this.Database = new Manager(this.folder, this.database, true);
        this.read();
    }

    public static void main(String[] args) {
        Mini mini = new Mini(".", "mini");
        Double amount = mini.getArguments("Nijikokun").getDouble("money");
        mini.setArgument((Object)"Nijikokun", (Object)"money", amount + 2.0, true);
        System.out.println(mini.getArguments("Nijikokun").getDouble("money"));
        System.out.println(mini.getIndices().toString());
    }

    private String[] trim(String[] values) {
        int length = values.length;
        for (int i = 0; i < length; ++i) {
            if (values[i] == null) continue;
            values[i] = values[i].trim();
        }
        return values;
    }

    private void read() {
        this.read(true);
    }

    private void read(boolean pushed) {
        this.Database = new Manager(this.folder, this.database, true);
        this.Database.removeDuplicates();
        this.Database.read();
        this.Indexes = new LinkedHashMap();
        if (pushed) {
            this.pushedIndexes = new LinkedHashMap();
        }
        for (String line : this.Database.getLines()) {
            String[] parsed;
            if (line.trim().isEmpty() || (parsed = this.trim(line.trim().split(" ")))[0].contains(":") || parsed[0].isEmpty()) continue;
            Arguments entry = new Arguments(this.parseIndice(parsed[0]));
            for (String item : parsed) {
                if (!item.contains(":")) continue;
                String[] map = this.trim(item.split(":", 2));
                String key = map[0];
                String value = map[1];
                if (key == null) continue;
                entry.setValue(key, value);
            }
            this.Indexes.put(this.parseIndice(parsed[0]), entry);
        }
    }

    public boolean hasIndex(Object index) {
        return this.Indexes.containsKey(this.parseIndice(index));
    }

    public LinkedHashMap<String, Arguments> getIndices() {
        return this.Indexes;
    }

    public void addIndex(Arguments entry) {
        this.addIndex(entry.getKey(), entry);
    }

    public void addIndex(Object index, Arguments entry) {
        this.pushedIndexes.put(this.parseIndice(index), entry);
        this.changed = true;
    }

    public boolean alterIndex(Object original, String updated) {
        return this.alterIndex(original, updated, true);
    }

    public boolean alterIndex(Object original, String updated, boolean update) {
        if (!this.hasIndex(original) || this.hasIndex(updated)) {
            return false;
        }
        Arguments data = this.Indexes.get(this.parseIndice(original));
        this.removeIndex(original);
        this.addIndex(updated, data);
        if (update) {
            this.update();
        }
        return true;
    }

    public void removeIndex(Object key) {
        this.Database.remove(this.Indexes.get(this.parseIndice(key)).toString());
        this.read(false);
    }

    public Arguments getArguments(Object key) {
        return this.Indexes.get(this.parseIndice(key));
    }

    public void setArgument(String index, Object key, Object value) {
        this.setArgument((Object)index, key, String.valueOf(value), false);
    }

    public void setArgument(Object index, Object key, String value, boolean save) {
        if (!this.hasIndex(index)) {
            return;
        }
        this.changed = true;
        Arguments original = this.Indexes.get(this.parseIndice(index)).copy();
        original.setValue(this.parseIndice(key), value);
        this.pushedIndexes.put(this.parseIndice(index), original);
        if (save) {
            this.update();
        }
    }

    public void setArgument(Object index, Object key, Object value, boolean save) {
        String formatted = "";
        if (value instanceof int[]) {
            for (int v : (int[])value) {
                formatted = v + ",";
            }
        } else if (value instanceof String[]) {
            for (String v : (String[])value) {
                formatted = v + ",";
            }
        } else if (value instanceof Double[]) {
            for (Double v : (Double[])value) {
                formatted = v + ",";
            }
        } else if (value instanceof Boolean[]) {
            for (Boolean v : (Boolean[])value) {
                formatted = v + ",";
            }
        } else if (value instanceof Long[]) {
            for (Long v : (Long[])value) {
                formatted = v + ",";
            }
        } else if (value instanceof Float[]) {
            for (Float v : (Float[])value) {
                formatted = v + ",";
            }
        } else if (value instanceof Byte[]) {
            for (Byte v : (Byte[])value) {
                formatted = v + ",";
            }
        } else if (value instanceof char[]) {
            for (char v : (char[])value) {
                formatted = v + ",";
            }
        } else if (value instanceof ArrayList) {
            ArrayList data = (ArrayList)value;
            for (Object v : data) {
                formatted = v + ",";
            }
        }
        if (formatted.length() > 1) {
            formatted.substring(0, formatted.length() - 2);
        } else {
            formatted = String.valueOf(value);
        }
        this.setArgument((Object)this.parseIndice(index), (Object)this.parseIndice(key), formatted, save);
    }

    public void update() {
        if (!this.changed) {
            return;
        }
        LinkedList lines = new LinkedList();
        for (String key : this.pushedIndexes.keySet()) {
            if (!this.Indexes.containsKey(key) || this.Indexes.get(key).toString().equals(this.pushedIndexes.get(key).toString())) continue;
            this.Database.remove(this.Indexes.get(key).toString());
        }
        this.read(false);
        for (String key : this.pushedIndexes.keySet()) {
            if (this.Indexes.containsKey(key)) {
                if (this.Indexes.get(key).toString().equals(this.pushedIndexes.get(key).toString())) continue;
                this.Indexes.put(key, this.pushedIndexes.get(key));
                this.Database.append(this.Indexes.get(key).toString());
                continue;
            }
            this.Database.append(this.pushedIndexes.get(key).toString());
        }
        this.pushedIndexes.clear();
        this.read();
    }

    private String parseIndice(Object key) {
        if (this.caseSensitive) {
            return String.valueOf(key);
        }
        return String.valueOf(key).toLowerCase();
    }
}

