/*
 * Decompiled with CFR 0.152.
 */
package com.iCo6.IO.mini.file;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Manager {
    private String directory = "";
    private String file = "";
    private String source = "";
    private LinkedList<String> lines = new LinkedList();

    public Manager(String directory, String file, boolean create) {
        this.directory = directory;
        this.file = file;
        if (create) {
            this.existsCreate();
        }
    }

    public String getSource() {
        return this.source;
    }

    public LinkedList<String> getLines() {
        return this.lines;
    }

    public String getDirectory() {
        return this.directory;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public void setFile(String file, boolean create) {
        this.file = file;
        if (create) {
            this.create();
        }
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public void setDirectory(String directory, boolean create) {
        this.directory = directory;
        if (create) {
            this.createDirectory();
        }
    }

    private void log(Level level, Object message) {
        Logger.getLogger("FileManager").log(level, String.valueOf(message));
    }

    public boolean exists() {
        return this.exists(this.directory, this.file);
    }

    public boolean exists(String file) {
        return this.exists(this.directory, file);
    }

    public boolean exists(String directory, String file) {
        return new File(directory, file).exists();
    }

    public void existsCreate() {
        this.existsCreate(this.directory, this.file);
    }

    public void existsCreate(String directory, String file) {
        if (!new File(directory).exists()) {
            if (!new File(directory, file).exists()) {
                this.create(directory, file);
            } else {
                this.createDirectory(directory);
            }
        } else if (!new File(directory, file).exists()) {
            this.create(directory, file);
        }
    }

    public boolean delete() {
        return new File(this.directory, this.file).delete();
    }

    public boolean create() {
        return this.create(this.directory, this.file);
    }

    public boolean create(String directory, String file) {
        try {
            new File(directory).mkdirs();
            new File(directory, file).createNewFile();
        }
        catch (IOException ex) {
            this.log(Level.SEVERE, ex);
            return false;
        }
        return true;
    }

    public boolean createDirectory() {
        return this.createDirectory(this.directory);
    }

    public boolean createDirectory(String directory) {
        return new File(directory).mkdirs();
    }

    public boolean append(String data) {
        return this.append(this.directory, this.file, new String[]{data});
    }

    public boolean append(String[] lines) {
        return this.append(this.directory, this.file, lines);
    }

    public boolean append(String file, String data) {
        return this.append(this.directory, file, new String[]{data});
    }

    public boolean append(String file, String[] lines) {
        return this.append(this.directory, file, lines);
    }

    public boolean append(String directory, String file, String data) {
        return this.append(directory, file, new String[]{data});
    }

    public boolean append(String directory, String file, String[] lines) {
        this.existsCreate(directory, file);
        try {
            BufferedWriter output = new BufferedWriter(new FileWriter(new File(directory, file), true));
            try {
                for (String append : lines) {
                    output.write(append);
                    output.newLine();
                }
            }
            catch (IOException ex) {
                this.log(Level.SEVERE, ex);
                output.close();
                return false;
            }
            output.close();
            return true;
        }
        catch (FileNotFoundException ex) {
            this.log(Level.SEVERE, ex);
        }
        catch (IOException ex) {
            this.log(Level.SEVERE, ex);
        }
        return false;
    }

    public boolean read() {
        return this.read(this.directory, this.file);
    }

    public boolean read(String file) {
        return this.read(this.directory, file);
    }

    public boolean read(String directory, String file) {
        StringBuilder sb = new StringBuilder();
        this.lines = new LinkedList();
        this.source = "";
        try {
            BufferedReader input = new BufferedReader(new FileReader(new File(directory, file)));
            try {
                String line;
                while ((line = input.readLine()) != null) {
                    this.lines.add(line);
                    sb.append(line).append('\n');
                }
                this.source = sb.toString().trim();
                input.close();
            }
            catch (IOException ex) {
                this.log(Level.SEVERE, ex);
                return false;
            }
            return true;
        }
        catch (FileNotFoundException ex) {
            this.log(Level.SEVERE, ex);
            return false;
        }
    }

    public boolean write(Object data) {
        return this.write(this.directory, this.file, new Object[]{data});
    }

    public boolean write(Object[] lines) {
        return this.write(this.directory, this.file, lines);
    }

    public boolean write(String file, Object data) {
        return this.write(this.directory, file, new Object[]{data});
    }

    public boolean write(String file, String[] lines) {
        return this.write(this.directory, file, lines);
    }

    public boolean write(String directory, String file, Object data) {
        return this.write(directory, file, new Object[]{data});
    }

    public boolean write(String directory, String file, Object[] lines) {
        this.existsCreate(directory, file);
        try {
            BufferedWriter output = new BufferedWriter(new FileWriter(new File(directory, file)));
            try {
                for (Object line : lines) {
                    output.write(String.valueOf(line));
                    output.newLine();
                }
                output.close();
            }
            catch (IOException ex) {
                this.log(Level.SEVERE, ex);
                output.close();
                return false;
            }
            return true;
        }
        catch (FileNotFoundException ex) {
            this.log(Level.SEVERE, ex);
        }
        catch (IOException ex) {
            this.log(Level.SEVERE, ex);
        }
        return false;
    }

    public boolean remove(Object line) {
        return this.remove(this.directory, this.file, new Object[]{line});
    }

    public boolean remove(Object[] lines) {
        return this.remove(this.directory, this.file, lines);
    }

    public boolean remove(String file, Object[] lines) {
        return this.remove(this.directory, file, lines);
    }

    public boolean remove(String directory, String file, Object line) {
        return this.remove(directory, file, new Object[]{line});
    }

    public boolean remove(String directory, String file, Object[] lines) {
        this.existsCreate(directory, file);
        this.read(directory, file);
        File input = new File(directory, file);
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(input));
            try {
                for (String current : this.lines) {
                    boolean found = false;
                    for (Object line : lines) {
                        if (!current.equals(String.valueOf(line))) continue;
                        found = true;
                    }
                    if (found) continue;
                    writer.write(current);
                    writer.newLine();
                }
                writer.close();
            }
            catch (IOException e) {
                writer.close();
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public void removeDuplicates() {
        this.removeDupilcates(this.directory, this.file);
    }

    public void removeDuplicates(String file) {
        this.removeDupilcates(this.directory, file);
    }

    public void removeDupilcates(String directory, String file) {
        LinkedHashSet<String> uniqueLines = new LinkedHashSet<String>();
        this.existsCreate(directory, file);
        File input = new File(directory, file);
        try {
            BufferedReader reader = new BufferedReader(new FileReader(input));
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    uniqueLines.add(line);
                }
                reader.close();
            }
            catch (IOException e) {
                reader.close();
                return;
            }
            BufferedWriter writer = new BufferedWriter(new FileWriter(input));
            try {
                for (String current : uniqueLines) {
                    writer.write(current);
                    writer.newLine();
                }
                writer.close();
            }
            catch (IOException e) {
                writer.close();
                return;
            }
        }
        catch (Exception e) {
            System.out.println(e);
            return;
        }
    }
}

