/*
 * Decompiled with CFR 0.152.
 */
package com.iCo6;

import com.iCo6.Constants;
import com.iCo6.IO.Database;
import com.iCo6.IO.exceptions.MissingDriver;
import com.iCo6.command.Handler;
import com.iCo6.command.Parser;
import com.iCo6.command.exceptions.InvalidUsage;
import com.iCo6.handlers.Create;
import com.iCo6.handlers.Empty;
import com.iCo6.handlers.Give;
import com.iCo6.handlers.Help;
import com.iCo6.handlers.Money;
import com.iCo6.handlers.Payment;
import com.iCo6.handlers.Purge;
import com.iCo6.handlers.Remove;
import com.iCo6.handlers.Set;
import com.iCo6.handlers.Status;
import com.iCo6.handlers.Take;
import com.iCo6.handlers.Top;
import com.iCo6.listeners.players;
import com.iCo6.system.Account;
import com.iCo6.system.Accounts;
import com.iCo6.system.Interest;
import com.iCo6.system.Queried;
import com.iCo6.util.Common;
import com.iCo6.util.Messaging;
import com.iCo6.util.Template;
import com.iCo6.util.Thrun;
import com.iCo6.util.org.apache.commons.dbutils.DbUtils;
import com.iCo6.util.org.apache.commons.dbutils.QueryRunner;
import com.iCo6.util.org.apache.commons.dbutils.ResultSetHandler;
import com.iCo6.util.wget;
import com.nijikokun.bukkit.Permissions.Permissions;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;
import org.bukkit.Server;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.permissions.Permission;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.h2.jdbcx.JdbcConnectionPool;

public class iConomy
extends JavaPlugin {
    public PluginDescriptionFile info;
    public PluginManager manager;
    private static Accounts Accounts = new Accounts();
    public Parser Commands = new Parser();
    public Permissions Permissions;
    private boolean testedPermissions = false;
    public static boolean TerminalSupport = false;
    public static File directory;
    public static Database Database;
    public static Server Server;
    public static Template Template;
    public static Timer Interest;
    private JdbcConnectionPool h2pool;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEnable() {
        long endTime;
        long startTime = System.nanoTime();
        try {
            block28: {
                Locale.setDefault(Locale.US);
                Server = this.getServer();
                if (this.getServer().getServerName().equalsIgnoreCase("craftbukkit")) {
                    TerminalSupport = ((CraftServer)this.getServer()).getReader().getTerminal().isANSISupported();
                }
                this.info = this.getDescription();
                directory = this.getDataFolder();
                if (!directory.exists()) {
                    directory.mkdir();
                }
                Common.extract("Config.yml", "Template.yml");
                Constants.load(new File(directory, "Config.yml"));
                Template = new Template(directory.getPath(), "Template.yml");
                LinkedHashMap<String, String> nodes = new LinkedHashMap<String, String>();
                nodes.put("top.opening", "<green>-----[ <white>Wealthiest Accounts <green>]-----");
                nodes.put("top.item", "<gray>+i. <green>+name <gray>- <white>+amount");
                try {
                    Template.update(nodes);
                }
                catch (IOException ex) {
                    System.out.println(ex.getMessage());
                }
                Database.Type type = com.iCo6.IO.Database.getType(Constants.Nodes.DatabaseType.toString());
                if (!type.equals((Object)Database.Type.InventoryDB) && !type.equals((Object)Database.Type.MiniDB)) {
                    Constants.Drivers driver = null;
                    switch (type) {
                        case H2DB: {
                            driver = Constants.Drivers.H2;
                            break;
                        }
                        case MySQL: {
                            driver = Constants.Drivers.MySQL;
                            break;
                        }
                        case SQLite: {
                            driver = Constants.Drivers.SQLite;
                            break;
                        }
                        case Postgre: {
                            driver = Constants.Drivers.Postgre;
                        }
                    }
                    if (driver != null && !new File("lib", driver.getFilename()).exists()) {
                        System.out.println("[iConomy] Downloading " + driver.getFilename() + "...");
                        wget.fetch(driver.getUrl(), driver.getFilename());
                        System.out.println("[iConomy] Finished Downloading.");
                    }
                }
                this.Commands.add("/money +name", new Money(this));
                this.Commands.setPermission("money", "iConomy.holdings");
                this.Commands.setPermission("money+", "iConomy.holdings.others");
                this.Commands.setHelp("money", new String[]{"", "Check your balance."});
                this.Commands.setHelp("money+", new String[]{" [name]", "Check others balance."});
                this.Commands.add("/money -h|?|help +command", new Help(this));
                this.Commands.setPermission("help", "iConomy.help");
                this.Commands.setHelp("help", new String[]{" (command)", "For Help & Information."});
                this.Commands.add("/money -t|top", new Top(this));
                this.Commands.setPermission("top", "iConomy.top");
                this.Commands.setHelp("top", new String[]{"", "View top economical accounts."});
                this.Commands.add("/money -p|pay +name +amount:empty", new Payment(this));
                this.Commands.setPermission("pay", "iConomy.payment");
                this.Commands.setHelp("pay", new String[]{" [name] [amount]", "Send money to others."});
                this.Commands.add("/money -c|create +name", new Create(this));
                this.Commands.setPermission("create", "iConomy.accounts.create");
                this.Commands.setHelp("create", new String[]{" [name]", "Create an account."});
                this.Commands.add("/money -r|remove +name", new Remove(this));
                this.Commands.setPermission("remove", "iConomy.accounts.remove");
                this.Commands.setHelp("remove", new String[]{" [name]", "Remove an account."});
                this.Commands.add("/money -g|give +name +amount:empty", new Give(this));
                this.Commands.setPermission("give", "iConomy.accounts.give");
                this.Commands.setHelp("give", new String[]{" [name] [amount]", "Give money."});
                this.Commands.add("/money -t|take +name +amount:empty", new Take(this));
                this.Commands.setPermission("take", "iConomy.accounts.take");
                this.Commands.setHelp("take", new String[]{" [name] [amount]", "Take money."});
                this.Commands.add("/money -s|set +name +amount:empty", new Set(this));
                this.Commands.setPermission("set", "iConomy.accounts.set");
                this.Commands.setHelp("set", new String[]{" [name] [amount]", "Set account balance."});
                this.Commands.add("/money -u|status +name +status:empty", new Status(this));
                this.Commands.setPermission("status", "iConomy.accounts.status");
                this.Commands.setPermission("status+", "iConomy.accounts.status.set");
                this.Commands.setHelp("status", new String[]{" [name] (status)", "Check/Set account status."});
                this.Commands.add("/money -x|purge", new Purge(this));
                this.Commands.setPermission("purge", "iConomy.accounts.purge");
                this.Commands.setHelp("purge", new String[]{"", "Purge all accounts with initial holdings."});
                this.Commands.add("/money -e|empty", new Empty(this));
                this.Commands.setPermission("empty", "iConomy.accounts.empty");
                this.Commands.setHelp("empty", new String[]{"", "Empty database of accounts."});
                try {
                    Database = new Database(Constants.Nodes.DatabaseType.toString(), Constants.Nodes.DatabaseUrl.toString(), Constants.Nodes.DatabaseUsername.toString(), Constants.Nodes.DatabasePassword.toString());
                    if (Database.isSQL()) {
                        if (Database.tableExists(Constants.Nodes.DatabaseTable.toString())) break block28;
                        String SQL = Common.resourceToString("SQL/Core/Create-Table-" + Database.getType().toString().toLowerCase() + ".sql");
                        SQL = String.format(SQL, Constants.Nodes.DatabaseTable.getValue());
                        try {
                            QueryRunner run = new QueryRunner();
                            Connection c = Database.getConnection();
                            try {
                                run.update(c, SQL);
                                break block28;
                            }
                            catch (SQLException ex) {
                                System.out.println("[iConomy] Error creating database: " + ex);
                                break block28;
                            }
                            finally {
                                DbUtils.close(c);
                            }
                        }
                        catch (SQLException ex) {
                            System.out.println("[iConomy] Database Error: " + ex);
                        }
                        break block28;
                    }
                    this.onConversion();
                }
                catch (MissingDriver ex) {
                    System.out.println(ex.getMessage());
                }
            }
            this.getServer().getPluginManager().registerEvents((Listener)new players(), (Plugin)this);
        }
        finally {
            endTime = System.nanoTime();
        }
        if (Constants.Nodes.Interest.getBoolean().booleanValue()) {
            Thrun.init(new Runnable(){

                public void run() {
                    long time = Constants.Nodes.InterestTime.getLong() * 1000L;
                    Interest = new Timer();
                    Interest.scheduleAtFixedRate((TimerTask)new Interest(iConomy.this.getDataFolder().getPath()), time, time);
                }
            });
        }
        if (Constants.Nodes.Purging.getBoolean().booleanValue()) {
            Thrun.init(new Runnable(){

                public void run() {
                    Queried.purgeDatabase();
                    System.out.println("[" + iConomy.this.info.getName() + " - " + Constants.Nodes.CodeName.toString() + "] Purged accounts with default balance.");
                }
            });
        }
        long duration = endTime - startTime;
        System.out.println("[" + this.info.getName() + " - " + Constants.Nodes.CodeName.toString() + "] Enabled (" + Common.readableProfile(duration) + ")");
        System.out.println("[" + this.info.getName() + "] Hello, I'm Nijikokun. Yes, this is an April Fools joke, but '/money top' was fixed! Enjoy :) - Rare Version!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDisable() {
        long endTime;
        String name = this.info.getName();
        System.out.println("[" + name + "] Closing general data...");
        long startTime = System.nanoTime();
        try {
            this.info = null;
            Server = null;
            this.manager = null;
            Accounts = null;
            this.Commands = null;
            Database = null;
            Template = null;
            if (Interest != null) {
                Interest.cancel();
                Interest.purge();
                Interest = null;
            }
            TerminalSupport = false;
        }
        finally {
            endTime = System.nanoTime();
        }
        long duration = endTime - startTime;
        System.out.println("[" + name + "] Disabled. (" + Common.readableProfile(duration) + ")");
    }

    public boolean onConversion() {
        if (!Constants.Nodes.Convert.getBoolean().booleanValue()) {
            return false;
        }
        Thrun.init(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                String from = Constants.Nodes.ConvertFrom.toString();
                String table = Constants.Nodes.ConvertTable.toString();
                String username = Constants.Nodes.ConvertUsername.toString();
                String password = Constants.Nodes.ConvertPassword.toString();
                String url = Constants.Nodes.ConvertURL.toString();
                if (!Common.matches(from, "h2", "h2db", "h2sql", "mysql", "mysqldb")) {
                    return;
                }
                String driver = "";
                String dsn = "";
                if (Common.matches(from, "sqlite", "h2", "h2sql", "h2db")) {
                    driver = "org.h2.Driver";
                    dsn = "jdbc:h2:" + directory + File.separator + table + ";AUTO_RECONNECT=TRUE";
                    username = "sa";
                    password = "sa";
                } else if (Common.matches(from, "mysql", "mysqldb")) {
                    driver = "com.mysql.jdbc.Driver";
                    dsn = url + "/" + table;
                }
                if (!DbUtils.loadDriver(driver)) {
                    System.out.println("Please make sure the " + from + " driver library jar exists.");
                    return;
                }
                Connection old = null;
                try {
                    old = username.isEmpty() && password.isEmpty() ? DriverManager.getConnection(url) : DriverManager.getConnection(url, username, password);
                }
                catch (SQLException ex) {
                    System.out.println(ex);
                    return;
                }
                QueryRunner run = new QueryRunner();
                try {
                    try {
                        run.query(old, "SELECT * FROM " + table, new ResultSetHandler(){

                            public Object handle(ResultSet rs) throws SQLException {
                                Account current = null;
                                Boolean next = rs.next();
                                if (next.booleanValue()) {
                                    if (Accounts.exists(rs.getString("username"))) {
                                        current = Accounts.get(rs.getString("username"));
                                    } else {
                                        Accounts.create(rs.getString("username"), rs.getDouble("balance"));
                                    }
                                }
                                if (current != null) {
                                    current.getHoldings().setBalance(rs.getDouble("balance"));
                                }
                                if (next.booleanValue() && Accounts.exists(rs.getString("username")) && rs.getBoolean("hidden")) {
                                    Accounts.get(rs.getString("username")).setStatus(1);
                                }
                                return true;
                            }
                        });
                    }
                    catch (SQLException ex) {
                        System.out.println("[iConomy] Error issueing SQL query: " + ex);
                    }
                    finally {
                        DbUtils.close(old);
                    }
                }
                catch (SQLException ex) {
                    System.out.println("[iConomy] Database Error: " + ex);
                }
                System.out.println("[iConomy] Conversion complete. Please update your configuration, change convert to false!");
            }
        });
        return false;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        Handler handler = this.Commands.getHandler(command.getName());
        String split = "/" + command.getName().toLowerCase();
        for (int i = 0; i < args.length; ++i) {
            split = split + " " + args[i];
        }
        Messaging.save(sender);
        this.Commands.save(split);
        this.Commands.parse();
        if (this.Commands.getHandler() != null) {
            handler = this.Commands.getHandler();
        }
        if (handler == null) {
            return false;
        }
        try {
            return handler.perform(sender, this.Commands.getArguments());
        }
        catch (InvalidUsage ex) {
            Messaging.send(sender, ex.getMessage());
            return false;
        }
    }

    public boolean hasPermissions(CommandSender sender, String command) {
        block9: {
            String node;
            Player player;
            block10: {
                block12: {
                    block11: {
                        if (!(sender instanceof Player)) break block9;
                        player = (Player)sender;
                        if (player == null) {
                            System.out.println("[iConomy] Cannot execute command with false player");
                            return false;
                        }
                        if (!this.Commands.hasPermission(command)) break block9;
                        node = this.Commands.getPermission(command);
                        if (node == null) {
                            return true;
                        }
                        if (this.Permissions == null && !this.testedPermissions) {
                            Plugin Perms = Server.getPluginManager().getPlugin("Permissions");
                            if (Perms != null && Perms.isEnabled()) {
                                this.Permissions = (Permissions)Perms;
                                System.out.println("[iConomy] hooked into Permissions.");
                            }
                            this.testedPermissions = true;
                        }
                        if (this.Permissions == null) break block10;
                        if (com.nijikokun.bukkit.Permissions.Permissions.Security.permission(player, node)) break block11;
                        if (!com.nijikokun.bukkit.Permissions.Permissions.Security.permission(player, node.toLowerCase())) break block12;
                    }
                    return true;
                }
                return false;
            }
            try {
                Permission perm = new Permission(node);
                return player.hasPermission(perm) || player.hasPermission(node) || player.hasPermission(node.toLowerCase());
            }
            catch (Exception e) {
                return player.isOp();
            }
        }
        return true;
    }

    public static String format(String account) {
        return Accounts.get(account).getHoldings().toString();
    }

    public static String format(double amount) {
        DecimalFormat formatter = new DecimalFormat("#,##0.00");
        String formatted = formatter.format(amount);
        if (formatted.endsWith(".")) {
            formatted = formatted.substring(0, formatted.length() - 1);
        }
        return Common.formatted(formatted, Constants.Nodes.Major.getStringList(), Constants.Nodes.Minor.getStringList());
    }
}

