/*
 * Decompiled with CFR 0.152.
 */
package com.iCo6.system;

import com.iCo6.Constants;
import com.iCo6.iConomy;
import com.iCo6.system.Account;
import com.iCo6.system.Accounts;
import com.iCo6.system.Queried;
import com.iCo6.util.Template;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.TimerTask;
import org.bukkit.entity.Player;

public class Interest
extends TimerTask {
    Template Template = null;

    public Interest(String directory) {
        this.Template = new Template(directory, "Messages.yml");
    }

    public void run() {
        Accounts Accounts2 = new Accounts();
        DecimalFormat DecimalFormat2 = new DecimalFormat("#.##");
        ArrayList<String> players2 = new ArrayList<String>();
        LinkedHashMap<String, HashMap<String, Object>> queries = new LinkedHashMap<String, HashMap<String, Object>>();
        if (Constants.Nodes.InterestOnline.getBoolean().booleanValue()) {
            Player[] player;
            for (Player p : player = iConomy.Server.getOnlinePlayers()) {
                players2.add(p.getName());
            }
        } else {
            players2.addAll(Queried.accountList());
        }
        double cutoff = Constants.Nodes.InterestCutoff.getDouble();
        double percentage = Constants.Nodes.InterestPercentage.getDouble();
        double min = Constants.Nodes.InterestMin.getDouble();
        double max = Constants.Nodes.InterestMax.getDouble();
        double amount = 0.0;
        String table = Constants.Nodes.DatabaseTable.toString();
        String query = "UPDATE " + table + " SET balance = ? WHERE username = ?";
        if (percentage == 0.0) {
            try {
                amount = min != max ? Double.valueOf(DecimalFormat2.format(Math.random() * (max - min) + min)) : max;
            }
            catch (NumberFormatException e) {
                amount = max;
            }
        }
        for (String name : players2) {
            if (!Accounts2.exists(name)) continue;
            Account account = new Account(name);
            Double balance = account.getHoldings().getBalance();
            if (cutoff > 0.0 && (balance >= cutoff || cutoff < 0.0 && balance <= cutoff)) continue;
            LinkedHashMap<String, Double> data = new LinkedHashMap<String, Double>();
            if (percentage != 0.0) {
                amount = Double.valueOf(DecimalFormat2.format(percentage * balance / 100.0));
            }
            data.put("original", balance);
            data.put("balance", balance + amount);
            queries.put(name, data);
        }
        if (queries.isEmpty()) {
            return;
        }
        Queried.doInterest(query, queries);
    }
}

