/*
 * Decompiled with CFR 0.152.
 */
package com.iCo6.system;

import com.iCo6.Constants;
import com.iCo6.IO.InventoryDB;
import com.iCo6.IO.mini.Arguments;
import com.iCo6.IO.mini.Mini;
import com.iCo6.iConomy;
import com.iCo6.system.Account;
import com.iCo6.system.Accounts;
import com.iCo6.system.MoneyComparator;
import com.iCo6.system.Transaction;
import com.iCo6.system.Transactions;
import com.iCo6.util.Thrun;
import com.iCo6.util.org.apache.commons.dbutils.DbUtils;
import com.iCo6.util.org.apache.commons.dbutils.QueryRunner;
import com.iCo6.util.org.apache.commons.dbutils.ResultSetHandler;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.bukkit.entity.Player;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Queried {
    static Mini database;
    static InventoryDB inventory;
    static ResultSetHandler<String> returnName;
    static ResultSetHandler<List<String>> returnList;
    static ResultSetHandler<Boolean> returnBoolean;
    static ResultSetHandler<Double> returnBalance;
    static ResultSetHandler<Integer> returnStatus;

    static boolean useOrbDB() {
        if (!iConomy.Database.getType().toString().equalsIgnoreCase("orbdb")) {
            return false;
        }
        if (database == null) {
            database = iConomy.Database.getDatabase();
        }
        return true;
    }

    static boolean useMiniDB() {
        if (!iConomy.Database.getType().toString().equalsIgnoreCase("minidb")) {
            return false;
        }
        if (database == null) {
            database = iConomy.Database.getDatabase();
        }
        return true;
    }

    static boolean useInventoryDB() {
        if (!iConomy.Database.getType().toString().equalsIgnoreCase("inventorydb")) {
            return false;
        }
        if (inventory == null) {
            inventory = iConomy.Database.getInventoryDatabase();
        }
        if (database == null) {
            database = iConomy.Database.getDatabase();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<String> accountList() {
        List<String> accounts = new ArrayList<String>();
        if (Queried.useMiniDB() || Queried.useInventoryDB() || Queried.useOrbDB()) {
            if (Queried.useInventoryDB()) {
                accounts.addAll(inventory.getAllPlayers());
            }
            if (Queried.useOrbDB()) {
                for (Player p : iConomy.Server.getOnlinePlayers()) {
                    accounts.add(p.getName());
                }
            }
            accounts.addAll(database.getIndices().keySet());
            return accounts;
        }
        try {
            QueryRunner run = new QueryRunner();
            Connection c = iConomy.Database.getConnection();
            try {
                String t = Constants.Nodes.DatabaseTable.toString();
                accounts = run.query(c, "SELECT username FROM " + t, returnList);
            }
            catch (SQLException ex) {
                System.out.println("[iConomy] Error issueing SQL query: " + ex);
            }
            finally {
                DbUtils.close(c);
            }
        }
        catch (SQLException ex) {
            System.out.println("[iConomy] Database Error: " + ex);
        }
        return accounts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<Account> topAccounts(int amount) {
        Accounts Accounts2 = new Accounts();
        ArrayList<Account> accounts = new ArrayList<Account>();
        ArrayList<Account> finals = new ArrayList<Account>();
        List<String> total = new ArrayList<String>();
        if (Queried.useMiniDB() || Queried.useInventoryDB() || Queried.useOrbDB()) {
            if (Queried.useInventoryDB()) {
                total.addAll(inventory.getAllPlayers());
            }
            if (Queried.useOrbDB()) {
                for (Player p : iConomy.Server.getOnlinePlayers()) {
                    total.add(p.getName());
                }
            }
            total.addAll(database.getIndices().keySet());
        } else {
            try {
                QueryRunner run = new QueryRunner();
                Connection c = iConomy.Database.getConnection();
                try {
                    String t = Constants.Nodes.DatabaseTable.toString();
                    total = run.query(c, "SELECT username FROM " + t + " WHERE status <> 1 ORDER BY balance DESC LIMIT " + amount, returnList);
                }
                catch (SQLException ex) {
                    System.out.println("[iConomy] Error issueing SQL query: " + ex);
                }
                finally {
                    DbUtils.close(c);
                }
            }
            catch (SQLException ex) {
                System.out.println("[iConomy] Database Error: " + ex);
            }
        }
        for (String player : total) {
            if (Queried.useMiniDB() || Queried.useInventoryDB() || Queried.useOrbDB()) {
                accounts.add(Accounts2.get(player));
                continue;
            }
            finals.add(new Account(player));
        }
        if (Queried.useMiniDB() || Queried.useInventoryDB() || Queried.useOrbDB()) {
            Collections.sort(accounts, new MoneyComparator());
            if (amount > accounts.size()) {
                amount = accounts.size();
            }
            for (int i = 0; i < amount; ++i) {
                if (((Account)accounts.get(i)).getStatus() == 1) {
                    --i;
                    continue;
                }
                finals.add((Account)accounts.get(i));
            }
        }
        return finals;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean createAccount(String name, Double balance, Integer status) {
        Boolean created = false;
        if (Queried.useMiniDB() || Queried.useInventoryDB() || Queried.useOrbDB()) {
            if (Queried.hasAccount(name)) {
                return false;
            }
            if (Queried.useOrbDB() && iConomy.Server.getPlayer(name) != null) {
                return false;
            }
            if (Queried.useInventoryDB() && inventory.dataExists(name)) {
                return false;
            }
            Arguments Row = new Arguments(name);
            Row.setValue("balance", balance);
            Row.setValue("status", status);
            database.addIndex(Row.getKey(), Row);
            database.update();
            return true;
        }
        try {
            QueryRunner run = new QueryRunner();
            Connection c = iConomy.Database.getConnection();
            try {
                String t = Constants.Nodes.DatabaseTable.toString();
                Integer amount = run.update(c, "INSERT INTO " + t + "(username, balance, status) values (?, ?, ?)", name.toLowerCase(), balance, status);
                if (amount > 0) {
                    created = true;
                }
            }
            catch (SQLException ex) {
                System.out.println("[iConomy] Error issueing SQL query: " + ex);
            }
            finally {
                DbUtils.close(c);
            }
        }
        catch (SQLException ex) {
            System.out.println("[iConomy] Database Error: " + ex);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean removeAccount(String name) {
        Boolean removed = false;
        if (Queried.useMiniDB() || Queried.useInventoryDB() || Queried.useOrbDB()) {
            if (database.hasIndex(name)) {
                database.removeIndex(name);
                database.update();
                return true;
            }
            return false;
        }
        try {
            QueryRunner run = new QueryRunner();
            Connection c = iConomy.Database.getConnection();
            try {
                String t = Constants.Nodes.DatabaseTable.toString();
                Integer amount = run.update(c, "DELETE FROM " + t + " WHERE username=?", (Object)name.toLowerCase());
                if (amount > 0) {
                    removed = true;
                }
            }
            catch (SQLException ex) {
                System.out.println("[iConomy] Error issueing SQL query: " + ex);
            }
            finally {
                DbUtils.close(c);
            }
        }
        catch (SQLException ex) {
            System.out.println("[iConomy] Database Error: " + ex);
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean hasAccount(String name) {
        Boolean exists = false;
        if (Queried.useMiniDB() || Queried.useInventoryDB() || Queried.useOrbDB()) {
            if (Queried.useInventoryDB() && inventory.dataExists(name)) {
                return true;
            }
            if (Queried.useOrbDB() && iConomy.Server.getPlayer(name) != null) {
                return true;
            }
            return database.hasIndex(name);
        }
        try {
            QueryRunner run = new QueryRunner();
            Connection c = iConomy.Database.getConnection();
            try {
                String t = Constants.Nodes.DatabaseTable.toString();
                exists = run.query(c, "SELECT id FROM " + t + " WHERE username=?", returnBoolean, name.toLowerCase());
            }
            catch (SQLException ex) {
                System.out.println("[iConomy] Error issueing SQL query: " + ex);
            }
            finally {
                DbUtils.close(c);
            }
        }
        catch (SQLException ex) {
            System.out.println("[iConomy] Database Error: " + ex);
        }
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static double getBalance(String name) {
        Double balance = Constants.Nodes.Balance.getDouble();
        if (!Queried.hasAccount(name)) {
            return balance;
        }
        if (Queried.useMiniDB() || Queried.useInventoryDB() || Queried.useOrbDB()) {
            if (Queried.useInventoryDB() && inventory.dataExists(name)) {
                return inventory.getBalance(name);
            }
            if (Queried.useOrbDB() && iConomy.Server.getPlayer(name) != null) {
                return iConomy.Server.getPlayer(name).getTotalExperience();
            }
            if (database.hasIndex(name)) {
                return database.getArguments(name).getDouble("balance");
            }
            return balance;
        }
        try {
            QueryRunner run = new QueryRunner();
            Connection c = iConomy.Database.getConnection();
            try {
                String t = Constants.Nodes.DatabaseTable.toString();
                balance = run.query(c, "SELECT balance FROM " + t + " WHERE username=?", returnBalance, name.toLowerCase());
            }
            catch (SQLException ex) {
                System.out.println("[iConomy] Error issueing SQL query: " + ex);
            }
            finally {
                DbUtils.close(c);
            }
        }
        catch (SQLException ex) {
            System.out.println("[iConomy] Database Error: " + ex);
        }
        return balance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setBalance(String name, double balance) {
        double original = 0.0;
        double gain = 0.0;
        double loss = 0.0;
        if (Constants.Nodes.Logging.getBoolean().booleanValue()) {
            original = Queried.getBalance(name);
            gain = balance - original;
            loss = original - balance;
        }
        if (!Queried.hasAccount(name)) {
            Queried.createAccount(name, balance, 0);
            if (Constants.Nodes.Logging.getBoolean().booleanValue()) {
                if (gain < 0.0) {
                    gain = 0.0;
                }
                if (loss < 0.0) {
                    loss = 0.0;
                }
                Transactions.insert(new Transaction("setBalance", "System", name).setFromBalance(original).setToBalance(balance).setGain(gain).setLoss(loss).setSet(balance));
            }
            return;
        }
        if (Queried.useMiniDB() || Queried.useInventoryDB() || Queried.useOrbDB()) {
            if (Queried.useInventoryDB() && inventory.dataExists(name)) {
                inventory.setBalance(name, balance);
                return;
            }
            if (Queried.useOrbDB()) {
                Player gainer = iConomy.Server.getPlayer(name);
                if (gainer != null) {
                    if (balance < (double)gainer.getTotalExperience()) {
                        int amount = (int)((double)gainer.getTotalExperience() - balance);
                        for (int i = 0; i < amount; ++i) {
                            if (gainer.getExp() > 0.0f) {
                                gainer.setExp(gainer.getExp() - 1.0f);
                                continue;
                            }
                            if (gainer.getTotalExperience() > 0) {
                                gainer.setTotalExperience(gainer.getTotalExperience() - 1);
                                continue;
                            }
                            break;
                        }
                    } else {
                        int amount = (int)(balance - (double)gainer.getTotalExperience());
                        for (int i = 0; i < amount; ++i) {
                            gainer.setExp(gainer.getExp() + 1.0f);
                        }
                    }
                }
                return;
            }
            if (database.hasIndex(name)) {
                database.setArgument(name, "balance", balance);
                database.update();
            }
            return;
        }
        try {
            QueryRunner run = new QueryRunner();
            Connection c = iConomy.Database.getConnection();
            try {
                String t = Constants.Nodes.DatabaseTable.toString();
                int update = run.update(c, "UPDATE " + t + " SET balance=? WHERE username=?", balance, name.toLowerCase());
            }
            catch (SQLException ex) {
                System.out.println("[iConomy] Error issueing SQL query: " + ex);
            }
            finally {
                DbUtils.close(c);
            }
        }
        catch (SQLException ex) {
            System.out.println("[iConomy] Database Error: " + ex);
        }
    }

    static void doInterest(final String query, LinkedHashMap<String, HashMap<String, Object>> queries) {
        final Object[][] parameters = new Object[queries.size()][2];
        int i = 0;
        for (String name : queries.keySet()) {
            double balance = (Double)queries.get(name).get("balance");
            double original = 0.0;
            double gain = 0.0;
            double loss = 0.0;
            if (Constants.Nodes.Logging.getBoolean().booleanValue()) {
                original = Queried.getBalance(name);
                gain = balance - original;
                loss = original - balance;
            }
            if (!(Queried.useInventoryDB() || Queried.useMiniDB() || Queried.useOrbDB())) {
                parameters[i][0] = balance;
                parameters[i][1] = name;
                ++i;
            } else if (Queried.useMiniDB()) {
                if (!Queried.hasAccount(name)) continue;
                database.setArgument(name, "balance", balance);
                database.update();
            } else if (Queried.useInventoryDB()) {
                if (inventory.dataExists(name)) {
                    inventory.setBalance(name, balance);
                } else if (database.hasIndex(name)) {
                    database.setArgument(name, "balance", balance);
                    database.update();
                }
            } else if (Queried.useOrbDB()) {
                if (!Queried.hasAccount(name)) continue;
                Player gainer = iConomy.Server.getPlayer(name);
                if (gainer != null) {
                    Queried.setBalance(name, balance);
                }
            }
            if (!Constants.Nodes.Logging.getBoolean().booleanValue()) continue;
            if (gain < 0.0) {
                gain = 0.0;
            }
            if (loss < 0.0) {
                loss = 0.0;
            }
            Transactions.insert(new Transaction("Interest", "System", name).setFromBalance(original).setToBalance(balance).setGain(gain).setLoss(loss).setSet(balance));
        }
        if (!(Queried.useInventoryDB() || Queried.useMiniDB() || Queried.useOrbDB())) {
            Thrun.init(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        QueryRunner run = new QueryRunner();
                        Connection c = iConomy.Database.getConnection();
                        try {
                            run.batch(c, query, parameters);
                        }
                        catch (SQLException ex) {
                            System.out.println("[iConomy] Error with batching: " + ex);
                        }
                        finally {
                            DbUtils.close(c);
                        }
                    }
                    catch (SQLException ex) {
                        System.out.println("[iConomy] Database Error: " + ex);
                    }
                }
            });
        }
    }

    public static void purgeDatabase() {
        if (Queried.useMiniDB() || Queried.useInventoryDB() || Queried.useOrbDB()) {
            for (String index : database.getIndices().keySet()) {
                if (database.getArguments(index).getDouble("balance") != Constants.Nodes.Balance.getDouble()) continue;
                database.removeIndex(index);
            }
            database.update();
            if (Queried.useInventoryDB()) {
                for (Player p : iConomy.Server.getOnlinePlayers()) {
                    if (!inventory.dataExists(p.getName()) || inventory.getBalance(p.getName()) != Constants.Nodes.Balance.getDouble().doubleValue()) continue;
                    inventory.setBalance(p.getName(), 0.0);
                }
            }
            if (Queried.useOrbDB()) {
                for (Player p : iConomy.Server.getOnlinePlayers()) {
                    if ((double)p.getExp() != Constants.Nodes.Balance.getDouble()) continue;
                    p.setExp(0.0f);
                }
            }
            return;
        }
        Thrun.init(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    QueryRunner run = new QueryRunner();
                    Connection c = iConomy.Database.getConnection();
                    try {
                        String t = Constants.Nodes.DatabaseTable.toString();
                        Integer amount = run.update(c, "DELETE FROM " + t + " WHERE balance=?", (Object)Constants.Nodes.Balance.getDouble());
                    }
                    catch (SQLException ex) {
                        System.out.println("[iConomy] Error issueing SQL query: " + ex);
                    }
                    finally {
                        DbUtils.close(c);
                    }
                }
                catch (SQLException ex) {
                    System.out.println("[iConomy] Database Error: " + ex);
                }
            }
        });
    }

    static void emptyDatabase() {
        if (Queried.useMiniDB() || Queried.useInventoryDB() || Queried.useOrbDB()) {
            for (String index : database.getIndices().keySet()) {
                database.removeIndex(index);
            }
            database.update();
            if (Queried.useInventoryDB()) {
                for (Player p : iConomy.Server.getOnlinePlayers()) {
                    if (!inventory.dataExists(p.getName())) continue;
                    inventory.setBalance(p.getName(), 0.0);
                }
            }
            if (Queried.useOrbDB()) {
                for (Player p : iConomy.Server.getOnlinePlayers()) {
                    p.setExp(0.0f);
                }
            }
            return;
        }
        Thrun.init(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    QueryRunner run = new QueryRunner();
                    Connection c = iConomy.Database.getConnection();
                    try {
                        String t = Constants.Nodes.DatabaseTable.toString();
                        Integer amount = run.update(c, "TRUNCATE TABLE " + t);
                    }
                    catch (SQLException ex) {
                        System.out.println("[iConomy] Error issueing SQL query: " + ex);
                    }
                    finally {
                        DbUtils.close(c);
                    }
                }
                catch (SQLException ex) {
                    System.out.println("[iConomy] Database Error: " + ex);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Integer getStatus(String name) {
        int status = 0;
        if (!Queried.hasAccount(name)) {
            return -1;
        }
        if (Queried.useMiniDB()) {
            return database.getArguments(name).getInteger("status");
        }
        if (Queried.useInventoryDB()) {
            return inventory.dataExists(name) ? 1 : (database.hasIndex(name) ? database.getArguments(name).getInteger("status") : 0);
        }
        if (Queried.useOrbDB()) {
            return iConomy.Server.getPlayer(name) != null ? 1 : (database.hasIndex(name) ? database.getArguments(name).getInteger("status") : 0);
        }
        try {
            QueryRunner run = new QueryRunner();
            Connection c = iConomy.Database.getConnection();
            try {
                String t = Constants.Nodes.DatabaseTable.toString();
                status = run.query(c, "SELECT status FROM " + t + " WHERE username=?", returnStatus, name.toLowerCase());
            }
            catch (SQLException ex) {
                System.out.println("[iConomy] Error issueing SQL query: " + ex);
            }
            finally {
                DbUtils.close(c);
            }
        }
        catch (SQLException ex) {
            System.out.println("[iConomy] Database Error: " + ex);
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setStatus(String name, int status) {
        if (!Queried.hasAccount(name)) {
            return;
        }
        if (Queried.useMiniDB()) {
            database.setArgument(name, "status", status);
            database.update();
            return;
        }
        if (Queried.useInventoryDB() || Queried.useOrbDB()) {
            if (database.hasIndex(name)) {
                database.setArgument(name, "status", status);
                database.update();
            }
            return;
        }
        try {
            QueryRunner run = new QueryRunner();
            Connection c = iConomy.Database.getConnection();
            try {
                String t = Constants.Nodes.DatabaseTable.toString();
                int update = run.update(c, "UPDATE " + t + " SET status=? WHERE username=?", status, name.toLowerCase());
            }
            catch (SQLException ex) {
                System.out.println("[iConomy] Error issueing SQL query: " + ex);
            }
            finally {
                DbUtils.close(c);
            }
        }
        catch (SQLException ex) {
            System.out.println("[iConomy] Database Error: " + ex);
        }
    }

    static {
        returnName = new ResultSetHandler<String>(){

            @Override
            public String handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    return rs.getString("name");
                }
                return null;
            }
        };
        returnList = new ResultSetHandler<List<String>>(){
            private List<String> accounts;

            @Override
            public List<String> handle(ResultSet rs) throws SQLException {
                this.accounts = new ArrayList<String>();
                while (rs.next()) {
                    this.accounts.add(rs.getString("username"));
                }
                return this.accounts;
            }
        };
        returnBoolean = new ResultSetHandler<Boolean>(){

            @Override
            public Boolean handle(ResultSet rs) throws SQLException {
                return rs.next();
            }
        };
        returnBalance = new ResultSetHandler<Double>(){

            @Override
            public Double handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    return rs.getDouble("balance");
                }
                return null;
            }
        };
        returnStatus = new ResultSetHandler<Integer>(){

            @Override
            public Integer handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    return rs.getInt("status");
                }
                return null;
            }
        };
    }
}

