/*
 * Decompiled with CFR 0.152.
 */
package com.iCo6.util.nbt;

import com.iCo6.util.nbt.NBTUtils;
import com.iCo6.util.nbt.Tag;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ListTag<T extends Tag>
extends Tag {
    private final Class<T> type;
    private final List<T> value;

    public ListTag(String name, Class<T> type, List<T> value) {
        super(name);
        this.type = type;
        this.value = Collections.unmodifiableList(value);
    }

    public Class<T> getType() {
        return this.type;
    }

    @Override
    public List<T> getValue() {
        return this.value;
    }

    public String toString() {
        String name = this.getName();
        String append = "";
        if (name != null && !name.equals("")) {
            append = "(\"" + this.getName() + "\")";
        }
        StringBuilder bldr = new StringBuilder();
        bldr.append("TAG_List" + append + ": " + this.value.size() + " entries of type " + NBTUtils.getTypeName(this.type) + "\r\n{\r\n");
        for (Tag t : this.value) {
            bldr.append("   " + t.toString().replaceAll("\r\n", "\r\n   ") + "\r\n");
        }
        bldr.append("}");
        return bldr.toString();
    }
}

