/*
 * Decompiled with CFR 0.152.
 */
package com.iCo6.util.org.apache.commons.dbutils;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryLoader {
    private static final QueryLoader instance = new QueryLoader();
    private final Map<String, Map<String, String>> queries = new HashMap<String, Map<String, String>>();

    public static QueryLoader instance() {
        return instance;
    }

    protected QueryLoader() {
    }

    public synchronized Map<String, String> load(String path) throws IOException {
        Map<String, String> queryMap = this.queries.get(path);
        if (queryMap == null) {
            queryMap = this.loadQueries(path);
            this.queries.put(path, queryMap);
        }
        return queryMap;
    }

    protected Map<String, String> loadQueries(String path) throws IOException {
        InputStream in = this.getClass().getResourceAsStream(path);
        if (in == null) {
            throw new IllegalArgumentException(path + " not found.");
        }
        Properties props = new Properties();
        props.load(in);
        return new HashMap<Object, Object>(props);
    }

    public synchronized void unload(String path) {
        this.queries.remove(path);
    }
}

