/*
 * Decompiled with CFR 0.152.
 */
package net.serubin.hatme;

import net.serubin.hatme.HatMe;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class HatExecutor {
    private HatMe plugin;

    public HatExecutor(HatMe plugin) {
        this.plugin = plugin;
    }

    public boolean hatOn(Player player) {
        ItemStack itemHand = player.getItemInHand();
        if (itemHand == null || itemHand.getTypeId() == 0) {
            if (player.getInventory().getHelmet() == null) {
                this.plugin.sendMessage(player, ChatColor.RED, this.plugin.airHeadMessage());
                return true;
            }
            return this.hatOff(player);
        }
        if (!this.headEmpty(player)) {
            this.plugin.sendMessage(player, ChatColor.RED, this.plugin.hatAlreadyOnMessage());
            return true;
        }
        if (this.moveOneToHead(itemHand, player)) {
            this.plugin.sendMessage(player, ChatColor.YELLOW, this.plugin.hatOnMessage());
            return true;
        }
        return false;
    }

    public boolean hatOnAll(Player player) {
        ItemStack itemHand = player.getItemInHand();
        if (itemHand == null) {
            this.plugin.sendMessage(player, ChatColor.RED, this.plugin.airHeadMessage());
            return true;
        }
        if (!this.headEmpty(player)) {
            this.plugin.sendMessage(player, ChatColor.RED, this.plugin.hatAlreadyOnMessage());
            return true;
        }
        if (this.moveAllToHead(itemHand, player)) {
            this.plugin.sendMessage(player, ChatColor.YELLOW, this.plugin.hatOnMessage());
            return true;
        }
        return false;
    }

    public boolean giveHat(Player player, int itemID) {
        if (itemID == 0) {
            this.plugin.sendMessage(player, ChatColor.RED, this.plugin.airHeadMessage());
            return true;
        }
        if (!this.headEmpty(player)) {
            this.plugin.sendMessage(player, ChatColor.RED, this.plugin.hatAlreadyOnMessage());
            return true;
        }
        if (this.setHead(itemID, player)) {
            this.plugin.sendMessage(player, ChatColor.YELLOW, this.plugin.hatOnMessage());
            return true;
        }
        return false;
    }

    public boolean hatOff(Player player) {
        PlayerInventory inventory = player.getInventory();
        int empty = inventory.firstEmpty();
        ItemStack itemHead = inventory.getHelmet();
        if (empty == -1) {
            this.plugin.sendMessage(player, ChatColor.RED, this.plugin.noSpaceMessage());
            return true;
        }
        inventory.setHelmet(null);
        inventory.setItem(empty, itemHead);
        this.plugin.sendMessage(player, ChatColor.YELLOW, this.plugin.hatOffMessage());
        return true;
    }

    private boolean moveOneToHead(ItemStack itemHand, Player player) {
        PlayerInventory playerInv = player.getInventory();
        if (itemHand.getAmount() == 1) {
            playerInv.setHelmet(itemHand);
            playerInv.setItemInHand(null);
            return true;
        }
        ItemStack newHelmet = new ItemStack(itemHand.getType(), 1, itemHand.getDurability());
        this.plugin.debug("itemHand Original: " + itemHand.getAmount());
        newHelmet.setAmount(1);
        playerInv.setHelmet(newHelmet);
        itemHand.setAmount(itemHand.getAmount() - 1);
        this.plugin.debug("itemHand New: " + itemHand.getAmount());
        return true;
    }

    private boolean moveAllToHead(ItemStack itemHand, Player player) {
        PlayerInventory playerInv = player.getInventory();
        playerInv.setHelmet(itemHand);
        playerInv.setItemInHand(null);
        return true;
    }

    private boolean setHead(int itemID, Player player) {
        PlayerInventory playerInv = player.getInventory();
        playerInv.setHelmet(new ItemStack(itemID));
        return true;
    }

    private boolean headEmpty(Player player) {
        return player.getInventory().getHelmet() == null;
    }
}

