/*
 * Decompiled with CFR 0.152.
 */
package net.serubin.hatme;

import java.util.logging.Logger;
import net.serubin.hatme.HatExecutor;
import net.serubin.hatme.HatPermsHandler;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class HatMe
extends JavaPlugin {
    private static HatMe plugin;
    static Logger log;
    private String name;
    private String version;
    private final String hatOn = "You now have a hat! Use /unhat to remove it.";
    private final String hatOff = "You have taken off your hat!";
    private final String noSpace = "You have no space to take of your hat!";
    private final String hatAlreadyOn = "You already have a hat on! Take it off with /unhat.";
    private final String airHead = "You have just tried to put air on your head. Good job.";
    private final String noPerm = "You do not have permission to use this command.";
    private String notAllowedMsg;
    private HatPermsHandler permsHandler;
    private HatExecutor executor;
    private boolean debug = false;

    public void onEnable() {
        this.version = this.getDescription().getVersion();
        this.name = this.getDescription().getName();
        this.info("Start Plugin... (Version: " + this.version + ")");
        PluginManager pm = this.getServer().getPluginManager();
        this.getConfig().options().copyDefaults(true);
        this.saveConfig();
        this.notAllowedMsg = this.getConfig().getString("plugin.hatme.notAllowedMsg");
        this.permsHandler = new HatPermsHandler(this, this.getConfig());
        this.executor = new HatExecutor(this);
        this.getCommand("hat").setExecutor((CommandExecutor)this);
        this.getCommand("unhat").setExecutor((CommandExecutor)this);
        this.info("Plugin Loaded!");
    }

    public void onDisable() {
        this.info("Plugin Stopping...");
        this.reloadConfig();
        this.saveConfig();
        this.info("Plugin Stopped.");
    }

    public String hatOnMessage() {
        return "You now have a hat! Use /unhat to remove it.";
    }

    public String hatOffMessage() {
        return "You have taken off your hat!";
    }

    public String noSpaceMessage() {
        return "You have no space to take of your hat!";
    }

    public String hatAlreadyOnMessage() {
        return "You already have a hat on! Take it off with /unhat.";
    }

    public String airHeadMessage() {
        return "You have just tried to put air on your head. Good job.";
    }

    public String noPermMessage() {
        return "You do not have permission to use this command.";
    }

    public void debug(String text) {
        if (this.debug) {
            log.info("[" + this.name + "] Debug - " + text);
        }
    }

    public void info(String text) {
        log.info("[" + this.name + "] " + text);
    }

    public void sendMessage(Player player, ChatColor color, String text) {
        player.sendMessage(color + "[" + this.name + "] " + text);
    }

    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        Player player;
        if (commandLabel.equalsIgnoreCase("hat")) {
            if (args.length == 0 && sender instanceof Player) {
                Player player2 = (Player)sender;
                if (!this.permsHandler.checkHatPerms(player2)) {
                    this.sendMessage(player2, ChatColor.RED, this.noPermMessage());
                    return true;
                }
                if (!this.permsHandler.checkRestrict(player2)) {
                    sender.sendMessage(ChatColor.RED + "[HatMe] " + this.notAllowedMsg);
                    return true;
                }
                return this.executor.hatOn(player2);
            }
            if (args.length == 1 && sender instanceof Player) {
                player = (Player)sender;
                if (args[0].equalsIgnoreCase("-a")) {
                    if (!this.permsHandler.checkHatAllPerms(player)) {
                        this.sendMessage(player, ChatColor.RED, this.noPermMessage());
                        return true;
                    }
                    if (player.getItemInHand().getTypeId() == 0) {
                        this.sendMessage(player, ChatColor.YELLOW, this.airHeadMessage());
                        return true;
                    }
                    if (!this.permsHandler.checkRestrict(player)) {
                        sender.sendMessage(ChatColor.RED + "[HatMe] " + this.notAllowedMsg);
                        return true;
                    }
                    return this.executor.hatOnAll(player);
                }
                if (this.checkArgInt(args[0])) {
                    if (!this.permsHandler.checkGivePerms(player, args[0])) {
                        this.sendMessage(player, ChatColor.RED, this.noPermMessage());
                        return true;
                    }
                    if (!this.permsHandler.checkItemRestrict(args[0], player)) {
                        sender.sendMessage(ChatColor.RED + "[HatMe] " + this.notAllowedMsg);
                        return true;
                    }
                    return this.executor.giveHat(player, Integer.parseInt(args[0]));
                }
            } else {
                sender.sendMessage(ChatColor.RED + "[HatMe] You have used this command incorrectly, or you are the console.");
                return true;
            }
        }
        if (commandLabel.equalsIgnoreCase("unhat")) {
            if (args.length >= 1 || !(sender instanceof Player)) {
                sender.sendMessage(ChatColor.RED + "[HatMe] This command does not take any arguments. If you are the console, you can't use this.");
                return true;
            }
            player = (Player)sender;
            if (player.getInventory().getHelmet() == null) {
                player.sendMessage(ChatColor.YELLOW + "[HatMe] You have taken the air from around your head.");
                return true;
            }
            this.executor.hatOff(player);
            return true;
        }
        return false;
    }

    public boolean checkArgInt(String arg) {
        try {
            Integer.parseInt(arg);
        }
        catch (NumberFormatException ex) {
            return false;
        }
        return true;
    }

    static {
        log = Logger.getLogger("Minecraft");
    }
}

