/*
 * Decompiled with CFR 0.152.
 */
package lishid.openinv;

import java.util.HashMap;
import lishid.openinv.OpenInvEntityListener;
import lishid.openinv.OpenInvInventoryListener;
import lishid.openinv.OpenInvPlayerListener;
import lishid.openinv.commands.AnyChestPluginCommand;
import lishid.openinv.commands.OpenEnderPluginCommand;
import lishid.openinv.commands.OpenInvPluginCommand;
import lishid.openinv.commands.SearchInvPluginCommand;
import lishid.openinv.commands.SilentChestPluginCommand;
import lishid.openinv.commands.ToggleOpenInvPluginCommand;
import lishid.openinv.utils.Metrics;
import lishid.openinv.utils.OpenInvEnderChest;
import lishid.openinv.utils.OpenInvPlayerInventory;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class OpenInv
extends JavaPlugin {
    public static HashMap<String, OpenInvPlayerInventory> inventories = new HashMap();
    public static HashMap<String, OpenInvEnderChest> enderChests = new HashMap();
    public static OpenInv mainPlugin;
    private static Metrics metrics;

    public void onDisable() {
        PluginDescriptionFile pdfFile = this.getDescription();
        System.out.println("[" + pdfFile.getName() + "] version " + pdfFile.getVersion() + " disabled!");
    }

    public void onEnable() {
        mainPlugin = this;
        mainPlugin.getConfig().addDefault("ItemOpenInvItemID", (Object)280);
        mainPlugin.getConfig().options().copyDefaults(true);
        mainPlugin.saveConfig();
        PluginManager pm = this.getServer().getPluginManager();
        pm.registerEvents((Listener)new OpenInvPlayerListener(), (Plugin)this);
        pm.registerEvents((Listener)new OpenInvEntityListener(), (Plugin)this);
        pm.registerEvents((Listener)new OpenInvInventoryListener(), (Plugin)this);
        this.getCommand("openinv").setExecutor((CommandExecutor)new OpenInvPluginCommand(this));
        this.getCommand("searchinv").setExecutor((CommandExecutor)new SearchInvPluginCommand(this));
        this.getCommand("toggleopeninv").setExecutor((CommandExecutor)new ToggleOpenInvPluginCommand());
        this.getCommand("silentchest").setExecutor((CommandExecutor)new SilentChestPluginCommand(this));
        this.getCommand("anychest").setExecutor((CommandExecutor)new AnyChestPluginCommand(this));
        this.getCommand("openender").setExecutor((CommandExecutor)new OpenEnderPluginCommand(this));
        try {
            metrics = new Metrics((Plugin)this);
            metrics.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        PluginDescriptionFile pdfFile = this.getDescription();
        System.out.println("[" + pdfFile.getName() + "] version " + pdfFile.getVersion() + " enabled!");
    }

    public static boolean GetPlayerItemOpenInvStatus(String name) {
        return mainPlugin.getConfig().getBoolean("ItemOpenInv." + name.toLowerCase() + ".toggle", false);
    }

    public static void SetPlayerItemOpenInvStatus(String name, boolean status) {
        mainPlugin.getConfig().set("ItemOpenInv." + name.toLowerCase() + ".toggle", (Object)status);
        mainPlugin.saveConfig();
    }

    public static boolean GetPlayerSilentChestStatus(String name) {
        return mainPlugin.getConfig().getBoolean("SilentChest." + name.toLowerCase() + ".toggle", false);
    }

    public static void SetPlayerSilentChestStatus(String name, boolean status) {
        mainPlugin.getConfig().set("SilentChest." + name.toLowerCase() + ".toggle", (Object)status);
        mainPlugin.saveConfig();
    }

    public static boolean GetPlayerAnyChestStatus(String name) {
        return mainPlugin.getConfig().getBoolean("AnyChest." + name.toLowerCase() + ".toggle", true);
    }

    public static void SetPlayerAnyChestStatus(String name, boolean status) {
        mainPlugin.getConfig().set("AnyChest." + name.toLowerCase() + ".toggle", (Object)status);
        mainPlugin.saveConfig();
    }

    public static int GetItemOpenInvItem() {
        if (mainPlugin.getConfig().get("ItemOpenInvItemID") == null) {
            OpenInv.SaveToConfig("ItemOpenInvItemID", 280);
        }
        return mainPlugin.getConfig().getInt("ItemOpenInvItemID", 280);
    }

    public static Object GetFromConfig(String data, Object defaultValue) {
        Object val = mainPlugin.getConfig().get(data);
        if (val == null) {
            mainPlugin.getConfig().set(data, defaultValue);
            return defaultValue;
        }
        return val;
    }

    public static void SaveToConfig(String data, Object value) {
        mainPlugin.getConfig().set(data, value);
        mainPlugin.saveConfig();
    }

    public static void ShowHelp(Player player) {
        player.sendMessage(ChatColor.GREEN + "/openinv <Player> - Open a player's inventory");
        player.sendMessage(ChatColor.GREEN + "   (aliases: oi, inv, open)");
        player.sendMessage(ChatColor.GREEN + "/openender <Player> - Open a player's enderchest");
        player.sendMessage(ChatColor.GREEN + "   (aliases: oe, enderchest)");
        player.sendMessage(ChatColor.GREEN + "/toggleopeninv - Toggle item openinv function");
        player.sendMessage(ChatColor.GREEN + "   (aliases: toi, toggleoi, toggleinv)");
        player.sendMessage(ChatColor.GREEN + "/searchinv <Item> [MinAmount] - ");
        player.sendMessage(ChatColor.GREEN + "   Search and list players having a specific item.");
        player.sendMessage(ChatColor.GREEN + "   (aliases: si, search)");
        player.sendMessage(ChatColor.GREEN + "/anychest - Toggle anychest function");
        player.sendMessage(ChatColor.GREEN + "   (aliases: ac)");
        player.sendMessage(ChatColor.GREEN + "/silentchest - Toggle silent chest function");
        player.sendMessage(ChatColor.GREEN + "   (aliases: sc, silent)");
    }
}

