/*
 * Decompiled with CFR 0.152.
 */
package lishid.openinv;

import java.lang.reflect.Field;
import lishid.openinv.OpenInv;
import lishid.openinv.utils.OpenInvEnderChest;
import lishid.openinv.utils.OpenInvPlayerInventory;
import lishid.openinv.utils.SilentContainerChest;
import net.minecraft.server.Block;
import net.minecraft.server.EntityPlayer;
import net.minecraft.server.ICrafting;
import net.minecraft.server.IInventory;
import net.minecraft.server.InventoryLargeChest;
import net.minecraft.server.Packet;
import net.minecraft.server.Packet100OpenWindow;
import net.minecraft.server.TileEntityChest;
import net.minecraft.server.World;
import org.bukkit.ChatColor;
import org.bukkit.block.Chest;
import org.bukkit.block.Sign;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class OpenInvPlayerListener
implements Listener {
    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerJoin(PlayerJoinEvent event) {
        OpenInvEnderChest chest;
        OpenInvPlayerInventory inventory = OpenInv.inventories.get(event.getPlayer().getName().toLowerCase());
        if (inventory != null) {
            inventory.PlayerGoOnline((CraftPlayer)event.getPlayer());
        }
        if ((chest = OpenInv.enderChests.get(event.getPlayer().getName().toLowerCase())) != null) {
            chest.PlayerGoOnline((CraftPlayer)event.getPlayer());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerQuit(PlayerQuitEvent event) {
        OpenInvEnderChest chest;
        OpenInvPlayerInventory inventory = OpenInv.inventories.get(event.getPlayer().getName().toLowerCase());
        if (inventory != null) {
            inventory.PlayerGoOffline();
            inventory.InventoryRemovalCheck();
        }
        if ((chest = OpenInv.enderChests.get(event.getPlayer().getName().toLowerCase())) != null) {
            chest.PlayerGoOffline();
            chest.InventoryRemovalCheck();
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getAction() == Action.RIGHT_CLICK_BLOCK && event.useInteractedBlock() == Event.Result.DENY) {
            return;
        }
        if (event.getAction() == Action.RIGHT_CLICK_BLOCK && event.getClickedBlock().getState() instanceof Chest) {
            World world;
            EntityPlayer player;
            boolean silentchest = false;
            boolean anychest = false;
            int x = event.getClickedBlock().getX();
            int y = event.getClickedBlock().getY();
            int z = event.getClickedBlock().getZ();
            if (event.getPlayer().hasPermission("OpenInv.silent") && OpenInv.GetPlayerSilentChestStatus(event.getPlayer().getName())) {
                silentchest = true;
            }
            if (event.getPlayer().hasPermission("OpenInv.anychest") && OpenInv.GetPlayerAnyChestStatus(event.getPlayer().getName())) {
                try {
                    player = ((CraftPlayer)event.getPlayer()).getHandle();
                    world = player.world;
                    if (world.s(x, y + 1, z)) {
                        anychest = true;
                    }
                    if (world.getTypeId(x - 1, y, z) == Block.CHEST.id && world.s(x - 1, y + 1, z)) {
                        anychest = true;
                    }
                    if (world.getTypeId(x + 1, y, z) == Block.CHEST.id && world.s(x + 1, y + 1, z)) {
                        anychest = true;
                    }
                    if (world.getTypeId(x, y, z - 1) == Block.CHEST.id && world.s(x, y + 1, z - 1)) {
                        anychest = true;
                    }
                    if (world.getTypeId(x, y, z + 1) == Block.CHEST.id && world.s(x, y + 1, z + 1)) {
                        anychest = true;
                    }
                }
                catch (Exception e) {
                    event.getPlayer().sendMessage(ChatColor.RED + "Error while executing openinv. Unsupported CraftBukkit.");
                    e.printStackTrace();
                }
            }
            if (anychest || silentchest) {
                player = ((CraftPlayer)event.getPlayer()).getHandle();
                world = player.world;
                TileEntityChest chest = (TileEntityChest)world.getTileEntity(x, y, z);
                if (chest == null) {
                    return;
                }
                if (!anychest) {
                    if (world.s(x, y + 1, z)) {
                        return;
                    }
                    if (world.getTypeId(x - 1, y, z) == Block.CHEST.id && world.s(x - 1, y + 1, z)) {
                        return;
                    }
                    if (world.getTypeId(x + 1, y, z) == Block.CHEST.id && world.s(x + 1, y + 1, z)) {
                        return;
                    }
                    if (world.getTypeId(x, y, z - 1) == Block.CHEST.id && world.s(x, y + 1, z - 1)) {
                        return;
                    }
                    if (world.getTypeId(x, y, z + 1) == Block.CHEST.id && world.s(x, y + 1, z + 1)) {
                        return;
                    }
                }
                if (world.getTypeId(x - 1, y, z) == Block.CHEST.id) {
                    chest = new InventoryLargeChest("Large chest", (IInventory)((TileEntityChest)world.getTileEntity(x - 1, y, z)), (IInventory)chest);
                }
                if (world.getTypeId(x + 1, y, z) == Block.CHEST.id) {
                    chest = new InventoryLargeChest("Large chest", (IInventory)chest, (IInventory)((TileEntityChest)world.getTileEntity(x + 1, y, z)));
                }
                if (world.getTypeId(x, y, z - 1) == Block.CHEST.id) {
                    chest = new InventoryLargeChest("Large chest", (IInventory)((TileEntityChest)world.getTileEntity(x, y, z - 1)), (IInventory)chest);
                }
                if (world.getTypeId(x, y, z + 1) == Block.CHEST.id) {
                    chest = new InventoryLargeChest("Large chest", (IInventory)chest, (IInventory)((TileEntityChest)world.getTileEntity(x, y, z + 1)));
                }
                if (!silentchest) {
                    player.openContainer((IInventory)chest);
                } else {
                    try {
                        int id = 0;
                        try {
                            Field windowID = player.getClass().getDeclaredField("containerCounter");
                            windowID.setAccessible(true);
                            id = windowID.getInt(player);
                            id = id % 100 + 1;
                            windowID.setInt(player, id);
                        }
                        catch (NoSuchFieldException noSuchFieldException) {
                            // empty catch block
                        }
                        player.netServerHandler.sendPacket((Packet)new Packet100OpenWindow(id, 0, ((IInventory)chest).getName(), ((IInventory)chest).getSize()));
                        player.activeContainer = new SilentContainerChest((IInventory)player.inventory, (IInventory)chest);
                        player.activeContainer.windowId = id;
                        player.activeContainer.addSlotListener((ICrafting)player);
                        event.setUseInteractedBlock(Event.Result.DENY);
                        event.setCancelled(true);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        event.getPlayer().sendMessage(ChatColor.RED + "Error while sending silent chest.");
                    }
                }
                if (anychest) {
                    event.getPlayer().sendMessage("You are opening a blocked chest.");
                }
            }
        }
        if (event.getAction() == Action.RIGHT_CLICK_BLOCK && event.getClickedBlock().getState() instanceof Sign) {
            Player player = event.getPlayer();
            try {
                Sign sign = (Sign)event.getClickedBlock().getState();
                if (player.hasPermission("OpenInv.openinv") && sign.getLine(0).equalsIgnoreCase("[openinv]")) {
                    String text = String.valueOf(sign.getLine(1).trim()) + sign.getLine(2).trim() + sign.getLine(3).trim();
                    player.performCommand("openinv " + text);
                }
            }
            catch (Exception ex) {
                player.sendMessage("Internal Error.");
                ex.printStackTrace();
            }
        }
        if (event.getAction() == Action.RIGHT_CLICK_AIR || event.getAction() == Action.RIGHT_CLICK_BLOCK) {
            Player player = event.getPlayer();
            if (player.getItemInHand().getType().getId() != OpenInv.GetItemOpenInvItem() || !OpenInv.GetPlayerItemOpenInvStatus(player.getName()) || !player.hasPermission("OpenInv.openinv")) {
                return;
            }
            player.performCommand("openinv");
        }
    }
}

