/*
 * Decompiled with CFR 0.152.
 */
package lishid.openinv.commands;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import lishid.openinv.OpenInv;
import lishid.openinv.utils.OpenInvPlayerInventory;
import net.minecraft.server.EntityPlayer;
import net.minecraft.server.IInventory;
import net.minecraft.server.ItemInWorldManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.World;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.entity.Player;

public class OpenInvPluginCommand
implements CommandExecutor {
    private final OpenInv plugin;
    public static HashMap<Player, OpenInvPlayerInventory> offlineInv = new HashMap();
    public static HashMap<Player, String> openInvHistory = new HashMap();

    public OpenInvPluginCommand(OpenInv plugin) {
        this.plugin = plugin;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String name;
        String history;
        boolean offline;
        Player player;
        block16: {
            if (!(sender instanceof Player)) {
                sender.sendMessage(ChatColor.RED + "You can't use this from the console.");
                return true;
            }
            if (!sender.hasPermission("OpenInv.openinv")) {
                sender.sendMessage(ChatColor.RED + "You do not have permission to access player inventories");
                return true;
            }
            if (args.length > 0 && args[0].equalsIgnoreCase("?")) {
                OpenInv.ShowHelp((Player)sender);
                return true;
            }
            player = (Player)sender;
            offline = false;
            history = openInvHistory.get(player);
            if (history == null || history == "") {
                history = player.getName();
                openInvHistory.put(player, history);
            }
            name = "";
            if (args.length < 1) {
                if (history != null && history != "") {
                    name = history;
                    break block16;
                } else {
                    sender.sendMessage(ChatColor.RED + "OpenInv history is empty!");
                    return true;
                }
            }
            name = args[0];
        }
        Player target = this.plugin.getServer().getPlayer(name);
        if (target == null) {
            try {
                File playerfolder = new File(((org.bukkit.World)Bukkit.getWorlds().get(0)).getWorldFolder(), "players");
                if (!playerfolder.exists()) {
                    sender.sendMessage(ChatColor.RED + "Player " + name + " not found!");
                    return true;
                }
                String playername = OpenInvPluginCommand.matchUser(Arrays.asList(playerfolder.listFiles()), name);
                if (playername == null) {
                    sender.sendMessage(ChatColor.RED + "Player " + name + " not found!");
                    return true;
                }
                MinecraftServer server = ((CraftServer)Bukkit.getServer()).getServer();
                EntityPlayer entity = new EntityPlayer(server, (World)server.getWorldServer(0), playername, new ItemInWorldManager(server.getWorldServer(0)));
                CraftPlayer craftPlayer = target = entity == null ? null : entity.getBukkitEntity();
                if (target == null) {
                    sender.sendMessage(ChatColor.RED + "Player " + name + " not found!");
                    return true;
                }
                target.loadData();
                offline = true;
            }
            catch (Exception e) {
                sender.sendMessage("Error while retrieving offline player data!");
                e.printStackTrace();
                return true;
            }
        }
        if (!player.hasPermission("OpenInv.override") && target.hasPermission("OpenInv.exempt")) {
            sender.sendMessage(ChatColor.RED + target.getDisplayName() + "'s inventory is protected!");
            return true;
        }
        if (!player.hasPermission("OpenInv.crossworld") && !player.hasPermission("OpenInv.override") && target.getWorld() != player.getWorld()) {
            sender.sendMessage(ChatColor.RED + target.getDisplayName() + " is not in your world!");
            return true;
        }
        history = target.getName();
        openInvHistory.put(player, history);
        OpenInvPlayerInventory inv = OpenInv.inventories.get(target.getName().toLowerCase());
        if (inv == null) {
            inv = new OpenInvPlayerInventory((CraftPlayer)target, !offline);
            OpenInv.inventories.put(target.getName().toLowerCase(), inv);
        }
        ((CraftPlayer)player).getHandle().openContainer((IInventory)inv);
        return true;
    }

    public static String matchUser(Collection<File> container, String search) {
        String found = null;
        if (search == null) {
            return found;
        }
        String lowerSearch = search.toLowerCase();
        int delta = Integer.MAX_VALUE;
        for (File file : container) {
            String filename = file.getName();
            String str = filename.substring(0, filename.length() - 4);
            if (!str.toLowerCase().startsWith(lowerSearch)) continue;
            int curDelta = str.length() - lowerSearch.length();
            if (curDelta < delta) {
                found = str;
                delta = curDelta;
            }
            if (curDelta == 0) break;
        }
        return found;
    }
}

