/*
 * Decompiled with CFR 0.152.
 */
package lishid.openinv.utils;

import lishid.openinv.OpenInv;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.ItemStack;
import net.minecraft.server.PlayerInventory;
import org.bukkit.craftbukkit.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.entity.CraftPlayer;

public class OpenInvPlayerInventory
extends PlayerInventory {
    CraftPlayer owner;
    public boolean playerOnline = false;
    private ItemStack[] extra = new ItemStack[5];

    public OpenInvPlayerInventory(CraftPlayer p, boolean online) {
        super((EntityHuman)p.getHandle());
        this.owner = p;
        this.playerOnline = online;
        this.items = this.player.inventory.items;
        this.armor = this.player.inventory.armor;
    }

    public void onClose(CraftHumanEntity who) {
        super.onClose(who);
        this.InventoryRemovalCheck();
    }

    public void InventoryRemovalCheck() {
        if (this.transaction.isEmpty() && !this.playerOnline) {
            this.owner.saveData();
            OpenInv.inventories.remove(this.owner.getName().toLowerCase());
        }
    }

    public void PlayerGoOnline(CraftPlayer p) {
        if (!this.playerOnline) {
            p.getHandle().inventory.items = this.items;
            p.getHandle().inventory.armor = this.armor;
            p.saveData();
            this.playerOnline = true;
        }
    }

    public void PlayerGoOffline() {
        this.playerOnline = false;
    }

    public ItemStack[] getContents() {
        ItemStack[] C = new ItemStack[this.getSize()];
        System.arraycopy(this.items, 0, C, 0, this.items.length);
        System.arraycopy(this.items, 0, C, this.items.length, this.armor.length);
        return C;
    }

    public int getSize() {
        return super.getSize() + 5;
    }

    public ItemStack getItem(int i) {
        ItemStack[] is = this.items;
        if (i >= is.length) {
            i -= is.length;
            is = this.armor;
        } else {
            i = this.getReversedItemSlotNum(i);
        }
        if (i >= is.length) {
            i -= is.length;
            is = this.extra;
        } else if (is == this.armor) {
            i = this.getReversedArmorSlotNum(i);
        }
        return is[i];
    }

    public ItemStack splitStack(int i, int j) {
        ItemStack[] is = this.items;
        if (i >= is.length) {
            i -= is.length;
            is = this.armor;
        } else {
            i = this.getReversedItemSlotNum(i);
        }
        if (i >= is.length) {
            i -= is.length;
            is = this.extra;
        } else if (is == this.armor) {
            i = this.getReversedArmorSlotNum(i);
        }
        if (is[i] != null) {
            if (is[i].count <= j) {
                ItemStack itemstack = is[i];
                is[i] = null;
                return itemstack;
            }
            ItemStack itemstack = is[i].a(j);
            if (is[i].count == 0) {
                is[i] = null;
            }
            return itemstack;
        }
        return null;
    }

    public ItemStack splitWithoutUpdate(int i) {
        ItemStack[] is = this.items;
        if (i >= is.length) {
            i -= is.length;
            is = this.armor;
        } else {
            i = this.getReversedItemSlotNum(i);
        }
        if (i >= is.length) {
            i -= is.length;
            is = this.extra;
        } else if (is == this.armor) {
            i = this.getReversedArmorSlotNum(i);
        }
        if (is[i] != null) {
            ItemStack itemstack = is[i];
            is[i] = null;
            return itemstack;
        }
        return null;
    }

    public void setItem(int i, ItemStack itemstack) {
        ItemStack[] is = this.items;
        if (i >= is.length) {
            i -= is.length;
            is = this.armor;
        } else {
            i = this.getReversedItemSlotNum(i);
        }
        if (i >= is.length) {
            i -= is.length;
            is = this.extra;
        } else if (is == this.armor) {
            i = this.getReversedArmorSlotNum(i);
        }
        is[i] = itemstack;
    }

    private int getReversedItemSlotNum(int i) {
        if (i >= 27) {
            return i - 27;
        }
        return i + 9;
    }

    private int getReversedArmorSlotNum(int i) {
        if (i == 0) {
            return 3;
        }
        if (i == 1) {
            return 2;
        }
        if (i == 2) {
            return 1;
        }
        if (i == 3) {
            return 0;
        }
        return i;
    }

    public String getName() {
        if (this.player.name.length() > 16) {
            return this.player.name.substring(0, 16);
        }
        return this.player.name;
    }

    public boolean a(EntityHuman entityhuman) {
        return true;
    }
}

