/*
 * Decompiled with CFR 0.152.
 */
package com.nijikokun.register.payment.methods;

import com.nijikokun.register.payment.Method;
import me.greatman.Craftconomy.Account;
import me.greatman.Craftconomy.AccountHandler;
import me.greatman.Craftconomy.Bank;
import me.greatman.Craftconomy.BankHandler;
import me.greatman.Craftconomy.Craftconomy;
import me.greatman.Craftconomy.Currency;
import me.greatman.Craftconomy.CurrencyHandler;
import me.greatman.Craftconomy.utils.Config;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;

public class CraftEco
implements Method {
    private Craftconomy CraftCon;

    public Craftconomy getPlugin() {
        return this.CraftCon;
    }

    @Override
    public String getName() {
        return "Craftconomy";
    }

    @Override
    public String getVersion() {
        return "2.3";
    }

    @Override
    public int fractionalDigits() {
        return 2;
    }

    @Override
    public String format(double amount) {
        return Craftconomy.format((double)amount, (Currency)CurrencyHandler.getCurrency((String)Config.currencyDefault, (boolean)true));
    }

    @Override
    public boolean hasBanks() {
        return !BankHandler.listBanks().isEmpty();
    }

    @Override
    public boolean hasBank(String bank) {
        return this.hasBanks() && BankHandler.exists((String)bank);
    }

    @Override
    public boolean hasAccount(String name) {
        return AccountHandler.exists((String)name);
    }

    @Override
    public boolean hasBankAccount(String bank, String name) {
        return this.hasBank(bank) && BankHandler.getBank((String)bank).getOwner() == name;
    }

    @Override
    public boolean createAccount(String name) {
        if (this.hasAccount(name)) {
            return false;
        }
        return AccountHandler.getAccount((String)name) != null;
    }

    @Override
    public boolean createAccount(String name, double balance) {
        if (this.hasAccount(name)) {
            return false;
        }
        if (AccountHandler.getAccount((String)name) == null) {
            return false;
        }
        this.getAccount(name).set(balance);
        return true;
    }

    @Override
    public Method.MethodAccount getAccount(String name) {
        return new CraftAccount(AccountHandler.getAccount((String)name));
    }

    @Override
    public Method.MethodBankAccount getBankAccount(String bank, String name) {
        return new CraftBankAccount(BankHandler.getBank((String)bank));
    }

    @Override
    public boolean isCompatible(Plugin plugin) {
        return plugin.getDescription().getName().equalsIgnoreCase("Craftconomy") && plugin.getClass().getName().equals("me.greatman.Craftconomy.Craftconomy") && plugin instanceof Craftconomy;
    }

    @Override
    public void setPlugin(Plugin plugin) {
        this.CraftCon = (Craftconomy)plugin;
    }

    public class CraftAccount
    implements Method.MethodAccount {
        private Account account;
        private World defaultWorld;

        public CraftAccount(Account account) {
            this.account = account;
            this.defaultWorld = (World)Bukkit.getServer().getWorlds().get(0);
        }

        public Account geCraftAccount() {
            return this.account;
        }

        @Override
        public double balance() {
            return this.account.getBalance(this.defaultWorld);
        }

        @Override
        public double balance(World world) {
            return this.account.getBalance(world);
        }

        @Override
        public boolean set(double amount) {
            return this.set(amount, this.defaultWorld);
        }

        @Override
        public boolean set(double amount, World world) {
            if (this.account == null) {
                return false;
            }
            this.account.setBalance(amount, world);
            return true;
        }

        @Override
        public boolean add(double amount) {
            return this.add(amount, this.defaultWorld);
        }

        @Override
        public boolean add(double amount, World world) {
            if (this.account == null) {
                return false;
            }
            this.account.addMoney(amount, world);
            return true;
        }

        @Override
        public boolean subtract(double amount) {
            return this.subtract(amount, this.defaultWorld);
        }

        @Override
        public boolean subtract(double amount, World world) {
            if (this.account == null) {
                return false;
            }
            this.account.substractMoney(amount, world);
            return true;
        }

        @Override
        public boolean multiply(double amount) {
            return this.multiply(amount, this.defaultWorld);
        }

        @Override
        public boolean multiply(double amount, World world) {
            if (this.account == null) {
                return false;
            }
            this.account.multiplyMoney(amount, world);
            return true;
        }

        @Override
        public boolean divide(double amount) {
            return this.divide(amount, this.defaultWorld);
        }

        @Override
        public boolean divide(double amount, World world) {
            if (this.account == null) {
                return false;
            }
            this.account.divideMoney(amount, world);
            return true;
        }

        @Override
        public boolean hasEnough(double amount) {
            return this.hasEnough(amount, this.defaultWorld);
        }

        @Override
        public boolean hasEnough(double amount, World world) {
            return this.account.hasEnough(amount, world);
        }

        @Override
        public boolean hasOver(double amount) {
            return this.hasOver(amount, this.defaultWorld);
        }

        @Override
        public boolean hasOver(double amount, World world) {
            return this.hasEnough(amount + 0.01, world);
        }

        @Override
        public boolean hasUnder(double amount) {
            return this.hasUnder(amount, this.defaultWorld);
        }

        @Override
        public boolean hasUnder(double amount, World world) {
            return !this.hasEnough(amount, world);
        }

        @Override
        public boolean isNegative() {
            return this.isNegative(this.defaultWorld);
        }

        @Override
        public boolean isNegative(World world) {
            return this.balance(world) < 0.0;
        }

        @Override
        public boolean remove() {
            if (this.account == null) {
                return false;
            }
            return false;
        }
    }

    public class CraftBankAccount
    implements Method.MethodBankAccount {
        private Bank account;
        private World defaultWorld;

        public CraftBankAccount(Bank account) {
            this.account = account;
            this.defaultWorld = (World)Bukkit.getServer().getWorlds().get(0);
        }

        public Bank getCraftBankAccount() {
            return this.account;
        }

        @Override
        public String getBankName() {
            return this.account.getName();
        }

        @Override
        public int getBankId() {
            return this.account.getId();
        }

        @Override
        public double balance() {
            return this.balance(this.defaultWorld);
        }

        @Override
        public double balance(World world) {
            return this.account.getBalance(world);
        }

        @Override
        public boolean set(double amount) {
            return this.set(amount, this.defaultWorld);
        }

        @Override
        public boolean set(double amount, World world) {
            if (this.account == null) {
                return false;
            }
            this.account.setBalance(amount, CurrencyHandler.getCurrency((String)Config.currencyDefault, (boolean)true), world);
            return true;
        }

        @Override
        public boolean add(double amount) {
            return this.add(amount, this.defaultWorld);
        }

        @Override
        public boolean add(double amount, World world) {
            if (this.account == null) {
                return false;
            }
            this.account.addMoney(amount, CurrencyHandler.getCurrency((String)Config.currencyDefault, (boolean)true), world);
            return true;
        }

        @Override
        public boolean subtract(double amount) {
            return this.subtract(amount, this.defaultWorld);
        }

        @Override
        public boolean subtract(double amount, World world) {
            if (this.account == null) {
                return false;
            }
            this.account.substractMoney(amount, CurrencyHandler.getCurrency((String)Config.currencyDefault, (boolean)true), world);
            return true;
        }

        @Override
        public boolean multiply(double amount) {
            return this.multiply(amount, this.defaultWorld);
        }

        @Override
        public boolean multiply(double amount, World world) {
            if (this.account == null) {
                return false;
            }
            this.account.multiplyMoney(amount, CurrencyHandler.getCurrency((String)Config.currencyDefault, (boolean)true), world);
            return true;
        }

        @Override
        public boolean divide(double amount) {
            return this.divide(amount, this.defaultWorld);
        }

        @Override
        public boolean divide(double amount, World world) {
            if (this.account == null) {
                return false;
            }
            this.account.divideMoney(amount, CurrencyHandler.getCurrency((String)Config.currencyDefault, (boolean)true), world);
            return true;
        }

        @Override
        public boolean hasEnough(double amount) {
            return this.hasEnough(amount, this.defaultWorld);
        }

        @Override
        public boolean hasEnough(double amount, World world) {
            return this.account.hasEnough(amount, CurrencyHandler.getCurrency((String)Config.currencyDefault, (boolean)true), world);
        }

        @Override
        public boolean hasOver(double amount) {
            return this.hasOver(amount, this.defaultWorld);
        }

        @Override
        public boolean hasOver(double amount, World world) {
            return this.hasEnough(amount + 0.01, world);
        }

        @Override
        public boolean hasUnder(double amount) {
            return this.hasUnder(amount, this.defaultWorld);
        }

        @Override
        public boolean hasUnder(double amount, World world) {
            return !this.hasEnough(amount, world);
        }

        @Override
        public boolean isNegative() {
            return this.isNegative(this.defaultWorld);
        }

        @Override
        public boolean isNegative(World world) {
            return this.balance(world) < 0.0;
        }

        @Override
        public boolean remove() {
            if (this.account == null) {
                return false;
            }
            return false;
        }
    }
}

