/*
 * Decompiled with CFR 0.152.
 */
package com.nijikokun.register.payment.methods;

import com.nijikokun.register.payment.Method;
import me.ic3d.eco.ECO;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;

public class ECO3
implements Method {
    private ECO eco;

    @Override
    public Object getPlugin() {
        return this.eco;
    }

    @Override
    public String getName() {
        return "3co";
    }

    @Override
    public String getVersion() {
        return "2.0";
    }

    @Override
    public int fractionalDigits() {
        return 0;
    }

    @Override
    public String format(double amount) {
        return String.valueOf((int)Math.ceil(amount)) + " " + (amount == 1.0 ? this.eco.singularCurrency : this.eco.pluralCurrency);
    }

    @Override
    public boolean hasBanks() {
        return false;
    }

    @Override
    public boolean hasBank(String bank) {
        return false;
    }

    @Override
    public boolean hasAccount(String name) {
        return this.eco.hasAccount(name);
    }

    @Override
    public boolean hasBankAccount(String bank, String name) {
        return false;
    }

    @Override
    public boolean createAccount(String name) {
        if (this.hasAccount(name)) {
            return false;
        }
        this.eco.createAccount(name, Integer.valueOf(0));
        return true;
    }

    @Override
    public boolean createAccount(String name, double balance) {
        if (this.hasAccount(name)) {
            return false;
        }
        this.eco.createAccount(name, Integer.valueOf((int)balance));
        return true;
    }

    @Override
    public Method.MethodAccount getAccount(String name) {
        if (!this.hasAccount(name)) {
            this.createAccount(name);
        }
        return new ECO3Account(name);
    }

    @Override
    public Method.MethodBankAccount getBankAccount(String bank, String name) {
        return null;
    }

    @Override
    public boolean isCompatible(Plugin plugin) {
        return plugin.getDescription().getName().equals("3co") && plugin.getClass().getName().equals("me.ic3d.eco.ECO") && plugin instanceof ECO;
    }

    @Override
    public void setPlugin(Plugin plugin) {
        this.eco = (ECO)plugin;
    }

    public class ECO3Account
    implements Method.MethodAccount {
        private String name;

        public ECO3Account(String name) {
            this.name = name;
        }

        @Override
        public double balance() {
            return ECO3.this.eco.getMoney(this.name).intValue();
        }

        @Override
        public boolean set(double amount) {
            ECO3.this.eco.setMoney(this.name, Integer.valueOf((int)Math.ceil(amount)));
            return true;
        }

        @Override
        public boolean add(double amount) {
            this.set(this.balance() + amount);
            return true;
        }

        @Override
        public boolean subtract(double amount) {
            this.set(this.balance() - amount);
            return true;
        }

        @Override
        public boolean multiply(double amount) {
            this.set(this.balance() * amount);
            return true;
        }

        @Override
        public boolean divide(double amount) {
            this.set(this.balance() / amount);
            return true;
        }

        @Override
        public boolean hasEnough(double amount) {
            return ECO3.this.eco.hasEnough(this.name, Integer.valueOf((int)Math.ceil(amount)));
        }

        @Override
        public boolean hasOver(double amount) {
            return this.balance() > amount;
        }

        @Override
        public boolean hasUnder(double amount) {
            return this.balance() < amount;
        }

        @Override
        public boolean isNegative() {
            return this.balance() < 0.0;
        }

        @Override
        public boolean remove() {
            return false;
        }

        @Override
        public double balance(World world) {
            return this.balance();
        }

        @Override
        public boolean set(double amount, World world) {
            return this.set(amount);
        }

        @Override
        public boolean add(double amount, World world) {
            return this.add(amount);
        }

        @Override
        public boolean subtract(double amount, World world) {
            return this.subtract(amount);
        }

        @Override
        public boolean multiply(double amount, World world) {
            return this.multiply(amount);
        }

        @Override
        public boolean divide(double amount, World world) {
            return this.divide(amount);
        }

        @Override
        public boolean hasEnough(double amount, World world) {
            return this.hasEnough(amount);
        }

        @Override
        public boolean hasOver(double amount, World world) {
            return this.hasOver(amount);
        }

        @Override
        public boolean hasUnder(double amount, World world) {
            return this.hasUnder(amount);
        }

        @Override
        public boolean isNegative(World world) {
            return this.isNegative();
        }
    }
}

