/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.commandbook.bans;

import com.sk89q.commandbook.CommandBook;
import com.sk89q.commandbook.bans.Ban;
import com.sk89q.commandbook.bans.BanDatabase;
import com.sk89q.commandbook.bans.BansComponent;
import com.sk89q.commandbook.util.PlayerUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class FlatFileBanDatabase
implements BanDatabase {
    protected final Logger auditLogger = Logger.getLogger("Minecraft.CommandBook.Bans");
    protected final BansComponent component;
    protected final File dataDirectory;
    protected final File namesFile;
    protected Map<String, Ban> bannedNames;

    public static boolean toImport(File dataDirectory) {
        return new File(dataDirectory, "banned_names.txt").exists();
    }

    public FlatFileBanDatabase(File dataDirectory, BansComponent component) {
        this.dataDirectory = dataDirectory;
        this.component = component;
        this.namesFile = new File(dataDirectory, "banned_names.txt");
        try {
            FileHandler handler = new FileHandler(new File(dataDirectory, "bans.%g.%u.log").getAbsolutePath().replace("\\", "/"), true);
            handler.setFormatter(new Formatter(){
                private final SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");

                @Override
                public String format(LogRecord record) {
                    return "[" + this.dateFormat.format(new Date()) + "] " + record.getMessage() + "\r\n";
                }
            });
            this.auditLogger.addHandler(handler);
        }
        catch (SecurityException e) {
            CommandBook.logger().warning("Failed to setup audit log for the flat file ban database: " + e.getMessage());
        }
        catch (IOException e) {
            CommandBook.logger().warning("Failed to setup audit log for the flat file ban database: " + e.getMessage());
        }
    }

    @Override
    public synchronized boolean load() {
        boolean successful = true;
        try {
            this.bannedNames = this.readLowercaseList(this.namesFile);
            CommandBook.logger().info(this.bannedNames.size() + " banned name(s) loaded.");
        }
        catch (IOException e) {
            this.bannedNames = new HashMap<String, Ban>();
            CommandBook.logger().warning("Failed to load " + this.namesFile.getAbsolutePath() + ": " + e.getMessage());
            successful = false;
        }
        return successful;
    }

    @Override
    public synchronized boolean unload() {
        for (Handler handler : this.auditLogger.getHandlers()) {
            if (!(handler instanceof FileHandler)) continue;
            handler.flush();
            handler.close();
            this.auditLogger.removeHandler(handler);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized Map<String, Ban> readLowercaseList(File file) throws IOException {
        FileInputStream input = null;
        HashMap<String, Ban> list = new HashMap<String, Ban>();
        try {
            String line;
            input = new FileInputStream(file);
            InputStreamReader streamReader = new InputStreamReader((InputStream)input, "utf-8");
            BufferedReader reader = new BufferedReader(streamReader);
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).length() <= 0) continue;
                list.put(line.toLowerCase().trim(), new Ban(line.toLowerCase().trim(), null, null, System.currentTimeMillis(), 0L));
            }
        }
        catch (FileNotFoundException ignored) {
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException ignored) {}
            }
        }
        return list;
    }

    @Override
    public synchronized boolean save() {
        boolean successful = true;
        try {
            this.writeList(this.namesFile, this.bannedNames);
        }
        catch (IOException e) {
            CommandBook.logger().warning("Failed to write " + this.namesFile.getAbsolutePath() + ": " + e.getMessage());
            successful = false;
        }
        return successful;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void writeList(File file, Map<String, Ban> list) throws IOException {
        FileOutputStream output = null;
        try {
            output = new FileOutputStream(file);
            OutputStreamWriter streamWriter = new OutputStreamWriter((OutputStream)output, "utf-8");
            BufferedWriter writer = new BufferedWriter(streamWriter);
            for (String line : list.keySet()) {
                writer.write(line + "\r\n");
            }
            writer.close();
        }
        catch (FileNotFoundException ignore) {
        }
        catch (UnsupportedEncodingException e) {
            CommandBook.logger().log(Level.WARNING, "Failed to write list", e);
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    @Override
    public synchronized boolean isBannedName(String name) {
        return this.bannedNames.containsKey(name.toLowerCase().trim());
    }

    @Override
    public synchronized boolean isBannedAddress(InetAddress address) {
        return false;
    }

    @Override
    public String getBannedNameMesage(String name) {
        return this.getBannedNameMessage(name);
    }

    @Override
    public String getBannedNameMessage(String name) {
        return "You have been banned";
    }

    @Override
    public String getBannedAddressMessage(String address) {
        return "You have been banned";
    }

    @Override
    public synchronized void banName(String name, CommandSender source, String reason) {
        this.auditLogger.info(String.format("BAN: %s (%s) banned name '%s': %s", PlayerUtil.toUniqueName(source), CommandBook.inst().toInetAddressString(source), name, reason));
        this.bannedNames.put(name, new Ban(name.toLowerCase(), null, null, System.currentTimeMillis(), 0L));
    }

    @Override
    public synchronized void banAddress(String address, CommandSender source, String reason) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public void ban(Player player, CommandSender source, String reason, long end) {
        this.banName(player.getName(), source, reason);
    }

    @Override
    public void ban(String name, String address, CommandSender source, String reason, long end) {
        this.banName(name, source, reason);
    }

    @Override
    public boolean unbanName(String name, CommandSender source, String reason) {
        boolean removed;
        boolean bl = removed = this.bannedNames.remove(name.toLowerCase()) != null;
        if (removed) {
            this.auditLogger.info(String.format("UNBAN: %s (%s) unbanned name '%s': %s", PlayerUtil.toUniqueName(source), CommandBook.inst().toInetAddressString(source), name, reason));
        }
        return removed;
    }

    @Override
    public boolean unbanAddress(String address, CommandSender source, String reason) {
        return false;
    }

    @Override
    public boolean unban(String name, String address, CommandSender source, String reason) {
        return this.unbanName(name, source, reason);
    }

    @Override
    public void logKick(Player player, CommandSender source, String reason) {
        this.auditLogger.info(String.format("KICKED: %s (%s) kicked player '%s': %s", PlayerUtil.toUniqueName(source), CommandBook.inst().toInetAddressString(source), player.getName(), reason));
    }

    @Override
    public void importFrom(BanDatabase bans) {
        throw new UnsupportedOperationException("Importing to legacy ban storage provider not supported.");
    }

    @Override
    public Ban getBannedName(String name) {
        return this.bannedNames.get(name);
    }

    @Override
    public Ban getBannedAddress(String address) {
        return null;
    }

    @Override
    public Iterator<Ban> iterator() {
        return this.bannedNames.values().iterator();
    }
}

