/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.commandbook.util;

import com.sk89q.commandbook.util.PlayerIteratorAction;
import com.sk89q.commandbook.util.PlayerUtil;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TeleportPlayerIterator
extends PlayerIteratorAction {
    protected final Location loc;
    protected Location oldLoc;
    protected final boolean silent;

    public TeleportPlayerIterator(CommandSender sender, Location loc) {
        this(sender, loc, false);
    }

    public TeleportPlayerIterator(CommandSender sender, Location loc, boolean silent) {
        super(sender);
        this.loc = loc;
        this.silent = silent;
    }

    @Override
    public void perform(Player player) {
        this.oldLoc = player.getLocation();
        this.loc.getChunk().load(true);
        player.teleport(this.loc);
    }

    @Override
    public void onCaller(Player player) {
        player.sendMessage(ChatColor.YELLOW + "Teleported.");
    }

    @Override
    public void onVictim(CommandSender sender, Player player) {
        if (this.silent) {
            return;
        }
        if (this.oldLoc.getWorld().equals(this.loc.getWorld())) {
            player.sendMessage(ChatColor.YELLOW + "You've been teleported by " + PlayerUtil.toColoredName(sender, ChatColor.YELLOW) + ".");
        } else {
            player.sendMessage(ChatColor.YELLOW + "You've been teleported by " + PlayerUtil.toColoredName(sender, ChatColor.YELLOW) + " to world '" + this.loc.getWorld().getName() + "'.");
        }
    }

    @Override
    public void onInformMany(CommandSender sender, int affected) {
        sender.sendMessage(ChatColor.YELLOW.toString() + affected + " teleported.");
    }
}

