/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.util.ArrayList;
import java.util.List;
import org.h2.command.Prepared;
import org.h2.command.ddl.SchemaCommand;
import org.h2.command.dml.Query;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.Session;
import org.h2.expression.Parameter;
import org.h2.message.DbException;
import org.h2.schema.Schema;
import org.h2.table.Table;
import org.h2.table.TableView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateView
extends SchemaCommand {
    private Query select;
    private String viewName;
    private boolean ifNotExists;
    private String selectSQL;
    private String[] columnNames;
    private String comment;
    private boolean orReplace;
    private boolean force;

    public CreateView(Session session, Schema schema) {
        super(session, schema);
    }

    public void setViewName(String string) {
        this.viewName = string;
    }

    public void setSelect(Query query) {
        this.select = query;
    }

    public void setIfNotExists(boolean bl) {
        this.ifNotExists = bl;
    }

    public void setSelectSQL(String string) {
        this.selectSQL = string;
    }

    public void setColumnNames(String[] stringArray) {
        this.columnNames = stringArray;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public void setOrReplace(boolean bl) {
        this.orReplace = bl;
    }

    public void setForce(boolean bl) {
        this.force = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int update() {
        TableView tableView;
        ArrayList<Parameter> arrayList;
        String string;
        this.session.commit(true);
        Database database = this.session.getDatabase();
        Table table = this.getSchema().findTableOrView(this.session, this.viewName);
        ArrayList<DependentView> arrayList2 = new ArrayList<DependentView>();
        if (table != null) {
            if (this.ifNotExists) {
                return 0;
            }
            if (this.orReplace && table.getTableType().equals("VIEW")) {
                database.renameSchemaObject(this.session, table, database.getTempTableName(this.session));
                this.loadDependentViewSql(table, arrayList2);
            } else {
                throw DbException.get(90038, this.viewName);
            }
        }
        int n = this.getObjectId();
        if (this.select == null) {
            string = this.selectSQL;
        } else {
            arrayList = this.select.getParameters();
            if (arrayList != null && arrayList.size() > 0) {
                throw DbException.get(50100, "parameters in views");
            }
            string = this.select.getPlanSQL();
        }
        arrayList = database.getSystemSession();
        try {
            Schema schema = this.session.getDatabase().getSchema(this.session.getCurrentSchemaName());
            ((Session)((Object)arrayList)).setCurrentSchema(schema);
            tableView = new TableView(this.getSchema(), n, this.viewName, string, null, this.columnNames, (Session)((Object)arrayList), false);
        }
        finally {
            ((Session)((Object)arrayList)).setCurrentSchema(database.getSchema("PUBLIC"));
        }
        tableView.setComment(this.comment);
        try {
            tableView.recompileQuery(this.session);
        }
        catch (DbException dbException) {
            // empty catch block
        }
        database.addSchemaObject(this.session, tableView);
        if (table != null) {
            this.recreateDependentViews(database, table, arrayList2, tableView);
        }
        return 0;
    }

    private void recreateDependentViews(Database database, Table table, List<DependentView> list, TableView tableView) {
        String string = null;
        try {
            for (DependentView dependentView : list) {
                string = dependentView.viewName;
                if (this.force) {
                    this.execute(dependentView.createForceSql, true);
                    continue;
                }
                this.execute(dependentView.createSql, true);
            }
            database.removeSchemaObject(this.session, table);
        }
        catch (DbException dbException) {
            database.removeSchemaObject(this.session, tableView);
            database.renameSchemaObject(this.session, table, this.viewName);
            for (DependentView dependentView : list) {
                this.execute(dependentView.createForceSql, true);
            }
            throw DbException.get(90107, dbException, table.getName(), string);
        }
    }

    private void loadDependentViewSql(DbObject dbObject, List<DependentView> list) {
        for (DbObject dbObject2 : dbObject.getChildren()) {
            if (!(dbObject2 instanceof TableView)) continue;
            list.add(new DependentView((TableView)dbObject2));
            this.loadDependentViewSql(dbObject2, list);
        }
    }

    private void execute(String string, boolean bl) {
        Prepared prepared = this.session.prepare(string);
        prepared.update();
        if (bl) {
            this.session.commit(true);
        }
    }

    @Override
    public int getType() {
        return 34;
    }

    private static class DependentView {
        String viewName;
        String createSql;
        String createForceSql;

        DependentView(TableView tableView) {
            this.viewName = tableView.getName();
            this.createSql = tableView.getCreateSQL(true, false);
            this.createForceSql = tableView.getCreateSQL(true, true);
        }
    }
}

