/*
 * Decompiled with CFR 0.152.
 */
package lib.PatPeter.SQLibrary;

import java.io.File;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Logger;
import lib.PatPeter.SQLibrary.Database;

public class SQLite
extends Database {
    public String location;
    public String name;
    private File sqlFile;

    public SQLite(Logger log, String prefix, String name, String location) {
        super(log, prefix, "[SQLite] ");
        this.name = name;
        this.location = location;
        File folder = new File(this.location);
        if (this.name.contains("/") || this.name.contains("\\") || this.name.endsWith(".db")) {
            this.writeError("The database name can not contain: /, \\, or .db", true);
        }
        if (!folder.exists()) {
            folder.mkdir();
        }
        this.sqlFile = new File(String.valueOf(folder.getAbsolutePath()) + File.separator + name + ".db");
    }

    @Override
    protected boolean initialize() {
        try {
            Class.forName("org.sqlite.JDBC");
            return true;
        }
        catch (ClassNotFoundException e) {
            this.writeError("You need the SQLite library " + e, true);
            return false;
        }
    }

    @Override
    public Connection open() {
        if (this.initialize()) {
            try {
                this.connection = DriverManager.getConnection("jdbc:sqlite:" + this.sqlFile.getAbsolutePath());
                return this.connection;
            }
            catch (SQLException e) {
                this.writeError("SQLite exception on initialize " + e, true);
            }
        }
        return null;
    }

    @Override
    public void close() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException ex) {
                this.writeError("Error on Connection close: " + ex, true);
            }
        }
    }

    @Override
    public Connection getConnection() {
        if (this.connection == null) {
            return this.open();
        }
        return this.connection;
    }

    @Override
    public boolean checkConnection() {
        return this.connection != null;
    }

    @Override
    public ResultSet query(String query) {
        Statement statement = null;
        ResultSet result = null;
        try {
            this.connection = this.open();
            statement = this.connection.createStatement();
            switch (this.getStatement(query)) {
                case SELECT: {
                    result = statement.executeQuery(query);
                    return result;
                }
            }
            statement.executeQuery(query);
            return result;
        }
        catch (SQLException ex) {
            if (ex.getMessage().toLowerCase().contains("locking") || ex.getMessage().toLowerCase().contains("locked")) {
                return this.retry(query);
            }
            this.writeError("Error at SQL Query: " + ex.getMessage(), false);
            return null;
        }
    }

    @Override
    PreparedStatement prepare(String query) {
        try {
            this.connection = this.open();
            PreparedStatement ps = this.connection.prepareStatement(query);
            return ps;
        }
        catch (SQLException e) {
            if (!e.toString().contains("not return ResultSet")) {
                this.writeError("Error in SQL prepare() query: " + e.getMessage(), false);
            }
            return null;
        }
    }

    @Override
    public boolean createTable(String query) {
        Statement statement;
        block3: {
            statement = null;
            try {
                if (!query.equals("") && query != null) break block3;
                this.writeError("SQL Create Table query empty.", true);
                return false;
            }
            catch (SQLException ex) {
                this.writeError(ex.getMessage(), true);
                return false;
            }
        }
        statement = this.connection.createStatement();
        statement.execute(query);
        return true;
    }

    @Override
    public boolean checkTable(String table) {
        DatabaseMetaData dbm = null;
        try {
            dbm = this.open().getMetaData();
            ResultSet tables = dbm.getTables(null, null, table, null);
            return tables.next();
        }
        catch (SQLException e) {
            this.writeError("Failed to check if table \"" + table + "\" exists: " + e.getMessage(), true);
            return false;
        }
    }

    @Override
    public boolean wipeTable(String table) {
        String query;
        Statement statement;
        block4: {
            statement = null;
            query = null;
            try {
                if (this.checkTable(table)) break block4;
                this.writeError("Error at Wipe Table: table, " + table + ", does not exist", true);
                return false;
            }
            catch (SQLException ex) {
                if (!(ex.getMessage().toLowerCase().contains("locking") || ex.getMessage().toLowerCase().contains("locked") || ex.toString().contains("not return ResultSet"))) {
                    this.writeError("Error at SQL Wipe Table Query: " + ex, false);
                }
                return false;
            }
        }
        statement = this.connection.createStatement();
        query = "DELETE FROM " + table + ";";
        statement.executeQuery(query);
        return true;
    }

    public ResultSet retry(String query) {
        Statement statement = null;
        ResultSet result = null;
        try {
            statement = this.connection.createStatement();
            result = statement.executeQuery(query);
            return result;
        }
        catch (SQLException ex) {
            if (ex.getMessage().toLowerCase().contains("locking") || ex.getMessage().toLowerCase().contains("locked")) {
                this.writeError("Please close your previous ResultSet to run the query: \n" + query, false);
            } else {
                this.writeError("Error in SQL query: " + ex.getMessage(), false);
            }
            return null;
        }
    }
}

