/*
 * Decompiled with CFR 0.152.
 */
package me.ksafin.DynamicEconomy;

import couk.Adamki11s.Extras.Colour.ExtrasColour;
import couk.Adamki11s.Extras.Inventory.ExtrasInventory;
import java.io.File;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Logger;
import me.ksafin.DynamicEconomy.DynamicEconomy;
import me.ksafin.DynamicEconomy.DynamicShop;
import me.ksafin.DynamicEconomy.EnderEngine;
import me.ksafin.DynamicEconomy.Item;
import me.ksafin.DynamicEconomy.Messages;
import me.ksafin.DynamicEconomy.Utility;
import me.ksafin.DynamicEconomy.dataSigns;
import me.ksafin.DynamicEconomy.regionUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class Transaction
implements Runnable {
    private static ExtrasColour color = new ExtrasColour();
    private static ExtrasInventory inv = new ExtrasInventory();
    private static Logger log = Logger.getLogger("Minecraft");
    public static FileConfiguration regionConfigFile;
    static NumberFormat f;
    public static DecimalFormat decFormat;
    public static DecimalFormat changeFormat;

    static {
        f = NumberFormat.getNumberInstance(Locale.US);
        decFormat = (DecimalFormat)f;
        changeFormat = (DecimalFormat)f;
    }

    public static boolean buy(Player player, String[] args) {
        String bannedItem;
        String stringPlay = player.getName();
        if (args.length == 0 || args.length > 2) {
            color.sendColouredMessage(player, String.valueOf(DynamicEconomy.prefix) + "&2Wrong Command Usage. &f/buy [Item] (Amount)");
            Utility.writeToLog(String.valueOf(stringPlay) + " incorrectly called /buy");
            return false;
        }
        boolean withinRegion = true;
        double tax = DynamicEconomy.purchasetax;
        String[] itemInfo = new String[7];
        try {
            itemInfo = Item.getAllInfo(args[0]);
        }
        catch (Exception e) {
            color.sendColouredMessage(player, String.valueOf(DynamicEconomy.prefix) + "&2You entered the command arguments in the wrong order, or your item name was invalid ");
            Utility.writeToLog(String.valueOf(stringPlay) + " entered an invalid item, or entered command arguments in the wrong order");
            return false;
        }
        String itemName = itemInfo[0];
        double itemPrice = Double.parseDouble(itemInfo[1]);
        int itemStock = Integer.parseInt(itemInfo[5]);
        long itemID = Long.parseLong(itemInfo[6]);
        if (itemID >= 2500L && itemID < 2600L) {
            color.sendColouredMessage(player, String.valueOf(DynamicEconomy.prefix) + "&f" + itemName + "&2 is an enchantment. Use &f/buyenchantment&2 to buy it.");
            Utility.writeToLog(String.valueOf(stringPlay) + "tried to buy the enchantment " + itemName + " via /buy instead of /buyenchantment.");
            return false;
        }
        if (DynamicEconomy.useRegions) {
            int z;
            int y;
            Location loc = player.getLocation();
            int x = loc.getBlockX();
            withinRegion = regionUtils.withinRegion(x, y = loc.getBlockY(), z = loc.getBlockZ());
            if (!withinRegion) {
                color.sendColouredMessage(player, String.valueOf(DynamicEconomy.prefix) + Messages.notWithinRegion);
                Utility.writeToLog(String.valueOf(stringPlay) + " called /buy outside of an economy region.");
                return false;
            }
            if (DynamicEconomy.useRegionFlags) {
                List allowedGroups;
                boolean inRegion;
                String reg = regionUtils.getRegion(x, y, z);
                String node = "regions." + reg + ".flags";
                tax = DynamicEconomy.regionConfig.getDouble(String.valueOf(node) + ".purchasetax");
                String[] regionBannedItems = DynamicEconomy.regionConfig.getString(String.valueOf(node) + ".banned-purchase-items", "").split(",");
                int i = 0;
                while (i < regionBannedItems.length) {
                    bannedItem = Item.getTrueName(regionBannedItems[i]);
                    if (bannedItem.equals(itemName)) {
                        color.sendColouredMessage(player, String.valueOf(DynamicEconomy.prefix) + Messages.bannedInRegion);
                        Utility.writeToLog(String.valueOf(stringPlay) + " attempted to buy the banned item: " + bannedItem);
                        return false;
                    }
                    ++i;
                }
                if (DynamicEconomy.groupControl && !(inRegion = Item.isItemInRegionGroup(allowedGroups = DynamicEconomy.regionConfig.getStringList(String.valueOf(node) + ".allowed-purchase-groups"), itemName))) {
                    color.sendColouredMessage(player, String.valueOf(DynamicEconomy.prefix) + "&2You cannot buy &f" + itemName + "&2 in this region.");
                    Utility.writeToLog(String.valueOf(stringPlay) + " attempted to buy " + itemName + " in region " + reg + ", but it's not in any allowed item groups.");
                    return false;
                }
            }
        }
        if (itemName.equals("")) {
            color.sendColouredMessage(player, String.valueOf(DynamicEconomy.prefix) + Messages.itemDoesntExist);
            Utility.writeToLog(String.valueOf(stringPlay) + " attempted to buy the non-existent item '" + itemName + "'");
            return false;
        }
        int x = 0;
        while (x < DynamicEconomy.bannedPurchaseItems.length) {
            bannedItem = Item.getTrueName(DynamicEconomy.bannedPurchaseItems[x]);
            if (bannedItem.equals(itemName)) {
                color.sendColouredMessage(player, String.valueOf(DynamicEconomy.prefix) + Messages.bannedItem);
                Utility.writeToLog(String.valueOf(stringPlay) + " attempted to buy the banned item: " + bannedItem);
                return false;
            }
            ++x;
        }
        if (DynamicEconomy.groupControl && !Item.canBuy(player, itemName)) {
            color.sendColouredMessage(player, String.valueOf(DynamicEconomy.prefix) + "&2You are not permitted to purchase &f" + itemName);
            Utility.writeToLog(String.valueOf(stringPlay) + " tried to purchase " + itemName + " but was denied access.");
            return false;
        }
        int purchaseAmount = 0;
        if (args.length == 1) {
            purchaseAmount = DynamicEconomy.defaultAmount;
        } else if (args.length == 2) {
            if (args[1].equalsIgnoreCase("all")) {
                purchaseAmount = itemStock;
            } else {
                try {
                    purchaseAmount = Integer.parseInt(args[1]);
                }
                catch (Exception e) {
                    color.sendColouredMessage(player, String.valueOf(DynamicEconomy.prefix) + Messages.invalidCommandArgs);
                    Utility.writeToLog(String.valueOf(stringPlay) + " entered an invalid purchase amount, or entered command arguments in the wrong order.");
                    return false;
                }
            }
        }
        int emptySlotAmount = inv.getEmptySlots(player);
        int reqSlot = 0;
        reqSlot = itemID >= 256L && itemID <= 258L || itemID >= 267L && itemID <= 279L || itemID >= 298L && itemID <= 317L || itemID >= 283L && itemID <= 286L || itemID >= 290L && itemID <= 294L ? purchaseAmount : (int)((double)purchaseAmount / 64.0 + 0.99);
        if (reqSlot > emptySlotAmount) {
            color.sendColouredMessage(player, String.valueOf(DynamicEconomy.prefix) + "&2You need &f" + reqSlot + "&2 empty slots, but have &f" + emptySlotAmount);
            Utility.writeToLog(String.valueOf(stringPlay) + " attempted to buy " + purchaseAmount + " of '" + itemName + "', but didn't have enough space.");
            return false;
        }
        if (purchaseAmount <= 0) {
            color.sendColouredMessage(player, String.valueOf(DynamicEconomy.prefix) + Messages.negativeBuyAmount);
            Utility.writeToLog(String.valueOf(stringPlay) + " attempted to buy " + purchaseAmount + " of '" + itemName + "', but this amount is invalid.");
            return false;
        }
        double balance = DynamicEconomy.economy.getBalance(player.getName());
        if (itemStock < purchaseAmount) {
            color.sendColouredMessage(player, String.valueOf(DynamicEconomy.prefix) + Messages.notEnoughStock);
            color.sendColouredMessage(player, String.valueOf(DynamicEconomy.prefix) + "&2Your request: &f" + decFormat.format(purchaseAmount) + "   &2Current Stock: &f" + itemStock);
            Utility.writeToLog(String.valueOf(stringPlay) + " attempted to buy " + decFormat.format(purchaseAmount) + " of '" + itemName + "' but there was only " + itemStock + " remaining");
            return false;
        }
        EnderEngine engine = new EnderEngine(itemInfo);
        double totalCost = engine.getCost(purchaseAmount);
        double newPrice = engine.getPrice();
        int newStock = engine.getStock();
        engine.setBuyTime();
        double change = newPrice - itemPrice;
        int changeStock = 0;
        changeStock = newStock - itemStock;
        double percentTax = tax * 100.0;
        tax *= totalCost;
        totalCost += tax;
        if (DynamicEconomy.depositTax) {
            try {
                if (DynamicEconomy.taxAccountIsBank) {
                    DynamicEconomy.economy.bankDeposit(DynamicEconomy.taxAccount, tax);
                } else {
                    DynamicEconomy.economy.depositPlayer(DynamicEconomy.taxAccount, tax);
                }
            }
            catch (Exception e) {
                log.info("Tax-Account " + DynamicEconomy.taxAccount + " not found.");
                Utility.writeToLog("Attempted to deposit tax of " + DynamicEconomy.currencySymbol + tax + " to account " + DynamicEconomy.taxAccount + " but account not found.");
            }
        }
        decFormat.applyPattern("#.##");
        if (balance < totalCost) {
            color.sendColouredMessage(player, String.valueOf(DynamicEconomy.prefix) + Messages.notEnoughMoney);
            color.sendColouredMessage(player, String.valueOf(DynamicEconomy.prefix) + "&2Your balance: &f" + DynamicEconomy.currencySymbol + decFormat.format(balance) + "   &2Your order total: &f" + DynamicEconomy.currencySymbol + decFormat.format(totalCost));
            Utility.writeToLog(String.valueOf(stringPlay) + " attempted to buy " + decFormat.format(purchaseAmount) + " of '" + itemName + "' for " + decFormat.format(totalCost) + " but could not afford it.");
            return false;
        }
        DynamicEconomy.economy.withdrawPlayer(player.getName(), totalCost);
        color.sendColouredMessage(player, String.valueOf(DynamicEconomy.prefix) + Messages.purchaseSuccess);
        Utility.writeToLog(String.valueOf(stringPlay) + " bought " + purchaseAmount + " of '" + itemName + "' for " + totalCost);
        totalCost = Double.valueOf(decFormat.format(totalCost));
        itemPrice = Double.valueOf(decFormat.format(itemPrice));
        color.sendColouredMessage(player, String.valueOf(DynamicEconomy.prefix) + "&fYou bought " + purchaseAmount + " &2of " + itemName + "&f + " + decFormat.format(percentTax) + "&2% tax = &f" + DynamicEconomy.currencySymbol + totalCost + " &2TOTAL");
        changeFormat.applyPattern("#.#####");
        newPrice = Double.valueOf(decFormat.format(newPrice));
        change = Double.valueOf(changeFormat.format(change));
        if (itemPrice != newPrice) {
            if (DynamicEconomy.globalNotify) {
                Player[] playerArray = Bukkit.getServer().getOnlinePlayers();
                int n = playerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Player p = playerArray[n2];
                    if (!Utility.isQuiet(p) && !p.equals(player)) {
                        color.sendColouredMessage(p, String.valueOf(DynamicEconomy.prefix) + "&2New Price of &f" + itemName + "&2 is &f" + DynamicEconomy.currencySymbol + newPrice + "&2 (+" + change + ")");
                    }
                    ++n2;
                }
            }
            if (DynamicEconomy.localNotify) {
                color.sendColouredMessage(player, String.valueOf(DynamicEconomy.prefix) + "&2New Price of &f" + itemName + "&2 is &f" + DynamicEconomy.currencySymbol + newPrice + "&2 (+" + change + ")");
            }
            Utility.writeToLog(String.valueOf(DynamicEconomy.prefix) + " New price of " + itemName + " changed dynamically to " + newPrice + "(+" + change + ")");
        }
        int mat = 0;
        short dmg = 0;
        boolean data = false;
        if (itemID > 3000L) {
            mat = Transaction.getMat(itemID);
            dmg = Transaction.getDmg(itemID);
            ItemStack items = new ItemStack(mat, purchaseAmount, dmg);
            player.getInventory().addItem(new ItemStack[]{items});
        } else if (itemID == 999L) {
            player.giveExp(purchaseAmount);
        } else if (itemID >= 256L && itemID <= 258L || itemID >= 267L && itemID <= 279L || itemID >= 298L && itemID <= 317L || itemID >= 283L && itemID <= 286L || itemID >= 290L && itemID <= 294L) {
            int x2 = 0;
            while (x2 < purchaseAmount) {
                inv.addToInventory(player, (int)itemID, 1);
                ++x2;
            }
        } else {
            inv.addToInventory(player, (int)itemID, purchaseAmount);
        }
        player.updateInventory();
        engine.updateConfig();
        dataSigns.checkForUpdates(itemName, changeStock, change);
        DynamicShop.updateItem(itemName);
        return true;
    }

    private static int getMat(long itemID) {
        String idStr = String.valueOf(itemID);
        String[] split = idStr.split("00");
        int mat = Integer.parseInt(split[0]);
        return mat;
    }

    private static short getDmg(long itemID) {
        String idStr = String.valueOf(itemID);
        String[] split = idStr.split("00");
        short dmg = Short.parseShort(split[1]);
        return dmg;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean sellInventory(Player player) {
        Transaction.decFormat.setGroupingUsed(false);
        inv = player.getInventory();
        contents = inv.getContents();
        itemInfo = new String[7];
        totalSale = 0.0;
        maxDur = 0.0;
        tax = DynamicEconomy.salestax;
        itemSearchID = "";
        changeStock = 0;
        banned = new ArrayList<String>();
        if (DynamicEconomy.useRegions) {
            loc = player.getLocation();
            x = loc.getBlockX();
            withinRegion = regionUtils.withinRegion(x, y = loc.getBlockY(), z = loc.getBlockZ());
            if (!withinRegion) {
                Transaction.color.sendColouredMessage(player, String.valueOf(DynamicEconomy.prefix) + Messages.notWithinRegion);
                Utility.writeToLog(String.valueOf(player.getName()) + " called /buy outside of an economy region.");
                return false;
            }
            if (DynamicEconomy.useRegionFlags) {
                reg = regionUtils.getRegion(x, y, z);
                node = "regions." + reg + ".flags";
                tax = DynamicEconomy.regionConfig.getDouble(String.valueOf(node) + ".salestax", 0.0);
            }
        }
        x = 0;
        while (x < DynamicEconomy.bannedSaleItems.length) {
            banned.add(DynamicEconomy.bannedSaleItems[x]);
            ++x;
        }
        var37_19 = contents;
        var36_17 = contents.length;
        var35_16 = 0;
        while (var35_16 < var36_17) {
            block17: {
                block18: {
                    item = var37_19[var35_16];
                    if (item == null) break block17;
                    dur = item.getDurability();
                    itemID = item.getTypeId();
                    itemSearchID = dur == 0.0 || itemID >= 256 && itemID <= 258 || itemID >= 267 && itemID <= 279 || itemID >= 298 && itemID <= 317 || itemID >= 283 && itemID <= 286 || itemID >= 290 && itemID <= 294 ? String.valueOf(item.getTypeId()) : String.valueOf(item.getTypeId()) + ":" + (int)dur;
                    itemInfo = Item.getAllInfo(itemSearchID);
                    itemName = itemInfo[0];
                    itemPrice = Double.parseDouble(itemInfo[1]);
                    itemStock = Integer.parseInt(itemInfo[5]);
                    saleAmount = item.getAmount();
                    if (!DynamicEconomy.groupControl || Item.canSell(player, itemName)) break block18;
                    Transaction.color.sendColouredMessage(player, String.valueOf(DynamicEconomy.prefix) + "&2You are not permitted to sell &f" + itemName);
                    Utility.writeToLog(String.valueOf(player.getName()) + " tried to sell " + itemName + " but was denied access.");
                    break block17;
                }
                if (!DynamicEconomy.useRegions) ** GOTO lbl-1000
                loc = player.getLocation();
                x = loc.getBlockX();
                y = loc.getBlockY();
                z = loc.getBlockZ();
                if (!DynamicEconomy.useRegionFlags) ** GOTO lbl-1000
                reg = regionUtils.getRegion(x, y, z);
                node = "regions." + reg + ".flags";
                regionBannedItems = DynamicEconomy.regionConfig.getString(String.valueOf(node) + ".banned-sale-items", "").split(",");
                i = 0;
                while (i < regionBannedItems.length) {
                    bannedItem = Item.getTrueName(regionBannedItems[i]);
                    if (bannedItem.equals(itemName)) {
                        Transaction.color.sendColouredMessage(player, String.valueOf(DynamicEconomy.prefix) + Messages.bannedInRegion);
                        Utility.writeToLog(String.valueOf(player.getName()) + " attempted to sell the banned item: " + bannedItem);
                        break block17;
                    }
                    ++i;
                }
                if (DynamicEconomy.groupControl && !(inRegion = Item.isItemInRegionGroup(allowedGroups = DynamicEconomy.regionConfig.getStringList(String.valueOf(node) + ".allowed-sale-groups"), itemName))) {
                    Transaction.color.sendColouredMessage(player, String.valueOf(DynamicEconomy.prefix) + "&2You cannot sell &f" + itemName + "&2 in this region.");
                    Utility.writeToLog(String.valueOf(player.getName()) + " attempted to sell " + itemName + " in region " + reg + ", but it's not in any allowed item groups.");
                } else if (!banned.contains(itemName)) {
                    newPrice = 0.0;
                    newStock = 0;
                    engine = new EnderEngine(itemInfo);
                    if (itemID >= 256 && itemID <= 258 || itemID >= 267 && itemID <= 279 || itemID >= 298 && itemID <= 317 || itemID >= 283 && itemID <= 286 || itemID >= 290 && itemID <= 294) {
                        engine.incrementStock(1);
                        playerDur = item.getDurability();
                        itemMCname = item.getType().toString();
                        maxDur = Item.getMaxDur(itemMCname);
                        playerDur = maxDur - playerDur;
                        percentDur = playerDur / maxDur;
                        totalSale += engine.getPrice() * percentDur;
                    } else {
                        totalSale += engine.getSale(saleAmount);
                        newPrice = engine.getPrice();
                        newStock = engine.getStock();
                        engine.setSellTime();
                    }
                    engine.updateConfig();
                    change = newPrice - itemPrice;
                    changeStock = newStock - itemStock;
                    dataSigns.checkForUpdates(itemName, changeStock, change);
                    DynamicShop.updateItem(itemName);
                    inv.removeItem(new ItemStack[]{item});
                }
            }
            ++var35_16;
        }
        percentTax = tax * 100.0;
        tax *= totalSale;
        if (DynamicEconomy.depositTax) {
            try {
                if (DynamicEconomy.taxAccountIsBank) {
                    DynamicEconomy.economy.bankDeposit(DynamicEconomy.taxAccount, tax);
                } else {
                    DynamicEconomy.economy.depositPlayer(DynamicEconomy.taxAccount, tax);
                }
            }
            catch (Exception e) {
                Transaction.log.info("Tax-Account " + DynamicEconomy.taxAccount + " not found.");
                Utility.writeToLog("Attempted to deposit tax of " + DynamicEconomy.currencySymbol + tax + " to account " + DynamicEconomy.taxAccount + " but account not found.");
            }
        }
        DynamicEconomy.economy.depositPlayer(player.getName(), totalSale);
        Transaction.color.sendColouredMessage(player, String.valueOf(DynamicEconomy.prefix) + Messages.saleSuccess);
        player.updateInventory();
        totalSale = Double.valueOf(Transaction.decFormat.format(totalSale));
        Transaction.color.sendColouredMessage(player, String.valueOf(DynamicEconomy.prefix) + "&fYou sold&f your inventory &2 - " + Transaction.decFormat.format(percentTax) + "&2% tax = &f" + DynamicEconomy.currencySymbol + (totalSale -= tax) + " &2TOTAL");
        Utility.writeToLog(String.valueOf(DynamicEconomy.prefix) + player.getName() + " sold his entire inventory for " + totalSale);
        return true;
    }

    public static boolean sell(Player player, String[] args) {
        ItemStack saleItem;
        String bannedItem;
        String[] itemInfo;
        String stringPlay;
        block67: {
            ItemStack handItem;
            block68: {
                stringPlay = player.getName();
                if (args.length == 0 || args.length > 2) {
                    color.sendColouredMessage(player, String.valueOf(DynamicEconomy.prefix) + "&2Wrong Command Usage. &f/sell [Item] (Amount)");
                    Utility.writeToLog(String.valueOf(stringPlay) + " incorrectly called /sell");
                    return false;
                }
                if (args[0].equalsIgnoreCase("inventory") && args.length == 1) {
                    Transaction.sellInventory(player);
                    return true;
                }
                itemInfo = new String[7];
                try {
                    if (args.length != 1 || !args[0].equals("hand")) {
                        itemInfo = Item.getAllInfo(args[0]);
                        break block67;
                    }
                    handItem = player.getInventory().getItemInHand();
                    if (handItem.getEnchantments().size() == 0) break block68;
                    color.sendColouredMessage(player, String.valueOf(DynamicEconomy.prefix) + "&2This item is enchanted. Use &f/sellenchantment &2instead");
                    return false;
                }
                catch (Exception e) {
                    color.sendColouredMessage(player, String.valueOf(DynamicEconomy.prefix) + "&2You entered the command arguments in the wrong order, or your item name was invalid ");
                    Utility.writeToLog(String.valueOf(stringPlay) + " entered an invalid item, or entered command arguments in the wrong order");
                    return false;
                }
            }
            short dur = handItem.getDurability();
            int id = handItem.getTypeId();
            String name = "";
            name = dur == 0 ? String.valueOf(id) : String.valueOf(id) + ":" + dur;
            itemInfo = Item.getAllInfo(name);
        }
        String itemName = itemInfo[0];
        double itemPrice = Double.parseDouble(itemInfo[1]);
        int itemStock = Integer.parseInt(itemInfo[5]);
        long itemID = Long.parseLong(itemInfo[6]);
        if (itemID >= 2500L && itemID < 2600L) {
            color.sendColouredMessage(player, String.valueOf(DynamicEconomy.prefix) + "&f" + itemName + "&2 is an enchantment. Use &f/sellenchantment&2 to sell it.");
            Utility.writeToLog(String.valueOf(stringPlay) + "tried to buy the enchantment " + itemName + " via /sell instead of /sellenchantment.");
            return false;
        }
        double tax = DynamicEconomy.salestax;
        if (DynamicEconomy.useRegions) {
            int z;
            int y;
            Location loc = player.getLocation();
            int x = loc.getBlockX();
            boolean withinRegion = regionUtils.withinRegion(x, y = loc.getBlockY(), z = loc.getBlockZ());
            if (!withinRegion) {
                color.sendColouredMessage(player, String.valueOf(DynamicEconomy.prefix) + Messages.notWithinRegion);
                Utility.writeToLog(String.valueOf(stringPlay) + " called /buy outside of an economy region.");
                return false;
            }
            if (DynamicEconomy.useRegionFlags) {
                List allowedGroups;
                boolean inRegion;
                String reg = regionUtils.getRegion(x, y, z);
                String node = "regions." + reg + ".flags";
                tax = DynamicEconomy.regionConfig.getDouble(String.valueOf(node) + ".salestax");
                String[] regionBannedItems = DynamicEconomy.regionConfig.getString(String.valueOf(node) + ".banned-sale-items", "").split(",");
                int i = 0;
                while (i < regionBannedItems.length) {
                    bannedItem = Item.getTrueName(regionBannedItems[i]);
                    if (bannedItem.equals(itemName)) {
                        color.sendColouredMessage(player, String.valueOf(DynamicEconomy.prefix) + Messages.bannedInRegion);
                        Utility.writeToLog(String.valueOf(stringPlay) + " attempted to sell the banned item: " + bannedItem);
                        return false;
                    }
                    ++i;
                }
                if (DynamicEconomy.groupControl && !(inRegion = Item.isItemInRegionGroup(allowedGroups = DynamicEconomy.regionConfig.getStringList(String.valueOf(node) + ".allowed-sale-groups"), itemName))) {
                    color.sendColouredMessage(player, String.valueOf(DynamicEconomy.prefix) + "&2You cannot sell &f" + itemName + "&2 in this region.");
                    Utility.writeToLog(String.valueOf(stringPlay) + " attempted to sell " + itemName + " in region " + reg + ", but it's not in any allowed item groups.");
                    return false;
                }
            }
        }
        if (DynamicEconomy.groupControl && !Item.canSell(player, itemName)) {
            color.sendColouredMessage(player, String.valueOf(DynamicEconomy.prefix) + "&2You are not permitted to sell &f" + itemName);
            Utility.writeToLog(String.valueOf(stringPlay) + " tried to sell " + itemName + " but was denied access.");
            return false;
        }
        if (itemName.equals("")) {
            color.sendColouredMessage(player, String.valueOf(DynamicEconomy.prefix) + Messages.itemDoesntExist);
            Utility.writeToLog(String.valueOf(stringPlay) + " attempted to sell the non-existent item '" + itemName + "'");
            return false;
        }
        int x = 0;
        while (x < DynamicEconomy.bannedSaleItems.length) {
            bannedItem = Item.getTrueName(DynamicEconomy.bannedSaleItems[x]);
            if (bannedItem.equals(itemName)) {
                color.sendColouredMessage(player, String.valueOf(DynamicEconomy.prefix) + Messages.bannedItem);
                Utility.writeToLog(String.valueOf(stringPlay) + " attempted to sell the banned item: " + bannedItem);
                return false;
            }
            ++x;
        }
        int saleAmount = 0;
        boolean isAll = false;
        int mat = 0;
        short dmg = 0;
        boolean data = false;
        int userAmount = 0;
        if (args.length == 1) {
            if (args[0].equals("hand")) {
                saleAmount = player.getInventory().getItemInHand().getAmount();
                if (saleAmount == 0) {
                    color.sendColouredMessage(player, String.valueOf(DynamicEconomy.prefix) + "&2You have no item in your hand.");
                    Utility.writeToLog(String.valueOf(stringPlay) + " called /sell hand, but had no item in hand.");
                    return false;
                }
            } else {
                saleAmount = DynamicEconomy.defaultAmount;
            }
        } else if (args.length == 2) {
            if (args[1].equalsIgnoreCase("all")) {
                if (itemID > 3000L) {
                    mat = Transaction.getMat(itemID);
                    dmg = Transaction.getDmg(itemID);
                    saleItem = new ItemStack(mat, saleAmount, dmg);
                    saleAmount = Transaction.getAmountOfDataValue(player, saleItem);
                } else if (itemID == 999L) {
                    saleAmount = (int)player.getExp();
                } else {
                    saleItem = new ItemStack((int)itemID);
                    saleAmount = Transaction.getQuantity(player, saleItem);
                }
                isAll = true;
            } else {
                try {
                    saleAmount = Integer.parseInt(args[1]);
                }
                catch (Exception e) {
                    color.sendColouredMessage(player, String.valueOf(DynamicEconomy.prefix) + Messages.invalidCommandArgs);
                    Utility.writeToLog(String.valueOf(stringPlay) + " entered an invalid purchase amount, or entered command arguments in the wrong order.");
                    return false;
                }
            }
        }
        if (saleAmount <= 0) {
            color.sendColouredMessage(player, String.valueOf(DynamicEconomy.prefix) + Messages.negativeSellAmount);
            Utility.writeToLog(String.valueOf(stringPlay) + " attempted to sell " + saleAmount + " of '" + itemName + "', but this amount is invalid.");
            return false;
        }
        double balance = DynamicEconomy.economy.getBalance(player.getName());
        EnderEngine engine = new EnderEngine(itemInfo);
        double totalSale = engine.getSale(saleAmount);
        double newPrice = engine.getPrice();
        int newStock = engine.getStock();
        engine.setSellTime();
        double change = newPrice - itemPrice;
        int changeStock = newStock - itemStock;
        if (args[0].equalsIgnoreCase("hand")) {
            userAmount = player.getInventory().getItemInHand().getAmount();
        } else if (itemID > 3000L) {
            mat = Transaction.getMat(itemID);
            dmg = Transaction.getDmg(itemID);
            saleItem = new ItemStack(mat, saleAmount, dmg);
            userAmount = Transaction.getAmountOfDataValue(player, saleItem);
        } else if (itemID == 999L) {
            float percExp1 = player.getExp();
            player.giveExp(1);
            float percExp2 = player.getExp();
            float percUnit = percExp2 - percExp1;
            player.setExp(percExp2 - percUnit);
            int level = player.getLevel();
            int originalLevel = player.getLevel();
            float originalExp = player.getExp();
            float curExp = player.getExp();
            int expcount = 0;
            while (level > 0) {
                if (curExp <= 0.0f) {
                    --level;
                    player.setExp(0.5f);
                    percExp1 = player.getExp();
                    player.giveExp(1);
                    percExp2 = player.getExp();
                    percUnit = percExp2 - percExp1;
                    player.setExp(1.0f);
                    curExp = player.getExp();
                }
                curExp -= percUnit;
                ++expcount;
            }
            player.setLevel(originalLevel);
            player.setExp(originalExp);
            userAmount = expcount;
        } else {
            ItemStack i = new ItemStack((int)itemID);
            userAmount = Transaction.getQuantity(player, i);
        }
        if (isAll && saleAmount <= 0) {
            color.sendColouredMessage(player, String.valueOf(DynamicEconomy.prefix) + "&2You have no &f" + itemName);
            Utility.writeToLog(String.valueOf(stringPlay) + " attempted to sell all of their " + itemName + ", but had none.");
            return false;
        }
        if (saleAmount > userAmount && !isAll) {
            color.sendColouredMessage(player, String.valueOf(DynamicEconomy.prefix) + "&2You do not have &f" + saleAmount + " " + itemName);
            Utility.writeToLog(String.valueOf(stringPlay) + " attempted to sell " + saleAmount + " of " + itemName + ", but didn't have that many.");
            return false;
        }
        double percentTax = tax * 100.0;
        tax *= totalSale;
        totalSale -= tax;
        if (DynamicEconomy.depositTax) {
            try {
                if (DynamicEconomy.taxAccountIsBank) {
                    DynamicEconomy.economy.bankDeposit(DynamicEconomy.taxAccount, tax);
                } else {
                    DynamicEconomy.economy.depositPlayer(DynamicEconomy.taxAccount, tax);
                }
            }
            catch (Exception e) {
                log.info("Tax-Account " + DynamicEconomy.taxAccount + " not found.");
                Utility.writeToLog("Attempted to deposit tax of " + DynamicEconomy.currencySymbol + tax + " to account " + DynamicEconomy.taxAccount + " but account not found.");
            }
        }
        DynamicEconomy.economy.depositPlayer(player.getName(), totalSale);
        color.sendColouredMessage(player, String.valueOf(DynamicEconomy.prefix) + Messages.saleSuccess);
        decFormat.applyPattern("#.##");
        if (itemID >= 256L && itemID <= 258L || itemID >= 267L && itemID <= 279L || itemID >= 298L && itemID <= 317L || itemID >= 283L && itemID <= 286L || itemID >= 290L && itemID <= 294L) {
            ItemStack cs;
            totalSale = 0.0;
            HashMap itemsList = player.getInventory().all((int)itemID);
            ArrayList<Integer> keys = new ArrayList<Integer>();
            for (Integer key : itemsList.keySet()) {
                cs = (ItemStack)itemsList.get(key);
                if (cs.getEnchantments().size() <= 0) continue;
                keys.add(key);
            }
            for (Integer key : keys) {
                itemsList.remove(key);
            }
            int numSold = 0;
            for (Object s : itemsList.values()) {
                if (numSold == saleAmount) break;
                cs = (ItemStack)s;
                ItemStack itemStack = new ItemStack((int)itemID);
                String itemMCname = itemStack.getType().toString();
                double maxDur = Item.getMaxDur(itemMCname);
                double playerDur = cs.getDurability();
                playerDur = maxDur - playerDur;
                double percentDur = playerDur / maxDur;
                totalSale += itemPrice * percentDur;
                double indivsale = itemPrice * percentDur;
                Transaction.removeInventoryItem((Inventory)player.getInventory(), cs);
                itemPrice = Double.valueOf(decFormat.format(itemPrice));
                engine.incrementStock(1);
                percentDur *= 100.0;
                percentDur = Double.valueOf(decFormat.format(percentDur));
                indivsale = Double.valueOf(decFormat.format(indivsale));
                color.sendColouredMessage(player, String.valueOf(DynamicEconomy.prefix) + "&f1 &2" + itemName + "&f with " + percentDur + "% &2durability = &2" + DynamicEconomy.currencySymbol + indivsale);
                Utility.writeToLog(String.valueOf(stringPlay) + " sold a '" + itemName + "' at " + percentDur + "% durability for " + indivsale);
                ++numSold;
            }
            percentTax = tax * 100.0;
            tax = DynamicEconomy.salestax * totalSale;
            totalSale -= tax;
            totalSale = Double.valueOf(decFormat.format(totalSale));
            color.sendColouredMessage(player, String.valueOf(DynamicEconomy.prefix) + "&2TOTAL SALE (with " + decFormat.format(percentTax) + "% tax): &f" + DynamicEconomy.currencySymbol + totalSale);
        } else {
            ItemStack i;
            if (args[0].equalsIgnoreCase("hand")) {
                i = player.getInventory().getItemInHand();
                player.getInventory().removeItem(new ItemStack[]{i});
            } else if (itemID > 3000L) {
                mat = Transaction.getMat(itemID);
                dmg = Transaction.getDmg(itemID);
                i = new ItemStack(mat, saleAmount, dmg);
                player.getInventory().removeItem(new ItemStack[]{i});
            } else if (itemID == 999L) {
                float percExp1 = player.getExp();
                player.giveExp(1);
                float percExp2 = player.getExp();
                float percUnit = percExp2 - percExp1;
                player.setExp(percExp2 - percUnit);
                int level = player.getLevel();
                float curExp = player.getExp();
                int x2 = 0;
                while (x2 < saleAmount) {
                    if (curExp <= 0.0f) {
                        if (--level == 0) {
                            player.setLevel(0);
                            player.setExp(0.0f);
                            break;
                        }
                        player.setExp(0.5f);
                        percExp1 = player.getExp();
                        player.giveExp(1);
                        percExp2 = player.getExp();
                        percUnit = percExp2 - percExp1;
                        player.setExp(1.0f);
                        curExp = player.getExp();
                    }
                    curExp -= percUnit;
                    ++x2;
                }
                player.setLevel(level);
                player.setExp(curExp);
            } else {
                Material material = Material.getMaterial((int)((int)itemID));
                i = new ItemStack(material, saleAmount);
                player.getInventory().removeItem(new ItemStack[]{i});
            }
            player.updateInventory();
            totalSale = Double.valueOf(decFormat.format(totalSale));
            itemPrice = Double.valueOf(decFormat.format(itemPrice));
            newPrice = Double.valueOf(decFormat.format(newPrice));
            color.sendColouredMessage(player, String.valueOf(DynamicEconomy.prefix) + "&fYou sold &2" + saleAmount + "&f of &2" + itemName + "&f - " + decFormat.format(percentTax) + "&2% tax = &f" + DynamicEconomy.currencySymbol + totalSale + " &2TOTAL");
            Utility.writeToLog(String.valueOf(stringPlay) + " succesfully sold " + saleAmount + " of '" + itemName + "' for " + totalSale);
        }
        changeFormat.applyPattern("#.#####");
        newPrice = Double.valueOf(decFormat.format(newPrice));
        change = Double.valueOf(changeFormat.format(change));
        if (itemPrice != newPrice) {
            if (DynamicEconomy.globalNotify) {
                Player[] playerArray = Bukkit.getServer().getOnlinePlayers();
                int n = playerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Player p = playerArray[n2];
                    if (!Utility.isQuiet(p)) {
                        color.sendColouredMessage(p, String.valueOf(DynamicEconomy.prefix) + "&2New Price of &f" + itemName + "&2 is &f" + DynamicEconomy.currencySymbol + newPrice + "&2 (" + change + ")");
                    }
                    ++n2;
                }
            } else if (DynamicEconomy.localNotify) {
                color.sendColouredMessage(player, String.valueOf(DynamicEconomy.prefix) + "&2New Price of &f" + itemName + "&2 is &f" + DynamicEconomy.currencySymbol + newPrice + "&2 (" + change + ")");
            }
            Utility.writeToLog(String.valueOf(DynamicEconomy.prefix) + " New price of " + itemName + " changed dynamically to " + newPrice + "(" + change + ")");
        }
        engine.updateConfig();
        dataSigns.checkForUpdates(itemName, changeStock, change);
        DynamicShop.updateItem(itemName);
        return true;
    }

    public static void removeInventoryItems(Inventory inv, ItemStack s) {
        ItemStack[] itemStackArray = inv.getContents();
        int n = itemStackArray.length;
        int n2 = 0;
        while (n2 < n) {
            ItemStack is = itemStackArray[n2];
            if (is.getType().equals((Object)s.getType()) && is.getEnchantments().size() == s.getEnchantments().size()) {
                inv.removeItem(new ItemStack[]{is});
            }
            ++n2;
        }
    }

    public static void removeInventoryItem(Inventory inv, ItemStack s) {
        ItemStack[] itemStackArray = inv.getContents();
        int n = itemStackArray.length;
        int n2 = 0;
        while (n2 < n) {
            ItemStack is = itemStackArray[n2];
            if (is != null && is.getType().equals((Object)s.getType()) && is.getEnchantments().size() == s.getEnchantments().size()) {
                inv.removeItem(new ItemStack[]{is});
                return;
            }
            ++n2;
        }
    }

    private static int getAmountOfDataValue(Player p, ItemStack m) {
        ItemStack[] invent = p.getInventory().getContents();
        int amount = 0;
        ItemStack[] itemStackArray = invent;
        int n = invent.length;
        int n2 = 0;
        while (n2 < n) {
            ItemStack i = itemStackArray[n2];
            if (i != null && i.getTypeId() == m.getTypeId() && i.getDurability() == m.getDurability()) {
                amount += i.getAmount();
            }
            ++n2;
        }
        return amount;
    }

    public static int getQuantity(Player p, ItemStack item) {
        ItemStack[] invent = p.getInventory().getContents();
        int amount = 0;
        ItemStack[] itemStackArray = invent;
        int n = invent.length;
        int n2 = 0;
        while (n2 < n) {
            ItemStack i = itemStackArray[n2];
            if (i != null && i.getType().equals((Object)item.getType()) && i.getEnchantments().equals(item.getEnchantments()) && i.getDurability() == item.getDurability()) {
                amount += i.getAmount();
            }
            ++n2;
        }
        return amount;
    }

    public static void addStock(Player player, String[] args) {
        String stringPlay = player.getName();
        if (args.length < 2 || args.length > 2) {
            color.sendColouredMessage(player, String.valueOf(DynamicEconomy.prefix) + "&2Wrong Command Usage. &f/addStock [Item] [AdditionalStock]");
            Utility.writeToLog(String.valueOf(stringPlay) + " incorrectly called /addstock");
        } else {
            int addStock = 0;
            try {
                addStock = Integer.parseInt(args[1]);
            }
            catch (Exception e) {
                color.sendColouredMessage(player, String.valueOf(DynamicEconomy.prefix) + "&2You entered a non-integer amount.");
                Utility.writeToLog("Player" + stringPlay + " tried to add a non integer stock amount");
                e.printStackTrace();
            }
            String[] info = Item.getAllInfo(args[0]);
            EnderEngine engine = new EnderEngine(info);
            engine.incrementStock(addStock);
            engine.updateConfig();
            int newStock = engine.getStock();
            int oldStock = Integer.parseInt(info[5]);
            color.sendColouredMessage(player, String.valueOf(DynamicEconomy.prefix) + Messages.stockAdded);
            color.sendColouredMessage(player, String.valueOf(DynamicEconomy.prefix) + "&2Previous Stock: &f" + oldStock + "&2 | New Stock: &f" + newStock);
            Utility.writeToLog(String.valueOf(stringPlay) + " added " + addStock + " stock of " + info[0] + " for a new stock total of " + newStock);
            dataSigns.checkForUpdates(info[0], newStock - oldStock, 0.0);
        }
    }

    public static void removeStock(Player player, String[] args) {
        String stringPlay = player.getName();
        if (args.length < 2 || args.length > 2) {
            color.sendColouredMessage(player, String.valueOf(DynamicEconomy.prefix) + "&2Wrong Command Usage. &f/addStock [Item] [AdditionalStock]");
            Utility.writeToLog(String.valueOf(stringPlay) + " incorrectly called /removestock");
        } else {
            int removeStock = 0;
            try {
                removeStock = Integer.parseInt(args[1]);
            }
            catch (Exception e) {
                color.sendColouredMessage(player, String.valueOf(DynamicEconomy.prefix) + "&2You entered a non-integer amount.");
                Utility.writeToLog("Player" + stringPlay + " tried to remove a non integer stock amount");
                e.printStackTrace();
            }
            String[] info = Item.getAllInfo(args[0]);
            EnderEngine engine = new EnderEngine(info);
            engine.decrementStock(removeStock);
            engine.updateConfig();
            int newStock = engine.getStock();
            int oldStock = Integer.parseInt(info[5]);
            color.sendColouredMessage(player, String.valueOf(DynamicEconomy.prefix) + Messages.stockRemoved);
            color.sendColouredMessage(player, String.valueOf(DynamicEconomy.prefix) + "&2Previous Stock: &f" + oldStock + "&2 | New Stock: &f" + newStock);
            Utility.writeToLog(String.valueOf(stringPlay) + " removed " + removeStock + " stock of " + info[0] + " for a new stock total of " + newStock);
            dataSigns.checkForUpdates(info[0], newStock - oldStock, 0.0);
        }
    }

    public static void curTaxes(Player player, String[] args) {
        String stringPlay = player.getName();
        if (args.length > 0) {
            color.sendColouredMessage(player, String.valueOf(DynamicEconomy.prefix) + "&2Wrong Command Usage. &f/curTaxes");
            Utility.writeToLog(String.valueOf(stringPlay) + " incorrectly called /curTaxes");
        } else {
            color.sendColouredMessage(player, String.valueOf(DynamicEconomy.prefix) + "&fSales Tax: &2" + DynamicEconomy.salestax * 100.0 + "%");
            color.sendColouredMessage(player, String.valueOf(DynamicEconomy.prefix) + "&fPurchase Tax: &2" + DynamicEconomy.purchasetax * 100.0 + "%");
            Utility.writeToLog(String.valueOf(stringPlay) + " called /curtaxes");
        }
    }

    public static void setTaxes(Player player, String[] args) {
        String stringPlay = player.getName();
        if (args.length != 3) {
            color.sendColouredMessage(player, String.valueOf(DynamicEconomy.prefix) + "&2Wrong Command Usage. &f/settax [region] [sale|purchase] [amount]");
            Utility.writeToLog(String.valueOf(stringPlay) + " incorrectly called /settax");
        } else {
            File file;
            FileConfiguration conf;
            String region = args[0].toUpperCase();
            Double tax = 0.0;
            try {
                tax = Double.parseDouble(args[2]);
            }
            catch (Exception e) {
                color.sendColouredMessage(player, String.valueOf(DynamicEconomy.prefix) + "&2 " + args[2] + "&f% is an invalid amount.");
                return;
            }
            if (!args[1].equalsIgnoreCase("sale") && !args[1].equalsIgnoreCase("purchase")) {
                color.sendColouredMessage(player, String.valueOf(DynamicEconomy.prefix) + "&2This is an invalid tax name. Use either &fsale or &fpurchase");
                Utility.writeToLog(String.valueOf(stringPlay) + " tried to set tax '" + args[1] + "', which doesn't exist.");
                return;
            }
            if (region.equalsIgnoreCase("GLOBAL")) {
                if (args[1].equalsIgnoreCase("sale")) {
                    DynamicEconomy.config.set("salestax", (Object)tax);
                } else if (args[1].equalsIgnoreCase("purchase")) {
                    DynamicEconomy.config.set("purchasetax", (Object)tax);
                }
                conf = DynamicEconomy.config;
                file = DynamicEconomy.configFile;
            } else {
                if (!DynamicEconomy.regionConfig.contains("regions." + region)) {
                    color.sendColouredMessage(player, String.valueOf(DynamicEconomy.prefix) + "&2Region &f" + region + "&2 doesn't exist.");
                    Utility.writeToLog(String.valueOf(stringPlay) + " tried to set tax of region '" + region + "', which doesn't exist.");
                    return;
                }
                String node = "regions." + region + ".flags";
                if (args[1].equalsIgnoreCase("sale")) {
                    node = String.valueOf(node) + ".salestax";
                } else if (args[1].equalsIgnoreCase("purchase")) {
                    node = String.valueOf(node) + ".purchasetax";
                }
                DynamicEconomy.regionConfig.set(node, (Object)tax);
                conf = DynamicEconomy.regionConfig;
                file = DynamicEconomy.regionFile;
            }
            try {
                conf.save(file);
            }
            catch (Exception e) {
                log.info("[DynamicEconomy] Error saving config in /settax");
                e.printStackTrace();
            }
            decFormat.applyPattern("###.##");
            color.sendColouredMessage(player, String.valueOf(DynamicEconomy.prefix) + "&2" + args[0] + " " + args[1] + "tax set to &f" + decFormat.format(tax * 100.0) + "%");
            Utility.writeToLog(String.valueOf(stringPlay) + " set " + region + " " + args[1] + "tax to " + decFormat.format(tax * 100.0));
            DynamicEconomy.relConfig();
        }
    }

    public static void buyEnchantment(Player player, String[] args) {
        if (args.length != 2) {
            color.sendColouredMessage(player, String.valueOf(DynamicEconomy.prefix) + "&2Wrong Command Usage. &f/buyEnchantment [Enchantment] [Level]");
            Utility.writeToLog(String.valueOf(player.getName()) + " incorrectly called /buyEnchantment");
        } else {
            String bannedItem;
            String enchantment = args[0].toUpperCase();
            int level = 0;
            if (args[1].equalsIgnoreCase("I")) {
                level = 1;
            } else if (args[1].equalsIgnoreCase("II")) {
                level = 2;
            } else if (args[1].equalsIgnoreCase("III")) {
                level = 3;
            } else if (args[1].equalsIgnoreCase("IV")) {
                level = 4;
            } else if (args[1].equalsIgnoreCase("V")) {
                level = 5;
            } else {
                try {
                    level = Integer.parseInt(args[1]);
                }
                catch (NumberFormatException e) {
                    color.sendColouredMessage(player, String.valueOf(DynamicEconomy.prefix) + "&f" + args[1] + "&2 is not a valid enchantment level. Use 1-5 or I-V.");
                    Utility.writeToLog(String.valueOf(player.getName()) + " called /buyenchantment with invalid level " + args[1]);
                    return;
                }
            }
            if (!DynamicEconomy.itemConfig.contains(enchantment)) {
                color.sendColouredMessage(player, String.valueOf(DynamicEconomy.prefix) + "&f" + enchantment + "&2 is not a valid enchantment.");
                Utility.writeToLog(String.valueOf(player.getName()) + " called /buyenchantment with invalid enchantment " + enchantment);
                return;
            }
            String[] enchantmentInfo = Item.getAllInfo(enchantment);
            int id = Integer.parseInt(enchantmentInfo[6]);
            int stock = Integer.parseInt(enchantmentInfo[5]);
            double itemPrice = Double.parseDouble(enchantmentInfo[1]);
            int enchantmentID = id % 2500;
            Enchantment enchant = Enchantment.getById((int)enchantmentID);
            int maxLevel = enchant.getMaxLevel();
            if (level > maxLevel) {
                color.sendColouredMessage(player, String.valueOf(DynamicEconomy.prefix) + "&fThe maximum level for this enchantment is &f" + maxLevel);
                Utility.writeToLog(String.valueOf(player.getName()) + " called /buyenchantment with a level above the maximum for " + enchantment);
                return;
            }
            double tax = DynamicEconomy.purchasetax;
            if (DynamicEconomy.useRegions) {
                int z;
                int y;
                Location loc = player.getLocation();
                int x = loc.getBlockX();
                boolean withinRegion = regionUtils.withinRegion(x, y = loc.getBlockY(), z = loc.getBlockZ());
                if (!withinRegion) {
                    color.sendColouredMessage(player, String.valueOf(DynamicEconomy.prefix) + Messages.notWithinRegion);
                    Utility.writeToLog(String.valueOf(player.getName()) + " called /buyenchantment outside of an economy region.");
                    return;
                }
                if (DynamicEconomy.useRegionFlags) {
                    List allowedGroups;
                    boolean inRegion;
                    String reg = regionUtils.getRegion(x, y, z);
                    String node = "regions." + reg + ".flags";
                    tax = DynamicEconomy.regionConfig.getDouble(String.valueOf(node) + ".purchasetax");
                    String[] regionBannedItems = DynamicEconomy.regionConfig.getString(String.valueOf(node) + ".banned-purchase-items", "").split(",");
                    int i = 0;
                    while (i < regionBannedItems.length) {
                        bannedItem = Item.getTrueName(regionBannedItems[i]);
                        if (bannedItem.equals(enchantment)) {
                            color.sendColouredMessage(player, String.valueOf(DynamicEconomy.prefix) + Messages.bannedInRegion);
                            Utility.writeToLog(String.valueOf(player.getName()) + " attempted to buy the banned item: " + bannedItem);
                            return;
                        }
                        ++i;
                    }
                    if (DynamicEconomy.groupControl && !(inRegion = Item.isItemInRegionGroup(allowedGroups = DynamicEconomy.regionConfig.getStringList(String.valueOf(node) + ".allowed-purchase-groups"), enchantment))) {
                        color.sendColouredMessage(player, String.valueOf(DynamicEconomy.prefix) + "&2You cannot buy &f" + enchantment + "&2 in this region.");
                        Utility.writeToLog(String.valueOf(player.getName()) + " attempted to buy " + enchantment + " in region " + reg + ", but it's not in any allowed item groups.");
                        return;
                    }
                }
            }
            int x = 0;
            while (x < DynamicEconomy.bannedPurchaseItems.length) {
                bannedItem = Item.getTrueName(DynamicEconomy.bannedPurchaseItems[x]);
                if (bannedItem.equals(enchantment)) {
                    color.sendColouredMessage(player, String.valueOf(DynamicEconomy.prefix) + Messages.bannedItem);
                    Utility.writeToLog(String.valueOf(player.getName()) + " attempted to buy the banned item: " + bannedItem);
                    return;
                }
                ++x;
            }
            if (DynamicEconomy.groupControl && !Item.canBuy(player, enchantment)) {
                color.sendColouredMessage(player, String.valueOf(DynamicEconomy.prefix) + "&2You are not permitted to purchase &f" + enchantment);
                Utility.writeToLog(String.valueOf(player.getName()) + " tried to purchase " + enchantment + " but was denied access.");
                return;
            }
            ItemStack enchantTarg = player.getItemInHand();
            decFormat.applyPattern("#.##");
            boolean canEnchant = enchant.canEnchantItem(enchantTarg);
            if (!canEnchant) {
                color.sendColouredMessage(player, String.valueOf(DynamicEconomy.prefix) + "&2The item you are holding cannot be given the enchantment &f" + enchantment);
                Utility.writeToLog(String.valueOf(player.getName()) + " called /buyenchantment " + enchantment + " for an item this enchantment cannot be applied to.");
                return;
            }
            if (stock == 0) {
                color.sendColouredMessage(player, String.valueOf(DynamicEconomy.prefix) + Messages.notEnoughStock);
                Utility.writeToLog(String.valueOf(player.getName()) + " called /buyenchantment " + enchantment + " but there were none in stock.");
                return;
            }
            EnderEngine engine = new EnderEngine(enchantmentInfo);
            double totalCost = engine.getCost(1) * (double)level;
            double newPrice = engine.getPrice();
            int newStock = engine.getStock();
            double bal = DynamicEconomy.economy.getBalance(player.getName());
            if (totalCost > bal) {
                color.sendColouredMessage(player, String.valueOf(DynamicEconomy.prefix) + Messages.notEnoughMoney);
                Utility.writeToLog(String.valueOf(player.getName()) + " called /buyenchantment " + enchantment + " but could not afford it.");
                return;
            }
            double percentTax = tax * 100.0;
            tax *= totalCost;
            DynamicEconomy.economy.withdrawPlayer(player.getName(), totalCost += tax);
            if (DynamicEconomy.depositTax) {
                try {
                    if (DynamicEconomy.taxAccountIsBank) {
                        DynamicEconomy.economy.bankDeposit(DynamicEconomy.taxAccount, tax);
                    } else {
                        DynamicEconomy.economy.depositPlayer(DynamicEconomy.taxAccount, tax);
                    }
                }
                catch (Exception e) {
                    log.info("Tax-Account " + DynamicEconomy.taxAccount + " not found.");
                    Utility.writeToLog("Attempted to deposit tax of " + DynamicEconomy.currencySymbol + tax + " to account " + DynamicEconomy.taxAccount + " but account not found.");
                }
            }
            color.sendColouredMessage(player, String.valueOf(DynamicEconomy.prefix) + Messages.purchaseSuccess);
            Utility.writeToLog(String.valueOf(player.getName()) + " bought " + 1 + " of '" + enchantment + "' for " + totalCost);
            decFormat.setGroupingUsed(false);
            totalCost = Double.valueOf(decFormat.format(totalCost));
            itemPrice = Double.valueOf(decFormat.format(itemPrice));
            color.sendColouredMessage(player, String.valueOf(DynamicEconomy.prefix) + "&fYou bought " + 1 + " &2of " + enchantment + "&f + " + decFormat.format(percentTax) + "&2% tax = &f" + DynamicEconomy.currencySymbol + totalCost + " &2TOTAL");
            changeFormat.applyPattern("#.#####");
            newPrice = Double.valueOf(decFormat.format(newPrice));
            double change = Double.valueOf(changeFormat.format(newPrice - itemPrice));
            if (itemPrice != newPrice) {
                if (DynamicEconomy.globalNotify) {
                    Player[] playerArray = Bukkit.getServer().getOnlinePlayers();
                    int n = playerArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Player p = playerArray[n2];
                        if (!Utility.isQuiet(p)) {
                            color.sendColouredMessage(p, String.valueOf(DynamicEconomy.prefix) + "&2New Price of &f" + enchantment + "&2 is &f" + DynamicEconomy.currencySymbol + newPrice + "&2 (+" + change + ")");
                        }
                        ++n2;
                    }
                } else if (DynamicEconomy.localNotify) {
                    color.sendColouredMessage(player, String.valueOf(DynamicEconomy.prefix) + "&2New Price of &f" + enchantment + "&2 is &f" + DynamicEconomy.currencySymbol + newPrice + "&2 (+" + change + ")");
                }
                Utility.writeToLog(String.valueOf(DynamicEconomy.prefix) + " New price of " + enchantment + " changed dynamically to " + newPrice + "(+" + change + ")");
            }
            enchantTarg.addEnchantment(enchant, level);
            player.getInventory().setItemInHand(enchantTarg);
            player.updateInventory();
            engine.updateConfig();
            dataSigns.checkForUpdates(enchantment, stock - newStock, change);
            DynamicShop.updateItem(enchantment);
        }
    }

    public static void sellEnchantment(Player player, String[] args) {
        if (args.length != 1) {
            color.sendColouredMessage(player, String.valueOf(DynamicEconomy.prefix) + "&2Wrong Command Usage. &f/sellEnchantment [Enchantment]");
            Utility.writeToLog(String.valueOf(player.getName()) + " incorrectly called /sellEnchantment");
        } else {
            String bannedItem;
            String enchantment = args[0].toUpperCase();
            int level = 0;
            if (!DynamicEconomy.itemConfig.contains(enchantment)) {
                color.sendColouredMessage(player, String.valueOf(DynamicEconomy.prefix) + "&f" + enchantment + "&2 is not a valid enchantment.");
                Utility.writeToLog(String.valueOf(player.getName()) + " called /sellenchantment with invalid enchantment " + enchantment);
                return;
            }
            String[] enchantmentInfo = Item.getAllInfo(enchantment);
            int id = Integer.parseInt(enchantmentInfo[6]);
            int stock = Integer.parseInt(enchantmentInfo[5]);
            double itemPrice = Double.parseDouble(enchantmentInfo[1]);
            int enchantmentID = id % 2500;
            Enchantment enchant = Enchantment.getById((int)enchantmentID);
            double tax = DynamicEconomy.salestax;
            if (DynamicEconomy.useRegions) {
                int z;
                int y;
                Location loc = player.getLocation();
                int x = loc.getBlockX();
                boolean withinRegion = regionUtils.withinRegion(x, y = loc.getBlockY(), z = loc.getBlockZ());
                if (!withinRegion) {
                    color.sendColouredMessage(player, String.valueOf(DynamicEconomy.prefix) + Messages.notWithinRegion);
                    Utility.writeToLog(String.valueOf(player.getName()) + " called /sellenchantment outside of an economy region.");
                    return;
                }
                decFormat.applyPattern("###.##");
                if (DynamicEconomy.useRegionFlags) {
                    List allowedGroups;
                    boolean inRegion;
                    String reg = regionUtils.getRegion(x, y, z);
                    String node = "regions." + reg + ".flags";
                    tax = DynamicEconomy.regionConfig.getDouble(String.valueOf(node) + ".salestax");
                    String[] regionBannedItems = DynamicEconomy.regionConfig.getString(String.valueOf(node) + ".banned-sale-items", "").split(",");
                    int i = 0;
                    while (i < regionBannedItems.length) {
                        bannedItem = Item.getTrueName(regionBannedItems[i]);
                        if (bannedItem.equals(enchantment)) {
                            color.sendColouredMessage(player, String.valueOf(DynamicEconomy.prefix) + Messages.bannedInRegion);
                            Utility.writeToLog(String.valueOf(player.getName()) + " attempted to sell the banned item: " + bannedItem);
                            return;
                        }
                        ++i;
                    }
                    if (DynamicEconomy.groupControl && !(inRegion = Item.isItemInRegionGroup(allowedGroups = DynamicEconomy.regionConfig.getStringList(String.valueOf(node) + ".allowed-sale-groups"), enchantment))) {
                        color.sendColouredMessage(player, String.valueOf(DynamicEconomy.prefix) + "&2You cannot sell &f" + enchantment + "&2 in this region.");
                        Utility.writeToLog(String.valueOf(player.getName()) + " attempted to sell " + enchantment + " in region " + reg + ", but it's not in any allowed item groups.");
                        return;
                    }
                }
            }
            int x = 0;
            while (x < DynamicEconomy.bannedSaleItems.length) {
                bannedItem = Item.getTrueName(DynamicEconomy.bannedSaleItems[x]);
                if (bannedItem.equals(enchantment)) {
                    color.sendColouredMessage(player, String.valueOf(DynamicEconomy.prefix) + Messages.bannedItem);
                    Utility.writeToLog(String.valueOf(player.getName()) + " attempted to sell the banned item: " + bannedItem);
                    return;
                }
                ++x;
            }
            if (DynamicEconomy.groupControl && !Item.canSell(player, enchantment)) {
                color.sendColouredMessage(player, String.valueOf(DynamicEconomy.prefix) + "&2You are not permitted to sell &f" + enchantment);
                Utility.writeToLog(String.valueOf(player.getName()) + " tried to sell " + enchantment + " but was denied access.");
                return;
            }
            ItemStack enchantTarg = player.getItemInHand();
            if (!enchantTarg.getEnchantments().containsKey(enchant)) {
                color.sendColouredMessage(player, String.valueOf(DynamicEconomy.prefix) + "&2The item you are holding does not have the enchantment &f" + enchantment);
                Utility.writeToLog(String.valueOf(player.getName()) + " called /sellenchantment " + enchantment + " for an item which doesnt have this enchantment");
                return;
            }
            level = (Integer)enchantTarg.getEnchantments().get(enchant);
            enchantTarg.removeEnchantment(enchant);
            EnderEngine engine = new EnderEngine(enchantmentInfo);
            double totalSale = engine.getSale(1) * (double)level;
            double newPrice = engine.getPrice();
            int newStock = engine.getStock();
            double percentTax = tax * 100.0;
            tax *= totalSale;
            player.getInventory().setItemInHand(enchantTarg);
            DynamicEconomy.economy.depositPlayer(player.getName(), totalSale -= tax);
            if (DynamicEconomy.depositTax) {
                try {
                    if (DynamicEconomy.taxAccountIsBank) {
                        DynamicEconomy.economy.bankDeposit(DynamicEconomy.taxAccount, tax);
                    } else {
                        DynamicEconomy.economy.depositPlayer(DynamicEconomy.taxAccount, tax);
                    }
                }
                catch (Exception e) {
                    log.info("Tax-Account " + DynamicEconomy.taxAccount + " not found.");
                    Utility.writeToLog("Attempted to deposit tax of " + DynamicEconomy.currencySymbol + tax + " to account " + DynamicEconomy.taxAccount + " but account not found.");
                }
            }
            color.sendColouredMessage(player, String.valueOf(DynamicEconomy.prefix) + Messages.saleSuccess);
            Utility.writeToLog(String.valueOf(player.getName()) + " sold " + 1 + " of '" + enchantment + "' for " + totalSale);
            decFormat.setGroupingUsed(false);
            totalSale = Double.valueOf(decFormat.format(totalSale));
            itemPrice = Double.valueOf(decFormat.format(itemPrice));
            color.sendColouredMessage(player, String.valueOf(DynamicEconomy.prefix) + "&2TOTAL SALE (with " + decFormat.format(percentTax) + "% tax): &f" + DynamicEconomy.currencySymbol + totalSale);
            changeFormat.applyPattern("#.#####");
            newPrice = Double.valueOf(decFormat.format(newPrice));
            double change = Double.valueOf(changeFormat.format(itemPrice - newPrice));
            if (itemPrice != newPrice) {
                if (DynamicEconomy.globalNotify) {
                    Player[] playerArray = Bukkit.getServer().getOnlinePlayers();
                    int n = playerArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Player p = playerArray[n2];
                        if (!Utility.isQuiet(p)) {
                            color.sendColouredMessage(p, String.valueOf(DynamicEconomy.prefix) + "&2New Price of &f" + enchantment + "&2 is &f" + DynamicEconomy.currencySymbol + newPrice + "&2 (-" + change + ")");
                        }
                        ++n2;
                    }
                } else if (DynamicEconomy.localNotify) {
                    color.sendColouredMessage(player, String.valueOf(DynamicEconomy.prefix) + "&2New Price of &f" + enchantment + "&2 is &f" + DynamicEconomy.currencySymbol + newPrice + "&2 (+" + change + ")");
                }
                Utility.writeToLog(String.valueOf(DynamicEconomy.prefix) + " New price of " + enchantment + " changed dynamically to " + newPrice + "(-" + change + ")");
            }
            player.updateInventory();
            engine.updateConfig();
            dataSigns.checkForUpdates(enchantment, stock - newStock, change);
            DynamicShop.updateItem(enchantment);
        }
    }

    @Override
    public void run() {
        Set itemsSet = DynamicEconomy.itemConfig.getKeys(false);
        Object[] itemsObj = itemsSet.toArray();
        String[] items = new String[itemsObj.length];
        int i = 0;
        while (i < items.length) {
            items[i] = itemsObj[i].toString();
            ++i;
        }
        long period = DynamicEconomy.overTimePriceChangePeriod * 60L * 1000L;
        int x = 0;
        while (x < items.length) {
            Player p;
            int n;
            int n2;
            Player[] playerArray;
            double price;
            long buyTime = DynamicEconomy.itemConfig.getLong(String.valueOf(items[x]) + ".buytime");
            long sellTime = DynamicEconomy.itemConfig.getLong(String.valueOf(items[x]) + ".selltime");
            Calendar.getInstance();
            long buyDifference = Calendar.getInstance().getTimeInMillis() - buyTime;
            Calendar.getInstance();
            long sellDifference = Calendar.getInstance().getTimeInMillis() - sellTime;
            EnderEngine engine = new EnderEngine(Item.getAllInfo(items[x]));
            if (DynamicEconomy.enableOverTimePriceDecay && buyDifference >= period && buyTime != 0L) {
                engine.decay();
                price = engine.getPrice();
                decFormat.applyPattern("#.##");
                if (DynamicEconomy.globalNotify) {
                    playerArray = Bukkit.getServer().getOnlinePlayers();
                    n2 = playerArray.length;
                    n = 0;
                    while (n < n2) {
                        p = playerArray[n];
                        if (!Utility.isQuiet(p)) {
                            price = Double.valueOf(decFormat.format(price));
                            color.sendColouredMessage(p, String.valueOf(DynamicEconomy.prefix) + "&2New Price of &f" + items[x] + "&2 is &f" + DynamicEconomy.currencySymbol + price + "&2 ( -" + DynamicEconomy.overTimePriceDecayPercent * 100.0 + "% )");
                        }
                        ++n;
                    }
                }
                DynamicEconomy.itemConfig.set(String.valueOf(items[x]) + ".buytime", (Object)Calendar.getInstance().getTimeInMillis());
            }
            if (DynamicEconomy.enableOverTimePriceInflation && sellDifference >= period && sellTime != 0L) {
                engine.inflate();
                price = engine.getPrice();
                decFormat.applyPattern("#.##");
                if (DynamicEconomy.globalNotify) {
                    playerArray = Bukkit.getServer().getOnlinePlayers();
                    n2 = playerArray.length;
                    n = 0;
                    while (n < n2) {
                        p = playerArray[n];
                        if (!Utility.isQuiet(p)) {
                            price = Double.valueOf(decFormat.format(price));
                            color.sendColouredMessage(p, String.valueOf(DynamicEconomy.prefix) + "&2New Price of &f" + items[x] + "&2 is &f" + DynamicEconomy.currencySymbol + price + "&2 ( +" + DynamicEconomy.overTimePriceInflationPercent * 100.0 + "% )");
                        }
                        ++n;
                    }
                }
                DynamicEconomy.itemConfig.set(String.valueOf(items[x]) + ".selltime", (Object)Calendar.getInstance().getTimeInMillis());
            }
            ++x;
        }
        try {
            DynamicEconomy.itemConfig.save(DynamicEconomy.itemsFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

