/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.blockqueue;

import com.palmergames.bukkit.blockqueue.BlockJob;
import com.palmergames.bukkit.blockqueue.BlockQueue;
import com.palmergames.bukkit.blockqueue.BlockWork;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;

public class BlockWorker
implements Runnable {
    private BlockQueue blockQueue;
    private Server server;
    public static final Object NO_MORE_WORK = new Object();
    public static final Object END_JOB = new Object();
    private boolean running;
    private BlockJob currentJob;
    private int blocks;
    private int skipped;

    public BlockWorker(Server server, BlockQueue blockQueue) {
        this.blockQueue = blockQueue;
        this.setServer(server);
        this.setRunning(true);
    }

    public synchronized void setRunning(boolean bl) {
        this.running = bl;
    }

    @Override
    public void run() {
        this.blocks = 0;
        this.skipped = 0;
        try {
            Object object;
            while (this.running && (object = this.blockQueue.getWork()) != NO_MORE_WORK) {
                if (object == END_JOB) {
                    this.onJobFinish(this.currentJob);
                }
                if (object instanceof BlockWork) {
                    try {
                        this.buildBlock((BlockWork)object);
                    }
                    catch (Exception exception) {
                        ++this.skipped;
                    }
                    ++this.blocks;
                }
                if (!(object instanceof BlockJob)) continue;
                this.currentJob = (BlockJob)object;
                this.blocks = 0;
                this.skipped = 0;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.out.println("[Blocker] BlockQueue Thread stopped.");
        this.blockQueue = null;
    }

    public void buildBlock(BlockWork blockWork) {
        Block block = blockWork.getWorld().getBlockAt(blockWork.getX(), blockWork.getY(), blockWork.getZ());
        if (blockWork.getId() == block.getTypeId()) {
            return;
        }
        block.setTypeId(blockWork.getId());
        block.setData(blockWork.getData());
    }

    public void setServer(Server server) {
        this.server = server;
    }

    public Server getServer() {
        return this.server;
    }

    public void onJobFinish(BlockJob blockJob) {
        if (blockJob.isNotify()) {
            Player player = this.getServer().getPlayer(blockJob.getBoss());
            player.sendMessage("Generated: " + this.blocks + " Blocks");
            if (this.skipped > 0) {
                player.sendMessage("Skipped: " + this.skipped + " Blocks");
            }
        }
    }
}

