/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny;

import ca.xshade.bukkit.questioner.Questioner;
import ca.xshade.questionmanager.Option;
import ca.xshade.questionmanager.Question;
import com.earth2me.essentials.Essentials;
import com.nijiko.permissions.PermissionHandler;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyFormatter;
import com.palmergames.bukkit.towny.TownyLogger;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyTimerHandler;
import com.palmergames.bukkit.towny.command.NationCommand;
import com.palmergames.bukkit.towny.command.PlotCommand;
import com.palmergames.bukkit.towny.command.ResidentCommand;
import com.palmergames.bukkit.towny.command.TownCommand;
import com.palmergames.bukkit.towny.command.TownyAdminCommand;
import com.palmergames.bukkit.towny.command.TownyCommand;
import com.palmergames.bukkit.towny.command.TownyWorldCommand;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.listeners.TownyBlockListener;
import com.palmergames.bukkit.towny.listeners.TownyCustomListener;
import com.palmergames.bukkit.towny.listeners.TownyEntityListener;
import com.palmergames.bukkit.towny.listeners.TownyEntityMonitorListener;
import com.palmergames.bukkit.towny.listeners.TownyPlayerListener;
import com.palmergames.bukkit.towny.listeners.TownyWeatherListener;
import com.palmergames.bukkit.towny.listeners.TownyWorldListener;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.PlayerCache;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.permissions.BukkitPermSource;
import com.palmergames.bukkit.towny.permissions.GroupManagerSource;
import com.palmergames.bukkit.towny.permissions.NullPermSource;
import com.palmergames.bukkit.towny.permissions.PEXSource;
import com.palmergames.bukkit.towny.permissions.Perms3Source;
import com.palmergames.bukkit.towny.permissions.TownyPerms;
import com.palmergames.bukkit.towny.permissions.bPermsSource;
import com.palmergames.bukkit.towny.questioner.TownyQuestionTask;
import com.palmergames.bukkit.towny.regen.TownyRegenAPI;
import com.palmergames.bukkit.towny.utils.PlayerCacheUtil;
import com.palmergames.bukkit.towny.war.flagwar.TownyWar;
import com.palmergames.bukkit.towny.war.flagwar.listeners.TownyWarBlockListener;
import com.palmergames.bukkit.towny.war.flagwar.listeners.TownyWarCustomListener;
import com.palmergames.bukkit.towny.war.flagwar.listeners.TownyWarEntityListener;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.util.FileMgmt;
import com.palmergames.util.JavaUtil;
import com.palmergames.util.StringMgmt;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.command.CommandExecutor;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class Towny
extends JavaPlugin {
    private String version = "2.0.0";
    public static PermissionHandler permissionHandler;
    private final TownyPlayerListener playerListener = new TownyPlayerListener(this);
    private final TownyBlockListener blockListener = new TownyBlockListener(this);
    private final TownyCustomListener customListener = new TownyCustomListener(this);
    private final TownyEntityListener entityListener = new TownyEntityListener(this);
    private final TownyWeatherListener weatherListener = new TownyWeatherListener(this);
    private final TownyEntityMonitorListener entityMonitorListener = new TownyEntityMonitorListener(this);
    private final TownyWorldListener worldListener = new TownyWorldListener(this);
    private final TownyWarBlockListener townyWarBlockListener = new TownyWarBlockListener(this);
    private final TownyWarCustomListener townyWarCustomListener = new TownyWarCustomListener(this);
    private final TownyWarEntityListener townyWarEntityListener = new TownyWarEntityListener(this);
    private TownyUniverse townyUniverse;
    private Map<String, PlayerCache> playerCache = Collections.synchronizedMap(new HashMap());
    private Essentials essentials = null;
    private boolean citizens2 = false;
    private boolean error = false;

    public void onEnable() {
        System.out.println("====================      Towny      ========================");
        this.version = this.getDescription().getVersion();
        this.townyUniverse = new TownyUniverse(this);
        BukkitTools.initialize(this);
        TownyTimerHandler.initialize(this);
        TownyEconomyHandler.initialize(this);
        TownyFormatter.initialize(this);
        TownyRegenAPI.initialize(this);
        PlayerCacheUtil.initialize(this);
        TownyPerms.initialize(this);
        if (this.load()) {
            this.getCommand("townyadmin").setExecutor((CommandExecutor)new TownyAdminCommand(this));
            this.getCommand("townyworld").setExecutor((CommandExecutor)new TownyWorldCommand(this));
            this.getCommand("resident").setExecutor((CommandExecutor)new ResidentCommand(this));
            this.getCommand("towny").setExecutor((CommandExecutor)new TownyCommand(this));
            this.getCommand("town").setExecutor((CommandExecutor)new TownCommand(this));
            this.getCommand("nation").setExecutor((CommandExecutor)new NationCommand(this));
            this.getCommand("plot").setExecutor((CommandExecutor)new PlotCommand(this));
            TownyWar.onEnable();
            if (TownySettings.isTownyUpdating(this.getVersion())) {
                this.update();
            }
            TownyPerms.registerPermissionNodes();
        }
        this.registerEvents();
        TownyLogger.log.info("=============================================================");
        if (this.isError()) {
            TownyLogger.log.info("[WARNING] - ***** SAFE MODE ***** " + this.version);
        } else {
            TownyLogger.log.info("[Towny] Version: " + this.version + " - Mod Enabled");
        }
        TownyLogger.log.info("=============================================================");
        if (!this.isError()) {
            for (Player player : BukkitTools.getOnlinePlayers()) {
                if (player == null) continue;
                try {
                    this.getTownyUniverse().onLogin(player);
                }
                catch (TownyException townyException) {
                    TownyMessaging.sendErrorMsg((Object)player, townyException.getMessage());
                }
            }
        }
    }

    public void SetWorldFlags() {
        for (Town town : TownyUniverse.getDataSource().getTowns()) {
            TownyMessaging.sendDebugMsg("[Towny] Setting flags for: " + town.getName());
            if (town.getWorld() != null) continue;
            TownyLogger.log.warning("[Towny Error] Detected an error with the world files. Attempting to repair");
            if (town.hasHomeBlock()) {
                try {
                    TownyWorld townyWorld = town.getHomeBlock().getWorld();
                    if (townyWorld.hasTown(town)) continue;
                    townyWorld.addTown(town);
                    TownyUniverse.getDataSource().saveTown(town);
                    TownyUniverse.getDataSource().saveWorld(townyWorld);
                }
                catch (TownyException townyException) {
                    TownyLogger.log.warning("[Towny Error] Failed get world data for: " + town.getName());
                }
                continue;
            }
            TownyLogger.log.warning("[Towny Error] No Homeblock - Failed to detect world for: " + town.getName());
        }
    }

    public void onDisable() {
        System.out.println("==============================================================");
        if (TownyUniverse.getDataSource() != null && !this.error) {
            TownyUniverse.getDataSource().saveQueues();
        }
        if (!this.error) {
            TownyWar.onDisable();
        }
        if (TownyUniverse.isWarTime()) {
            this.getTownyUniverse().getWarEvent().toggleEnd();
        }
        TownyTimerHandler.toggleTownyRepeatingTimer(false);
        TownyTimerHandler.toggleDailyTimer(false);
        TownyTimerHandler.toggleMobRemoval(false);
        TownyTimerHandler.toggleHealthRegen(false);
        TownyTimerHandler.toggleTeleportWarmup(false);
        TownyRegenAPI.cancelProtectionRegenTasks();
        this.playerCache.clear();
        this.townyUniverse = null;
        System.out.println("[Towny] Version: " + this.version + " - Mod Disabled");
        System.out.println("=============================================================");
        TownyLogger.shutDown();
    }

    public boolean load() {
        Pattern pattern = Pattern.compile("-b(\\d*?)jnks", 2);
        Matcher matcher = pattern.matcher(this.getServer().getVersion());
        if (!this.townyUniverse.loadSettings()) {
            this.setError(true);
            return false;
        }
        this.setupLogger();
        if (TownySettings.isBypassVersionCheck()) {
            TownyLogger.log.info("[Towny] Bypassing CraftBukkit Version check.");
        } else {
            int n = TownySettings.getMinBukkitVersion();
            if (!matcher.find() || matcher.group(1) == null) {
                this.error = true;
                TownyLogger.log.severe("[Towny Error] Unable to read CraftBukkit Version.");
                TownyLogger.log.severe("[Towny Error] Towny requires version " + n + " or higher.");
                TownyLogger.log.severe("[Towny Error] Check your CraftBukkit version or set 'bypass_version_check' to true in the Towny config.");
                this.getServer().getPluginManager().disablePlugin((Plugin)this);
                return false;
            }
            int n2 = Integer.parseInt(matcher.group(1));
            if (n2 < n) {
                this.error = true;
                TownyLogger.log.severe("[Towny Error] CraftBukkit Version (" + n2 + ") is outdated! ");
                TownyLogger.log.severe("[Towny Error] Towny requires version " + n + " or higher.");
                this.getServer().getPluginManager().disablePlugin((Plugin)this);
                return false;
            }
        }
        this.checkPlugins();
        this.SetWorldFlags();
        TownyTimerHandler.toggleTownyRepeatingTimer(false);
        TownyTimerHandler.toggleDailyTimer(false);
        TownyTimerHandler.toggleMobRemoval(false);
        TownyTimerHandler.toggleHealthRegen(false);
        TownyTimerHandler.toggleTeleportWarmup(false);
        TownyTimerHandler.toggleTownyRepeatingTimer(true);
        TownyTimerHandler.toggleDailyTimer(true);
        TownyTimerHandler.toggleMobRemoval(true);
        TownyTimerHandler.toggleHealthRegen(TownySettings.hasHealthRegen());
        TownyTimerHandler.toggleTeleportWarmup(TownySettings.getTeleportWarmupTime() > 0);
        this.resetCache();
        return true;
    }

    private void checkPlugins() {
        Plugin plugin;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (TownySettings.isUsingPermissions()) {
            plugin = this.getServer().getPluginManager().getPlugin("GroupManager");
            if (plugin != null) {
                this.getTownyUniverse().setPermissionSource(new GroupManagerSource(this, plugin));
                arrayList.add(String.format("%s v%s", "GroupManager", plugin.getDescription().getVersion()));
            } else {
                plugin = this.getServer().getPluginManager().getPlugin("PermissionsEx");
                if (plugin != null) {
                    this.getTownyUniverse().setPermissionSource(new PEXSource(this, plugin));
                    arrayList.add(String.format("%s v%s", "PermissionsEX", plugin.getDescription().getVersion()));
                } else {
                    plugin = this.getServer().getPluginManager().getPlugin("bPermissions");
                    if (plugin != null) {
                        this.getTownyUniverse().setPermissionSource(new bPermsSource(this, plugin));
                        arrayList.add(String.format("%s v%s", "bPermissions", plugin.getDescription().getVersion()));
                    } else {
                        plugin = this.getServer().getPluginManager().getPlugin("Permissions");
                        if (plugin != null) {
                            this.getTownyUniverse().setPermissionSource(new Perms3Source(this, plugin));
                            arrayList.add(String.format("%s v%s", "Permissions", plugin.getDescription().getVersion()));
                        } else {
                            this.getTownyUniverse().setPermissionSource(new BukkitPermSource(this));
                            arrayList.add("BukkitPermissions");
                        }
                    }
                }
            }
        } else {
            this.getTownyUniverse().setPermissionSource(new NullPermSource(this));
        }
        if (TownySettings.isUsingEconomy()) {
            if (TownyEconomyHandler.setupEconomy().booleanValue()) {
                arrayList.add(TownyEconomyHandler.getVersion());
            } else {
                TownyMessaging.sendErrorMsg("No compatible Economy plugins found. You need iConomy 5.01, or the vault/Register.jar with any of the supported eco systems.");
            }
        }
        if ((plugin = this.getServer().getPluginManager().getPlugin("Essentials")) == null) {
            TownySettings.setUsingEssentials(false);
        } else if (TownySettings.isUsingEssentials()) {
            this.essentials = (Essentials)plugin;
            arrayList.add(String.format("%s v%s", "Essentials", plugin.getDescription().getVersion()));
        }
        plugin = this.getServer().getPluginManager().getPlugin("Questioner");
        if (plugin == null) {
            TownySettings.setUsingQuestioner(false);
        } else if (TownySettings.isUsingQuestioner()) {
            arrayList.add(String.format("%s v%s", "Questioner", plugin.getDescription().getVersion()));
        }
        plugin = this.getServer().getPluginManager().getPlugin("Citizens");
        if (plugin != null) {
            this.citizens2 = plugin.getDescription().getVersion().startsWith("2");
        }
        if (arrayList.size() > 0) {
            TownyLogger.log.info("[Towny] Using: " + StringMgmt.join(arrayList, ", "));
        }
    }

    private void registerEvents() {
        PluginManager pluginManager = this.getServer().getPluginManager();
        if (!this.isError()) {
            pluginManager.registerEvents((Listener)this.townyWarBlockListener, (Plugin)this);
            pluginManager.registerEvents((Listener)this.townyWarEntityListener, (Plugin)this);
            pluginManager.registerEvents((Listener)this.entityMonitorListener, (Plugin)this);
            pluginManager.registerEvents((Listener)this.weatherListener, (Plugin)this);
            pluginManager.registerEvents((Listener)this.townyWarCustomListener, (Plugin)this);
            pluginManager.registerEvents((Listener)this.customListener, (Plugin)this);
            pluginManager.registerEvents((Listener)this.worldListener, (Plugin)this);
        }
        pluginManager.registerEvents((Listener)this.playerListener, (Plugin)this);
        pluginManager.registerEvents((Listener)this.blockListener, (Plugin)this);
        pluginManager.registerEvents((Listener)this.entityListener, (Plugin)this);
    }

    private void update() {
        try {
            List<String> list = JavaUtil.readTextFromJar("/ChangeLog.txt");
            boolean bl = false;
            TownyLogger.log.info("------------------------------------");
            TownyLogger.log.info("[Towny] ChangeLog up until v" + this.getVersion());
            String string = TownySettings.getLastRunVersion(this.getVersion());
            for (String string2 : list) {
                if (string2.startsWith("v" + string)) {
                    bl = true;
                }
                if (!bl || string2.replaceAll(" ", "").replaceAll("\t", "").length() <= 0) continue;
                TownyLogger.log.info(string2);
            }
            TownyLogger.log.info("------------------------------------");
        }
        catch (IOException iOException) {
            TownyMessaging.sendDebugMsg("Could not read ChangeLog.txt");
        }
        TownySettings.setLastRunVersion(this.getVersion());
    }

    public TownyUniverse getTownyUniverse() {
        return this.townyUniverse;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isError() {
        return this.error;
    }

    protected void setError(boolean bl) {
        this.error = bl;
    }

    public boolean isPermissions() {
        return TownySettings.isUsingPermissions();
    }

    public boolean isEssentials() {
        return TownySettings.isUsingEssentials() && this.essentials != null;
    }

    public boolean isCitizens2() {
        return this.citizens2;
    }

    public Essentials getEssentials() throws TownyException {
        if (this.essentials == null) {
            throw new TownyException("Essentials is not installed, or not enabled!");
        }
        return this.essentials;
    }

    public World getServerWorld(String string) throws NotRegisteredException {
        for (World world : BukkitTools.getWorlds()) {
            if (!world.getName().equals(string)) continue;
            return world;
        }
        throw new NotRegisteredException(String.format("A world called '$%s' has not been registered.", string));
    }

    public boolean hasCache(Player player) {
        return this.playerCache.containsKey(player.getName().toLowerCase());
    }

    public void newCache(Player player) {
        try {
            this.getTownyUniverse();
            this.playerCache.put(player.getName().toLowerCase(), new PlayerCache(TownyUniverse.getDataSource().getWorld(player.getWorld().getName()), player));
        }
        catch (NotRegisteredException notRegisteredException) {
            TownyMessaging.sendErrorMsg((Object)player, "Could not create permission cache for this world (" + player.getWorld().getName() + ".");
        }
    }

    public void deleteCache(Player player) {
        this.deleteCache(player.getName());
    }

    public void deleteCache(String string) {
        this.playerCache.remove(string.toLowerCase());
    }

    public PlayerCache getCache(Player player) {
        if (!this.hasCache(player)) {
            this.newCache(player);
            this.getCache(player).setLastTownBlock(new WorldCoord(player.getWorld().getName(), Coord.parseCoord((Entity)player)));
        }
        return this.playerCache.get(player.getName().toLowerCase());
    }

    public void resetCache() {
        for (Player player : BukkitTools.getOnlinePlayers()) {
            if (player == null) continue;
            this.getCache(player).resetAndUpdate(new WorldCoord(player.getWorld().getName(), Coord.parseCoord((Entity)player)));
        }
    }

    public void updateCache(WorldCoord worldCoord) {
        for (Player player : BukkitTools.getOnlinePlayers()) {
            if (player == null || !Coord.parseCoord((Entity)player).equals(worldCoord)) continue;
            this.getCache(player).resetAndUpdate(worldCoord);
        }
    }

    public void updateCache() {
        WorldCoord worldCoord = null;
        for (Player player : BukkitTools.getOnlinePlayers()) {
            if (player == null) continue;
            worldCoord = new WorldCoord(player.getWorld().getName(), Coord.parseCoord((Entity)player));
            PlayerCache playerCache = this.getCache(player);
            if (playerCache.getLastTownBlock() == worldCoord) continue;
            playerCache.resetAndUpdate(worldCoord);
        }
    }

    public void updateCache(Player player) {
        WorldCoord worldCoord = new WorldCoord(player.getWorld().getName(), Coord.parseCoord((Entity)player));
        PlayerCache playerCache = this.getCache(player);
        if (playerCache.getLastTownBlock() != worldCoord) {
            playerCache.resetAndUpdate(worldCoord);
        }
    }

    public void resetCache(Player player) {
        this.getCache(player).resetAndUpdate(new WorldCoord(player.getWorld().getName(), Coord.parseCoord((Entity)player)));
    }

    public void setPlayerMode(Player player, String[] stringArray, boolean bl) {
        if (player == null) {
            return;
        }
        try {
            Resident resident = TownyUniverse.getDataSource().getResident(player.getName());
            resident.setModes(stringArray, bl);
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
    }

    public void removePlayerMode(Player player) {
        try {
            Resident resident = TownyUniverse.getDataSource().getResident(player.getName());
            resident.clearModes();
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
    }

    public List<String> getPlayerMode(Player player) {
        return this.getPlayerMode(player.getName());
    }

    public List<String> getPlayerMode(String string) {
        try {
            Resident resident = TownyUniverse.getDataSource().getResident(string);
            return resident.getModes();
        }
        catch (NotRegisteredException notRegisteredException) {
            return null;
        }
    }

    public boolean hasPlayerMode(Player player, String string) {
        return this.hasPlayerMode(player.getName(), string);
    }

    public boolean hasPlayerMode(String string, String string2) {
        try {
            Resident resident = TownyUniverse.getDataSource().getResident(string);
            return resident.hasMode(string2);
        }
        catch (NotRegisteredException notRegisteredException) {
            return false;
        }
    }

    public String getConfigPath() {
        return this.getDataFolder().getPath() + FileMgmt.fileSeparator() + "settings" + FileMgmt.fileSeparator() + "config.yml";
    }

    public Object getSetting(String string) {
        return TownySettings.getProperty(string);
    }

    public void log(String string) {
        if (TownySettings.isLogging()) {
            TownyLogger.log.info(ChatColor.stripColor((String)string));
        }
    }

    public void setupLogger() {
        TownyLogger.setup(this.getTownyUniverse().getRootFolder(), TownySettings.isAppendingToLog());
    }

    public void appendQuestion(Questioner questioner, Question question) throws Exception {
        for (Option option : question.getOptions()) {
            if (!(option.getReaction() instanceof TownyQuestionTask)) continue;
            ((TownyQuestionTask)((Object)option.getReaction())).setTowny(this);
        }
        questioner.appendQuestion(question);
    }

    public boolean parseOnOff(String string) throws Exception {
        if (string.equalsIgnoreCase("on")) {
            return true;
        }
        if (string.equalsIgnoreCase("off")) {
            return false;
        }
        throw new Exception(String.format(TownySettings.getLangString("msg_err_invalid_input"), " on/off."));
    }
}

