/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny;

import com.palmergames.bukkit.towny.TownyLogFormatter;
import com.palmergames.bukkit.towny.TownyMoneyLogFormatter;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownyEconomyObject;
import com.palmergames.util.FileMgmt;
import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Logger;

public class TownyLogger {
    public static final Logger log = Logger.getLogger("com.palmergames.bukkit.towny.log");
    public static final Logger money = Logger.getLogger("com.palmergames.bukkit.towny.moneylog");
    public static final Logger debug = Logger.getLogger("com.palmergames.bukkit.towny.debug");

    public static void setup(String string, boolean bl) {
        String string2 = string + FileMgmt.fileSeparator() + "logs";
        TownyLogger.setupLogger(log, string2, "towny.log", new TownyLogFormatter(), TownySettings.isAppendingToLog());
        TownyLogger.setupLogger(money, string2, "money.csv", new TownyMoneyLogFormatter(), TownySettings.isAppendingToLog());
        money.setUseParentHandlers(false);
        TownyLogger.setupLogger(debug, string2, "debug.log", new TownyLogFormatter(), TownySettings.isAppendingToLog());
    }

    public static void shutDown() {
        TownyLogger.CloseDownLogger(log);
        TownyLogger.CloseDownLogger(money);
        TownyLogger.CloseDownLogger(debug);
    }

    public static void setupLogger(Logger logger, String string, String string2, Formatter formatter, boolean bl) {
        try {
            FileHandler fileHandler = new FileHandler(string + FileMgmt.fileSeparator() + string2, bl);
            fileHandler.setFormatter(formatter);
            logger.addHandler(fileHandler);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void CloseDownLogger(Logger logger) {
        for (Handler handler : logger.getHandlers()) {
            logger.removeHandler(handler);
            handler.close();
        }
    }

    public static void logMoneyTransaction(TownyEconomyObject townyEconomyObject, double d, TownyEconomyObject townyEconomyObject2, String string) {
        money.info(String.format("%s,%s,%s,%s", string == null ? "" : string, TownyLogger.getObjectName(townyEconomyObject), d, TownyLogger.getObjectName(townyEconomyObject2)));
    }

    private static String getObjectName(TownyEconomyObject townyEconomyObject) {
        String string = townyEconomyObject == null ? "Server" : (townyEconomyObject instanceof Resident ? "Resident" : (townyEconomyObject instanceof Town ? "Town" : (townyEconomyObject instanceof Nation ? "Nation" : "Server")));
        return String.format("[%s] %s", string, townyEconomyObject != null ? townyEconomyObject.getName() : "");
    }
}

