/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny;

import com.palmergames.bukkit.towny.TownyLogger;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.ResidentList;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.bukkit.util.ChatTools;
import com.palmergames.bukkit.util.Colors;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TownyMessaging {
    public static void sendErrorMsg(String string) {
        TownyLogger.log.warning(ChatTools.stripColour("[Towny] Error: " + string));
    }

    public static void sendErrorMsg(Object object, String string) {
        boolean bl = false;
        if (object instanceof Player) {
            bl = true;
        }
        if (object == null) {
            System.out.print("Message called with null sender");
        }
        for (String string2 : ChatTools.color(TownySettings.getLangString("default_towny_prefix") + "\u00a7c" + string)) {
            if (bl) {
                ((Player)object).sendMessage(string2);
                continue;
            }
            ((CommandSender)object).sendMessage(Colors.strip(string2));
        }
        TownyMessaging.sendDevMsg(string);
    }

    public static void sendErrorMsg(Object object, String[] stringArray) {
        boolean bl = false;
        if (object instanceof Player) {
            bl = true;
        }
        for (String string : ChatTools.color(TownySettings.getLangString("default_towny_prefix") + "\u00a7c" + stringArray)) {
            if (bl) {
                ((Player)object).sendMessage(string);
                continue;
            }
            ((CommandSender)object).sendMessage(Colors.strip(string));
        }
        TownyMessaging.sendDevMsg(stringArray);
    }

    public static void sendMsg(String string) {
        TownyLogger.log.info("[Towny] " + ChatTools.stripColour(string));
    }

    public static void sendMsg(Object object, String string) {
        for (String string2 : ChatTools.color(TownySettings.getLangString("default_towny_prefix") + "\u00a72" + string)) {
            if (object instanceof Player) {
                ((Player)object).sendMessage(string2);
                continue;
            }
            if (object instanceof CommandSender) {
                ((CommandSender)object).sendMessage(Colors.strip(string2));
                continue;
            }
            if (!(object instanceof Resident)) continue;
            try {
                TownyUniverse.getPlayer((Resident)object).sendMessage(Colors.strip(string2));
            }
            catch (TownyException townyException) {}
        }
        TownyMessaging.sendDevMsg(string);
    }

    public static void sendMsg(Player player, String[] stringArray) {
        for (String string : ChatTools.color(TownySettings.getLangString("default_towny_prefix") + "\u00a72" + stringArray)) {
            player.sendMessage(string);
        }
    }

    public static void sendDevMsg(String string) {
        if (TownySettings.isDevMode()) {
            Player player = Bukkit.getServer().getPlayer(TownySettings.getDevName());
            if (player == null) {
                return;
            }
            for (String string2 : ChatTools.color(TownySettings.getLangString("default_towny_prefix") + " DevMode: " + "\u00a7c" + string)) {
                player.sendMessage(string2);
            }
        }
    }

    public static void sendDevMsg(String[] stringArray) {
        if (TownySettings.isDevMode()) {
            Player player = Bukkit.getServer().getPlayer(TownySettings.getDevName());
            if (player == null) {
                return;
            }
            for (String string : ChatTools.color(TownySettings.getLangString("default_towny_prefix") + " DevMode: " + "\u00a7c" + stringArray)) {
                player.sendMessage(string);
            }
        }
    }

    public static void sendDebugMsg(String string) {
        if (TownySettings.getDebug()) {
            TownyLogger.debug.info(ChatTools.stripColour("[Towny] Debug: " + string));
        }
        TownyMessaging.sendDevMsg(string);
    }

    public static void sendMessage(Object object, List<String> list) {
        TownyMessaging.sendMessage(object, list.toArray(new String[0]));
    }

    public static void sendMessage(Object object, String string) {
        if (object instanceof Player) {
            ((Player)object).sendMessage(string);
        } else if (object instanceof CommandSender) {
            ((CommandSender)object).sendMessage(string);
        } else if (object instanceof Resident) {
            try {
                TownyUniverse.getPlayer((Resident)object).sendMessage(Colors.strip(string));
            }
            catch (TownyException townyException) {
                // empty catch block
            }
        }
    }

    public static void sendMessage(Object object, String[] stringArray) {
        boolean bl = false;
        if (object instanceof Player) {
            bl = true;
        }
        for (String string : stringArray) {
            if (bl) {
                ((Player)object).sendMessage(string);
                continue;
            }
            ((CommandSender)object).sendMessage(string);
        }
    }

    public static void sendTownMessage(Town town, List<String> list) {
        TownyMessaging.sendTownMessage(town, list.toArray(new String[0]));
    }

    public static void sendNationMessage(Nation nation, List<String> list) {
        TownyMessaging.sendNationMessage(nation, list.toArray(new String[0]));
    }

    public static void sendGlobalMessage(List<String> list) {
        TownyMessaging.sendGlobalMessage(list.toArray(new String[0]));
    }

    public static void sendGlobalMessage(String[] stringArray) {
        for (String string : stringArray) {
            TownyLogger.log.info(ChatTools.stripColour("[Global Msg] " + string));
        }
        for (String string : BukkitTools.getOnlinePlayers()) {
            if (string == null) continue;
            for (String string2 : stringArray) {
                string.sendMessage(string2);
            }
        }
    }

    public static void sendGlobalMessage(String string) {
        TownyLogger.log.info(ChatTools.stripColour("[Global Message] " + string));
        for (Player player : BukkitTools.getOnlinePlayers()) {
            if (player == null) continue;
            player.sendMessage(string);
        }
    }

    public static void sendResidentMessage(Resident resident, String[] player) throws TownyException {
        for (String string : player) {
            TownyLogger.log.info(ChatTools.stripColour("[Resident Msg] " + resident.getName() + ": " + string));
        }
        Player player2 = TownyUniverse.getPlayer(resident);
        for (Player player3 : player) {
            player2.sendMessage((String)player3);
        }
    }

    public static void sendResidentMessage(Resident resident, String string) throws TownyException {
        TownyLogger.log.info(ChatTools.stripColour("[Resident Msg] " + resident.getName() + ": " + string));
        Player player = TownyUniverse.getPlayer(resident);
        player.sendMessage(TownySettings.getLangString("default_towny_prefix") + string);
    }

    public static void sendTownMessage(Town town, String[] stringArray) {
        for (String string : stringArray) {
            TownyLogger.log.info(ChatTools.stripColour("[Town Msg] " + town.getName() + ": " + string));
        }
        for (Player player : TownyUniverse.getOnlinePlayers(town)) {
            for (String string : stringArray) {
                player.sendMessage(string);
            }
        }
    }

    public static void sendTownMessagePrefixed(Town town, String string) {
        TownyLogger.log.info(ChatTools.stripColour(string));
        for (Player player : TownyUniverse.getOnlinePlayers(town)) {
            player.sendMessage(TownySettings.getLangString("default_towny_prefix") + string);
        }
    }

    public static void sendTownMessage(Town town, String string) {
        TownyLogger.log.info(ChatTools.stripColour("[Town Msg] " + town.getName() + ": " + string));
        for (Player player : TownyUniverse.getOnlinePlayers(town)) {
            player.sendMessage(string);
        }
    }

    public static void sendNationMessage(Nation nation, String[] stringArray) {
        for (String string : stringArray) {
            TownyLogger.log.info(ChatTools.stripColour("[Nation Msg] " + nation.getName() + ": " + string));
        }
        for (Player player : TownyUniverse.getOnlinePlayers(nation)) {
            for (String string : stringArray) {
                player.sendMessage(string);
            }
        }
    }

    public static void sendNationMessage(Nation nation, String string) {
        TownyLogger.log.info(ChatTools.stripColour("[Nation Msg] " + nation.getName() + ": " + string));
        for (Player player : TownyUniverse.getOnlinePlayers(nation)) {
            player.sendMessage(string);
        }
    }

    public static void sendNationMessagePrefixed(Nation nation, String string) {
        TownyLogger.log.info(ChatTools.stripColour("[Nation Msg] " + nation.getName() + ": " + string));
        for (Player player : TownyUniverse.getOnlinePlayers(nation)) {
            player.sendMessage(TownySettings.getLangString("default_towny_prefix") + string);
        }
    }

    public static void sendTownBoard(Player player, Town town) {
        for (String string : ChatTools.color("\u00a76[" + town.getName() + "] " + "\u00a7e" + town.getTownBoard())) {
            player.sendMessage(string);
        }
    }

    public static void sendMessageToMode(ResidentList residentList, String string, String string2) {
        for (Resident resident : TownyUniverse.getOnlineResidents(residentList)) {
            if (!resident.hasMode(string2)) continue;
            TownyMessaging.sendMessage((Object)resident, string);
        }
    }

    public static void sendMessageToMode(Town town, String string, String string2) {
        for (Resident resident : town.getResidents()) {
            if (!BukkitTools.isOnline(resident.getName())) continue;
            TownyMessaging.sendMessage((Object)resident, string);
        }
    }
}

