/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny;

import com.palmergames.bukkit.config.CommentedConfiguration;
import com.palmergames.bukkit.config.ConfigNodes;
import com.palmergames.bukkit.towny.ChunkNotification;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlockOwner;
import com.palmergames.bukkit.towny.object.TownyObject;
import com.palmergames.bukkit.towny.object.TownyPermission;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.permissions.PermissionNodes;
import com.palmergames.bukkit.towny.war.flagwar.TownyWarConfig;
import com.palmergames.bukkit.util.NameValidation;
import com.palmergames.util.FileMgmt;
import com.palmergames.util.TimeTools;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Material;

public class TownySettings {
    private static CommentedConfiguration config;
    private static CommentedConfiguration newConfig;
    private static CommentedConfiguration language;
    private static final SortedMap<Integer, Map<TownLevel, Object>> configTownLevel;
    private static final SortedMap<Integer, Map<NationLevel, Object>> configNationLevel;

    public static void newTownLevel(int n, String string, String string2, String string3, String string4, int n2, double d) {
        ConcurrentHashMap<TownLevel, Object> concurrentHashMap = new ConcurrentHashMap<TownLevel, Object>();
        concurrentHashMap.put(TownLevel.NAME_PREFIX, string);
        concurrentHashMap.put(TownLevel.NAME_POSTFIX, string2);
        concurrentHashMap.put(TownLevel.MAYOR_PREFIX, string3);
        concurrentHashMap.put(TownLevel.MAYOR_POSTFIX, string4);
        concurrentHashMap.put(TownLevel.TOWN_BLOCK_LIMIT, n2);
        concurrentHashMap.put(TownLevel.UPKEEP_MULTIPLIER, d);
        configTownLevel.put(n, concurrentHashMap);
    }

    public static void newNationLevel(int n, String string, String string2, String string3, String string4, String string5, String string6, int n2, double d) {
        ConcurrentHashMap<NationLevel, Object> concurrentHashMap = new ConcurrentHashMap<NationLevel, Object>();
        concurrentHashMap.put(NationLevel.NAME_PREFIX, string);
        concurrentHashMap.put(NationLevel.NAME_POSTFIX, string2);
        concurrentHashMap.put(NationLevel.CAPITAL_PREFIX, string3);
        concurrentHashMap.put(NationLevel.CAPITAL_POSTFIX, string4);
        concurrentHashMap.put(NationLevel.KING_PREFIX, string5);
        concurrentHashMap.put(NationLevel.KING_POSTFIX, string6);
        concurrentHashMap.put(NationLevel.TOWN_BLOCK_LIMIT_BONUS, n2);
        concurrentHashMap.put(NationLevel.UPKEEP_MULTIPLIER, d);
        configNationLevel.put(n, concurrentHashMap);
    }

    public static void loadTownLevelConfig() throws IOException {
        List list = config.getMapList("levels.town_level");
        for (Map map : list) {
            TownySettings.newTownLevel((Integer)map.get("numResidents"), (String)map.get("namePrefix"), (String)map.get("namePostfix"), (String)map.get("mayorPrefix"), (String)map.get("mayorPostfix"), (Integer)map.get("townBlockLimit"), (Double)map.get("upkeepModifier"));
        }
    }

    public static void loadNationLevelConfig() throws IOException {
        List list = config.getMapList("levels.nation_level");
        for (Map map : list) {
            TownySettings.newNationLevel((Integer)map.get("numResidents"), (String)map.get("namePrefix"), (String)map.get("namePostfix"), (String)map.get("capitalPrefix"), (String)map.get("capitalPostfix"), (String)map.get("kingPrefix"), (String)map.get("kingPostfix"), map.containsKey("townBlockLimitBonus") ? (Integer)map.get("townBlockLimitBonus") : 0, (Double)map.get("upkeepModifier"));
        }
    }

    public static Map<TownLevel, Object> getTownLevel(int n) {
        return (Map)configTownLevel.get(n);
    }

    public static Map<NationLevel, Object> getNationLevel(int n) {
        return (Map)configNationLevel.get(n);
    }

    public static Map<TownLevel, Object> getTownLevel(Town town) {
        return TownySettings.getTownLevel(TownySettings.calcTownLevel(town));
    }

    public static Map<NationLevel, Object> getNationLevel(Nation nation) {
        return TownySettings.getNationLevel(TownySettings.calcNationLevel(nation));
    }

    public static int calcTownLevel(Town town) {
        int n = town.getNumResidents();
        for (Integer n2 : configTownLevel.keySet()) {
            if (n < n2) continue;
            return n2;
        }
        return 0;
    }

    public static int calcNationLevel(Nation nation) {
        int n = nation.getNumResidents();
        for (Integer n2 : configNationLevel.keySet()) {
            if (n < n2) continue;
            return n2;
        }
        return 0;
    }

    public static void loadConfig(String string, String string2) throws IOException {
        File file = FileMgmt.CheckYMLExists(new File(string));
        if (file != null) {
            config = new CommentedConfiguration(file);
            if (!config.load()) {
                System.out.print("Failed to load Config!");
            }
            TownySettings.setDefaults(string2, file);
            config.save();
            TownySettings.loadCachedObjects();
        }
    }

    public static void loadCachedObjects() throws IOException {
        TownyWarConfig.setFlagBaseMaterial(Material.matchMaterial((String)TownySettings.getString(ConfigNodes.WAR_ENEMY_FLAG_BASE_BLOCK)));
        TownyWarConfig.setFlagLightMaterial(Material.matchMaterial((String)TownySettings.getString(ConfigNodes.WAR_ENEMY_FLAG_LIGHT_BLOCK)));
        TownyWarConfig.setBeaconWireFrameMaterial(Material.matchMaterial((String)TownySettings.getString(ConfigNodes.WAR_ENEMY_BEACON_WIREFRAME_BLOCK)));
        TownySettings.loadTownLevelConfig();
        TownySettings.loadNationLevelConfig();
        TownyWarConfig.setEditableMaterialsInWarZone(TownySettings.getAllowedMaterials(ConfigNodes.WAR_WARZONE_EDITABLE_MATERIALS));
        ChunkNotification.loadFormatStrings();
    }

    public static void loadLanguage(String string, String string2) throws IOException {
        String string3 = TownySettings.getString(ConfigNodes.LANGUAGE.getRoot(), string2);
        String string4 = string + FileMgmt.fileSeparator() + string3;
        File file = FileMgmt.unpackResourceFile(string4, string3, string2);
        if (file != null) {
            language = new CommentedConfiguration(file);
            language.load();
        }
    }

    private static void sendError(String string) {
        System.out.println("[Towny] Error could not read " + string);
    }

    private static String[] parseString(String string) {
        return TownySettings.parseSingleLineString(string).split("@");
    }

    public static String parseSingleLineString(String string) {
        return string.replaceAll("&", "\u00a7");
    }

    public static boolean getBoolean(ConfigNodes configNodes) {
        return Boolean.parseBoolean(config.getString(configNodes.getRoot().toLowerCase(), configNodes.getDefault()));
    }

    public static double getDouble(ConfigNodes configNodes) {
        try {
            return Double.parseDouble(config.getString(configNodes.getRoot().toLowerCase(), configNodes.getDefault()).trim());
        }
        catch (NumberFormatException numberFormatException) {
            TownySettings.sendError(configNodes.getRoot().toLowerCase() + " from config.yml");
            return 0.0;
        }
    }

    public static int getInt(ConfigNodes configNodes) {
        try {
            return Integer.parseInt(config.getString(configNodes.getRoot().toLowerCase(), configNodes.getDefault()).trim());
        }
        catch (NumberFormatException numberFormatException) {
            TownySettings.sendError(configNodes.getRoot().toLowerCase() + " from config.yml");
            return 0;
        }
    }

    public static String getString(ConfigNodes configNodes) {
        return config.getString(configNodes.getRoot().toLowerCase(), configNodes.getDefault());
    }

    public static String getString(String string, String string2) {
        String string3 = config.getString(string.toLowerCase(), string2);
        if (string3 == null) {
            TownySettings.sendError(string.toLowerCase() + " from config.yml");
            return "";
        }
        return string3;
    }

    public static String getLangString(String string) {
        String string2 = language.getString(string.toLowerCase());
        if (string2 == null) {
            TownySettings.sendError(string.toLowerCase() + " from " + config.getString("language"));
            return "";
        }
        return TownySettings.parseSingleLineString(string2);
    }

    public static String getConfigLang(ConfigNodes configNodes) {
        return TownySettings.parseSingleLineString(TownySettings.getString(configNodes));
    }

    public static List<Integer> getIntArr(ConfigNodes configNodes) {
        String[] stringArray = TownySettings.getString(configNodes.getRoot(), configNodes.getDefault()).split(",");
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null) continue;
                try {
                    arrayList.add(Integer.parseInt(stringArray[i].trim()));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    TownySettings.sendError(configNodes.getRoot().toLowerCase() + " from config.yml");
                }
            }
        }
        return arrayList;
    }

    private static List<String> getStrArr(ConfigNodes configNodes) {
        String[] stringArray = TownySettings.getString(configNodes.getRoot().toLowerCase(), configNodes.getDefault()).split(",");
        ArrayList<String> arrayList = new ArrayList<String>();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null) continue;
                arrayList.add(stringArray[i].trim());
            }
        }
        return arrayList;
    }

    public static long getSeconds(ConfigNodes configNodes) {
        try {
            return TimeTools.getSeconds(TownySettings.getString(configNodes));
        }
        catch (NumberFormatException numberFormatException) {
            TownySettings.sendError(configNodes.getRoot().toLowerCase() + " from config.yml");
            return 1L;
        }
    }

    public static Set<Material> getAllowedMaterials(ConfigNodes configNodes) {
        HashSet<Material> hashSet = new HashSet<Material>();
        for (String string : TownySettings.getStrArr(configNodes)) {
            if (string.equals("*")) {
                hashSet.addAll(Arrays.asList(Material.values()));
                continue;
            }
            if (string.startsWith("-")) {
                hashSet.remove(Material.matchMaterial((String)string));
                continue;
            }
            hashSet.add(Material.matchMaterial((String)string));
        }
        return hashSet;
    }

    public static void addComment(String string, String ... stringArray) {
        newConfig.addComment(string.toLowerCase(), stringArray);
    }

    private static void setDefaults(String string, File file) {
        newConfig = new CommentedConfiguration(file);
        newConfig.load();
        for (ConfigNodes configNodes : ConfigNodes.values()) {
            if (configNodes.getComments().length > 0) {
                TownySettings.addComment(configNodes.getRoot(), configNodes.getComments());
            }
            if (configNodes.getRoot() == ConfigNodes.LEVELS.getRoot()) {
                TownySettings.setDefaultLevels();
                continue;
            }
            if (configNodes.getRoot() == ConfigNodes.LEVELS_TOWN_LEVEL.getRoot() || configNodes.getRoot() == ConfigNodes.LEVELS_NATION_LEVEL.getRoot()) continue;
            if (configNodes.getRoot() == ConfigNodes.VERSION.getRoot()) {
                TownySettings.setNewProperty(configNodes.getRoot(), string);
                continue;
            }
            if (configNodes.getRoot() == ConfigNodes.LAST_RUN_VERSION.getRoot()) {
                TownySettings.setNewProperty(configNodes.getRoot(), TownySettings.getLastRunVersion(string));
                continue;
            }
            if (configNodes.getRoot() == ConfigNodes.VERSION_BUKKIT.getRoot()) {
                TownySettings.setNewProperty(configNodes.getRoot(), ConfigNodes.VERSION_BUKKIT.getDefault());
                continue;
            }
            TownySettings.setNewProperty(configNodes.getRoot(), config.get(configNodes.getRoot().toLowerCase()) != null ? config.get(configNodes.getRoot().toLowerCase()) : configNodes.getDefault());
        }
        config = newConfig;
        newConfig = null;
    }

    private static void setDefaultLevels() {
        HashMap<String, Object> hashMap;
        ArrayList arrayList;
        TownySettings.addComment(ConfigNodes.LEVELS_TOWN_LEVEL.getRoot(), "", "# default Town levels.");
        if (!config.contains(ConfigNodes.LEVELS_TOWN_LEVEL.getRoot())) {
            arrayList = new ArrayList();
            hashMap = new HashMap<String, Object>();
            hashMap.put("numResidents", 0);
            hashMap.put("namePrefix", "");
            hashMap.put("namePostfix", " Ruins");
            hashMap.put("mayorPrefix", "Spirit ");
            hashMap.put("mayorPostfix", "");
            hashMap.put("townBlockLimit", 1);
            hashMap.put("upkeepModifier", 1.0);
            arrayList.add(new HashMap(hashMap));
            hashMap.clear();
            hashMap.put("numResidents", 1);
            hashMap.put("namePrefix", "");
            hashMap.put("namePostfix", " (Settlement)");
            hashMap.put("mayorPrefix", "Hermit ");
            hashMap.put("mayorPostfix", "");
            hashMap.put("townBlockLimit", 16);
            hashMap.put("upkeepModifier", 1.0);
            arrayList.add(new HashMap(hashMap));
            hashMap.clear();
            hashMap.put("numResidents", 2);
            hashMap.put("namePrefix", "");
            hashMap.put("namePostfix", " (Hamlet)");
            hashMap.put("mayorPrefix", "Chief ");
            hashMap.put("mayorPostfix", "");
            hashMap.put("townBlockLimit", 32);
            hashMap.put("upkeepModifier", 1.0);
            arrayList.add(new HashMap(hashMap));
            hashMap.clear();
            hashMap.put("numResidents", 6);
            hashMap.put("namePrefix", "");
            hashMap.put("namePostfix", " (Village)");
            hashMap.put("mayorPrefix", "Baron Von ");
            hashMap.put("mayorPostfix", "");
            hashMap.put("townBlockLimit", 96);
            hashMap.put("upkeepModifier", 1.0);
            arrayList.add(new HashMap(hashMap));
            hashMap.clear();
            hashMap.put("numResidents", 10);
            hashMap.put("namePrefix", "");
            hashMap.put("namePostfix", " (Town)");
            hashMap.put("mayorPrefix", "Viscount ");
            hashMap.put("mayorPostfix", "");
            hashMap.put("townBlockLimit", 160);
            hashMap.put("upkeepModifier", 1.0);
            arrayList.add(new HashMap(hashMap));
            hashMap.clear();
            hashMap.put("numResidents", 14);
            hashMap.put("namePrefix", "");
            hashMap.put("namePostfix", " (Large Town)");
            hashMap.put("mayorPrefix", "Count Von ");
            hashMap.put("mayorPostfix", "");
            hashMap.put("townBlockLimit", 224);
            hashMap.put("upkeepModifier", 1.0);
            arrayList.add(new HashMap(hashMap));
            hashMap.clear();
            hashMap.put("numResidents", 20);
            hashMap.put("namePrefix", "");
            hashMap.put("namePostfix", " (City)");
            hashMap.put("mayorPrefix", "Earl ");
            hashMap.put("mayorPostfix", "");
            hashMap.put("townBlockLimit", 320);
            hashMap.put("upkeepModifier", 1.0);
            arrayList.add(new HashMap(hashMap));
            hashMap.clear();
            hashMap.put("numResidents", 24);
            hashMap.put("namePrefix", "");
            hashMap.put("namePostfix", " (Large City)");
            hashMap.put("mayorPrefix", "Duke ");
            hashMap.put("mayorPostfix", "");
            hashMap.put("townBlockLimit", 384);
            hashMap.put("upkeepModifier", 1.0);
            arrayList.add(new HashMap(hashMap));
            hashMap.clear();
            hashMap.put("numResidents", 28);
            hashMap.put("namePrefix", "");
            hashMap.put("namePostfix", " (Metropolis)");
            hashMap.put("mayorPrefix", "Lord ");
            hashMap.put("mayorPostfix", "");
            hashMap.put("townBlockLimit", 448);
            hashMap.put("upkeepModifier", 1.0);
            arrayList.add(new HashMap(hashMap));
            hashMap.clear();
            newConfig.set(ConfigNodes.LEVELS_TOWN_LEVEL.getRoot(), arrayList);
        } else {
            newConfig.set(ConfigNodes.LEVELS_TOWN_LEVEL.getRoot(), config.get(ConfigNodes.LEVELS_TOWN_LEVEL.getRoot()));
        }
        TownySettings.addComment(ConfigNodes.LEVELS_NATION_LEVEL.getRoot(), "", "# default Nation levels.");
        if (!config.contains(ConfigNodes.LEVELS_NATION_LEVEL.getRoot())) {
            arrayList = new ArrayList();
            hashMap = new HashMap();
            hashMap.put("numResidents", 0);
            hashMap.put("namePrefix", "Land of ");
            hashMap.put("namePostfix", " (Nation)");
            hashMap.put("capitalPrefix", "");
            hashMap.put("capitalPostfix", "");
            hashMap.put("kingPrefix", "Leader ");
            hashMap.put("kingPostfix", "");
            hashMap.put("townBlockLimitBonus", 10);
            hashMap.put("upkeepModifier", 1.0);
            arrayList.add(new HashMap(hashMap));
            hashMap.clear();
            hashMap.put("numResidents", 10);
            hashMap.put("namePrefix", "Federation of ");
            hashMap.put("namePostfix", " (Nation)");
            hashMap.put("capitalPrefix", "");
            hashMap.put("capitalPostfix", "");
            hashMap.put("kingPrefix", "Count ");
            hashMap.put("kingPostfix", "");
            hashMap.put("townBlockLimitBonus", 20);
            hashMap.put("upkeepModifier", 1.0);
            arrayList.add(new HashMap(hashMap));
            hashMap.clear();
            hashMap.put("numResidents", 20);
            hashMap.put("namePrefix", "Dominion of ");
            hashMap.put("namePostfix", " (Nation)");
            hashMap.put("capitalPrefix", "");
            hashMap.put("capitalPostfix", "");
            hashMap.put("kingPrefix", "Duke ");
            hashMap.put("kingPostfix", "");
            hashMap.put("townBlockLimitBonus", 40);
            hashMap.put("upkeepModifier", 1.0);
            arrayList.add(new HashMap(hashMap));
            hashMap.clear();
            hashMap.put("numResidents", 30);
            hashMap.put("namePrefix", "Kingdom of ");
            hashMap.put("namePostfix", " (Nation)");
            hashMap.put("capitalPrefix", "");
            hashMap.put("capitalPostfix", "");
            hashMap.put("kingPrefix", "King ");
            hashMap.put("kingPostfix", "");
            hashMap.put("townBlockLimitBonus", 60);
            hashMap.put("upkeepModifier", 1.0);
            arrayList.add(new HashMap(hashMap));
            hashMap.clear();
            hashMap.put("numResidents", 40);
            hashMap.put("namePrefix", "The ");
            hashMap.put("namePostfix", " Empire");
            hashMap.put("capitalPrefix", "");
            hashMap.put("capitalPostfix", "");
            hashMap.put("kingPrefix", "Emperor ");
            hashMap.put("kingPostfix", "");
            hashMap.put("townBlockLimitBonus", 100);
            hashMap.put("upkeepModifier", 1.0);
            arrayList.add(new HashMap(hashMap));
            hashMap.clear();
            hashMap.put("numResidents", 60);
            hashMap.put("namePrefix", "The ");
            hashMap.put("namePostfix", " Realm");
            hashMap.put("capitalPrefix", "");
            hashMap.put("capitalPostfix", "");
            hashMap.put("kingPrefix", "God Emperor ");
            hashMap.put("kingPostfix", "");
            hashMap.put("townBlockLimitBonus", 140);
            hashMap.put("upkeepModifier", 1.0);
            arrayList.add(new HashMap(hashMap));
            hashMap.clear();
            newConfig.set(ConfigNodes.LEVELS_NATION_LEVEL.getRoot(), arrayList);
        } else {
            newConfig.set(ConfigNodes.LEVELS_NATION_LEVEL.getRoot(), config.get(ConfigNodes.LEVELS_NATION_LEVEL.getRoot()));
        }
    }

    public static String[] getRegistrationMsg(String string) {
        return TownySettings.parseString(String.format(TownySettings.getLangString("MSG_REGISTRATION"), string));
    }

    public static String[] getNewTownMsg(String string, String string2) {
        return TownySettings.parseString(String.format(TownySettings.getLangString("MSG_NEW_TOWN"), string, string2));
    }

    public static String[] getNewNationMsg(String string, String string2) {
        return TownySettings.parseString(String.format(TownySettings.getLangString("MSG_NEW_NATION"), string, string2));
    }

    public static String[] getJoinTownMsg(String string) {
        return TownySettings.parseString(String.format(TownySettings.getLangString("MSG_JOIN_TOWN"), string));
    }

    public static String[] getJoinNationMsg(String string) {
        return TownySettings.parseString(String.format(TownySettings.getLangString("MSG_JOIN_NATION"), string));
    }

    public static String[] getNewMayorMsg(String string) {
        return TownySettings.parseString(String.format(TownySettings.getLangString("MSG_NEW_MAYOR"), string));
    }

    public static String[] getNewKingMsg(String string, String string2) {
        return TownySettings.parseString(String.format(TownySettings.getLangString("MSG_NEW_KING"), string, string2));
    }

    public static String[] getJoinWarMsg(TownyObject townyObject) {
        return TownySettings.parseString(String.format(TownySettings.getLangString("MSG_WAR_JOIN"), townyObject.getName()));
    }

    public static String[] getWarTimeEliminatedMsg(String string) {
        return TownySettings.parseString(String.format(TownySettings.getLangString("MSG_WAR_ELIMINATED"), string));
    }

    public static String[] getWarTimeForfeitMsg(String string) {
        return TownySettings.parseString(String.format(TownySettings.getLangString("MSG_WAR_FORFEITED"), string));
    }

    public static String[] getWarTimeLoseTownBlockMsg(WorldCoord worldCoord, String string) {
        return TownySettings.parseString(String.format(TownySettings.getLangString("MSG_WAR_LOSE_BLOCK"), worldCoord.toString(), string));
    }

    public static String[] getWarTimeScoreMsg(Town town, int n) {
        return TownySettings.parseString(String.format(TownySettings.getLangString("MSG_WAR_SCORE"), town.getName(), n));
    }

    public static String[] getCouldntPayTaxesMsg(TownyObject townyObject, String string) {
        return TownySettings.parseString(String.format(TownySettings.getLangString("MSG_COULDNT_PAY_TAXES"), townyObject.getName(), string));
    }

    public static String getPayedTownTaxMsg() {
        return TownySettings.getLangString("MSG_PAYED_TOWN_TAX");
    }

    public static String getPayedResidentTaxMsg() {
        return TownySettings.getLangString("MSG_PAYED_RESIDENT_TAX");
    }

    public static String getTaxExemptMsg() {
        return TownySettings.getLangString("MSG_TAX_EXEMPT");
    }

    public static String[] getDelResidentMsg(Resident resident) {
        return TownySettings.parseString(String.format(TownySettings.getLangString("MSG_DEL_RESIDENT"), resident.getName()));
    }

    public static String[] getDelTownMsg(Town town) {
        return TownySettings.parseString(String.format(TownySettings.getLangString("MSG_DEL_TOWN"), town.getName()));
    }

    public static String[] getDelNationMsg(Nation nation) {
        return TownySettings.parseString(String.format(TownySettings.getLangString("MSG_DEL_NATION"), nation.getName()));
    }

    public static String[] getBuyResidentPlotMsg(String string, String string2, Double d) {
        return TownySettings.parseString(String.format(TownySettings.getLangString("MSG_BUY_RESIDENT_PLOT"), string, string2, d));
    }

    public static String[] getPlotForSaleMsg(String string, WorldCoord worldCoord) {
        return TownySettings.parseString(String.format(TownySettings.getLangString("MSG_PLOT_FOR_SALE"), string, worldCoord.toString()));
    }

    public static String getMayorAbondonMsg() {
        return TownySettings.parseSingleLineString(TownySettings.getLangString("MSG_MAYOR_ABANDON"));
    }

    public static String getNotPermToNewTownLine() {
        return TownySettings.parseSingleLineString(TownySettings.getLangString("MSG_ADMIN_ONLY_CREATE_TOWN"));
    }

    public static String getNotPermToNewNationLine() {
        return TownySettings.parseSingleLineString(TownySettings.getLangString("MSG_ADMIN_ONLY_CREATE_NATION"));
    }

    public static String getKingPrefix(Resident resident) {
        try {
            return (String)TownySettings.getNationLevel(resident.getTown().getNation()).get((Object)NationLevel.KING_PREFIX);
        }
        catch (NotRegisteredException notRegisteredException) {
            TownySettings.sendError("getKingPrefix.");
            return "";
        }
    }

    public static String getMayorPrefix(Resident resident) {
        try {
            return (String)TownySettings.getTownLevel(resident.getTown()).get((Object)TownLevel.MAYOR_PREFIX);
        }
        catch (NotRegisteredException notRegisteredException) {
            TownySettings.sendError("getMayorPrefix.");
            return "";
        }
    }

    public static String getCapitalPostfix(Town town) {
        try {
            return (String)TownySettings.getNationLevel(town.getNation()).get((Object)NationLevel.CAPITAL_POSTFIX);
        }
        catch (NotRegisteredException notRegisteredException) {
            TownySettings.sendError("getCapitalPostfix.");
            return "";
        }
    }

    public static String getTownPostfix(Town town) {
        try {
            return (String)TownySettings.getTownLevel(town).get((Object)TownLevel.NAME_POSTFIX);
        }
        catch (Exception exception) {
            TownySettings.sendError("getTownPostfix.");
            return "";
        }
    }

    public static String getNationPostfix(Nation nation) {
        try {
            return (String)TownySettings.getNationLevel(nation).get((Object)NationLevel.NAME_POSTFIX);
        }
        catch (Exception exception) {
            TownySettings.sendError("getNationPostfix.");
            return "";
        }
    }

    public static String getNationPrefix(Nation nation) {
        try {
            return (String)TownySettings.getNationLevel(nation).get((Object)NationLevel.NAME_PREFIX);
        }
        catch (Exception exception) {
            TownySettings.sendError("getNationPrefix.");
            return "";
        }
    }

    public static String getTownPrefix(Town town) {
        try {
            return (String)TownySettings.getTownLevel(town).get((Object)TownLevel.NAME_PREFIX);
        }
        catch (Exception exception) {
            TownySettings.sendError("getTownPrefix.");
            return "";
        }
    }

    public static String getCapitalPrefix(Town town) {
        try {
            return (String)TownySettings.getNationLevel(town.getNation()).get((Object)NationLevel.CAPITAL_PREFIX);
        }
        catch (NotRegisteredException notRegisteredException) {
            TownySettings.sendError("getCapitalPrefix.");
            return "";
        }
    }

    public static String getKingPostfix(Resident resident) {
        try {
            return (String)TownySettings.getNationLevel(resident.getTown().getNation()).get((Object)NationLevel.KING_POSTFIX);
        }
        catch (NotRegisteredException notRegisteredException) {
            TownySettings.sendError("getKingPostfix.");
            return "";
        }
    }

    public static String getMayorPostfix(Resident resident) {
        try {
            return (String)TownySettings.getTownLevel(resident.getTown()).get((Object)TownLevel.MAYOR_POSTFIX);
        }
        catch (NotRegisteredException notRegisteredException) {
            TownySettings.sendError("getMayorPostfix.");
            return "";
        }
    }

    public static String getNPCPrefix() {
        return TownySettings.getString(ConfigNodes.FILTERS_NPC_PREFIX.getRoot(), ConfigNodes.FILTERS_NPC_PREFIX.getDefault());
    }

    public static long getInactiveAfter() {
        return TownySettings.getSeconds(ConfigNodes.RES_SETTING_INACTIVE_AFTER_TIME);
    }

    public static String getLoadDatabase() {
        return TownySettings.getString(ConfigNodes.PLUGIN_DATABASE_LOAD);
    }

    public static String getSaveDatabase() {
        return TownySettings.getString(ConfigNodes.PLUGIN_DATABASE_SAVE);
    }

    public static String getSQLHostName() {
        return TownySettings.getString(ConfigNodes.PLUGIN_DATABASE_HOSTNAME);
    }

    public static String getSQLPort() {
        return TownySettings.getString(ConfigNodes.PLUGIN_DATABASE_PORT);
    }

    public static String getSQLDBName() {
        return TownySettings.getString(ConfigNodes.PLUGIN_DATABASE_DBNAME);
    }

    public static String getSQLTablePrefix() {
        return TownySettings.getString(ConfigNodes.PLUGIN_DATABASE_TABLEPREFIX);
    }

    public static String getSQLUsername() {
        return TownySettings.getString(ConfigNodes.PLUGIN_DATABASE_USERNAME);
    }

    public static String getSQLPassword() {
        return TownySettings.getString(ConfigNodes.PLUGIN_DATABASE_PASSWORD);
    }

    public static int getMaxTownBlocks(Town town) {
        int n = TownySettings.getTownBlockRatio();
        int n2 = town.getBonusBlocks() + town.getPurchasedBlocks();
        n2 = n == 0 ? (n2 += ((Integer)TownySettings.getTownLevel(town).get((Object)TownLevel.TOWN_BLOCK_LIMIT)).intValue()) : (n2 += town.getNumResidents() * n);
        if (town.hasNation()) {
            try {
                n2 += ((Integer)TownySettings.getNationLevel(town.getNation()).get((Object)NationLevel.TOWN_BLOCK_LIMIT_BONUS)).intValue();
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
        }
        return n2;
    }

    public static int getNationBonusBlocks(Nation nation) {
        return (Integer)TownySettings.getNationLevel(nation).get((Object)NationLevel.TOWN_BLOCK_LIMIT_BONUS);
    }

    public static int getNationBonusBlocks(Town town) {
        if (town.hasNation()) {
            try {
                return TownySettings.getNationBonusBlocks(town.getNation());
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
        }
        return 0;
    }

    public static int getTownBlockRatio() {
        return TownySettings.getInt(ConfigNodes.TOWN_TOWN_BLOCK_RATIO);
    }

    public static int getTownBlockSize() {
        return TownySettings.getInt(ConfigNodes.TOWN_TOWN_BLOCK_SIZE);
    }

    public static boolean getFriendlyFire() {
        return TownySettings.getBoolean(ConfigNodes.GTOWN_SETTINGS_FRIENDLY_FIRE);
    }

    public static boolean isTownCreationAdminOnly() {
        return TownySettings.getBoolean(ConfigNodes.PERMS_TOWN_CREATION_ADMIN_ONLY);
    }

    public static boolean isNationCreationAdminOnly() {
        return TownySettings.getBoolean(ConfigNodes.PERMS_NATION_CREATION_ADMIN_ONLY);
    }

    public static boolean isUsingEconomy() {
        return TownySettings.getBoolean(ConfigNodes.PLUGIN_USING_ECONOMY);
    }

    public static boolean isFakeResident(String string) {
        return TownySettings.getString(ConfigNodes.PLUGIN_MODS_FAKE_RESIDENTS).toLowerCase().contains(string.toLowerCase());
    }

    public static boolean isUsingEssentials() {
        return TownySettings.getBoolean(ConfigNodes.PLUGIN_USING_ESSENTIALS);
    }

    public static void setUsingEssentials(boolean bl) {
        TownySettings.setProperty(ConfigNodes.PLUGIN_USING_ESSENTIALS.getRoot(), bl);
    }

    public static double getNewTownPrice() {
        return TownySettings.getDouble(ConfigNodes.ECO_PRICE_NEW_TOWN);
    }

    public static double getNewNationPrice() {
        return TownySettings.getDouble(ConfigNodes.ECO_PRICE_NEW_NATION);
    }

    public static boolean getUnclaimedZoneBuildRights() {
        return TownySettings.getBoolean(ConfigNodes.UNCLAIMED_ZONE_BUILD);
    }

    public static boolean getUnclaimedZoneDestroyRights() {
        return TownySettings.getBoolean(ConfigNodes.UNCLAIMED_ZONE_DESTROY);
    }

    public static boolean getUnclaimedZoneItemUseRights() {
        return TownySettings.getBoolean(ConfigNodes.UNCLAIMED_ZONE_ITEM_USE);
    }

    public static boolean getDebug() {
        return TownySettings.getBoolean(ConfigNodes.PLUGIN_DEBUG_MODE);
    }

    public static void setDebug(boolean bl) {
        TownySettings.setProperty(ConfigNodes.PLUGIN_DEBUG_MODE.getRoot(), bl);
    }

    public static boolean getShowTownNotifications() {
        return TownySettings.getBoolean(ConfigNodes.GTOWN_SETTINGS_SHOW_TOWN_NOTIFICATIONS);
    }

    public static String getUnclaimedZoneName() {
        return TownySettings.getLangString("UNCLAIMED_ZONE_NAME");
    }

    public static int getMaxTitleLength() {
        return TownySettings.getInt(ConfigNodes.FILTERS_MODIFY_CHAT_MAX_LGTH);
    }

    public static int getMaxNameLength() {
        return TownySettings.getInt(ConfigNodes.FILTERS_MAX_NAME_LGTH);
    }

    public static long getDeleteTime() {
        return TownySettings.getSeconds(ConfigNodes.RES_SETTING_DELETE_OLD_RESIDENTS_TIME);
    }

    public static boolean isDeleteEcoAccount() {
        return TownySettings.getBoolean(ConfigNodes.RES_SETTING_DELETE_OLD_RESIDENTS_ECO);
    }

    public static boolean isDeletingOldResidents() {
        return TownySettings.getBoolean(ConfigNodes.RES_SETTING_DELETE_OLD_RESIDENTS_ENABLE);
    }

    public static int getWarTimeWarningDelay() {
        return TownySettings.getInt(ConfigNodes.WAR_EVENT_WARNING_DELAY);
    }

    public static boolean isWarTimeTownsNeutral() {
        return TownySettings.getBoolean(ConfigNodes.WAR_EVENT_TOWNS_NEUTRAL);
    }

    public static boolean isAllowWarBlockGriefing() {
        return TownySettings.getBoolean(ConfigNodes.WAR_EVENT_BLOCK_GRIEFING);
    }

    public static int getWarzoneTownBlockHealth() {
        return TownySettings.getInt(ConfigNodes.WAR_EVENT_TOWN_BLOCK_HP);
    }

    public static int getWarzoneHomeBlockHealth() {
        return TownySettings.getInt(ConfigNodes.WAR_EVENT_HOME_BLOCK_HP);
    }

    public static String[] getWarTimeLoseTownBlockMsg(WorldCoord worldCoord) {
        return TownySettings.getWarTimeLoseTownBlockMsg(worldCoord, "");
    }

    public static String getDefaultTownName() {
        return TownySettings.getString(ConfigNodes.RES_SETTING_DEFAULT_TOWN_NAME);
    }

    public static int getWarPointsForTownBlock() {
        return TownySettings.getInt(ConfigNodes.WAR_EVENT_POINTS_TOWNBLOCK);
    }

    public static int getWarPointsForTown() {
        return TownySettings.getInt(ConfigNodes.WAR_EVENT_POINTS_TOWN);
    }

    public static int getWarPointsForNation() {
        return TownySettings.getInt(ConfigNodes.WAR_EVENT_POINTS_NATION);
    }

    public static int getWarPointsForKill() {
        return TownySettings.getInt(ConfigNodes.WAR_EVENT_POINTS_KILL);
    }

    public static int getMinWarHeight() {
        return TownySettings.getInt(ConfigNodes.WAR_EVENT_MIN_HEIGHT);
    }

    public static List<String> getWorldMobRemovalEntities() {
        if (TownySettings.getDebug()) {
            System.out.println("[Towny] Debug: Reading World Mob removal entities. ");
        }
        return TownySettings.getStrArr(ConfigNodes.PROT_MOB_REMOVE_WORLD);
    }

    public static List<String> getTownMobRemovalEntities() {
        if (TownySettings.getDebug()) {
            System.out.println("[Towny] Debug: Reading Town Mob removal entities. ");
        }
        return TownySettings.getStrArr(ConfigNodes.PROT_MOB_REMOVE_TOWN);
    }

    public static boolean isRemovingVillagerBabiesWorld() {
        return TownySettings.getBoolean(ConfigNodes.PROT_MOB_REMOVE_VILLAGER_BABIES_WORLD);
    }

    public static boolean isRemovingVillagerBabiesTown() {
        return TownySettings.getBoolean(ConfigNodes.PROT_MOB_REMOVE_VILLAGER_BABIES_TOWN);
    }

    public static List<String> getWildExplosionProtectionEntities() {
        if (TownySettings.getDebug()) {
            System.out.println("[Towny] Debug: Wilderness explosion protection entities. ");
        }
        return TownySettings.getStrArr(ConfigNodes.NWS_PLOT_MANAGEMENT_WILD_ENTITY_REVERT_LIST);
    }

    public static long getMobRemovalSpeed() {
        return TownySettings.getSeconds(ConfigNodes.PROT_MOB_REMOVE_SPEED);
    }

    public static long getHealthRegenSpeed() {
        return TownySettings.getSeconds(ConfigNodes.GTOWN_SETTINGS_REGEN_SPEED);
    }

    public static boolean hasHealthRegen() {
        return TownySettings.getBoolean(ConfigNodes.GTOWN_SETTINGS_REGEN_ENABLE);
    }

    public static boolean getTownDefaultPublic() {
        return TownySettings.getBoolean(ConfigNodes.TOWN_DEF_PUBLIC);
    }

    public static boolean getTownDefaultOpen() {
        return TownySettings.getBoolean(ConfigNodes.TOWN_DEF_OPEN);
    }

    public static boolean hasTownLimit() {
        return TownySettings.getTownLimit() == 0;
    }

    public static int getTownLimit() {
        return TownySettings.getInt(ConfigNodes.TOWN_LIMIT);
    }

    public static int getMaxPurchedBlocks() {
        return TownySettings.getInt(ConfigNodes.TOWN_MAX_PURCHASED_BLOCKS);
    }

    public static boolean isSellingBonusBlocks() {
        return TownySettings.getMaxPurchedBlocks() != 0;
    }

    public static double getPurchasedBonusBlocksCost() {
        return TownySettings.getDouble(ConfigNodes.ECO_PRICE_PURCHASED_BONUS_TOWNBLOCK);
    }

    public static double getNationNeutralityCost() {
        return TownySettings.getDouble(ConfigNodes.ECO_PRICE_NATION_NEUTRALITY);
    }

    public static boolean isAllowingOutposts() {
        return TownySettings.getBoolean(ConfigNodes.GTOWN_SETTINGS_ALLOW_OUTPOSTS);
    }

    public static double getOutpostCost() {
        return TownySettings.getDouble(ConfigNodes.ECO_PRICE_OUTPOST);
    }

    public static List<Integer> getSwitchIds() {
        return TownySettings.getIntArr(ConfigNodes.PROT_SWITCH_ID);
    }

    public static List<Integer> getUnclaimedZoneIgnoreIds() {
        return TownySettings.getIntArr(ConfigNodes.UNCLAIMED_ZONE_IGNORE);
    }

    public static List<Integer> getItemUseIds() {
        return TownySettings.getIntArr(ConfigNodes.PROT_ITEM_USE_ID);
    }

    public static boolean isUnclaimedZoneIgnoreId(int n) {
        return TownySettings.getUnclaimedZoneIgnoreIds().contains(n);
    }

    public static boolean isSwitchId(int n) {
        return TownySettings.getSwitchIds().contains(n);
    }

    public static boolean isItemUseId(int n) {
        return TownySettings.getItemUseIds().contains(n);
    }

    private static void setProperty(String string, Object object) {
        config.set(string.toLowerCase(), object.toString());
    }

    private static void setNewProperty(String string, Object object) {
        if (object == null) {
            object = "";
        }
        newConfig.set(string.toLowerCase(), object.toString());
    }

    public static Object getProperty(String string) {
        return config.get(string.toLowerCase());
    }

    public static double getClaimPrice() {
        return TownySettings.getDouble(ConfigNodes.ECO_PRICE_CLAIM_TOWNBLOCK);
    }

    public static boolean getUnclaimedZoneSwitchRights() {
        return TownySettings.getBoolean(ConfigNodes.UNCLAIMED_ZONE_SWITCH);
    }

    public static boolean getEndermanProtect() {
        return TownySettings.getBoolean(ConfigNodes.NWS_WORLD_ENDERMAN);
    }

    public static String getUnclaimedPlotName() {
        return TownySettings.getLangString("UNCLAIMED_PLOT_NAME");
    }

    public static long getDayInterval() {
        return TownySettings.getSeconds(ConfigNodes.PLUGIN_DAY_INTERVAL);
    }

    public static long getNewDayTime() {
        long l;
        long l2 = TownySettings.getSeconds(ConfigNodes.PLUGIN_NEWDAY_TIME);
        if (l2 > (l = TownySettings.getDayInterval())) {
            TownySettings.setProperty(ConfigNodes.PLUGIN_NEWDAY_TIME.getRoot(), l);
            return l;
        }
        return l2;
    }

    public static boolean isAllowingTownSpawn() {
        return TownySettings.getBoolean(ConfigNodes.GTOWN_SETTINGS_ALLOW_TOWN_SPAWN);
    }

    public static boolean isAllowingPublicTownSpawnTravel() {
        return TownySettings.getBoolean(ConfigNodes.GTOWN_SETTINGS_ALLOW_TOWN_SPAWN_TRAVEL);
    }

    public static List<String> getDisallowedTownSpawnZones() {
        if (TownySettings.getDebug()) {
            System.out.println("[Towny] Debug: Reading disallowed town spawn zones. ");
        }
        return TownySettings.getStrArr(ConfigNodes.GTOWN_SETTINGS_PREVENT_TOWN_SPAWN_IN);
    }

    public static boolean isTaxingDaily() {
        return TownySettings.getBoolean(ConfigNodes.ECO_DAILY_TAXES_ENABLED);
    }

    public static double getMaxTax() {
        return TownySettings.getDouble(ConfigNodes.ECO_DAILY_TAXES_MAX_TAX);
    }

    public static double getMaxTaxPercent() {
        return TownySettings.getDouble(ConfigNodes.ECO_DAILY_TAXES_MAX_TAX_PERCENT);
    }

    public static boolean isBackingUpDaily() {
        return TownySettings.getBoolean(ConfigNodes.PLUGIN_DAILY_BACKUPS);
    }

    public static double getBaseSpoilsOfWar() {
        return TownySettings.getDouble(ConfigNodes.WAR_EVENT_BASE_SPOILS);
    }

    public static double getWartimeDeathPrice() {
        return TownySettings.getDouble(ConfigNodes.WAR_EVENT_PRICE_DEATH);
    }

    public static double getDeathPrice() {
        return TownySettings.getDouble(ConfigNodes.ECO_PRICE_DEATH);
    }

    public static double getWartimeTownBlockLossPrice() {
        return TownySettings.getDouble(ConfigNodes.WAR_EVENT_TOWN_BLOCK_LOSS_PRICE);
    }

    public static boolean isDevMode() {
        return TownySettings.getBoolean(ConfigNodes.PLUGIN_DEV_MODE_ENABLE);
    }

    public static void setDevMode(boolean bl) {
        TownySettings.setProperty(ConfigNodes.PLUGIN_DEV_MODE_ENABLE.getRoot(), bl);
    }

    public static String getDevName() {
        return TownySettings.getString(ConfigNodes.PLUGIN_DEV_MODE_DEV_NAME);
    }

    public static boolean isDeclaringNeutral() {
        return TownySettings.getBoolean(ConfigNodes.WARTIME_NATION_CAN_BE_NEUTRAL);
    }

    public static void setDeclaringNeutral(boolean bl) {
        TownySettings.setProperty(ConfigNodes.WARTIME_NATION_CAN_BE_NEUTRAL.getRoot(), bl);
    }

    public static boolean isRemovingOnMonarchDeath() {
        return TownySettings.getBoolean(ConfigNodes.WAR_EVENT_REMOVE_ON_MONARCH_DEATH);
    }

    public static double getTownUpkeepCost(Town town) {
        double d = town != null ? (TownySettings.isUpkeepByPlot() ? (double)town.getTownBlocks().size() : Double.valueOf(TownySettings.getTownLevel(town).get((Object)TownLevel.UPKEEP_MULTIPLIER).toString())) : 1.0;
        return TownySettings.getTownUpkeep() * d;
    }

    public static double getTownUpkeep() {
        return TownySettings.getDouble(ConfigNodes.ECO_PRICE_TOWN_UPKEEP);
    }

    public static boolean isUpkeepByPlot() {
        return TownySettings.getBoolean(ConfigNodes.ECO_PRICE_TOWN_UPKEEP_PLOTBASED);
    }

    public static boolean isUpkeepPayingPlots() {
        return TownySettings.getBoolean(ConfigNodes.ECO_UPKEEP_PLOTPAYMENTS);
    }

    public static double getNationUpkeep() {
        return TownySettings.getDouble(ConfigNodes.ECO_PRICE_NATION_UPKEEP);
    }

    public static double getNationUpkeepCost(Nation nation) {
        double d = nation != null ? Double.valueOf(TownySettings.getNationLevel(nation).get((Object)NationLevel.UPKEEP_MULTIPLIER).toString()) : 1.0;
        return TownySettings.getNationUpkeep() * d;
    }

    public static String getFlatFileBackupType() {
        return TownySettings.getString(ConfigNodes.PLUGIN_FLATFILE_BACKUP);
    }

    public static long getBackupLifeLength() {
        long l = TimeTools.getMillis(TownySettings.getString(ConfigNodes.PLUGIN_BACKUPS_ARE_DELETED_AFTER));
        long l2 = TimeTools.getMillis("1d");
        if (l >= 0L && l < l2) {
            l = l2;
        }
        return l;
    }

    public static boolean isPvP() {
        return TownySettings.getBoolean(ConfigNodes.NWS_WORLD_PVP);
    }

    public static boolean isForcingPvP() {
        return TownySettings.getBoolean(ConfigNodes.NWS_FORCE_PVP_ON);
    }

    public static boolean isPlayerTramplingCropsDisabled() {
        return TownySettings.getBoolean(ConfigNodes.NWS_DISABLE_PLAYER_CROP_TRAMPLING);
    }

    public static boolean isCreatureTramplingCropsDisabled() {
        return TownySettings.getBoolean(ConfigNodes.NWS_DISABLE_CREATURE_CROP_TRAMPLING);
    }

    public static boolean isWorldMonstersOn() {
        return TownySettings.getBoolean(ConfigNodes.NWS_WORLD_MONSTERS_ON);
    }

    public static boolean isExplosions() {
        return TownySettings.getBoolean(ConfigNodes.NWS_WORLD_EXPLOSION);
    }

    public static boolean isForcingExplosions() {
        return TownySettings.getBoolean(ConfigNodes.NWS_FORCE_EXPLOSIONS_ON);
    }

    public static boolean isForcingMonsters() {
        return TownySettings.getBoolean(ConfigNodes.NWS_FORCE_TOWN_MONSTERS_ON);
    }

    public static boolean isFire() {
        return TownySettings.getBoolean(ConfigNodes.NWS_WORLD_FIRE);
    }

    public static boolean isForcingFire() {
        return TownySettings.getBoolean(ConfigNodes.NWS_FORCE_FIRE_ON);
    }

    public static boolean isUsingPlotManagementDelete() {
        return TownySettings.getBoolean(ConfigNodes.NWS_PLOT_MANAGEMENT_DELETE_ENABLE);
    }

    public static List<Integer> getPlotManagementDeleteIds() {
        return TownySettings.getIntArr(ConfigNodes.NWS_PLOT_MANAGEMENT_DELETE);
    }

    public static boolean isUsingPlotManagementMayorDelete() {
        return TownySettings.getBoolean(ConfigNodes.NWS_PLOT_MANAGEMENT_MAYOR_DELETE_ENABLE);
    }

    public static List<String> getPlotManagementMayorDelete() {
        return TownySettings.getStrArr(ConfigNodes.NWS_PLOT_MANAGEMENT_MAYOR_DELETE);
    }

    public static boolean isUsingPlotManagementRevert() {
        return TownySettings.getBoolean(ConfigNodes.NWS_PLOT_MANAGEMENT_REVERT_ENABLE);
    }

    public static long getPlotManagementSpeed() {
        return TownySettings.getSeconds(ConfigNodes.NWS_PLOT_MANAGEMENT_REVERT_TIME);
    }

    public static boolean isUsingPlotManagementWildRegen() {
        return TownySettings.getBoolean(ConfigNodes.NWS_PLOT_MANAGEMENT_WILD_MOB_REVERT_ENABLE);
    }

    public static long getPlotManagementWildRegenDelay() {
        return TownySettings.getSeconds(ConfigNodes.NWS_PLOT_MANAGEMENT_WILD_MOB_REVERT_TIME);
    }

    public static List<Integer> getPlotManagementIgnoreIds() {
        return TownySettings.getIntArr(ConfigNodes.NWS_PLOT_MANAGEMENT_REVERT_IGNORE);
    }

    public static boolean isTownRespawning() {
        return TownySettings.getBoolean(ConfigNodes.GTOWN_SETTINGS_TOWN_RESPAWN);
    }

    public static boolean isTownRespawningInOtherWorlds() {
        return TownySettings.getBoolean(ConfigNodes.GTOWN_SETTINGS_TOWN_RESPAWN_SAME_WORLD_ONLY);
    }

    public static boolean isTownyUpdating(String string) {
        return !TownySettings.isTownyUpToDate(string);
    }

    public static int getMinBukkitVersion() {
        return TownySettings.getInt(ConfigNodes.VERSION_BUKKIT);
    }

    public static boolean isBypassVersionCheck() {
        return TownySettings.getBoolean(ConfigNodes.VERSION_BUKKIT_BYPASS);
    }

    public static boolean isTownyUpToDate(String string) {
        return string.equals(TownySettings.getLastRunVersion(string));
    }

    public static String getLastRunVersion(String string) {
        return TownySettings.getString(ConfigNodes.LAST_RUN_VERSION.getRoot(), string);
    }

    public static void setLastRunVersion(String string) {
        TownySettings.setProperty(ConfigNodes.LAST_RUN_VERSION.getRoot(), string);
        config.save();
    }

    public static int getMinDistanceFromTownHomeblocks() {
        return TownySettings.getInt(ConfigNodes.TOWN_MIN_DISTANCE_FROM_TOWN_HOMEBLOCK);
    }

    public static int getMaxDistanceBetweenHomeblocks() {
        return TownySettings.getInt(ConfigNodes.TOWN_MAX_DISTANCE_BETWEEN_HOMEBLOCKS);
    }

    public static int getMaxResidentPlots(Resident resident) {
        int n = TownyUniverse.getPermissionSource().getGroupPermissionIntNode(resident.getName(), PermissionNodes.TOWNY_MAX_PLOTS.getNode());
        if (n == -1) {
            n = TownySettings.getInt(ConfigNodes.TOWN_MAX_PLOTS_PER_RESIDENT);
        }
        return n;
    }

    public static boolean getPermFlag_Resident_Friend_Build() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_RES_FR_BUILD);
    }

    public static boolean getPermFlag_Resident_Friend_Destroy() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_RES_FR_DESTROY);
    }

    public static boolean getPermFlag_Resident_Friend_ItemUse() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_RES_FR_ITEM_USE);
    }

    public static boolean getPermFlag_Resident_Friend_Switch() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_RES_FR_SWITCH);
    }

    public static boolean getPermFlag_Resident_Ally_Build() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_RES_ALLY_BUILD);
    }

    public static boolean getPermFlag_Resident_Ally_Destroy() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_RES_ALLY_DESTROY);
    }

    public static boolean getPermFlag_Resident_Ally_ItemUse() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_RES_ALLY_ITEM_USE);
    }

    public static boolean getPermFlag_Resident_Ally_Switch() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_RES_ALLY_SWITCH);
    }

    public static boolean getPermFlag_Resident_Outsider_Build() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_RES_OUTSIDER_BUILD);
    }

    public static boolean getPermFlag_Resident_Outsider_Destroy() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_RES_OUTSIDER_DESTROY);
    }

    public static boolean getPermFlag_Resident_Outsider_ItemUse() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_RES_OUTSIDER_ITEM_USE);
    }

    public static boolean getPermFlag_Resident_Outsider_Switch() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_RES_OUTSIDER_SWITCH);
    }

    public static boolean getPermFlag_Town_Default_PVP() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_TOWN_DEF_PVP);
    }

    public static boolean getPermFlag_Town_Default_FIRE() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_TOWN_DEF_FIRE);
    }

    public static boolean getPermFlag_Town_Default_Explosion() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_TOWN_DEF_EXPLOSION);
    }

    public static boolean getPermFlag_Town_Default_Mobs() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_TOWN_DEF_MOBS);
    }

    public static boolean getPermFlag_Town_Resident_Build() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_TOWN_RES_BUILD);
    }

    public static boolean getPermFlag_Town_Resident_Destroy() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_TOWN_RES_DESTROY);
    }

    public static boolean getPermFlag_Town_Resident_ItemUse() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_TOWN_RES_ITEM_USE);
    }

    public static boolean getPermFlag_Town_Resident_Switch() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_TOWN_RES_SWITCH);
    }

    public static boolean getPermFlag_Town_Ally_Build() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_TOWN_ALLY_BUILD);
    }

    public static boolean getPermFlag_Town_Ally_Destroy() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_TOWN_ALLY_DESTROY);
    }

    public static boolean getPermFlag_Town_Ally_ItemUse() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_TOWN_ALLY_ITEM_USE);
    }

    public static boolean getPermFlag_Town_Ally_Switch() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_TOWN_ALLY_SWITCH);
    }

    public static boolean getPermFlag_Town_Outsider_Build() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_TOWN_OUTSIDER_BUILD);
    }

    public static boolean getPermFlag_Town_Outsider_Destroy() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_TOWN_OUTSIDER_DESTROY);
    }

    public static boolean getPermFlag_Town_Outsider_ItemUse() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_TOWN_OUTSIDER_ITEM_USE);
    }

    public static boolean getPermFlag_Town_Outsider_Switch() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_TOWN_OUTSIDER_SWITCH);
    }

    public static boolean getDefaultResidentPermission(TownBlockOwner townBlockOwner, TownyPermission.ActionType actionType) {
        if (townBlockOwner instanceof Resident) {
            switch (actionType) {
                case BUILD: {
                    return TownySettings.getPermFlag_Resident_Friend_Build();
                }
                case DESTROY: {
                    return TownySettings.getPermFlag_Resident_Friend_Destroy();
                }
                case SWITCH: {
                    return TownySettings.getPermFlag_Resident_Friend_Switch();
                }
                case ITEM_USE: {
                    return TownySettings.getPermFlag_Resident_Friend_ItemUse();
                }
            }
            throw new UnsupportedOperationException();
        }
        if (townBlockOwner instanceof Town) {
            switch (actionType) {
                case BUILD: {
                    return TownySettings.getPermFlag_Town_Resident_Build();
                }
                case DESTROY: {
                    return TownySettings.getPermFlag_Town_Resident_Destroy();
                }
                case SWITCH: {
                    return TownySettings.getPermFlag_Town_Resident_Switch();
                }
                case ITEM_USE: {
                    return TownySettings.getPermFlag_Town_Resident_ItemUse();
                }
            }
            throw new UnsupportedOperationException();
        }
        throw new UnsupportedOperationException();
    }

    public static boolean getDefaultAllyPermission(TownBlockOwner townBlockOwner, TownyPermission.ActionType actionType) {
        if (townBlockOwner instanceof Resident) {
            switch (actionType) {
                case BUILD: {
                    return TownySettings.getPermFlag_Resident_Ally_Build();
                }
                case DESTROY: {
                    return TownySettings.getPermFlag_Resident_Ally_Destroy();
                }
                case SWITCH: {
                    return TownySettings.getPermFlag_Resident_Ally_Switch();
                }
                case ITEM_USE: {
                    return TownySettings.getPermFlag_Resident_Ally_ItemUse();
                }
            }
            throw new UnsupportedOperationException();
        }
        if (townBlockOwner instanceof Town) {
            switch (actionType) {
                case BUILD: {
                    return TownySettings.getPermFlag_Town_Ally_Build();
                }
                case DESTROY: {
                    return TownySettings.getPermFlag_Town_Ally_Destroy();
                }
                case SWITCH: {
                    return TownySettings.getPermFlag_Town_Ally_Switch();
                }
                case ITEM_USE: {
                    return TownySettings.getPermFlag_Town_Ally_ItemUse();
                }
            }
            throw new UnsupportedOperationException();
        }
        throw new UnsupportedOperationException();
    }

    public static boolean getDefaultOutsiderPermission(TownBlockOwner townBlockOwner, TownyPermission.ActionType actionType) {
        if (townBlockOwner instanceof Resident) {
            switch (actionType) {
                case BUILD: {
                    return TownySettings.getPermFlag_Resident_Outsider_Build();
                }
                case DESTROY: {
                    return TownySettings.getPermFlag_Resident_Outsider_Destroy();
                }
                case SWITCH: {
                    return TownySettings.getPermFlag_Resident_Outsider_Switch();
                }
                case ITEM_USE: {
                    return TownySettings.getPermFlag_Resident_Outsider_ItemUse();
                }
            }
            throw new UnsupportedOperationException();
        }
        if (townBlockOwner instanceof Town) {
            switch (actionType) {
                case BUILD: {
                    return TownySettings.getPermFlag_Town_Outsider_Build();
                }
                case DESTROY: {
                    return TownySettings.getPermFlag_Town_Outsider_Destroy();
                }
                case SWITCH: {
                    return TownySettings.getPermFlag_Town_Outsider_Switch();
                }
                case ITEM_USE: {
                    return TownySettings.getPermFlag_Town_Outsider_ItemUse();
                }
            }
            throw new UnsupportedOperationException();
        }
        throw new UnsupportedOperationException();
    }

    public static boolean getDefaultPermission(TownBlockOwner townBlockOwner, TownyPermission.PermLevel permLevel, TownyPermission.ActionType actionType) {
        switch (permLevel) {
            case RESIDENT: {
                return TownySettings.getDefaultResidentPermission(townBlockOwner, actionType);
            }
            case ALLY: {
                return TownySettings.getDefaultAllyPermission(townBlockOwner, actionType);
            }
            case OUTSIDER: {
                return TownySettings.getDefaultOutsiderPermission(townBlockOwner, actionType);
            }
        }
        throw new UnsupportedOperationException();
    }

    public static boolean isLogging() {
        return TownySettings.getBoolean(ConfigNodes.PLUGIN_LOGGING);
    }

    public static boolean isUsingQuestioner() {
        return TownySettings.getBoolean(ConfigNodes.PLUGIN_USING_QUESTIONER_ENABLE);
    }

    public static void setUsingQuestioner(boolean bl) {
        TownySettings.setProperty(ConfigNodes.PLUGIN_USING_QUESTIONER_ENABLE.getRoot(), bl);
    }

    public static String questionerAccept() {
        return TownySettings.getString(ConfigNodes.PLUGIN_QUESTIONER_ACCEPT);
    }

    public static String questionerDeny() {
        return TownySettings.getString(ConfigNodes.PLUGIN_QUESTIONER_DENY);
    }

    public static boolean isAppendingToLog() {
        return !TownySettings.getBoolean(ConfigNodes.PLUGIN_RESET_LOG_ON_BOOT);
    }

    public static boolean isUsingPermissions() {
        return TownySettings.getBoolean(ConfigNodes.PLUGIN_USING_PERMISSIONS);
    }

    public static void setUsingPermissions(boolean bl) {
        TownySettings.setProperty(ConfigNodes.PLUGIN_USING_PERMISSIONS.getRoot(), bl);
    }

    public static String getNameFilterRegex() {
        return TownySettings.getString(ConfigNodes.FILTERS_REGEX_NAME_FILTER_REGEX);
    }

    public static String getNameCheckRegex() {
        return TownySettings.getString(ConfigNodes.FILTERS_REGEX_NAME_CHECK_REGEX);
    }

    public static String getNameRemoveRegex() {
        return TownySettings.getString(ConfigNodes.FILTERS_REGEX_NAME_REMOVE_REGEX);
    }

    public static boolean isUsingCheatProtection() {
        return TownySettings.getBoolean(ConfigNodes.PROT_CHEAT);
    }

    public static long getRegenDelay() {
        return TownySettings.getSeconds(ConfigNodes.PROT_REGEN_DELAY);
    }

    public static int getTeleportWarmupTime() {
        return TownySettings.getInt(ConfigNodes.GTOWN_SETTINGS_SPAWN_TIMER);
    }

    public static double getTownBankCap() {
        return TownySettings.getDouble(ConfigNodes.ECO_BANK_CAP_TOWN);
    }

    public static double getNationBankCap() {
        return TownySettings.getDouble(ConfigNodes.ECO_BANK_CAP_NATION);
    }

    public static boolean getTownBankAllowWithdrawls() {
        return TownySettings.getBoolean(ConfigNodes.ECO_BANK_TOWN_ALLOW_WITHDRAWLS);
    }

    public static void SetTownBankAllowWithdrawls(boolean bl) {
        TownySettings.setProperty(ConfigNodes.ECO_BANK_TOWN_ALLOW_WITHDRAWLS.getRoot(), bl);
    }

    public static boolean geNationBankAllowWithdrawls() {
        return TownySettings.getBoolean(ConfigNodes.ECO_BANK_NATION_ALLOW_WITHDRAWLS);
    }

    public static void SetNationBankAllowWithdrawls(boolean bl) {
        TownySettings.setProperty(ConfigNodes.ECO_BANK_NATION_ALLOW_WITHDRAWLS.getRoot(), bl);
    }

    @Deprecated
    public static boolean isValidRegionName(String string) {
        return !NameValidation.isBlacklistName(string);
    }

    @Deprecated
    public static boolean isValidName(String string) {
        return NameValidation.isValidName(string);
    }

    @Deprecated
    public static String filterName(String string) {
        return NameValidation.filterName(string);
    }

    static {
        configTownLevel = Collections.synchronizedSortedMap(new TreeMap(Collections.reverseOrder()));
        configNationLevel = Collections.synchronizedSortedMap(new TreeMap(Collections.reverseOrder()));
    }

    public static enum NationLevel {
        NAME_PREFIX,
        NAME_POSTFIX,
        CAPITAL_PREFIX,
        CAPITAL_POSTFIX,
        KING_PREFIX,
        KING_POSTFIX,
        TOWN_BLOCK_LIMIT_BONUS,
        UPKEEP_MULTIPLIER;

    }

    public static enum TownLevel {
        NAME_PREFIX,
        NAME_POSTFIX,
        MAYOR_PREFIX,
        MAYOR_POSTFIX,
        TOWN_BLOCK_LIMIT,
        UPKEEP_MULTIPLIER;

    }
}

