/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.command;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyFormatter;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.command.TownCommand;
import com.palmergames.bukkit.towny.exceptions.EconomyException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockOwner;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.permissions.PermissionNodes;
import com.palmergames.bukkit.towny.regen.TownyRegenAPI;
import com.palmergames.bukkit.towny.tasks.PlotClaim;
import com.palmergames.bukkit.towny.utils.AreaSelectionUtil;
import com.palmergames.bukkit.util.ChatTools;
import com.palmergames.bukkit.util.Colors;
import com.palmergames.util.StringMgmt;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class PlotCommand
implements CommandExecutor {
    private static Towny plugin;
    public static final List<String> output;

    public PlotCommand(Towny towny) {
        plugin = towny;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean onCommand(CommandSender commandSender, Command command, String string, String[] stringArray) {
        if (commandSender instanceof Player) {
            Player player = (Player)commandSender;
            System.out.println("[PLAYER_COMMAND] " + player.getName() + ": /" + string + " " + StringMgmt.join(stringArray));
            if (stringArray == null) {
                for (String string2 : output) {
                    player.sendMessage(string2);
                }
                return true;
            }
            try {
                return this.parsePlotCommand(player, stringArray);
            }
            catch (TownyException townyException) {
                TownyMessaging.sendErrorMsg((Object)player, townyException.getMessage());
                return true;
            }
        }
        for (String string3 : output) {
            commandSender.sendMessage(Colors.strip(string3));
        }
        return true;
    }

    public boolean parsePlotCommand(Player player, String[] stringArray) throws TownyException {
        if (stringArray.length == 0 || stringArray[0].equalsIgnoreCase("?")) {
            for (String string : output) {
                player.sendMessage(string);
            }
        } else {
            String string;
            Resident resident;
            try {
                resident = TownyUniverse.getDataSource().getResident(player.getName());
                string = player.getWorld().getName();
                resident.getTown();
            }
            catch (TownyException townyException) {
                TownyMessaging.sendErrorMsg((Object)player, townyException.getMessage());
                return true;
            }
            try {
                if (stringArray[0].equalsIgnoreCase("claim")) {
                    if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_PLOT_CLAIM.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    if (TownyUniverse.isWarTime()) {
                        throw new TownyException(TownySettings.getLangString("msg_war_cannot_do"));
                    }
                    List<WorldCoord> list = AreaSelectionUtil.selectWorldCoordArea(resident, new WorldCoord(string, Coord.parseCoord((Entity)player)), StringMgmt.remFirstArg(stringArray));
                    if (list.size() > 0) {
                        double d = 0.0;
                        for (WorldCoord worldCoord : new ArrayList<WorldCoord>(list)) {
                            try {
                                double d2 = worldCoord.getTownBlock().getPlotPrice();
                                if (d2 > -1.0) {
                                    d += worldCoord.getTownBlock().getPlotPrice();
                                    continue;
                                }
                                if (worldCoord.getTownBlock().getTown().isMayor(resident)) continue;
                                list.remove(worldCoord);
                            }
                            catch (NotRegisteredException notRegisteredException) {
                                list.remove(worldCoord);
                            }
                        }
                        int n = TownySettings.getMaxResidentPlots(resident);
                        if (n >= 0 && resident.getTownBlocks().size() + list.size() > n) {
                            throw new TownyException(String.format(TownySettings.getLangString("msg_max_plot_own"), n));
                        }
                        if (TownySettings.isUsingEconomy() && !resident.canPayFromHoldings(d)) {
                            throw new TownyException(String.format(TownySettings.getLangString("msg_no_funds_claim"), list.size(), TownyEconomyHandler.getFormattedBalance(d)));
                        }
                        new PlotClaim(plugin, player, resident, list, true).start();
                    }
                    player.sendMessage(TownySettings.getLangString("msg_err_empty_area_selection"));
                }
                if (stringArray[0].equalsIgnoreCase("unclaim")) {
                    if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_PLOT_UNCLAIM.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    if (TownyUniverse.isWarTime()) {
                        throw new TownyException(TownySettings.getLangString("msg_war_cannot_do"));
                    }
                    if (stringArray.length == 2 && stringArray[1].equalsIgnoreCase("all")) {
                        new PlotClaim(plugin, player, resident, null, false).start();
                    }
                    List<WorldCoord> list = AreaSelectionUtil.selectWorldCoordArea(resident, new WorldCoord(string, Coord.parseCoord((Entity)player)), StringMgmt.remFirstArg(stringArray));
                    if ((list = AreaSelectionUtil.filterOwnedBlocks(resident, list)).size() > 0) {
                        new PlotClaim(plugin, player, resident, list, false).start();
                    }
                    player.sendMessage(TownySettings.getLangString("msg_err_empty_area_selection"));
                }
                if (stringArray[0].equalsIgnoreCase("notforsale") || stringArray[0].equalsIgnoreCase("nfs")) {
                    if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_PLOT_NOTFORSALE.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    List<WorldCoord> list = AreaSelectionUtil.selectWorldCoordArea(resident, new WorldCoord(string, Coord.parseCoord((Entity)player)), StringMgmt.remFirstArg(stringArray));
                    list = AreaSelectionUtil.filterOwnedBlocks(resident.getTown(), list);
                    for (WorldCoord worldCoord : list) {
                        this.setPlotForSale(resident, worldCoord, -1.0);
                    }
                }
                if (stringArray[0].equalsIgnoreCase("forsale") || stringArray[0].equalsIgnoreCase("fs")) {
                    if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_PLOT_FORSALE.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    WorldCoord worldCoord = new WorldCoord(string, Coord.parseCoord((Entity)player));
                    double d = worldCoord.getTownBlock().getTown().getPlotTypePrice(worldCoord.getTownBlock().getType());
                    if (stringArray.length > 1) {
                        List<Object> list;
                        int n = AreaSelectionUtil.getAreaSelectPivot(stringArray);
                        if (n >= 0) {
                            list = AreaSelectionUtil.selectWorldCoordArea(resident, new WorldCoord(string, Coord.parseCoord((Entity)player)), StringMgmt.subArray(stringArray, n + 1, stringArray.length));
                            list = AreaSelectionUtil.filterOwnedBlocks(resident.getTown(), list);
                            if (list.size() == 0) {
                                player.sendMessage(TownySettings.getLangString("msg_err_empty_area_selection"));
                                return true;
                            }
                        } else {
                            list = new ArrayList<WorldCoord>();
                            list.add(worldCoord);
                        }
                        if (n != 1) {
                            try {
                                d = Double.parseDouble(stringArray[1]);
                                if (d < 0.0) {
                                    TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_negative_money"));
                                    return true;
                                }
                            }
                            catch (NumberFormatException numberFormatException) {
                                player.sendMessage(String.format(TownySettings.getLangString("msg_error_must_be_num"), new Object[0]));
                                return true;
                            }
                        }
                        for (WorldCoord worldCoord2 : list) {
                            if (list.size() > 1) {
                                d = worldCoord2.getTownBlock().getTown().getPlotTypePrice(worldCoord2.getTownBlock().getType());
                            }
                            this.setPlotForSale(resident, worldCoord2, d);
                        }
                    }
                    this.setPlotForSale(resident, worldCoord, d);
                }
                if (stringArray[0].equalsIgnoreCase("perm")) {
                    if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_PLOT_PERM.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    TownBlock townBlock = new WorldCoord(string, Coord.parseCoord((Entity)player)).getTownBlock();
                    TownyMessaging.sendMessage((Object)player, TownyFormatter.getStatus(townBlock));
                }
                if (stringArray[0].equalsIgnoreCase("toggle")) {
                    TownBlock townBlock = new WorldCoord(string, Coord.parseCoord((Entity)player)).getTownBlock();
                    this.plotTestOwner(resident, townBlock);
                    this.plotToggle(player, new WorldCoord(string, Coord.parseCoord((Entity)player)).getTownBlock(), StringMgmt.remFirstArg(stringArray));
                }
                if (stringArray[0].equalsIgnoreCase("set")) {
                    if ((stringArray = StringMgmt.remFirstArg(stringArray)).length > 0) {
                        if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_PLOT_SET.getNode(stringArray[0].toLowerCase()))) {
                            throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                        }
                        if (stringArray[0].equalsIgnoreCase("perm")) {
                            TownBlock townBlock = new WorldCoord(string, Coord.parseCoord((Entity)player)).getTownBlock();
                            TownBlockOwner townBlockOwner = this.plotTestOwner(resident, townBlock);
                            this.toggleTest(player, townBlock, StringMgmt.join(StringMgmt.remFirstArg(stringArray), ""));
                            TownCommand.setTownBlockPermissions(player, townBlockOwner, townBlock.getPermissions(), StringMgmt.remFirstArg(stringArray), true);
                            townBlock.setChanged(true);
                            TownyUniverse.getDataSource().saveTownBlock(townBlock);
                            return true;
                        }
                        WorldCoord worldCoord = new WorldCoord(string, Coord.parseCoord((Entity)player));
                        TownBlock townBlock = worldCoord.getTownBlock();
                        this.setPlotType(resident, worldCoord, stringArray[0]);
                        townBlock.setChanged(true);
                        TownyUniverse.getDataSource().saveTownBlock(townBlock);
                        player.sendMessage(String.format(TownySettings.getLangString("msg_plot_set_type"), stringArray[0]));
                    }
                    player.sendMessage(ChatTools.formatCommand("", "/plot set", "reset", ""));
                    player.sendMessage(ChatTools.formatCommand("", "/plot set", "shop|embassy|arena|wilds|spleef", ""));
                    player.sendMessage(ChatTools.formatCommand("", "/plot set perm", "?", ""));
                }
                if (stringArray[0].equalsIgnoreCase("clear")) {
                    if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_PLOT_CLEAR.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    TownBlock townBlock = new WorldCoord(string, Coord.parseCoord((Entity)player)).getTownBlock();
                    if (townBlock != null) {
                        if (townBlock.hasResident()) {
                            if (!townBlock.isOwner(resident)) {
                                player.sendMessage(TownySettings.getLangString("msg_area_not_own"));
                                return true;
                            }
                        } else if (!townBlock.getTown().equals(resident.getTown())) {
                            player.sendMessage(TownySettings.getLangString("msg_area_not_own"));
                            return true;
                        }
                        for (String string2 : TownyUniverse.getDataSource().getWorld(string).getPlotManagementMayorDelete()) {
                            if (Material.matchMaterial((String)string2) != null) {
                                TownyRegenAPI.deleteTownBlockMaterial(townBlock, Material.getMaterial((String)string2).getId());
                                player.sendMessage(String.format(TownySettings.getLangString("msg_clear_plot_material"), string2));
                                continue;
                            }
                            throw new TownyException(String.format(TownySettings.getLangString("msg_err_invalid_property"), string2));
                        }
                    }
                    player.sendMessage(TownySettings.getLangString("msg_err_empty_area_selection"));
                }
                throw new TownyException(String.format(TownySettings.getLangString("msg_err_invalid_property"), stringArray[0]));
            }
            catch (TownyException townyException) {
                TownyMessaging.sendErrorMsg((Object)player, townyException.getMessage());
            }
            catch (EconomyException economyException) {
                TownyMessaging.sendErrorMsg((Object)player, economyException.getMessage());
            }
        }
        return true;
    }

    public void setPlotType(Resident resident, WorldCoord worldCoord, String string) throws TownyException {
        if (resident.hasTown()) {
            try {
                TownBlock townBlock = worldCoord.getTownBlock();
                this.plotTestOwner(resident, townBlock);
                townBlock.setType(string);
            }
            catch (NotRegisteredException notRegisteredException) {
                throw new TownyException(TownySettings.getLangString("msg_err_not_part_town"));
            }
        } else {
            throw new TownyException(TownySettings.getLangString("msg_err_must_belong_town"));
        }
    }

    public void setPlotForSale(Resident resident, WorldCoord worldCoord, double d) throws TownyException {
        if (resident.hasTown()) {
            try {
                TownBlock townBlock = worldCoord.getTownBlock();
                this.plotTestOwner(resident, townBlock);
                townBlock.setPlotPrice(d);
                if (d != -1.0) {
                    TownyMessaging.sendTownMessage(townBlock.getTown(), TownySettings.getPlotForSaleMsg(resident.getName(), worldCoord));
                } else {
                    TownyUniverse.getPlayer(resident).sendMessage(TownySettings.getLangString("msg_err_plot_nfs"));
                }
                TownyUniverse.getDataSource().saveTown(townBlock.getTown());
            }
            catch (NotRegisteredException notRegisteredException) {
                throw new TownyException(TownySettings.getLangString("msg_err_not_part_town"));
            }
        } else {
            throw new TownyException(TownySettings.getLangString("msg_err_must_belong_town"));
        }
    }

    public void plotToggle(Player player, TownBlock townBlock, String[] stringArray) {
        if (stringArray.length == 0) {
            player.sendMessage(ChatTools.formatTitle("/res toggle"));
            player.sendMessage(ChatTools.formatCommand("", "/res toggle", "pvp", ""));
            player.sendMessage(ChatTools.formatCommand("", "/res toggle", "explosion", ""));
            player.sendMessage(ChatTools.formatCommand("", "/res toggle", "fire", ""));
            player.sendMessage(ChatTools.formatCommand("", "/res toggle", "mobs", ""));
        } else {
            try {
                if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_PLOT_TOGGLE.getNode(stringArray[0].toLowerCase()))) {
                    throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                }
                if (stringArray[0].equalsIgnoreCase("pvp")) {
                    this.toggleTest(player, townBlock, StringMgmt.join(stringArray, " "));
                    townBlock.getPermissions().pvp = !townBlock.getPermissions().pvp;
                    TownyMessaging.sendMessage((Object)player, String.format(TownySettings.getLangString("msg_changed_pvp"), "Plot", townBlock.getPermissions().pvp ? "Enabled" : "Disabled"));
                } else if (stringArray[0].equalsIgnoreCase("explosion")) {
                    this.toggleTest(player, townBlock, StringMgmt.join(stringArray, " "));
                    townBlock.getPermissions().explosion = !townBlock.getPermissions().explosion;
                    TownyMessaging.sendMessage((Object)player, String.format(TownySettings.getLangString("msg_changed_expl"), "the Plot", townBlock.getPermissions().explosion ? "Enabled" : "Disabled"));
                } else if (stringArray[0].equalsIgnoreCase("fire")) {
                    this.toggleTest(player, townBlock, StringMgmt.join(stringArray, " "));
                    townBlock.getPermissions().fire = !townBlock.getPermissions().fire;
                    TownyMessaging.sendMessage((Object)player, String.format(TownySettings.getLangString("msg_changed_fire"), "the Plot", townBlock.getPermissions().fire ? "Enabled" : "Disabled"));
                } else if (stringArray[0].equalsIgnoreCase("mobs")) {
                    this.toggleTest(player, townBlock, StringMgmt.join(stringArray, " "));
                    townBlock.getPermissions().mobs = !townBlock.getPermissions().mobs;
                    TownyMessaging.sendMessage((Object)player, String.format(TownySettings.getLangString("msg_changed_mobs"), "the Plot", townBlock.getPermissions().mobs ? "Enabled" : "Disabled"));
                } else {
                    TownyMessaging.sendErrorMsg((Object)player, String.format(TownySettings.getLangString("msg_err_invalid_property"), "plot"));
                    return;
                }
                townBlock.setChanged(true);
                TownyUniverse.getDataSource().saveTownBlock(townBlock);
            }
            catch (Exception exception) {
                TownyMessaging.sendErrorMsg((Object)player, exception.getMessage());
            }
            TownyUniverse.getDataSource().saveTownBlock(townBlock);
        }
    }

    private void toggleTest(Player player, TownBlock townBlock, String string) throws TownyException {
        Town town = townBlock.getTown();
        if ((string = string.toLowerCase()).contains("mobs") && town.getWorld().isForceTownMobs()) {
            throw new TownyException(TownySettings.getLangString("msg_world_mobs"));
        }
        if (string.contains("fire") && town.getWorld().isForceFire()) {
            throw new TownyException(TownySettings.getLangString("msg_world_fire"));
        }
        if (string.contains("explosion") && town.getWorld().isForceExpl()) {
            throw new TownyException(TownySettings.getLangString("msg_world_expl"));
        }
        if (string.contains("pvp") && town.getWorld().isForcePVP()) {
            throw new TownyException(TownySettings.getLangString("msg_world_pvp"));
        }
        if ((string.contains("pvp") || string.trim().equalsIgnoreCase("off")) && townBlock.getType().equals((Object)TownBlockType.ARENA)) {
            throw new TownyException(TownySettings.getLangString("msg_plot_pvp"));
        }
    }

    public TownBlockOwner plotTestOwner(Resident resident, TownBlock townBlock) throws TownyException {
        if (townBlock.hasResident()) {
            Resident resident2 = townBlock.getResident();
            if (resident != resident2 && !townBlock.getTown().getMayor().equals(resident) && !townBlock.getTown().hasAssistant(resident)) {
                throw new TownyException(TownySettings.getLangString("msg_area_not_own"));
            }
            return resident2;
        }
        Town town = townBlock.getTown();
        if (!town.isMayor(resident) && !town.hasAssistant(resident)) {
            throw new TownyException(TownySettings.getLangString("msg_not_mayor_ass"));
        }
        if (resident.getTown() != town) {
            throw new TownyException(TownySettings.getLangString("msg_err_not_part_town"));
        }
        return town;
    }

    static {
        output = new ArrayList<String>();
        output.add(ChatTools.formatTitle("/plot"));
        output.add(ChatTools.formatCommand(TownySettings.getLangString("res_sing"), "/plot claim", "", TownySettings.getLangString("msg_block_claim")));
        output.add(ChatTools.formatCommand(TownySettings.getLangString("res_sing"), "/plot claim", "[rect/circle] [radius]", ""));
        output.add(ChatTools.formatCommand(TownySettings.getLangString("res_sing") + "/" + TownySettings.getLangString("mayor_sing"), "/plot notforsale", "", TownySettings.getLangString("msg_plot_nfs")));
        output.add(ChatTools.formatCommand(TownySettings.getLangString("res_sing") + "/" + TownySettings.getLangString("mayor_sing"), "/plot notforsale", "[rect/circle] [radius]", ""));
        output.add(ChatTools.formatCommand(TownySettings.getLangString("res_sing") + "/" + TownySettings.getLangString("mayor_sing"), "/plot forsale [$]", "", TownySettings.getLangString("msg_plot_fs")));
        output.add(ChatTools.formatCommand(TownySettings.getLangString("res_sing") + "/" + TownySettings.getLangString("mayor_sing"), "/plot forsale [$]", "within [rect/circle] [radius]", ""));
        output.add(ChatTools.formatCommand(TownySettings.getLangString("res_sing") + "/" + TownySettings.getLangString("mayor_sing"), "/plot clear", "", ""));
        output.add(ChatTools.formatCommand(TownySettings.getLangString("res_sing") + "/" + TownySettings.getLangString("mayor_sing"), "/plot set ...", "", TownySettings.getLangString("msg_plot_fs")));
        output.add(ChatTools.formatCommand(TownySettings.getLangString("res_sing"), "/plot toggle", "[pvp/fire/explosion/mobs]", ""));
        output.add(TownySettings.getLangString("msg_nfs_abr"));
    }
}

