/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.command;

import ca.xshade.bukkit.questioner.Questioner;
import ca.xshade.questionmanager.Option;
import ca.xshade.questionmanager.Question;
import com.earth2me.essentials.Teleport;
import com.earth2me.essentials.User;
import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyFormatter;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyTimerHandler;
import com.palmergames.bukkit.towny.event.TownAddResidentEvent;
import com.palmergames.bukkit.towny.event.TownRemoveResidentEvent;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.EconomyException;
import com.palmergames.bukkit.towny.exceptions.EmptyTownException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockOwner;
import com.palmergames.bukkit.towny.object.TownSpawnLevel;
import com.palmergames.bukkit.towny.object.TownyObservableType;
import com.palmergames.bukkit.towny.object.TownyPermission;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.permissions.PermissionNodes;
import com.palmergames.bukkit.towny.permissions.TownyPerms;
import com.palmergames.bukkit.towny.questioner.JoinTownTask;
import com.palmergames.bukkit.towny.questioner.ResidentTownQuestionTask;
import com.palmergames.bukkit.towny.regen.PlotBlockData;
import com.palmergames.bukkit.towny.regen.TownyRegenAPI;
import com.palmergames.bukkit.towny.tasks.TownClaim;
import com.palmergames.bukkit.towny.utils.AreaSelectionUtil;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.bukkit.util.ChatTools;
import com.palmergames.bukkit.util.Colors;
import com.palmergames.bukkit.util.NameValidation;
import com.palmergames.util.StringMgmt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.naming.InvalidNameException;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;

public class TownCommand
implements CommandExecutor {
    private static Towny plugin;
    private static final List<String> output;

    public TownCommand(Towny towny) {
        plugin = towny;
    }

    public boolean onCommand(CommandSender commandSender, Command command, String string, String[] stringArray) {
        if (commandSender instanceof Player) {
            Player player = (Player)commandSender;
            System.out.println("[PLAYER_COMMAND] " + player.getName() + ": /" + string + " " + StringMgmt.join(stringArray));
            this.parseTownCommand(player, stringArray);
        } else {
            for (String string2 : output) {
                commandSender.sendMessage(Colors.strip(string2));
            }
        }
        return true;
    }

    private void parseTownCommand(Player player, String[] stringArray) {
        block60: {
            try {
                if (stringArray.length == 0) {
                    try {
                        Resident resident = TownyUniverse.getDataSource().getResident(player.getName());
                        Town town = resident.getTown();
                        TownyMessaging.sendMessage((Object)player, TownyFormatter.getStatus(town));
                        break block60;
                    }
                    catch (NotRegisteredException notRegisteredException) {
                        throw new TownyException(TownySettings.getLangString("msg_err_dont_belong_town"));
                    }
                }
                if (stringArray[0].equalsIgnoreCase("?") || stringArray[0].equalsIgnoreCase("help")) {
                    for (String string : output) {
                        player.sendMessage(string);
                    }
                    break block60;
                }
                if (stringArray[0].equalsIgnoreCase("here")) {
                    if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWN_HERE.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    this.showTownStatusHere(player);
                    break block60;
                }
                if (stringArray[0].equalsIgnoreCase("list")) {
                    if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWN_LIST.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    this.listTowns(player);
                    break block60;
                }
                if (stringArray[0].equalsIgnoreCase("new")) {
                    if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWN_NEW.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    if (stringArray.length == 1) {
                        throw new TownyException(TownySettings.getLangString("msg_specify_name"));
                    }
                    if (stringArray.length == 2) {
                        this.newTown(player, stringArray[1], player.getName());
                    } else {
                        if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWNYADMIN_TOWN_NEW.getNode())) {
                            throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                        }
                        this.newTown(player, stringArray[1], stringArray[2]);
                    }
                    break block60;
                }
                if (stringArray[0].equalsIgnoreCase("leave")) {
                    if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWN_LEAVE.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    this.townLeave(player);
                    break block60;
                }
                if (stringArray[0].equalsIgnoreCase("withdraw")) {
                    if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWN_WITHDRAW.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    if (stringArray.length == 2) {
                        try {
                            this.townWithdraw(player, Integer.parseInt(stringArray[1].trim()));
                            break block60;
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new TownyException(TownySettings.getLangString("msg_error_must_be_int"));
                        }
                    }
                    throw new TownyException(String.format(TownySettings.getLangString("msg_must_specify_amnt"), "/town withdraw"));
                }
                if (stringArray[0].equalsIgnoreCase("deposit")) {
                    if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWN_DEPOSIT.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    if (stringArray.length == 2) {
                        try {
                            this.townDeposit(player, Integer.parseInt(stringArray[1].trim()));
                            break block60;
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new TownyException(TownySettings.getLangString("msg_error_must_be_int"));
                        }
                    }
                    throw new TownyException(String.format(TownySettings.getLangString("msg_must_specify_amnt"), "/town deposit"));
                }
                String[] stringArray2 = StringMgmt.remFirstArg(stringArray);
                if (stringArray[0].equalsIgnoreCase("rank")) {
                    this.townRank(player, stringArray2);
                    break block60;
                }
                if (stringArray[0].equalsIgnoreCase("set")) {
                    this.townSet(player, stringArray2);
                    break block60;
                }
                if (stringArray[0].equalsIgnoreCase("buy")) {
                    if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWN_BUY.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    this.townBuy(player, stringArray2);
                    break block60;
                }
                if (stringArray[0].equalsIgnoreCase("toggle")) {
                    this.townToggle(player, stringArray2);
                    break block60;
                }
                if (stringArray[0].equalsIgnoreCase("mayor")) {
                    if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWN_MAYOR.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    this.townMayor(player, stringArray2);
                    break block60;
                }
                if (stringArray[0].equalsIgnoreCase("spawn")) {
                    TownCommand.townSpawn(player, stringArray2, false);
                    break block60;
                }
                if (stringArray[0].equalsIgnoreCase("outpost")) {
                    TownCommand.townSpawn(player, stringArray2, true);
                    break block60;
                }
                if (stringArray[0].equalsIgnoreCase("delete")) {
                    if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWN_DELETE.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    this.townDelete(player, stringArray2);
                    break block60;
                }
                if (stringArray[0].equalsIgnoreCase("ranklist")) {
                    if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWN_RANKLIST.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    try {
                        Resident resident = TownyUniverse.getDataSource().getResident(player.getName());
                        Town town = resident.getTown();
                        TownyMessaging.sendMessage((Object)player, TownyFormatter.getRanks(town));
                        break block60;
                    }
                    catch (NotRegisteredException notRegisteredException) {
                        throw new TownyException(TownySettings.getLangString("msg_err_dont_belong_town"));
                    }
                }
                if (stringArray[0].equalsIgnoreCase("join")) {
                    if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWN_JOIN.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    TownCommand.parseTownJoin((CommandSender)player, stringArray2);
                    break block60;
                }
                if (stringArray[0].equalsIgnoreCase("add")) {
                    if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWN_ADD.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    TownCommand.townAdd(player, null, stringArray2);
                    break block60;
                }
                if (stringArray[0].equalsIgnoreCase("kick")) {
                    if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWN_KICK.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    TownCommand.townKick(player, stringArray2);
                    break block60;
                }
                if (stringArray[0].equalsIgnoreCase("claim")) {
                    if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWN_CLAIM.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    TownCommand.parseTownClaimCommand(player, stringArray2);
                    break block60;
                }
                if (stringArray[0].equalsIgnoreCase("unclaim")) {
                    if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWN_UNCLAIM.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    TownCommand.parseTownUnclaimCommand(player, stringArray2);
                    break block60;
                }
                if (stringArray[0].equalsIgnoreCase("online")) {
                    if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWN_ONLINE.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    try {
                        Resident resident = TownyUniverse.getDataSource().getResident(player.getName());
                        Town town = resident.getTown();
                        TownyMessaging.sendMessage((Object)player, TownyFormatter.getFormattedOnlineResidents(TownySettings.getLangString("msg_town_online"), town));
                        break block60;
                    }
                    catch (NotRegisteredException notRegisteredException) {
                        throw new TownyException(TownySettings.getLangString("msg_err_dont_belong_town"));
                    }
                }
                try {
                    Town town = TownyUniverse.getDataSource().getTown(stringArray[0]);
                    TownyMessaging.sendMessage((Object)player, TownyFormatter.getStatus(town));
                }
                catch (NotRegisteredException notRegisteredException) {
                    throw new TownyException(String.format(TownySettings.getLangString("msg_err_not_registered_1"), stringArray[0]));
                }
            }
            catch (Exception exception) {
                TownyMessaging.sendErrorMsg((Object)player, exception.getMessage());
            }
        }
    }

    public void listTowns(Player player) {
        player.sendMessage(ChatTools.formatTitle(TownySettings.getLangString("town_plu")));
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Town object : TownyUniverse.getDataSource().getTowns()) {
            String string = "\u00a7b" + object.getName();
            string = string + (object.isOpen() ? "\u00a7f (Open)" : "");
            string = string + "\u00a73 [" + object.getNumResidents() + "]";
            string = string + "\u00a7f";
            arrayList.add(string);
        }
        for (String string : ChatTools.list(arrayList)) {
            player.sendMessage(string);
        }
    }

    public void townMayor(Player player, String[] stringArray) {
        if (stringArray.length == 0 || stringArray[0].equalsIgnoreCase("?")) {
            this.showTownMayorHelp(player);
        }
    }

    public void showTownStatusHere(Player player) {
        try {
            TownyWorld townyWorld = TownyUniverse.getDataSource().getWorld(player.getWorld().getName());
            Coord coord = Coord.parseCoord((Entity)player);
            this.showTownStatusAtCoord(player, townyWorld, coord);
        }
        catch (TownyException townyException) {
            TownyMessaging.sendErrorMsg((Object)player, townyException.getMessage());
        }
    }

    public void showTownStatusAtCoord(Player player, TownyWorld townyWorld, Coord coord) throws TownyException {
        if (!townyWorld.hasTownBlock(coord)) {
            throw new TownyException(String.format(TownySettings.getLangString("msg_not_claimed"), coord));
        }
        Town town = townyWorld.getTownBlock(coord).getTown();
        TownyMessaging.sendMessage((Object)player, TownyFormatter.getStatus(town));
    }

    public void showTownMayorHelp(Player player) {
        player.sendMessage(ChatTools.formatTitle("Town Mayor Help"));
        player.sendMessage(ChatTools.formatCommand(TownySettings.getLangString("mayor_sing"), "/town", "withdraw [$]", ""));
        player.sendMessage(ChatTools.formatCommand(TownySettings.getLangString("mayor_sing"), "/town", "claim", "'/town claim ?' " + TownySettings.getLangString("res_5")));
        player.sendMessage(ChatTools.formatCommand(TownySettings.getLangString("mayor_sing"), "/town", "unclaim", "'/town " + TownySettings.getLangString("res_5")));
        player.sendMessage(ChatTools.formatCommand(TownySettings.getLangString("mayor_sing"), "/town", "[add/kick] " + TownySettings.getLangString("res_2") + " .. []", TownySettings.getLangString("res_6")));
        player.sendMessage(ChatTools.formatCommand(TownySettings.getLangString("mayor_sing"), "/town", "[add+/kick+] " + TownySettings.getLangString("res_2"), TownySettings.getLangString("res_7")));
        player.sendMessage(ChatTools.formatCommand(TownySettings.getLangString("mayor_sing"), "/town", "set [] .. []", "'/town set' " + TownySettings.getLangString("res_5")));
        player.sendMessage(ChatTools.formatCommand(TownySettings.getLangString("mayor_sing"), "/town", "buy [] .. []", "'/town buy' " + TownySettings.getLangString("res_5")));
        player.sendMessage(ChatTools.formatCommand(TownySettings.getLangString("mayor_sing"), "/town", "toggle", ""));
        player.sendMessage(ChatTools.formatCommand(TownySettings.getLangString("mayor_sing"), "/town", "rank add/remove [resident] [rank]", "'/town rank ?' " + TownySettings.getLangString("res_5")));
        player.sendMessage(ChatTools.formatCommand(TownySettings.getLangString("mayor_sing"), "/town", "delete", ""));
    }

    public void townToggle(Player player, String[] stringArray) throws TownyException {
        if (stringArray.length == 0) {
            player.sendMessage(ChatTools.formatTitle("/town toggle"));
            player.sendMessage(ChatTools.formatCommand("", "/town toggle", "pvp", ""));
            player.sendMessage(ChatTools.formatCommand("", "/town toggle", "public", ""));
            player.sendMessage(ChatTools.formatCommand("", "/town toggle", "explosion", ""));
            player.sendMessage(ChatTools.formatCommand("", "/town toggle", "fire", ""));
            player.sendMessage(ChatTools.formatCommand("", "/town toggle", "mobs", ""));
            player.sendMessage(ChatTools.formatCommand("", "/town toggle", "taxpercent", ""));
            player.sendMessage(ChatTools.formatCommand("", "/town toggle", "open", ""));
        } else {
            Town town;
            try {
                Resident resident = TownyUniverse.getDataSource().getResident(player.getName());
                town = resident.getTown();
            }
            catch (TownyException townyException) {
                throw new TownyException(townyException.getMessage());
            }
            if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWN_TOGGLE.getNode(stringArray[0].toLowerCase()))) {
                throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
            }
            if (stringArray[0].equalsIgnoreCase("public")) {
                town.setPublic(!town.isPublic());
                TownyMessaging.sendTownMessage(town, String.format(TownySettings.getLangString("msg_changed_public"), town.isPublic() ? "Enabled" : "Disabled"));
            } else if (stringArray[0].equalsIgnoreCase("pvp")) {
                this.toggleTest(player, town, StringMgmt.join(stringArray, " "));
                town.setPVP(!town.isPVP());
                TownyMessaging.sendTownMessage(town, String.format(TownySettings.getLangString("msg_changed_pvp"), "Town", town.isPVP() ? "Enabled" : "Disabled"));
            } else if (stringArray[0].equalsIgnoreCase("explosion")) {
                this.toggleTest(player, town, StringMgmt.join(stringArray, " "));
                town.setBANG(!town.isBANG());
                TownyMessaging.sendTownMessage(town, String.format(TownySettings.getLangString("msg_changed_expl"), "Town", town.isBANG() ? "Enabled" : "Disabled"));
            } else if (stringArray[0].equalsIgnoreCase("fire")) {
                this.toggleTest(player, town, StringMgmt.join(stringArray, " "));
                town.setFire(!town.isFire());
                TownyMessaging.sendTownMessage(town, String.format(TownySettings.getLangString("msg_changed_fire"), "Town", town.isFire() ? "Enabled" : "Disabled"));
            } else if (stringArray[0].equalsIgnoreCase("mobs")) {
                this.toggleTest(player, town, StringMgmt.join(stringArray, " "));
                town.setHasMobs(!town.hasMobs());
                TownyMessaging.sendTownMessage(town, String.format(TownySettings.getLangString("msg_changed_mobs"), "Town", town.hasMobs() ? "Enabled" : "Disabled"));
            } else if (stringArray[0].equalsIgnoreCase("taxpercent")) {
                town.setTaxPercentage(!town.isTaxPercentage());
                TownyMessaging.sendTownMessage(town, String.format(TownySettings.getLangString("msg_changed_taxpercent"), town.isTaxPercentage() ? "Enabled" : "Disabled"));
            } else if (stringArray[0].equalsIgnoreCase("open")) {
                town.setOpen(!town.isOpen());
                TownyMessaging.sendTownMessage(town, String.format(TownySettings.getLangString("msg_changed_open"), town.isOpen() ? "Enabled" : "Disabled"));
                if (town.isOpen()) {
                    throw new TownyException(String.format(TownySettings.getLangString("msg_toggle_open_on_warning"), new Object[0]));
                }
            } else {
                throw new TownyException(String.format(TownySettings.getLangString("msg_err_invalid_property"), stringArray[0]));
            }
            for (TownBlock townBlock : town.getTownBlocks()) {
                if (townBlock.hasResident() || townBlock.isChanged()) continue;
                townBlock.setType(townBlock.getType());
                TownyUniverse.getDataSource().saveTownBlock(townBlock);
            }
            TownyUniverse.getDataSource().saveTown(town);
        }
    }

    private void toggleTest(Player player, Town town, String string) throws TownyException {
        if ((string = string.toLowerCase()).contains("mobs") && town.getWorld().isForceTownMobs()) {
            throw new TownyException(TownySettings.getLangString("msg_world_mobs"));
        }
        if (string.contains("fire") && town.getWorld().isForceFire()) {
            throw new TownyException(TownySettings.getLangString("msg_world_fire"));
        }
        if (string.contains("explosion") && town.getWorld().isForceExpl()) {
            throw new TownyException(TownySettings.getLangString("msg_world_expl"));
        }
        if (string.contains("pvp") && town.getWorld().isForcePVP()) {
            throw new TownyException(TownySettings.getLangString("msg_world_pvp"));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void townRank(Player player, String[] stringArray) throws TownyException {
        Resident resident;
        if (stringArray.length == 0) {
            player.sendMessage(ChatTools.formatTitle("/town rank"));
            player.sendMessage(ChatTools.formatCommand("", "/town rank", "add/remove [resident] rank", ""));
            return;
        }
        Town town = null;
        if (stringArray.length < 3) {
            throw new TownyException("Eg: /town rank add/remove [resident] [rank]");
        }
        try {
            Resident resident2 = TownyUniverse.getDataSource().getResident(player.getName());
            resident = TownyUniverse.getDataSource().getResident(stringArray[1]);
            town = resident2.getTown();
            if (town != resident.getTown()) {
                throw new TownyException("This resident is not a member of your Town!");
            }
        }
        catch (TownyException townyException) {
            throw new TownyException(townyException.getMessage());
        }
        String string = stringArray[2].toLowerCase();
        if (!TownyPerms.getTownRanks().contains(string)) {
            throw new TownyException("Unknown rank '" + string + "'. Permissible ranks are :- " + StringMgmt.join(TownyPerms.getTownRanks(), ",") + ".");
        }
        if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWN_RANK.getNode(string))) {
            throw new TownyException("You do not have permission to grant this rank.");
        }
        if (stringArray[0].equalsIgnoreCase("add")) {
            try {
                if (!resident.addTownRank(string)) {
                    TownyMessaging.sendErrorMsg((Object)player, "That resident isn't a member of a town!");
                    return;
                }
                TownyMessaging.sendMsg(resident, "You have been granted the Town rank of '" + string + "'.");
                TownyMessaging.sendMsg((Object)player, "You have granted the Town rank of '" + string + "' to " + resident.getName() + ".");
            }
            catch (AlreadyRegisteredException alreadyRegisteredException) {
                TownyMessaging.sendMsg((Object)player, resident.getName() + " already holds this Town rank.");
                return;
            }
        }
        if (!stringArray[0].equalsIgnoreCase("remove")) {
            TownyMessaging.sendErrorMsg((Object)player, String.format(TownySettings.getLangString("msg_err_invalid_property"), stringArray[0]));
            return;
        }
        try {
            if (resident.removeTownRank(string)) {
                TownyMessaging.sendMsg(resident, "You have been demoted from the Town rank of '" + string + "'.");
                TownyMessaging.sendMsg((Object)player, "You have removed the Town rank of '" + string + "' from " + resident.getName() + ".");
            }
        }
        catch (NotRegisteredException notRegisteredException) {
            TownyMessaging.sendMsg((Object)player, resident.getName() + " doesn't hold this Town rank.");
            return;
        }
        TownyUniverse.getDataSource().saveResident(resident);
    }

    public void townSet(Player player, String[] stringArray) throws TownyException {
        if (stringArray.length == 0) {
            player.sendMessage(ChatTools.formatTitle("/town set"));
            player.sendMessage(ChatTools.formatCommand("", "/town set", "board [message ... ]", ""));
            player.sendMessage(ChatTools.formatCommand("", "/town set", "mayor " + TownySettings.getLangString("town_help_2"), ""));
            player.sendMessage(ChatTools.formatCommand("", "/town set", "homeblock", ""));
            player.sendMessage(ChatTools.formatCommand("", "/town set", "spawn/outpost", ""));
            player.sendMessage(ChatTools.formatCommand("", "/town set", "perm ...", "'/town set perm' " + TownySettings.getLangString("res_5")));
            player.sendMessage(ChatTools.formatCommand("", "/town set", "taxes [$]", ""));
            player.sendMessage(ChatTools.formatCommand("", "/town set", "[plottax/shoptax/embassytax] [$]", ""));
            player.sendMessage(ChatTools.formatCommand("", "/town set", "[plotprice/shopprice/embassyprice] [$]", ""));
            player.sendMessage(ChatTools.formatCommand("", "/town set", "name [name]", ""));
            player.sendMessage(ChatTools.formatCommand("", "/town set", "tag [upto 4 letters] or clear", ""));
        } else {
            Resident resident;
            Town town = null;
            Nation nation = null;
            TownyWorld townyWorld = null;
            try {
                resident = TownyUniverse.getDataSource().getResident(player.getName());
                town = resident.getTown();
                if (town.hasNation()) {
                    nation = town.getNation();
                }
            }
            catch (TownyException townyException) {
                TownyMessaging.sendErrorMsg((Object)player, townyException.getMessage());
                return;
            }
            if (stringArray[0].equalsIgnoreCase("board")) {
                if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWN_SET_BOARD.getNode())) {
                    throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                }
                if (stringArray.length < 2) {
                    TownyMessaging.sendErrorMsg((Object)player, "Eg: /town set board " + TownySettings.getLangString("town_help_9"));
                    return;
                }
                String string = stringArray[1];
                for (int i = 2; i < stringArray.length; ++i) {
                    string = string + " " + stringArray[i];
                }
                town.setTownBoard(string);
                TownyMessaging.sendTownBoard(player, town);
            } else {
                if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWN_SET.getNode(stringArray[0].toLowerCase()))) {
                    throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                }
                if (stringArray[0].equalsIgnoreCase("mayor")) {
                    if (stringArray.length < 2) {
                        TownyMessaging.sendErrorMsg((Object)player, "Eg: /town set mayor Dumbo");
                        return;
                    }
                    try {
                        if (!resident.isMayor()) {
                            throw new TownyException(TownySettings.getLangString("msg_not_mayor"));
                        }
                        String string = town.getMayor().getName();
                        Resident resident2 = TownyUniverse.getDataSource().getResident(stringArray[1]);
                        town.setMayor(resident2);
                        plugin.deleteCache(string);
                        plugin.deleteCache(resident2.getName());
                        TownyMessaging.sendTownMessage(town, TownySettings.getNewMayorMsg(resident2.getName()));
                    }
                    catch (TownyException townyException) {
                        TownyMessaging.sendErrorMsg((Object)player, townyException.getMessage());
                        return;
                    }
                }
                if (stringArray[0].equalsIgnoreCase("taxes")) {
                    if (stringArray.length < 2) {
                        TownyMessaging.sendErrorMsg((Object)player, "Eg: /town set taxes 7");
                        return;
                    }
                    try {
                        Double d = Double.parseDouble(stringArray[1]);
                        if (d < 0.0) {
                            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_negative_money"));
                            return;
                        }
                        if (town.isTaxPercentage() && d > 100.0) {
                            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_not_percentage"));
                            return;
                        }
                        town.setTaxes(d);
                        TownyMessaging.sendTownMessage(town, String.format(TownySettings.getLangString("msg_town_set_tax"), player.getName(), stringArray[1]));
                    }
                    catch (NumberFormatException numberFormatException) {
                        TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_error_must_be_num"));
                        return;
                    }
                }
                if (stringArray[0].equalsIgnoreCase("plottax")) {
                    if (stringArray.length < 2) {
                        TownyMessaging.sendErrorMsg((Object)player, "Eg: /town set plottax 10");
                        return;
                    }
                    try {
                        Double d = Double.parseDouble(stringArray[1]);
                        if (d < 0.0) {
                            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_negative_money"));
                            return;
                        }
                        town.setPlotTax(d);
                        TownyMessaging.sendTownMessage(town, String.format(TownySettings.getLangString("msg_town_set_plottax"), player.getName(), stringArray[1]));
                    }
                    catch (NumberFormatException numberFormatException) {
                        TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_error_must_be_num"));
                        return;
                    }
                }
                if (stringArray[0].equalsIgnoreCase("shoptax")) {
                    if (stringArray.length < 2) {
                        TownyMessaging.sendErrorMsg((Object)player, "Eg: /town set shoptax 10");
                        return;
                    }
                    try {
                        Double d = Double.parseDouble(stringArray[1]);
                        if (d < 0.0) {
                            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_negative_money"));
                            return;
                        }
                        town.setCommercialPlotTax(d);
                        TownyMessaging.sendTownMessage(town, String.format(TownySettings.getLangString("msg_town_set_alttax"), player.getName(), "shop", stringArray[1]));
                    }
                    catch (NumberFormatException numberFormatException) {
                        TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_error_must_be_num"));
                        return;
                    }
                }
                if (stringArray[0].equalsIgnoreCase("embassytax")) {
                    if (stringArray.length < 2) {
                        TownyMessaging.sendErrorMsg((Object)player, "Eg: /town set embassytax 10");
                        return;
                    }
                    try {
                        Double d = Double.parseDouble(stringArray[1]);
                        if (d < 0.0) {
                            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_negative_money"));
                            return;
                        }
                        town.setEmbassyPlotTax(d);
                        TownyMessaging.sendTownMessage(town, String.format(TownySettings.getLangString("msg_town_set_alttax"), player.getName(), "embassy", stringArray[1]));
                    }
                    catch (NumberFormatException numberFormatException) {
                        TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_error_must_be_num"));
                        return;
                    }
                }
                if (stringArray[0].equalsIgnoreCase("plotprice")) {
                    if (stringArray.length < 2) {
                        TownyMessaging.sendErrorMsg((Object)player, "Eg: /town set plotprice 50");
                        return;
                    }
                    try {
                        Double d = Double.parseDouble(stringArray[1]);
                        if (d < 0.0) {
                            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_negative_money"));
                            return;
                        }
                        town.setPlotPrice(d);
                        TownyMessaging.sendTownMessage(town, String.format(TownySettings.getLangString("msg_town_set_plotprice"), player.getName(), stringArray[1]));
                    }
                    catch (NumberFormatException numberFormatException) {
                        TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_error_must_be_num"));
                        return;
                    }
                }
                if (stringArray[0].equalsIgnoreCase("shopprice")) {
                    if (stringArray.length < 2) {
                        TownyMessaging.sendErrorMsg((Object)player, "Eg: /town set shopprice 50");
                        return;
                    }
                    try {
                        Double d = Double.parseDouble(stringArray[1]);
                        if (d < 0.0) {
                            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_negative_money"));
                            return;
                        }
                        town.setCommercialPlotPrice(d);
                        TownyMessaging.sendTownMessage(town, String.format(TownySettings.getLangString("msg_town_set_altprice"), player.getName(), "shop", stringArray[1]));
                    }
                    catch (NumberFormatException numberFormatException) {
                        TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_error_must_be_num"));
                        return;
                    }
                }
                if (stringArray[0].equalsIgnoreCase("embassyprice")) {
                    if (stringArray.length < 2) {
                        TownyMessaging.sendErrorMsg((Object)player, "Eg: /town set embassyprice 50");
                        return;
                    }
                    try {
                        Double d = Double.parseDouble(stringArray[1]);
                        if (d < 0.0) {
                            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_negative_money"));
                            return;
                        }
                        town.setEmbassyPlotPrice(d);
                        TownyMessaging.sendTownMessage(town, String.format(TownySettings.getLangString("msg_town_set_altprice"), player.getName(), "embassy", stringArray[1]));
                    }
                    catch (NumberFormatException numberFormatException) {
                        TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_error_must_be_num"));
                        return;
                    }
                }
                if (stringArray[0].equalsIgnoreCase("name")) {
                    if (stringArray.length < 2) {
                        TownyMessaging.sendErrorMsg((Object)player, "Eg: /town set name BillyBobTown");
                        return;
                    }
                    if (!NameValidation.isBlacklistName(stringArray[1])) {
                        this.townRename(player, town, stringArray[1]);
                    } else {
                        TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_invalid_name"));
                    }
                } else if (stringArray[0].equalsIgnoreCase("tag")) {
                    if (stringArray.length < 2) {
                        TownyMessaging.sendErrorMsg((Object)player, "Eg: /town set tag PLTC");
                    } else if (stringArray[1].equalsIgnoreCase("clear")) {
                        try {
                            town.setTag(" ");
                            TownyMessaging.sendTownMessage(town, String.format(TownySettings.getLangString("msg_reset_town_tag"), player.getName()));
                        }
                        catch (TownyException townyException) {
                            TownyMessaging.sendErrorMsg((Object)player, townyException.getMessage());
                        }
                    } else {
                        try {
                            town.setTag(NameValidation.checkAndFilterName(stringArray[1]));
                            TownyMessaging.sendTownMessage(town, String.format(TownySettings.getLangString("msg_set_town_tag"), player.getName(), town.getTag()));
                        }
                        catch (TownyException townyException) {
                            TownyMessaging.sendErrorMsg((Object)player, townyException.getMessage());
                        }
                        catch (InvalidNameException invalidNameException) {
                            TownyMessaging.sendErrorMsg((Object)player, invalidNameException.getMessage());
                        }
                    }
                } else {
                    if (stringArray[0].equalsIgnoreCase("homeblock")) {
                        Coord coord = Coord.parseCoord((Entity)player);
                        try {
                            if (TownyUniverse.isWarTime()) {
                                throw new TownyException(TownySettings.getLangString("msg_war_cannot_do"));
                            }
                            TownyWorld townyWorld2 = TownyUniverse.getDataSource().getWorld(player.getWorld().getName());
                            if (townyWorld2.getMinDistanceFromOtherTowns(coord, resident.getTown()) < TownySettings.getMinDistanceFromTownHomeblocks()) {
                                throw new TownyException(TownySettings.getLangString("msg_too_close"));
                            }
                            if (TownySettings.getMaxDistanceBetweenHomeblocks() > 0 && townyWorld2.getMinDistanceFromOtherTowns(coord, resident.getTown()) > TownySettings.getMaxDistanceBetweenHomeblocks() && townyWorld2.hasTowns()) {
                                throw new TownyException(TownySettings.getLangString("msg_too_far"));
                            }
                            TownBlock townBlock = TownyUniverse.getDataSource().getWorld(player.getWorld().getName()).getTownBlock(coord);
                            townyWorld = town.getWorld();
                            town.setHomeBlock(townBlock);
                            TownyMessaging.sendMsg((Object)player, String.format(TownySettings.getLangString("msg_set_town_home"), coord.toString()));
                        }
                        catch (TownyException townyException) {
                            TownyMessaging.sendErrorMsg((Object)player, townyException.getMessage());
                            return;
                        }
                    }
                    if (stringArray[0].equalsIgnoreCase("spawn")) {
                        try {
                            town.setSpawn(player.getLocation());
                            TownyMessaging.sendMsg((Object)player, TownySettings.getLangString("msg_set_town_spawn"));
                        }
                        catch (TownyException townyException) {
                            TownyMessaging.sendErrorMsg((Object)player, townyException.getMessage());
                            return;
                        }
                    }
                    if (stringArray[0].equalsIgnoreCase("outpost")) {
                        try {
                            town.addOutpostSpawn(player.getLocation());
                            TownyMessaging.sendMsg((Object)player, TownySettings.getLangString("msg_set_outpost_spawn"));
                        }
                        catch (TownyException townyException) {
                            TownyMessaging.sendErrorMsg((Object)player, townyException.getMessage());
                            return;
                        }
                    }
                    if (stringArray[0].equalsIgnoreCase("perm")) {
                        try {
                            this.toggleTest(player, town, StringMgmt.join(stringArray, " "));
                        }
                        catch (Exception exception) {
                            TownyMessaging.sendErrorMsg((Object)player, exception.getMessage());
                            return;
                        }
                        String[] stringArray2 = StringMgmt.remFirstArg(stringArray);
                        TownCommand.setTownBlockOwnerPermissions(player, town, stringArray2);
                    } else {
                        TownyMessaging.sendErrorMsg((Object)player, String.format(TownySettings.getLangString("msg_err_invalid_property"), "town"));
                        return;
                    }
                }
            }
            TownyUniverse.getDataSource().saveTown(town);
            TownyUniverse.getDataSource().saveTownList();
            if (nation != null) {
                TownyUniverse.getDataSource().saveNation(nation);
            }
            if (townyWorld != null) {
                TownyUniverse.getDataSource().saveWorld(town.getWorld());
                TownyUniverse.getDataSource().saveWorld(townyWorld);
            }
        }
    }

    public void townBuy(Player player, String[] stringArray) {
        if (stringArray.length == 0) {
            player.sendMessage(ChatTools.formatTitle("/town buy"));
            if (TownySettings.isSellingBonusBlocks()) {
                String string = "\u00a7e[Purchased Bonus] \u00a72Cost: \u00a7a%s\u00a78 | \u00a72Max: \u00a7a%d";
                player.sendMessage(String.format(string, TownyEconomyHandler.getFormattedBalance(TownySettings.getPurchasedBonusBlocksCost()), TownySettings.getMaxPurchedBlocks()));
                player.sendMessage(ChatTools.formatCommand("", "/town buy", "bonus [n]", ""));
            } else {
                player.sendMessage("Nothing for sale right now.");
            }
        } else {
            Town town;
            try {
                Resident resident = TownyUniverse.getDataSource().getResident(player.getName());
                town = resident.getTown();
            }
            catch (TownyException townyException) {
                TownyMessaging.sendErrorMsg((Object)player, townyException.getMessage());
                return;
            }
            try {
                if (stringArray[0].equalsIgnoreCase("bonus")) {
                    if (stringArray.length == 2) {
                        try {
                            int n = TownCommand.townBuyBonusTownBlocks(town, Integer.parseInt(stringArray[1].trim()));
                            double d = (double)n * TownySettings.getPurchasedBonusBlocksCost();
                            TownyMessaging.sendMsg((Object)player, String.format(TownySettings.getLangString("msg_buy"), n, "bonus town blocks", TownyEconomyHandler.getFormattedBalance(d)));
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new TownyException(TownySettings.getLangString("msg_error_must_be_int"));
                        }
                    } else {
                        throw new TownyException(String.format(TownySettings.getLangString("msg_must_specify_amnt"), "/town buy bonus"));
                    }
                }
                TownyUniverse.getDataSource().saveTown(town);
            }
            catch (TownyException townyException) {
                TownyMessaging.sendErrorMsg((Object)player, townyException.getMessage());
            }
        }
    }

    public static int townBuyBonusTownBlocks(Town town, int n) throws TownyException {
        if (n < 0) {
            throw new TownyException(TownySettings.getLangString("msg_err_negative"));
        }
        int n2 = town.getPurchasedBlocks();
        int n3 = n2 + n > TownySettings.getMaxPurchedBlocks() ? TownySettings.getMaxPurchedBlocks() - n2 : n;
        if (n3 == 0) {
            return n3;
        }
        try {
            double d = (double)n3 * TownySettings.getPurchasedBonusBlocksCost();
            if (TownySettings.isUsingEconomy() && !town.pay(d, String.format("Town Buy Bonus (%d)", n3))) {
                throw new TownyException(String.format(TownySettings.getLangString("msg_no_funds_to_buy"), n3, "bonus town blocks", TownyEconomyHandler.getFormattedBalance(d)));
            }
        }
        catch (EconomyException economyException) {
            throw new TownyException("Economy Error");
        }
        town.addPurchasedBlocks(n3);
        return n3;
    }

    public void newTown(Player player, String string, String string2) {
        try {
            String string3;
            if (TownyUniverse.isWarTime()) {
                throw new TownyException(TownySettings.getLangString("msg_war_cannot_do"));
            }
            if (TownySettings.hasTownLimit() && TownyUniverse.getDataSource().getTowns().size() >= TownySettings.getTownLimit()) {
                throw new TownyException(TownySettings.getLangString("msg_err_universe_limit"));
            }
            try {
                string3 = NameValidation.checkAndFilterName(string);
            }
            catch (InvalidNameException invalidNameException) {
                string3 = null;
            }
            if (string3 == null || TownyUniverse.getDataSource().hasTown(string3)) {
                throw new TownyException(String.format(TownySettings.getLangString("msg_err_invalid_name"), string));
            }
            Resident resident = TownyUniverse.getDataSource().getResident(string2);
            if (resident.hasTown()) {
                throw new TownyException(String.format(TownySettings.getLangString("msg_err_already_res"), resident.getName()));
            }
            TownyWorld townyWorld = TownyUniverse.getDataSource().getWorld(player.getWorld().getName());
            if (!townyWorld.isUsingTowny()) {
                throw new TownyException(TownySettings.getLangString("msg_set_use_towny_off"));
            }
            Coord coord = Coord.parseCoord((Entity)player);
            if (townyWorld.hasTownBlock(coord)) {
                throw new TownyException(String.format(TownySettings.getLangString("msg_already_claimed_1"), coord));
            }
            if (townyWorld.getMinDistanceFromOtherTowns(coord) < TownySettings.getMinDistanceFromTownHomeblocks()) {
                throw new TownyException(TownySettings.getLangString("msg_too_close"));
            }
            if (TownySettings.getMaxDistanceBetweenHomeblocks() > 0 && townyWorld.getMinDistanceFromOtherTowns(coord) > TownySettings.getMaxDistanceBetweenHomeblocks() && townyWorld.hasTowns()) {
                throw new TownyException(TownySettings.getLangString("msg_too_far"));
            }
            if (TownySettings.isUsingEconomy() && !resident.pay(TownySettings.getNewTownPrice(), "New Town Cost")) {
                throw new TownyException(String.format(TownySettings.getLangString("msg_no_funds_new_town"), resident.getName().equals(player.getName()) ? "You" : resident.getName()));
            }
            this.newTown(townyWorld, string, resident, coord, player.getLocation());
            TownyMessaging.sendGlobalMessage(TownySettings.getNewTownMsg(player.getName(), string));
        }
        catch (TownyException townyException) {
            TownyMessaging.sendErrorMsg((Object)player, townyException.getMessage());
        }
        catch (EconomyException economyException) {
            TownyMessaging.sendErrorMsg((Object)player, economyException.getMessage());
        }
    }

    public Town newTown(TownyWorld townyWorld, String string, Resident resident, Coord coord, Location location) throws TownyException {
        townyWorld.newTownBlock(coord);
        TownyUniverse.getDataSource().newTown(string);
        Town town = TownyUniverse.getDataSource().getTown(string);
        town.addResident(resident);
        town.setMayor(resident);
        TownBlock townBlock = townyWorld.getTownBlock(coord);
        townBlock.setTown(town);
        town.setHomeBlock(townBlock);
        townBlock.setType(townBlock.getType());
        town.setSpawn(location);
        if (townyWorld.isUsingPlotManagementRevert()) {
            PlotBlockData plotBlockData = TownyRegenAPI.getPlotChunk(townBlock);
            if (plotBlockData != null) {
                TownyRegenAPI.deletePlotChunk(plotBlockData);
            } else {
                plotBlockData = new PlotBlockData(townBlock);
                plotBlockData.initialize();
            }
            TownyRegenAPI.addPlotChunkSnapshot(plotBlockData);
            plotBlockData = null;
        }
        TownyMessaging.sendDebugMsg("Creating new Town account: town-" + string);
        if (TownySettings.isUsingEconomy()) {
            town.setBalance(0.0);
        }
        TownyUniverse.getDataSource().saveResident(resident);
        TownyUniverse.getDataSource().saveTownBlock(townBlock);
        TownyUniverse.getDataSource().saveTown(town);
        TownyUniverse.getDataSource().saveWorld(townyWorld);
        TownyUniverse.getDataSource().saveTownList();
        plugin.updateCache(townBlock.getWorldCoord());
        return town;
    }

    public void townRename(Player player, Town town, String string) {
        try {
            TownyUniverse.getDataSource().renameTown(town, string);
            TownyMessaging.sendTownMessage(town, String.format(TownySettings.getLangString("msg_town_set_name"), player.getName(), town.getName()));
        }
        catch (TownyException townyException) {
            TownyMessaging.sendErrorMsg((Object)player, townyException.getMessage());
        }
    }

    public void townLeave(Player player) {
        Town town;
        Resident resident;
        try {
            if (TownyUniverse.isWarTime()) {
                throw new TownyException(TownySettings.getLangString("msg_war_cannot_do"));
            }
            resident = TownyUniverse.getDataSource().getResident(player.getName());
            town = resident.getTown();
            plugin.deleteCache(resident.getName());
        }
        catch (TownyException townyException) {
            TownyMessaging.sendErrorMsg((Object)player, townyException.getMessage());
            return;
        }
        if (resident.isMayor()) {
            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getMayorAbondonMsg());
            return;
        }
        try {
            town.removeResident(resident);
        }
        catch (EmptyTownException emptyTownException) {
            TownyUniverse.getDataSource().removeTown(emptyTownException.getTown());
        }
        catch (NotRegisteredException notRegisteredException) {
            TownyMessaging.sendErrorMsg((Object)player, notRegisteredException.getMessage());
            return;
        }
        TownyUniverse.getDataSource().saveResident(resident);
        TownyUniverse.getDataSource().saveTown(town);
        plugin.resetCache();
        TownyMessaging.sendTownMessage(town, String.format(TownySettings.getLangString("msg_left_town"), resident.getName()));
        TownyMessaging.sendMsg((Object)player, String.format(TownySettings.getLangString("msg_left_town"), resident.getName()));
    }

    public static void townSpawn(Player player, String[] stringArray, Boolean bl) {
        try {
            double d;
            Object object;
            Object object2;
            TownSpawnLevel townSpawnLevel;
            Location location;
            Object object3;
            String string;
            Town town;
            boolean bl2 = TownyUniverse.getPermissionSource().isTownyAdmin(player);
            Resident resident = TownyUniverse.getDataSource().getResident(player.getName());
            if (stringArray.length == 0 || stringArray.length > 0 && bl.booleanValue()) {
                town = resident.getTown();
                string = TownySettings.getLangString("msg_err_cant_afford_tp");
            } else {
                town = TownyUniverse.getDataSource().getTown(stringArray[0]);
                string = String.format(TownySettings.getLangString("msg_err_cant_afford_tp_town"), town.getName());
            }
            if (bl.booleanValue()) {
                if (!town.hasOutpostSpawn()) {
                    throw new TownyException(TownySettings.getLangString("msg_err_outpost_spawn"));
                }
                try {
                    object3 = Integer.parseInt(stringArray[stringArray.length - 1]);
                }
                catch (NumberFormatException numberFormatException) {
                    object3 = 1;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    object3 = 1;
                }
                location = town.getOutpostSpawn(Math.max(1, (Integer)object3));
            } else {
                location = town.getSpawn();
            }
            if (bl2) {
                townSpawnLevel = TownSpawnLevel.ADMIN;
            } else if (stringArray.length == 0) {
                townSpawnLevel = TownSpawnLevel.TOWN_RESIDENT;
            } else if (!resident.hasTown()) {
                townSpawnLevel = TownSpawnLevel.UNAFFILIATED;
            } else if (resident.getTown() == town) {
                townSpawnLevel = bl != false ? TownSpawnLevel.TOWN_RESIDENT_OUTPOST : TownSpawnLevel.TOWN_RESIDENT;
            } else if (resident.hasNation() && town.hasNation()) {
                object3 = resident.getTown().getNation();
                if (object3 == (object2 = town.getNation())) {
                    townSpawnLevel = TownSpawnLevel.PART_OF_NATION;
                } else {
                    if (((Nation)object2).hasEnemy((Nation)object3)) {
                        throw new TownyException(TownySettings.getLangString("msg_err_public_spawn_enemy"));
                    }
                    townSpawnLevel = ((Nation)object2).hasAlly((Nation)object3) ? TownSpawnLevel.NATION_ALLY : TownSpawnLevel.UNAFFILIATED;
                }
            } else {
                townSpawnLevel = TownSpawnLevel.UNAFFILIATED;
            }
            TownyMessaging.sendDebugMsg(townSpawnLevel.toString() + " " + townSpawnLevel.isAllowed());
            townSpawnLevel.checkIfAllowed(plugin, player);
            if (!bl2 && townSpawnLevel != TownSpawnLevel.TOWN_RESIDENT && townSpawnLevel != TownSpawnLevel.TOWN_RESIDENT_OUTPOST && !town.isPublic()) {
                throw new TownyException(TownySettings.getLangString("msg_err_not_public"));
            }
            if (!bl2 && !(object3 = TownySettings.getDisallowedTownSpawnZones()).isEmpty()) {
                object2 = null;
                try {
                    object = plugin.getCache(player).getLastLocation();
                    object2 = TownyUniverse.getTownName((Location)object);
                }
                catch (NullPointerException nullPointerException) {
                    object2 = TownyUniverse.getTownName(player.getLocation());
                }
                if (object2 == null && object3.contains("unclaimed")) {
                    throw new TownyException(String.format(TownySettings.getLangString("msg_err_town_spawn_disallowed_from"), "the Wilderness"));
                }
                if (object2 != null && resident.hasNation() && TownyUniverse.getDataSource().getTown((String)object2).hasNation()) {
                    Nation nation;
                    object = TownyUniverse.getDataSource().getTown((String)object2).getNation();
                    if (((Nation)object).hasEnemy(nation = resident.getTown().getNation()) && object3.contains("enemy")) {
                        throw new TownyException(String.format(TownySettings.getLangString("msg_err_town_spawn_disallowed_from"), "Enemy areas"));
                    }
                    if (!((Nation)object).hasAlly(nation) && !((Nation)object).hasEnemy(nation) && object3.contains("neutral")) {
                        throw new TownyException(String.format(TownySettings.getLangString("msg_err_town_spawn_disallowed_from"), "Neutral towns"));
                    }
                }
            }
            if ((d = townSpawnLevel.getCost()) > 0.0 && TownySettings.isUsingEconomy() && resident.getHoldingBalance() < d) {
                throw new TownyException(string);
            }
            object = location.getChunk();
            boolean bl3 = plugin.isEssentials();
            if (bl3 && !bl2) {
                try {
                    User user = plugin.getEssentials().getUser((Object)player);
                    if (!user.isJailed()) {
                        Teleport teleport = user.getTeleport();
                        if (!object.isLoaded()) {
                            object.load();
                        }
                        teleport.cooldown(true);
                        teleport.teleport(location, null);
                    }
                }
                catch (Exception exception) {
                    TownyMessaging.sendErrorMsg((Object)player, "Error: " + exception.getMessage());
                    return;
                }
            }
            if (d > 0.0 && TownySettings.isUsingEconomy() && resident.payTo(d, town, String.format("Town Spawn (%s)", new Object[]{townSpawnLevel}))) {
                TownyMessaging.sendMsg((Object)player, String.format(TownySettings.getLangString("msg_cost_spawn"), TownyEconomyHandler.getFormattedBalance(d)));
            }
            if (bl2) {
                if (player.getVehicle() != null) {
                    player.getVehicle().eject();
                }
                if (!object.isLoaded()) {
                    object.load();
                }
                player.teleport(location, PlayerTeleportEvent.TeleportCause.COMMAND);
                return;
            }
            if (!bl3) {
                if (TownyTimerHandler.isTeleportWarmupRunning()) {
                    player.sendMessage(String.format(TownySettings.getLangString("msg_town_spawn_warmup"), TownySettings.getTeleportWarmupTime()));
                    plugin.getTownyUniverse().requestTeleport(player, location, d);
                } else {
                    if (player.getVehicle() != null) {
                        player.getVehicle().eject();
                    }
                    if (!object.isLoaded()) {
                        object.load();
                    }
                    player.teleport(location, PlayerTeleportEvent.TeleportCause.COMMAND);
                }
            }
        }
        catch (TownyException townyException) {
            TownyMessaging.sendErrorMsg((Object)player, townyException.getMessage());
        }
        catch (EconomyException economyException) {
            TownyMessaging.sendErrorMsg((Object)player, economyException.getMessage());
        }
    }

    public void townDelete(Player player, String[] stringArray) {
        if (stringArray.length == 0) {
            try {
                Resident resident = TownyUniverse.getDataSource().getResident(player.getName());
                Town town = resident.getTown();
                TownyUniverse.getDataSource().removeTown(town);
                TownyMessaging.sendGlobalMessage(TownySettings.getDelTownMsg(town));
            }
            catch (TownyException townyException) {
                TownyMessaging.sendErrorMsg((Object)player, townyException.getMessage());
                return;
            }
        }
        try {
            if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWNYADMIN_TOWN_DELETE.getNode())) {
                throw new TownyException(TownySettings.getLangString("msg_err_admin_only_delete_town"));
            }
            Town town = TownyUniverse.getDataSource().getTown(stringArray[0]);
            TownyUniverse.getDataSource().removeTown(town);
            TownyMessaging.sendGlobalMessage(TownySettings.getDelTownMsg(town));
        }
        catch (TownyException townyException) {
            TownyMessaging.sendErrorMsg((Object)player, townyException.getMessage());
            return;
        }
    }

    public static void townKick(Player player, String[] stringArray) {
        Town town;
        Resident resident;
        try {
            resident = TownyUniverse.getDataSource().getResident(player.getName());
            town = resident.getTown();
        }
        catch (TownyException townyException) {
            TownyMessaging.sendErrorMsg((Object)player, townyException.getMessage());
            return;
        }
        TownCommand.townKickResidents(player, resident, town, TownyUniverse.getValidatedResidents(player, stringArray));
        plugin.resetCache();
    }

    /*
     * WARNING - void declaration
     */
    public static void townAddResidents(Object object, Town town, List<Resident> list) {
        for (Resident object2 : new ArrayList<Resident>(list)) {
            try {
                if (plugin.isPermissions()) {
                    if (BukkitTools.getServer().matchPlayer(object2.getName()).isEmpty()) {
                        TownyMessaging.sendErrorMsg(object, String.format(TownySettings.getLangString("msg_offline_no_join"), object2.getName()));
                        list.remove(object2);
                        continue;
                    }
                    if (!TownyUniverse.getPermissionSource().has(BukkitTools.getServer().getPlayer(object2.getName()), PermissionNodes.TOWNY_TOWN_RESIDENT.getNode())) {
                        TownyMessaging.sendErrorMsg(object, String.format(TownySettings.getLangString("msg_not_allowed_join"), object2.getName()));
                        list.remove(object2);
                        continue;
                    }
                    town.addResidentCheck(object2);
                    TownCommand.townInviteResident(town, object2);
                    continue;
                }
                town.addResidentCheck(object2);
                TownCommand.townInviteResident(town, object2);
            }
            catch (AlreadyRegisteredException alreadyRegisteredException) {
                list.remove(object2);
                TownyMessaging.sendErrorMsg(object, alreadyRegisteredException.getMessage());
            }
        }
        if (list.size() > 0) {
            void var4_8;
            Object object3 = "";
            for (Resident resident : list) {
                object3 = (String)object3 + resident.getName() + ", ";
            }
            object3 = ((String)object3).substring(0, ((String)object3).length() - 2);
            if (object instanceof Player) {
                String string = ((Player)object).getName();
            } else {
                String string = "Console";
            }
            object3 = String.format(TownySettings.getLangString("msg_invited_join_town"), var4_8, object3);
            TownyMessaging.sendTownMessage(town, ChatTools.color((String)object3));
            TownyUniverse.getDataSource().saveTown(town);
        } else {
            TownyMessaging.sendErrorMsg(object, TownySettings.getLangString("msg_invalid_name"));
        }
    }

    public static void townAddResident(Town town, Resident resident) throws AlreadyRegisteredException {
        town.addResident(resident);
        plugin.deleteCache(resident.getName());
        TownyUniverse.getDataSource().saveResident(resident);
        TownyUniverse.getDataSource().saveTown(town);
        plugin.getTownyUniverse().setChangedNotify(TownyObservableType.TOWN_ADD_RESIDENT);
        BukkitTools.getPluginManager().callEvent((Event)new TownAddResidentEvent(resident, town));
    }

    private static void townInviteResident(Town town, Resident resident) throws AlreadyRegisteredException {
        Plugin plugin = BukkitTools.getServer().getPluginManager().getPlugin("Questioner");
        if (TownySettings.isUsingQuestioner() && plugin != null && plugin instanceof Questioner && plugin.isEnabled()) {
            Questioner questioner = (Questioner)plugin;
            questioner.loadClasses();
            ArrayList<Option> arrayList = new ArrayList<Option>();
            arrayList.add(new Option(TownySettings.questionerAccept(), (Runnable)((Object)new JoinTownTask(resident, town))));
            arrayList.add(new Option(TownySettings.questionerDeny(), (Runnable)((Object)new ResidentTownQuestionTask(resident, town){

                @Override
                public void run() {
                    TownyMessaging.sendTownMessage(this.getTown(), String.format(TownySettings.getLangString("msg_deny_invite"), this.getResident().getName()));
                }
            })));
            Question question = new Question(resident.getName(), String.format(TownySettings.getLangString("msg_invited"), town.getName()), arrayList);
            try {
                TownCommand.plugin.appendQuestion(questioner, question);
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
            }
        } else {
            try {
                TownCommand.townAddResident(town, resident);
            }
            catch (AlreadyRegisteredException alreadyRegisteredException) {
                // empty catch block
            }
        }
    }

    public static void townRemoveResident(Town town, Resident resident) throws EmptyTownException, NotRegisteredException {
        town.removeResident(resident);
        plugin.deleteCache(resident.getName());
        TownyUniverse.getDataSource().saveResident(resident);
        TownyUniverse.getDataSource().saveTown(town);
        plugin.getTownyUniverse().setChangedNotify(TownyObservableType.TOWN_REMOVE_RESIDENT);
        BukkitTools.getPluginManager().callEvent((Event)new TownRemoveResidentEvent(resident, town));
    }

    public static void townKickResidents(Object object, Resident resident, Town town, List<Resident> list) {
        Player player = null;
        if (object instanceof Player) {
            player = (Player)object;
        }
        for (Resident object2 : new ArrayList<Resident>(list)) {
            if (resident == object2 || object2.isMayor() || town.hasAssistant(object2)) {
                list.remove(object2);
                continue;
            }
            try {
                TownCommand.townRemoveResident(town, object2);
            }
            catch (NotRegisteredException emptyTownException) {
                list.remove(object2);
            }
            catch (EmptyTownException emptyTownException) {}
        }
        if (list.size() > 0) {
            Object object3 = "";
            for (Resident notRegisteredException : list) {
                object3 = (String)object3 + notRegisteredException.getName() + ", ";
                Player player2 = BukkitTools.getServer().getPlayer(notRegisteredException.getName());
                if (player2 == null) continue;
                player2.sendMessage(String.format(TownySettings.getLangString("msg_kicked_by"), player != null ? player.getName() : "CONSOLE"));
            }
            object3 = ((String)object3).substring(0, ((String)object3).length() - 2);
            object3 = String.format(TownySettings.getLangString("msg_kicked"), player != null ? player.getName() : "CONSOLE", object3);
            TownyMessaging.sendTownMessage(town, ChatTools.color((String)object3));
            TownyUniverse.getDataSource().saveTown(town);
        } else {
            TownyMessaging.sendErrorMsg(object, TownySettings.getLangString("msg_invalid_name"));
        }
    }

    public static void parseTownJoin(CommandSender commandSender, String[] stringArray) {
        try {
            String string;
            String string2;
            String string3;
            boolean bl = false;
            if (commandSender instanceof Player) {
                if (stringArray.length < 1) {
                    throw new Exception(String.format("Usage: /town join [town]", new Object[0]));
                }
                Player player = (Player)commandSender;
                string3 = player.getName();
                string2 = stringArray[0];
                string = "You";
            } else {
                if (stringArray.length < 2) {
                    throw new Exception(String.format("Usage: town join [resident] [town]", new Object[0]));
                }
                string3 = stringArray[0];
                string2 = stringArray[1];
                string = string3;
            }
            Resident resident = TownyUniverse.getDataSource().getResident(string3);
            Town town = TownyUniverse.getDataSource().getTown(string2);
            if (resident.hasTown()) {
                throw new Exception(String.format(TownySettings.getLangString("msg_err_already_res"), string));
            }
            if (!bl && !town.isOpen()) {
                throw new Exception(String.format(TownySettings.getLangString("msg_err_not_open"), town.getFormattedName()));
            }
            TownCommand.townAddResident(town, resident);
            TownyMessaging.sendTownMessage(town, ChatTools.color(String.format(TownySettings.getLangString("msg_join_town"), resident.getName())));
        }
        catch (Exception exception) {
            TownyMessaging.sendErrorMsg((Object)commandSender, exception.getMessage());
        }
    }

    public static void townAdd(Object object, Town town, String[] stringArray) {
        Town town2;
        String string = object instanceof Player ? ((Player)object).getName() : "Console";
        try {
            if (string.equalsIgnoreCase("Console")) {
                town2 = town;
            } else {
                Resident resident = TownyUniverse.getDataSource().getResident(string);
                town2 = town == null ? resident.getTown() : town;
            }
        }
        catch (TownyException townyException) {
            TownyMessaging.sendErrorMsg(object, townyException.getMessage());
            return;
        }
        TownCommand.townAddResidents(object, town2, TownyUniverse.getValidatedResidents(object, stringArray));
        if (!string.equalsIgnoreCase("Console")) {
            plugin.resetCache(BukkitTools.getPlayerExact(string));
        }
    }

    public static void setTownBlockOwnerPermissions(Player player, TownBlockOwner townBlockOwner, String[] stringArray) {
        TownCommand.setTownBlockPermissions(player, townBlockOwner, townBlockOwner.getPermissions(), stringArray, false);
    }

    public static void setTownBlockPermissions(Player player, TownBlockOwner townBlockOwner, TownyPermission townyPermission, String[] stringArray, boolean bl) {
        if (stringArray.length == 0 || stringArray[0].equalsIgnoreCase("?")) {
            player.sendMessage(ChatTools.formatTitle("/... set perm"));
            player.sendMessage(ChatTools.formatCommand("Level", "[resident/ally/outsider]", "", ""));
            player.sendMessage(ChatTools.formatCommand("Type", "[build/destroy/switch/itemuse]", "", ""));
            player.sendMessage(ChatTools.formatCommand("", "set perm", "[on/off]", "Toggle all permissions"));
            player.sendMessage(ChatTools.formatCommand("", "set perm", "[level/type] [on/off]", ""));
            player.sendMessage(ChatTools.formatCommand("", "set perm", "[level] [type] [on/off]", ""));
            player.sendMessage(ChatTools.formatCommand("", "set perm", "reset", ""));
            if (townBlockOwner instanceof Town) {
                player.sendMessage(ChatTools.formatCommand("Eg", "/town set perm", "ally off", ""));
            }
            if (townBlockOwner instanceof Resident) {
                player.sendMessage(ChatTools.formatCommand("Eg", "/resident|plot set perm", "friend build on", ""));
            }
            player.sendMessage(String.format(TownySettings.getLangString("plot_perms"), "'friend'", "'resident'"));
            player.sendMessage(TownySettings.getLangString("plot_perms_1"));
        } else {
            if (bl && stringArray[0].equalsIgnoreCase("friend")) {
                stringArray[0] = "resident";
            }
            if (stringArray.length == 1) {
                if (stringArray[0].equalsIgnoreCase("reset")) {
                    for (TownBlock townBlock : townBlockOwner.getTownBlocks()) {
                        if ((!(townBlockOwner instanceof Town) || townBlock.hasResident()) && (!(townBlockOwner instanceof Resident) || !townBlock.hasResident())) continue;
                        townBlock.setType(townBlock.getType());
                        TownyUniverse.getDataSource().deleteTownBlock(townBlock);
                    }
                    if (townBlockOwner instanceof Town) {
                        TownyMessaging.sendMsg((Object)player, String.format(TownySettings.getLangString("msg_set_perms_reset"), "Town owned"));
                    } else {
                        TownyMessaging.sendMsg((Object)player, String.format(TownySettings.getLangString("msg_set_perms_reset"), "your"));
                    }
                    plugin.resetCache();
                    return;
                }
                try {
                    boolean bl2 = plugin.parseOnOff(stringArray[0]);
                    for (String string : new String[]{"residentBuild", "residentDestroy", "residentSwitch", "residentItemUse", "outsiderBuild", "outsiderDestroy", "outsiderSwitch", "outsiderItemUse", "allyBuild", "allyDestroy", "allySwitch", "allyItemUse"}) {
                        townyPermission.set(string, bl2);
                    }
                }
                catch (Exception exception) {}
            } else if (stringArray.length == 2) {
                try {
                    boolean bl3 = plugin.parseOnOff(stringArray[1]);
                    if (stringArray[0].equalsIgnoreCase("resident") || stringArray[0].equalsIgnoreCase("friend")) {
                        townyPermission.residentBuild = bl3;
                        townyPermission.residentDestroy = bl3;
                        townyPermission.residentSwitch = bl3;
                        townyPermission.residentItemUse = bl3;
                    } else if (stringArray[0].equalsIgnoreCase("outsider")) {
                        townyPermission.outsiderBuild = bl3;
                        townyPermission.outsiderDestroy = bl3;
                        townyPermission.outsiderSwitch = bl3;
                        townyPermission.outsiderItemUse = bl3;
                    } else if (stringArray[0].equalsIgnoreCase("ally")) {
                        townyPermission.allyBuild = bl3;
                        townyPermission.allyDestroy = bl3;
                        townyPermission.allySwitch = bl3;
                        townyPermission.allyItemUse = bl3;
                    } else if (stringArray[0].equalsIgnoreCase("build")) {
                        townyPermission.residentBuild = bl3;
                        townyPermission.outsiderBuild = bl3;
                        townyPermission.allyBuild = bl3;
                    } else if (stringArray[0].equalsIgnoreCase("destroy")) {
                        townyPermission.residentDestroy = bl3;
                        townyPermission.outsiderDestroy = bl3;
                        townyPermission.allyDestroy = bl3;
                    } else if (stringArray[0].equalsIgnoreCase("switch")) {
                        townyPermission.residentSwitch = bl3;
                        townyPermission.outsiderSwitch = bl3;
                        townyPermission.allySwitch = bl3;
                    } else if (stringArray[0].equalsIgnoreCase("itemuse")) {
                        townyPermission.residentItemUse = bl3;
                        townyPermission.outsiderItemUse = bl3;
                        townyPermission.allyItemUse = bl3;
                    }
                }
                catch (Exception exception) {}
            } else if (stringArray.length == 3) {
                try {
                    boolean bl4 = plugin.parseOnOff(stringArray[2]);
                    String string2 = "";
                    string2 = stringArray[0] + stringArray[1];
                    townyPermission.set(string2, bl4);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            for (TownBlock townBlock : townBlockOwner.getTownBlocks()) {
                if (!(townBlockOwner instanceof Town) || townBlock.hasResident() || townBlock.isChanged()) continue;
                townBlock.setType(townBlock.getType());
                TownyUniverse.getDataSource().deleteTownBlock(townBlock);
            }
            TownyMessaging.sendMsg((Object)player, TownySettings.getLangString("msg_set_perms"));
            TownyMessaging.sendMessage((Object)player, "\u00a72 Perm: " + (townBlockOwner instanceof Resident ? townyPermission.getColourString().replace("f", "r") : townyPermission.getColourString()));
            TownyMessaging.sendMessage((Object)player, "\u00a72PvP: " + (townyPermission.pvp ? "\u00a74ON" : "\u00a7aOFF") + "\u00a72" + "  Explosions: " + (townyPermission.explosion ? "\u00a74ON" : "\u00a7aOFF") + "\u00a72" + "  Firespread: " + (townyPermission.fire ? "\u00a74ON" : "\u00a7aOFF") + "\u00a72" + "  Mob Spawns: " + (townyPermission.mobs ? "\u00a74ON" : "\u00a7aOFF"));
            plugin.resetCache();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void parseTownClaimCommand(Player player, String[] stringArray) {
        if (stringArray.length == 1 && stringArray[0].equalsIgnoreCase("?")) {
            player.sendMessage(ChatTools.formatTitle("/town claim"));
            player.sendMessage(ChatTools.formatCommand(TownySettings.getLangString("mayor_sing"), "/town claim", "", TownySettings.getLangString("msg_block_claim")));
            player.sendMessage(ChatTools.formatCommand(TownySettings.getLangString("mayor_sing"), "/town claim", "outpost", TownySettings.getLangString("mayor_help_3")));
            player.sendMessage(ChatTools.formatCommand(TownySettings.getLangString("mayor_sing"), "/town claim", "[circle/rect] [radius]", TownySettings.getLangString("mayor_help_4")));
            player.sendMessage(ChatTools.formatCommand(TownySettings.getLangString("mayor_sing"), "/town claim", "[circle/rect] auto", TownySettings.getLangString("mayor_help_5")));
            return;
        }
        try {
            List<WorldCoord> list;
            if (TownyUniverse.isWarTime()) {
                throw new TownyException(TownySettings.getLangString("msg_war_cannot_do"));
            }
            Resident resident = TownyUniverse.getDataSource().getResident(player.getName());
            Town town = resident.getTown();
            TownyWorld townyWorld = TownyUniverse.getDataSource().getWorld(player.getWorld().getName());
            if (!townyWorld.isUsingTowny()) {
                throw new TownyException(TownySettings.getLangString("msg_set_use_towny_off"));
            }
            double d = 0.0;
            boolean bl = true;
            boolean bl2 = false;
            Coord coord = Coord.parseCoord(plugin.getCache(player).getLastLocation());
            if (stringArray.length == 1 && stringArray[0].equalsIgnoreCase("outpost")) {
                if (!TownySettings.isAllowingOutposts()) throw new TownyException(TownySettings.getLangString("msg_outpost_disable"));
                if (townyWorld.hasTownBlock(coord)) {
                    throw new TownyException(String.format(TownySettings.getLangString("msg_already_claimed_1"), coord));
                }
                if (townyWorld.getMinDistanceFromOtherTowns(coord) < TownySettings.getMinDistanceFromTownHomeblocks()) {
                    throw new TownyException(TownySettings.getLangString("msg_too_close"));
                }
                list = AreaSelectionUtil.selectWorldCoordArea(town, new WorldCoord(townyWorld.getName(), coord), new String[0]);
                d = TownySettings.getOutpostCost();
                bl = false;
                bl2 = true;
            } else {
                list = AreaSelectionUtil.selectWorldCoordArea(town, new WorldCoord(townyWorld.getName(), coord), stringArray);
                d = TownySettings.getClaimPrice();
            }
            TownyMessaging.sendDebugMsg("townClaim: Pre-Filter Selection " + Arrays.toString(list.toArray(new WorldCoord[0])));
            list = AreaSelectionUtil.filterTownOwnedBlocks(list);
            TownyMessaging.sendDebugMsg("townClaim: Post-Filter Selection " + Arrays.toString(list.toArray(new WorldCoord[0])));
            TownCommand.checkIfSelectionIsValid(town, list, bl, d, false);
            try {
                double d2 = d * (double)list.size();
                if (TownySettings.isUsingEconomy() && !town.pay(d2, String.format("Town Claim (%d)", list.size()))) {
                    throw new TownyException(String.format(TownySettings.getLangString("msg_no_funds_claim"), list.size(), TownyEconomyHandler.getFormattedBalance(d2)));
                }
            }
            catch (EconomyException economyException) {
                throw new TownyException("Economy Error");
            }
            new TownClaim(plugin, player, town, list, bl2, true, false).start();
            return;
        }
        catch (TownyException townyException) {
            TownyMessaging.sendErrorMsg((Object)player, townyException.getMessage());
            return;
        }
    }

    public static void parseTownUnclaimCommand(Player player, String[] stringArray) {
        if (stringArray.length == 1 && stringArray[0].equalsIgnoreCase("?")) {
            player.sendMessage(ChatTools.formatTitle("/town unclaim"));
            player.sendMessage(ChatTools.formatCommand(TownySettings.getLangString("mayor_sing"), "/town unclaim", "", TownySettings.getLangString("mayor_help_6")));
            player.sendMessage(ChatTools.formatCommand(TownySettings.getLangString("mayor_sing"), "/town unclaim", "[circle/rect] [radius]", TownySettings.getLangString("mayor_help_7")));
            player.sendMessage(ChatTools.formatCommand(TownySettings.getLangString("mayor_sing"), "/town unclaim", "all", TownySettings.getLangString("mayor_help_8")));
        } else {
            try {
                if (TownyUniverse.isWarTime()) {
                    throw new TownyException(TownySettings.getLangString("msg_war_cannot_do"));
                }
                Resident resident = TownyUniverse.getDataSource().getResident(player.getName());
                Town town = resident.getTown();
                TownyWorld townyWorld = TownyUniverse.getDataSource().getWorld(player.getWorld().getName());
                if (stringArray.length == 1 && stringArray[0].equalsIgnoreCase("all")) {
                    new TownClaim(plugin, player, town, null, false, false, false).start();
                } else {
                    List<WorldCoord> list = AreaSelectionUtil.selectWorldCoordArea(town, new WorldCoord(townyWorld.getName(), Coord.parseCoord(plugin.getCache(player).getLastLocation())), stringArray);
                    list = AreaSelectionUtil.filterOwnedBlocks(town, list);
                    new TownClaim(plugin, player, town, list, false, false, false).start();
                    TownyMessaging.sendMsg((Object)player, String.format(TownySettings.getLangString("msg_abandoned_area"), Arrays.toString(list.toArray(new WorldCoord[0]))));
                }
            }
            catch (TownyException townyException) {
                TownyMessaging.sendErrorMsg((Object)player, townyException.getMessage());
                return;
            }
        }
    }

    public static boolean isEdgeBlock(TownBlockOwner townBlockOwner, List<WorldCoord> list) {
        for (WorldCoord worldCoord : list) {
            if (!TownCommand.isEdgeBlock(townBlockOwner, worldCoord)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEdgeBlock(TownBlockOwner townBlockOwner, WorldCoord worldCoord) {
        if (TownySettings.getDebug()) {
            System.out.print("[Towny] Debug: isEdgeBlock(" + worldCoord.toString() + ") = ");
        }
        int[][] nArrayArray = new int[][]{{-1, 0}, {1, 0}, {0, -1}, {0, 1}};
        for (int i = 0; i < 4; ++i) {
            try {
                TownBlock townBlock = worldCoord.getTownyWorld().getTownBlock(new Coord(worldCoord.getX() + nArrayArray[i][0], worldCoord.getZ() + nArrayArray[i][1]));
                if (!townBlock.isOwner(townBlockOwner)) continue;
                if (TownySettings.getDebug()) {
                    System.out.println("true");
                }
                return true;
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
        }
        if (TownySettings.getDebug()) {
            System.out.println("false");
        }
        return false;
    }

    public static void checkIfSelectionIsValid(TownBlockOwner townBlockOwner, List<WorldCoord> list, boolean bl, double d, boolean bl2) throws TownyException {
        if (bl2) {
            return;
        }
        Town town = (Town)townBlockOwner;
        if (bl && !TownCommand.isEdgeBlock(townBlockOwner, list) && !town.getTownBlocks().isEmpty()) {
            if (list.size() == 0) {
                throw new TownyException(TownySettings.getLangString("msg_already_claimed_2"));
            }
            throw new TownyException(TownySettings.getLangString("msg_err_not_attached_edge"));
        }
        if (townBlockOwner instanceof Town) {
            int n = TownySettings.getMaxTownBlocks(town) - town.getTownBlocks().size();
            TownyMessaging.sendDebugMsg("Claim Check Available: " + n);
            TownyMessaging.sendDebugMsg("Claim Selection Size: " + list.size());
            if (n - list.size() < 0) {
                throw new TownyException(TownySettings.getLangString("msg_err_not_enough_blocks"));
            }
        }
        try {
            double d2 = d * (double)list.size();
            if (TownySettings.isUsingEconomy() && !townBlockOwner.canPayFromHoldings(d2)) {
                throw new TownyException(String.format(TownySettings.getLangString("msg_err_cant_afford_blocks"), list.size(), TownyEconomyHandler.getFormattedBalance(d2)));
            }
        }
        catch (EconomyException economyException) {
            throw new TownyException("Economy Error");
        }
    }

    private void townWithdraw(Player player, int n) {
        try {
            if (!TownySettings.getTownBankAllowWithdrawls()) {
                throw new TownyException(TownySettings.getLangString("msg_err_withdraw_disabled"));
            }
            if (n < 0) {
                throw new TownyException(TownySettings.getLangString("msg_err_negative_money"));
            }
            Resident resident = TownyUniverse.getDataSource().getResident(player.getName());
            Town town = resident.getTown();
            town.withdrawFromBank(resident, n);
            TownyMessaging.sendTownMessage(town, String.format(TownySettings.getLangString("msg_xx_withdrew_xx"), resident.getName(), n, "town"));
        }
        catch (TownyException townyException) {
            TownyMessaging.sendErrorMsg((Object)player, townyException.getMessage());
        }
        catch (EconomyException economyException) {
            TownyMessaging.sendErrorMsg((Object)player, economyException.getMessage());
        }
    }

    private void townDeposit(Player player, int n) {
        try {
            Resident resident = TownyUniverse.getDataSource().getResident(player.getName());
            Town town = resident.getTown();
            double d = TownySettings.getTownBankCap();
            if (d > 0.0 && (double)n + town.getHoldingBalance() > d) {
                throw new TownyException(String.format(TownySettings.getLangString("msg_err_deposit_capped"), d));
            }
            if (n < 0) {
                throw new TownyException(TownySettings.getLangString("msg_err_negative_money"));
            }
            if (!resident.payTo(n, town, "Town Deposit")) {
                throw new TownyException(TownySettings.getLangString("msg_insuf_funds"));
            }
            TownyMessaging.sendTownMessage(town, String.format(TownySettings.getLangString("msg_xx_deposited_xx"), resident.getName(), n, "town"));
        }
        catch (TownyException townyException) {
            TownyMessaging.sendErrorMsg((Object)player, townyException.getMessage());
        }
        catch (EconomyException economyException) {
            TownyMessaging.sendErrorMsg((Object)player, economyException.getMessage());
        }
    }

    static {
        output = new ArrayList<String>();
        output.add(ChatTools.formatTitle("/town"));
        output.add(ChatTools.formatCommand("", "/town", "", TownySettings.getLangString("town_help_1")));
        output.add(ChatTools.formatCommand("", "/town", "[town]", TownySettings.getLangString("town_help_3")));
        output.add(ChatTools.formatCommand("", "/town", "here", TownySettings.getLangString("town_help_4")));
        output.add(ChatTools.formatCommand("", "/town", "list", ""));
        output.add(ChatTools.formatCommand("", "/town", "online", TownySettings.getLangString("town_help_10")));
        output.add(ChatTools.formatCommand("", "/town", "leave", ""));
        output.add(ChatTools.formatCommand("", "/town", "ranklist", ""));
        output.add(ChatTools.formatCommand("", "/town", "spawn", TownySettings.getLangString("town_help_5")));
        if (!TownySettings.isTownCreationAdminOnly()) {
            output.add(ChatTools.formatCommand("", "/town", "new [town]", TownySettings.getLangString("town_help_6")));
        }
        output.add(ChatTools.formatCommand(TownySettings.getLangString("admin_sing"), "/town", "new [town] " + TownySettings.getLangString("town_help_2"), TownySettings.getLangString("town_help_7")));
        output.add(ChatTools.formatCommand(TownySettings.getLangString("res_sing"), "/town", "deposit [$]", ""));
        output.add(ChatTools.formatCommand(TownySettings.getLangString("res_sing"), "/town", "rank add/remove [resident] [rank]", ""));
        output.add(ChatTools.formatCommand(TownySettings.getLangString("mayor_sing"), "/town", "mayor ?", TownySettings.getLangString("town_help_8")));
        output.add(ChatTools.formatCommand(TownySettings.getLangString("admin_sing"), "/town", "delete [town]", ""));
    }
}

